!/**
 * Highmaps JS v11.4.0 (2024-03-04)
 *
 * Highmaps as a plugin for Highcharts or Highcharts Stock.
 *
 * (c) 2011-2024 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function o(t,e,o,i){t.hasOwnProperty(e)||(t[e]=i.apply(null,o),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}o(e,"Core/Axis/Color/ColorAxisComposition.js",[e["Core/Color/Color.js"],e["Core/Utilities.js"]],function(t,e){var o,i=t.parse,r=e.addEvent,n=e.extend,s=e.merge,a=e.pick,l=e.splat;return function(t){var e;function o(){var t=this,o=this.userOptions;this.colorAxis=[],o.colorAxis&&(o.colorAxis=l(o.colorAxis),o.colorAxis.map(function(o){return new e(t,o)}))}function p(t){var e,o,i=this,r=this.chart.colorAxis||[],n=function(e){var o=t.allItems.indexOf(e);-1!==o&&(i.destroyItem(t.allItems[o]),t.allItems.splice(o,1))},s=[];for(r.forEach(function(t){(e=t.options)&&e.showInLegend&&(e.dataClasses&&e.visible?s=s.concat(t.getDataClassLegendSymbols()):e.visible&&s.push(t),t.series.forEach(function(t){(!t.options.showInLegend||e.dataClasses)&&("point"===t.options.legendType?t.points.forEach(function(t){n(t)}):n(t))}))}),o=s.length;o--;)t.allItems.unshift(s[o])}function h(t){t.visible&&t.item.legendColor&&t.item.legendItem.symbol.attr({fill:t.item.legendColor})}function c(t){var e;null===(e=this.chart.colorAxis)||void 0===e||e.forEach(function(e){e.update({},t.redraw)})}function u(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function d(){var t=this.axisTypes;t?-1===t.indexOf("colorAxis")&&t.push("colorAxis"):this.axisTypes=["colorAxis"]}function f(t){var e=this,o=t?"show":"hide";e.visible=e.options.visible=!!t,["graphic","dataLabel"].forEach(function(t){e[t]&&e[t][o]()}),this.series.buildKDTree()}function y(){var t=this,e=this.data.length?this.data:this.points,o=this.options.nullColor,i=this.colorAxis,r=this.colorKey;e.forEach(function(e){var n=e.getNestedProperty(r),s=e.options.color||(e.isNull||null===e.value?o:i&&void 0!==n?i.toColor(n,e):e.color||t.color);s&&e.color!==s&&(e.color=s,"point"===t.options.legendType&&e.legendItem&&e.legendItem.label&&t.chart.legend.colorizeItem(e,e.visible))})}function m(){this.elem.attr("fill",i(this.start).tweenTo(i(this.end),this.pos),void 0,!0)}function g(){this.elem.attr("stroke",i(this.start).tweenTo(i(this.end),this.pos),void 0,!0)}t.compose=function(t,i,l,v,b){var x,M=i.prototype,j=l.prototype,C=b.prototype;M.collectionsWithUpdate.includes("colorAxis")||(e=t,M.collectionsWithUpdate.push("colorAxis"),M.collectionsWithInit.colorAxis=[M.addColorAxis],r(i,"afterGetAxes",o),x=i.prototype.createAxis,i.prototype.createAxis=function(t,o){if("colorAxis"!==t)return x.apply(this,arguments);var i=new e(this,s(o.axis,{index:this[t].length,isX:!1}));return this.isDirtyLegend=!0,this.axes.forEach(function(t){t.series=[]}),this.series.forEach(function(t){t.bindAxes(),t.isDirtyData=!0}),a(o.redraw,!0)&&this.redraw(o.animation),i},j.fillSetter=m,j.strokeSetter=g,r(v,"afterGetAllItems",p),r(v,"afterColorizeItem",h),r(v,"afterUpdate",c),n(C,{optionalAxis:"colorAxis",translateColors:y}),n(C.pointClass.prototype,{setVisible:f}),r(b,"afterTranslate",u,{order:1}),r(b,"bindAxes",d))},t.pointSetVisible=f}(o||(o={})),o}),o(e,"Core/Axis/Color/ColorAxisDefaults.js",[],function(){return{lineWidth:0,minPadding:0,maxPadding:0,gridLineColor:"#ffffff",gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{distance:8,overflow:"justify",rotation:0},minColor:"#e6e9ff",maxColor:"#0022ff",tickLength:5,showInLegend:!0}}),o(e,"Core/Axis/Color/ColorAxisLike.js",[e["Core/Color/Color.js"],e["Core/Utilities.js"]],function(t,e){var o,i,r=t.parse,n=e.merge;return(o=i||(i={})).initDataClasses=function(t){var e,o,i,s=this.chart,a=this.legendItem=this.legendItem||{},l=this.options,p=t.dataClasses||[],h=s.options.chart.colorCount,c=0;this.dataClasses=o=[],a.labels=[];for(var u=0,d=p.length;u<d;++u)e=n(e=p[u]),o.push(e),(s.styledMode||!e.color)&&("category"===l.dataClassColor?(s.styledMode||(h=(i=s.options.colors||[]).length,e.color=i[c]),e.colorIndex=c,++c===h&&(c=0)):e.color=r(l.minColor).tweenTo(r(l.maxColor),d<2?.5:u/(d-1)))},o.initStops=function(){for(var t=this.options,e=this.stops=t.stops||[[0,t.minColor||""],[1,t.maxColor||""]],o=0,i=e.length;o<i;++o)e[o].color=r(e[o][1])},o.normalizedValue=function(t){var e=this.max||0,o=this.min||0;return this.logarithmic&&(t=this.logarithmic.log2lin(t)),1-(e-t)/(e-o||1)},o.toColor=function(t,e){var o,i,r,n,s,a,l=this.dataClasses,p=this.stops;if(l){for(a=l.length;a--;)if(i=(s=l[a]).from,r=s.to,(void 0===i||t>=i)&&(void 0===r||t<=r)){n=s.color,e&&(e.dataClass=a,e.colorIndex=s.colorIndex);break}}else{for(o=this.normalizedValue(t),a=p.length;a--&&!(o>p[a][0]););i=p[a]||p[a+1],o=1-((r=p[a+1]||i)[0]-o)/(r[0]-i[0]||1),n=i.color.tweenTo(r.color,o)}return n},i}),o(e,"Core/Axis/Color/ColorAxis.js",[e["Core/Axis/Axis.js"],e["Core/Axis/Color/ColorAxisComposition.js"],e["Core/Axis/Color/ColorAxisDefaults.js"],e["Core/Axis/Color/ColorAxisLike.js"],e["Core/Defaults.js"],e["Core/Legend/LegendSymbol.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o,i,r,n,s,a){var l,p=this&&this.__extends||(l=function(t,e){return(l=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}l(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),h=r.defaultOptions,c=s.series,u=a.defined,d=a.extend,f=a.fireEvent,y=a.isArray,m=a.isNumber,g=a.merge,v=a.pick,b=a.relativeLength;h.colorAxis=g(h.xAxis,o);var x=function(t){function o(e,o){var i=t.call(this,e,o)||this;return i.coll="colorAxis",i.visible=!0,i.init(e,o),i}return p(o,t),o.compose=function(t,i,r,n){e.compose(o,t,i,r,n)},o.prototype.init=function(e,o){var i=e.options.legend||{},r=o.layout?"vertical"!==o.layout:"vertical"!==i.layout;this.side=o.side||r?2:1,this.reversed=o.reversed||!r,this.opposite=!r,t.prototype.init.call(this,e,o,"colorAxis"),this.userOptions=o,y(e.userOptions.colorAxis)&&(e.userOptions.colorAxis[this.index]=o),o.dataClasses&&this.initDataClasses(o),this.initStops(),this.horiz=r,this.zoomEnabled=!1},o.prototype.hasData=function(){return!!(this.tickPositions||[]).length},o.prototype.setTickPositions=function(){if(!this.dataClasses)return t.prototype.setTickPositions.call(this)},o.prototype.setOptions=function(e){var o=g(h.colorAxis,e,{showEmpty:!1,title:null,visible:this.chart.options.legend.enabled&&!1!==e.visible});t.prototype.setOptions.call(this,o),this.options.crosshair=this.options.marker},o.prototype.setAxisSize=function(){var t,e=this.chart,i=null===(t=this.legendItem)||void 0===t?void 0:t.symbol,r=this.getSize(),n=r.width,s=r.height;i&&(this.left=+i.attr("x"),this.top=+i.attr("y"),this.width=n=+i.attr("width"),this.height=s=+i.attr("height"),this.right=e.chartWidth-this.left-n,this.bottom=e.chartHeight-this.top-s,this.pos=this.horiz?this.left:this.top),this.len=(this.horiz?n:s)||o.defaultLegendLength},o.prototype.getOffset=function(){var e,i=null===(e=this.legendItem)||void 0===e?void 0:e.group,r=this.chart.axisOffset[this.side];if(i){this.axisParent=i,t.prototype.getOffset.call(this);var n=this.chart.legend;n.allItems.forEach(function(t){t instanceof o&&t.drawLegendSymbol(n,t)}),n.render(),this.chart.getMargins(!0),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width),this.chart.axisOffset[this.side]=r}},o.prototype.setLegendColor=function(){var t=this.horiz,e=this.reversed,o=e?1:0,i=e?0:1,r=t?[o,0,i,0]:[0,i,0,o];this.legendColor={linearGradient:{x1:r[0],y1:r[1],x2:r[2],y2:r[3]},stops:this.stops}},o.prototype.drawLegendSymbol=function(t,e){var o,i=e.legendItem||{},r=t.padding,n=t.options,s=this.options.labels,a=v(n.itemDistance,10),l=this.horiz,p=this.getSize(),h=p.width,c=p.height,u=v(n.labelPadding,l?16:30);this.setLegendColor(),i.symbol||(i.symbol=this.chart.renderer.symbol("roundedRect").attr({r:null!==(o=n.symbolRadius)&&void 0!==o?o:3,zIndex:1}).add(i.group)),i.symbol.attr({x:0,y:(t.baseline||0)-11,width:h,height:c}),i.labelWidth=h+r+(l?a:v(s.x,s.distance)+(this.maxLabelLength||0)),i.labelHeight=c+r+(l?u:0)},o.prototype.setState=function(t){this.series.forEach(function(e){e.setState(t)})},o.prototype.setVisible=function(){},o.prototype.getSeriesExtremes=function(){var t,e,o,i,r,n,s,a,l=this.series,p=l.length;for(this.dataMin=1/0,this.dataMax=-1/0;p--;){if(e=(n=l[p]).colorKey=v(n.options.colorKey,n.colorKey,n.pointValKey,n.zoneAxis,"y"),i=n.pointArrayMap,r=n[e+"Min"]&&n[e+"Max"],n[e+"Data"])t=n[e+"Data"];else if(i){if(t=[],o=i.indexOf(e),s=n.yData,o>=0&&s)for(a=0;a<s.length;a++)t.push(v(s[a][o],s[a]))}else t=n.yData;if(r)n.minColorValue=n[e+"Min"],n.maxColorValue=n[e+"Max"];else{var h=c.prototype.getExtremes.call(n,t);n.minColorValue=h.dataMin,n.maxColorValue=h.dataMax}u(n.minColorValue)&&u(n.maxColorValue)&&(this.dataMin=Math.min(this.dataMin,n.minColorValue),this.dataMax=Math.max(this.dataMax,n.maxColorValue)),r||c.prototype.applyExtremes.call(n)}},o.prototype.drawCrosshair=function(e,o){var i,r=this.legendItem||{},n=o&&o.plotX,s=o&&o.plotY,a=this.pos,l=this.len;o&&((i=this.toPixels(o.getNestedProperty(o.series.colorKey)))<a?i=a-2:i>a+l&&(i=a+l+2),o.plotX=i,o.plotY=this.len-i,t.prototype.drawCrosshair.call(this,e,o),o.plotX=n,o.plotY=s,this.cross&&!this.cross.addedToColorAxis&&r.group&&(this.cross.addClass("highcharts-coloraxis-marker").add(r.group),this.cross.addedToColorAxis=!0,this.chart.styledMode||"object"!=typeof this.crosshair||this.cross.attr({fill:this.crosshair.color})))},o.prototype.getPlotLinePath=function(e){var o=this.left,i=e.translatedValue,r=this.top;return m(i)?this.horiz?[["M",i-4,r-6],["L",i+4,r-6],["L",i,r],["Z"]]:[["M",o,i],["L",o-6,i+6],["L",o-6,i-6],["Z"]]:t.prototype.getPlotLinePath.call(this,e)},o.prototype.update=function(e,o){var i=this.chart.legend;this.series.forEach(function(t){t.isDirtyData=!0}),(e.dataClasses&&i.allItems||this.dataClasses)&&this.destroyItems(),t.prototype.update.call(this,e,o),this.legendItem&&this.legendItem.label&&(this.setLegendColor(),i.colorizeItem(this,!0))},o.prototype.destroyItems=function(){var t=this.chart,e=this.legendItem||{};if(e.label)t.legend.destroyItem(this);else if(e.labels)for(var o=0,i=e.labels;o<i.length;o++){var r=i[o];t.legend.destroyItem(r)}t.isDirtyLegend=!0},o.prototype.destroy=function(){this.chart.isDirtyLegend=!0,this.destroyItems(),t.prototype.destroy.apply(this,[].slice.call(arguments))},o.prototype.remove=function(e){this.destroyItems(),t.prototype.remove.call(this,e)},o.prototype.getDataClassLegendSymbols=function(){var t,e=this,o=e.chart,i=e.legendItem&&e.legendItem.labels||[],r=o.options.legend,s=v(r.valueDecimals,-1),a=v(r.valueSuffix,""),l=function(t){return e.series.reduce(function(e,o){return e.push.apply(e,o.points.filter(function(e){return e.dataClass===t})),e},[])};return i.length||e.dataClasses.forEach(function(r,p){var h=r.from,c=r.to,u=o.numberFormatter,y=!0;t="",void 0===h?t="< ":void 0===c&&(t="> "),void 0!==h&&(t+=u(h,s)+a),void 0!==h&&void 0!==c&&(t+=" - "),void 0!==c&&(t+=u(c,s)+a),i.push(d({chart:o,name:t,options:{},drawLegendSymbol:n.rectangle,visible:!0,isDataClass:!0,setState:function(t){for(var e=0,o=l(p);e<o.length;e++)o[e].setState(t)},setVisible:function(){this.visible=y=e.visible=!y;for(var t=[],i=0,r=l(p);i<r.length;i++){var n=r[i];n.setVisible(y),n.hiddenInDataClass=!y,-1===t.indexOf(n.series)&&t.push(n.series)}o.legend.colorizeItem(this,y),t.forEach(function(t){f(t,"afterDataClassLegendClick")})}},r))}),i},o.prototype.getSize=function(){var t=this.chart,e=this.horiz,i=this.options,r=i.legend,n=i.height,s=i.width;return{width:v(u(s)?b(s,t.chartWidth):void 0,null==r?void 0:r.symbolWidth,e?o.defaultLegendLength:12),height:v(u(n)?b(n,t.chartHeight):void 0,null==r?void 0:r.symbolHeight,e?12:o.defaultLegendLength)}},o.defaultLegendLength=200,o.keepProps=["legendItem"],o}(t);return d(x.prototype,i),Array.prototype.push.apply(t.keepProps,x.keepProps),x}),o(e,"masters/modules/coloraxis.src.js",[e["Core/Globals.js"],e["Core/Axis/Color/ColorAxis.js"]],function(t,e){return t.ColorAxis=t.ColorAxis||e,t.ColorAxis.compose(t.Chart,t.Fx,t.Legend,t.Series),t}),o(e,"Maps/MapNavigationDefaults.js",[],function(){return{lang:{zoomIn:"Zoom in",zoomOut:"Zoom out"},mapNavigation:{buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{color:"#666666",fontSize:"1em",fontWeight:"bold"},theme:{fill:"#ffffff",stroke:"#e6e6e6","stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1}}}),o(e,"Maps/MapPointer.js",[e["Core/Utilities.js"]],function(t){var e,o=t.defined,i=t.extend,r=t.pick,n=t.wrap;return function(t){var e,s=0;function a(t){var e=this.chart;t=this.normalize(t),e.options.mapNavigation.enableDoubleClickZoomTo?e.pointer.inClass(t.target,"highcharts-tracker")&&e.hoverPoint&&e.hoverPoint.zoomTo():e.isInsidePlot(t.chartX-e.plotLeft,t.chartY-e.plotTop)&&e.mapZoom(.5,void 0,void 0,t.chartX,t.chartY)}function l(t){var i=this.chart,r=o((t=this.normalize(t)).wheelDelta)&&-t.wheelDelta/120||t.deltaY||t.detail;Math.abs(r)>=1&&(s+=Math.abs(r),e&&clearTimeout(e),e=setTimeout(function(){s=0},50)),s<10&&i.isInsidePlot(t.chartX-i.plotLeft,t.chartY-i.plotTop)&&i.mapView&&i.mapView.zoomBy(-((i.options.mapNavigation.mouseWheelSensitivity-1)*r),void 0,[t.chartX,t.chartY],!(1>Math.abs(r))&&void 0)}function p(t,e,o){var r=this.chart;if(e=t.call(this,e,o),r&&r.mapView){var n=r.mapView.pixelsToLonLat({x:e.chartX-r.plotLeft,y:e.chartY-r.plotTop});n&&i(e,n)}return e}function h(t){var e=this.chart.options.mapNavigation;e&&r(e.enableTouchZoom,e.enabled)&&(this.chart.zooming.pinchType="xy"),t.apply(this,[].slice.call(arguments,1))}t.compose=function(t){var e=t.prototype;e.onContainerDblClick||(i(e,{onContainerDblClick:a,onContainerMouseWheel:l}),n(e,"normalize",p),n(e,"zoomOption",h))}}(e||(e={})),e}),o(e,"Maps/MapSymbols.js",[],function(){var t;function e(e,o,i,r,n){if(n){var s=(null==n?void 0:n.r)||0;n.brBoxY=o-s,n.brBoxHeight=r+s}return t.roundedRect(e,o,i,r,n)}function o(e,o,i,r,n){if(n){var s=(null==n?void 0:n.r)||0;n.brBoxHeight=r+s}return t.roundedRect(e,o,i,r,n)}return{compose:function(i){(t=i.prototype.symbols).bottombutton=e,t.topbutton=o}}}),o(e,"Maps/MapNavigation.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Maps/MapNavigationDefaults.js"],e["Maps/MapPointer.js"],e["Maps/MapSymbols.js"],e["Core/Utilities.js"]],function(t,e,o,i,r,n){var s=t.setOptions,a=e.composed,l=n.addEvent,p=n.extend,h=n.merge,c=n.objectEach,u=n.pick,d=n.pushUnique;function f(t){t&&(t.preventDefault&&t.preventDefault(),t.stopPropagation&&t.stopPropagation(),t.cancelBubble=!0)}return function(){function t(t){this.chart=t,this.navButtons=[]}return t.compose=function(e,n,p){i.compose(n),r.compose(p),d(a,"Map.Navigation")&&(l(e,"beforeRender",function(){this.mapNavigation=new t(this),this.mapNavigation.update()}),s(o))},t.prototype.update=function(t){var e,o=this,i=o.chart,r=o.navButtons,n=function(t){this.handler.call(i,t),f(t)},s=i.options.mapNavigation;for(t&&(s=i.options.mapNavigation=h(i.options.mapNavigation,t));r.length;)r.pop().destroy();!i.renderer.forExport&&u(s.enableButtons,s.enabled)&&(o.navButtonsGroup||(o.navButtonsGroup=i.renderer.g().attr({zIndex:7}).add()),c(s.buttons,function(t,a){t=h(s.buttonOptions,t),!i.styledMode&&t.theme&&((e=t.theme).style=h(t.theme.style,t.style));var c,u=t.text,d=t.width,y=void 0===d?0:d,m=t.height,g=void 0===m?0:m,v=t.padding,b=void 0===v?0:v,x=i.renderer.button("+"!==u&&"-"!==u&&u||"",0,0,n,e,void 0,void 0,void 0,"zoomIn"===a?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+({zoomIn:"zoom-in",zoomOut:"zoom-out"})[a]).attr({width:y,height:g,title:i.options.lang[a],padding:t.padding,zIndex:5}).add(o.navButtonsGroup);if("+"===u||"-"===u){var M=y+1,j=[["M",b+3,b+g/2],["L",b+M-3,b+g/2]];"+"===u&&j.push(["M",b+M/2,b+3],["L",b+M/2,b+g-3]),i.renderer.path(j).addClass("highcharts-button-symbol").attr(i.styledMode?{}:{stroke:null===(c=t.style)||void 0===c?void 0:c.color,"stroke-width":3,"stroke-linecap":"round"}).add(x)}if(x.handler=t.onclick,l(x.element,"dblclick",f),r.push(x),p(t,{width:x.width,height:2*(x.height||0)}),i.hasLoaded)x.align(t,!1,t.alignTo);else var C=l(i,"load",function(){x.element&&x.align(t,!1,t.alignTo),C()})}),i.hasLoaded||l(i,"render",function(){var t=i.exportingGroup&&i.exportingGroup.getBBox();if(t){var e=o.navButtonsGroup.getBBox();if(!(e.x>=t.x+t.width||e.x+e.width<=t.x||e.y>=t.y+t.height||e.y+e.height<=t.y)){var r=-e.y-e.height+t.y-5,n=t.y+t.height-e.y+5,a=s.buttonOptions&&s.buttonOptions.verticalAlign;o.navButtonsGroup.attr({translateY:"bottom"===a?r:n})}}})),this.updateEvents(s)},t.prototype.updateEvents=function(t){var e=this.chart;u(t.enableDoubleClickZoom,t.enabled)||t.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||l(e.container,"dblclick",function(t){e.pointer.onContainerDblClick(t)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick()),u(t.enableMouseWheelZoom,t.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||l(e.container,"wheel",function(t){return e.pointer.inClass(t.target,"highcharts-no-mousewheel")||(e.pointer.onContainerMouseWheel(t),f(t)),!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())},t}()}),o(e,"Series/ColorMapComposition.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,i=t.seriesTypes.column.prototype,r=e.addEvent,n=e.defined;return function(t){function e(t){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:t&&"hover"===t.state?1:0})}t.pointMembers={dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return null!==this.value&&this.value!==1/0&&this.value!==-1/0&&(void 0===this.value||!isNaN(this.value))}},t.seriesMembers={colorKey:"value",axisTypes:["xAxis","yAxis","colorAxis"],parallelArrays:["x","y","value"],pointArrayMap:["value"],trackerGroups:["group","markerGroup","dataLabelsGroup"],colorAttribs:function(t){var e={};return n(t.color)&&(!t.state||"normal"===t.state)&&(e[this.colorProp||"fill"]=t.color),e},pointAttribs:i.pointAttribs},t.compose=function(t){return r(t.prototype.pointClass,"afterSetState",e),t}}(o||(o={})),o}),o(e,"Core/Chart/MapChart.js",[e["Core/Chart/Chart.js"],e["Core/Defaults.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"]],function(t,e,o,i){var r,n,s=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),a=this&&this.__spreadArray||function(t,e,o){if(o||2==arguments.length)for(var i,r=0,n=e.length;r<n;r++)!i&&r in e||(i||(i=Array.prototype.slice.call(e,0,r)),i[r]=e[r]);return t.concat(i||Array.prototype.slice.call(e))},l=e.getOptions,p=i.isNumber,h=i.merge,c=i.pick,u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return s(e,t),e.prototype.init=function(e,o){var i=l().credits,r=h({chart:{panning:{enabled:!0,type:"xy"},type:"map"},credits:{mapText:c(i.mapText,' \xa9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),mapTextFull:c(i.mapTextFull,"{geojson.copyright}")},mapView:{},tooltip:{followTouchMove:!1}},e);t.prototype.init.call(this,r,o)},e.prototype.mapZoom=function(t,e,o,i,r){this.mapView&&(p(t)&&(t=Math.log(t)/Math.log(.5)),this.mapView.zoomBy(t,p(e)&&p(o)?this.mapView.projection.inverse([e,o]):void 0,p(i)&&p(r)?[i,r]:void 0))},e.prototype.update=function(e){var o;e.chart&&"map"in e.chart&&(null===(o=this.mapView)||void 0===o||o.recommendMapView(this,a([e.chart.map],(this.options.series||[]).map(function(t){return t.mapData}),!0),!0)),t.prototype.update.apply(this,arguments)},e}(t);return(n=u||(u={})).maps={},n.mapChart=function(t,e,o){return new n(t,e,o)},n.splitPath=function(t){var e;return e="string"==typeof t?(t=t.replace(/([A-Za-z])/g," $1 ").replace(/^\s*/,"").replace(/\s*$/,"")).split(/[ ,;]+/).map(function(t){return/[A-Za-z]/.test(t)?t:parseFloat(t)}):t,o.prototype.pathToSegments(e)},u}),o(e,"Maps/MapUtilities.js",[],function(){return{boundsFromPath:function(t){var e,o=-Number.MAX_VALUE,i=Number.MAX_VALUE,r=-Number.MAX_VALUE,n=Number.MAX_VALUE;if(t.forEach(function(t){var s=t[t.length-2],a=t[t.length-1];"number"==typeof s&&"number"==typeof a&&(i=Math.min(i,s),o=Math.max(o,s),n=Math.min(n,a),r=Math.max(r,a),e=!0)}),e)return{x1:i,y1:n,x2:o,y2:r}},pointInPolygon:function(t,e){var o,i,r=!1,n=t.x,s=t.y;for(o=0,i=e.length-1;o<e.length;i=o++)e[o][1]>s!=e[i][1]>s&&n<(e[i][0]-e[o][0])*(s-e[o][1])/(e[i][1]-e[o][1])+e[o][0]&&(r=!r);return r}}}),o(e,"Series/Map/MapPoint.js",[e["Series/ColorMapComposition.js"],e["Maps/MapUtilities.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o,i){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),s=this&&this.__assign||function(){return(s=Object.assign||function(t){for(var e,o=1,i=arguments.length;o<i;o++)for(var r in e=arguments[o])Object.prototype.hasOwnProperty.call(e,r)&&(t[r]=e[r]);return t}).apply(this,arguments)},a=e.boundsFromPath,l=o.seriesTypes.scatter.prototype.pointClass,p=i.extend,h=i.isNumber,c=i.pick,u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n(e,t),e.getProjectedPath=function(t,e){return t.projectedPath||(e&&t.geometry?(e.hasCoordinates=!0,t.projectedPath=e.path(t.geometry)):t.projectedPath=t.path),t.projectedPath||[]},e.prototype.applyOptions=function(e,o){var i,r=this.series,n=t.prototype.applyOptions.call(this,e,o),a=r.joinBy;if(r.mapData&&r.mapMap){var l=a[1],h=t.prototype.getNestedProperty.call(this,l),c=void 0!==h&&r.mapMap[h];c?p(n,s(s({},c),{name:null!==(i=n.name)&&void 0!==i?i:c.name})):-1!==r.pointArrayMap.indexOf("value")&&(n.value=n.value||null)}return n},e.prototype.getProjectedBounds=function(t){var o=a(e.getProjectedPath(this,t)),i=this.properties,r=this.series.chart.mapView;if(o){var n=i&&i["hc-middle-lon"],s=i&&i["hc-middle-lat"];if(r&&h(n)&&h(s)){var l=t.forward([n,s]);o.midX=l[0],o.midY=l[1]}else{var p=i&&i["hc-middle-x"],u=i&&i["hc-middle-y"];o.midX=o.x1+(o.x2-o.x1)*c(this.middleX,h(p)?p:.5);var d=c(this.middleY,h(u)?u:.5);this.geometry||(d=1-d),o.midY=o.y2-(o.y2-o.y1)*d}return o}},e.prototype.onMouseOver=function(e){i.clearTimeout(this.colorInterval),!this.isNull&&this.visible||this.series.options.nullInteraction?t.prototype.onMouseOver.call(this,e):this.series.onMouseOut()},e.prototype.setVisible=function(t){this.visible=this.options.visible=!!t,this.dataLabel&&this.dataLabel[t?"show":"hide"](),this.graphic&&this.graphic.attr(this.series.pointAttribs(this))},e.prototype.zoomTo=function(t){var e=this.series.chart,o=e.mapView,i=this.bounds;if(o&&i){var r=h(this.insetIndex)&&o.insets[this.insetIndex];if(r){var n=r.projectedUnitsToPixels({x:i.x1,y:i.y1}),s=r.projectedUnitsToPixels({x:i.x2,y:i.y2}),a=o.pixelsToProjectedUnits({x:n.x,y:n.y}),l=o.pixelsToProjectedUnits({x:s.x,y:s.y});i={x1:a.x,y1:a.y,x2:l.x,y2:l.y}}o.fitToBounds(i,void 0,!1),this.series.isDirty=!0,e.redraw(t)}},e}(l);return p(u.prototype,{dataLabelOnNull:t.pointMembers.dataLabelOnNull,moveToTopOnHover:t.pointMembers.moveToTopOnHover,isValid:t.pointMembers.isValid}),u}),o(e,"Series/Map/MapSeriesDefaults.js",[e["Core/Utilities.js"]],function(t){var e=t.isNumber;return{affectsMapView:!0,animation:!1,dataLabels:{crop:!1,formatter:function(){var t=this.series.chart.numberFormatter,o=this.point.value;return e(o)?t(o,-1):this.point.name},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},linecap:"round",marker:null,nullColor:"#f7f7f7",stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:"#e6e6e6",borderWidth:1,joinBy:"hc-key",states:{hover:{halo:void 0,borderColor:"#666666",borderWidth:2},normal:{animation:!0},select:{color:"#cccccc"}},legendSymbol:"rectangle"}}),o(e,"Maps/MapViewDefaults.js",[],function(){return{center:[0,0],fitToGeometry:void 0,maxZoom:void 0,padding:0,projection:{name:void 0,parallels:void 0,rotation:void 0},zoom:void 0,insetOptions:{borderColor:"#cccccc",borderWidth:1,padding:"10%",relativeTo:"mapBoundingBox",units:"percent"}}}),o(e,"Maps/GeoJSONComposition.js",[e["Core/Globals.js"],e["Core/Templating.js"],e["Core/Utilities.js"]],function(t,e,o){var i,r=t.win,n=e.format,s=o.error,a=o.extend,l=o.merge,p=o.wrap;return function(t){function e(t){return this.mapView&&this.mapView.lonLatToProjectedUnits(t)}function o(t){return this.mapView&&this.mapView.projectedUnitsToLonLat(t)}function i(t,e){var o=this.options.chart.proj4||r.proj4;if(!o){s(21,!1,this);return}var i=e.jsonmarginX,n=e.jsonmarginY,a=e.jsonres,l=void 0===a?1:a,p=e.scale,h=void 0===p?1:p,c=e.xoffset,u=e.xpan,d=e.yoffset,f=e.ypan,y=o(e.crs,[t.lon,t.lat]),m=e.cosAngle||e.rotation&&Math.cos(e.rotation),g=e.sinAngle||e.rotation&&Math.sin(e.rotation),v=e.rotation?[y[0]*m+y[1]*g,-y[0]*g+y[1]*m]:y;return{x:((v[0]-(void 0===c?0:c))*h+(void 0===u?0:u))*l+(void 0===i?0:i),y:-((((void 0===d?0:d)-v[1])*h+(void 0===f?0:f))*l-(void 0===n?0:n))}}function h(t,e){var o=this.options.chart.proj4||r.proj4;if(!o){s(21,!1,this);return}if(null!==t.y){var i=e.jsonmarginX,n=e.jsonmarginY,a=e.jsonres,l=void 0===a?1:a,p=e.scale,h=void 0===p?1:p,c=e.xoffset,u=e.xpan,d=e.yoffset,f=e.ypan,y={x:((t.x-(void 0===i?0:i))/l-(void 0===u?0:u))/h+(void 0===c?0:c),y:((t.y-(void 0===n?0:n))/l+(void 0===f?0:f))/h+(void 0===d?0:d)},m=e.cosAngle||e.rotation&&Math.cos(e.rotation),g=e.sinAngle||e.rotation&&Math.sin(e.rotation),v=o(e.crs,"WGS84",e.rotation?{x:y.x*m+-(y.y*g),y:y.x*g+y.y*m}:y);return{lat:v.y,lon:v.x}}}function c(t,e){e||(e=Object.keys(t.objects)[0]);var o=t.objects[e];if(o["hc-decoded-geojson"]&&o["hc-decoded-geojson"].title===t.title)return o["hc-decoded-geojson"];var i=t.arcs;if(t.transform){var r=t.arcs,n=t.transform,s=n.scale,a=n.translate,l=void 0,p=void 0,h=void 0;i=[];for(var c=0,u=r.length;c<u;++c){var d=r[c];i.push(l=[]),p=0,h=0;for(var f=0,y=d.length;f<y;++f)l.push([(p+=d[f][0])*s[0]+a[0],(h+=d[f][1])*s[1]+a[1]])}}for(var m=function(t){return"number"==typeof t[0]?t.reduce(function(t,e,o){var r=e<0?i[~e]:i[e];return e<0?(r=r.slice(0,0===o?r.length:r.length-1)).reverse():o&&(r=r.slice(1)),t.concat(r)},[]):t.map(m)},g=o.geometries,v=[],c=0,u=g.length;c<u;++c)v.push({type:"Feature",properties:g[c].properties,geometry:{type:g[c].type,coordinates:g[c].coordinates||m(g[c].arcs)}});var b={type:"FeatureCollection",copyright:t.copyright,copyrightShort:t.copyrightShort,copyrightUrl:t.copyrightUrl,features:v,"hc-recommended-mapview":o["hc-recommended-mapview"],bbox:t.bbox,title:t.title};return o["hc-decoded-geojson"]=b,b}function u(t,e){e=l(!0,this.options.credits,e),this.mapCredits&&(e.href=void 0),t.call(this,e),this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})}t.compose=function(t){var r=t.prototype;r.transformFromLatLon||(r.fromLatLonToPoint=e,r.fromPointToLatLon=o,r.transformFromLatLon=i,r.transformToLatLon=h,p(r,"addCredits",u))},t.geojson=function(t,e,o){void 0===e&&(e="map");for(var i,r,s=[],l="Topology"===t.type?c(t):t,p=l.features,h=0,u=p.length;h<u;++h){var d=p[h],f=d.geometry||{},y=f.type,m=f.coordinates,g=d.properties,v=void 0;if(("map"===e||"mapbubble"===e)&&("Polygon"===y||"MultiPolygon"===y)?m.length&&(v={geometry:{coordinates:m,type:y}}):"mapline"===e&&("LineString"===y||"MultiLineString"===y)?m.length&&(v={geometry:{coordinates:m,type:y}}):"mappoint"===e&&"Point"===y&&m.length&&(v={geometry:{coordinates:m,type:y}}),v){var b=g&&(g.name||g.NAME),x=g&&g.lon,M=g&&g.lat;s.push(a(v,{lat:"number"==typeof M?M:void 0,lon:"number"==typeof x?x:void 0,name:"string"==typeof b?b:void 0,properties:g}))}}return o&&l.copyrightShort&&(o.chart.mapCredits=n(null===(i=o.chart.options.credits)||void 0===i?void 0:i.mapText,{geojson:l}),o.chart.mapCreditsFull=n(null===(r=o.chart.options.credits)||void 0===r?void 0:r.mapTextFull,{geojson:l})),s},t.topo2geo=c}(i||(i={})),i}),o(e,"Core/Geometry/PolygonClip.js",[],function(){function t(t,i,r){void 0===r&&(r=!0);for(var n,s,a,l=i[i.length-1],p=t,h=0;h<i.length;h++){var c=p;n=i[h],p=[],s=r?c[c.length-1]:c[0];for(var u=0;u<c.length;u++)e(l,n,a=c[u])?(e(l,n,s)||p.push(o(l,n,s,a)),p.push(a)):e(l,n,s)&&p.push(o(l,n,s,a)),s=a;l=n}return p}function e(t,e,o){return(e[0]-t[0])*(o[1]-t[1])>(e[1]-t[1])*(o[0]-t[0])}function o(t,e,o,i){var r=[t[0]-e[0],t[1]-e[1]],n=[o[0]-i[0],o[1]-i[1]],s=t[0]*e[1]-t[1]*e[0],a=o[0]*i[1]-o[1]*i[0],l=1/(r[0]*n[1]-r[1]*n[0]),p=[(s*n[0]-a*r[0])*l,(s*n[1]-a*r[1])*l];return p.isIntersection=!0,p}return{clipLineString:function(e,o){for(var i=[],r=t(e,o,!1),n=1;n<r.length;n++)r[n].isIntersection&&r[n-1].isIntersection&&(i.push(r.splice(0,n)),n=0),n===r.length-1&&i.push(r);return i},clipPolygon:t}}),o(e,"Maps/Projections/LambertConformalConic.js",[],function(){var t=Math.sign||function(t){return 0===t?0:t>0?1:-1},e=Math.PI/180,o=Math.PI/2,i=function(t){return Math.tan((o+t)/2)};return function(){function r(o){var r,n=(o.parallels||[]).map(function(t){return t*e}),s=n[0]||0,a=null!==(r=n[1])&&void 0!==r?r:s,l=Math.cos(s);"object"==typeof o.projectedBounds&&(this.projectedBounds=o.projectedBounds);var p=s===a?Math.sin(s):Math.log(l/Math.cos(a))/Math.log(i(a)/i(s));1e-10>Math.abs(p)&&(p=1e-10*(t(p)||1)),this.n=p,this.c=l*Math.pow(i(s),p)/p}return r.prototype.forward=function(t){var r=this.c,n=this.n,s=this.projectedBounds,a=t[0]*e,l=t[1]*e;r>0?l<-o+1e-6&&(l=-o+1e-6):l>o-1e-6&&(l=o-1e-6);var p=r/Math.pow(i(l),n),h=p*Math.sin(n*a)*63.78137,c=(r-p*Math.cos(n*a))*63.78137,u=[h,c];return s&&(h<s.x1||h>s.x2||c<s.y1||c>s.y2)&&(u.outside=!0),u},r.prototype.inverse=function(i){var r=this.c,n=this.n,s=i[0]/63.78137,a=r-i[1]/63.78137,l=t(n)*Math.sqrt(s*s+a*a),p=Math.atan2(s,Math.abs(a))*t(a);return a*n<0&&(p-=Math.PI*t(s)*t(a)),[p/n/e,(2*Math.atan(Math.pow(r/l,1/n))-o)/e]},r}()}),o(e,"Maps/Projections/EqualEarth.js",[],function(){var t=Math.sqrt(3)/2;return function(){function e(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-97.52595454902263,y2:97.52595454902263}}return e.prototype.forward=function(e){var o=Math.PI/180,i=Math.asin(t*Math.sin(e[1]*o)),r=i*i,n=r*r*r;return[e[0]*o*Math.cos(i)*74.03120656864502/(t*(1.340264+-.24331799999999998*r+n*(.0062510000000000005+.034164*r))),74.03120656864502*i*(1.340264+-.081106*r+n*(893e-6+.003796*r))]},e.prototype.inverse=function(e){for(var o,i,r,n,s=e[0]/74.03120656864502,a=e[1]/74.03120656864502,l=180/Math.PI,p=a,h=0;h<12&&(i=(o=p*p)*o*o,r=p*(1.340264+-.081106*o+i*(893e-6+.003796*o))-a,p-=n=r/(1.340264+-.24331799999999998*o+i*(.0062510000000000005+.034164*o)),!(1e-9>Math.abs(n)));++h);i=(o=p*p)*o*o;var c=l*t*s*(1.340264+-.24331799999999998*o+i*(.0062510000000000005+.034164*o))/Math.cos(p),u=l*Math.asin(Math.sin(p)/t);return Math.abs(c)>180?[NaN,NaN]:[c,u]},e}()}),o(e,"Maps/Projections/Miller.js",[],function(){var t=Math.PI/4,e=Math.PI/180;return function(){function o(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-146.91480769173063,y2:146.91480769173063}}return o.prototype.forward=function(o){return[o[0]*e*63.78137,79.7267125*Math.log(Math.tan(t+.4*o[1]*e))]},o.prototype.inverse=function(o){return[o[0]/63.78137/e,2.5*(Math.atan(Math.exp(o[1]/63.78137*.8))-t)/e]},o}()}),o(e,"Maps/Projections/Orthographic.js",[],function(){var t=Math.PI/180;return function(){function e(){this.antimeridianCutting=!1,this.bounds={x1:-63.78460826781007,x2:63.78460826781007,y1:-63.78460826781007,y2:63.78460826781007}}return e.prototype.forward=function(e){var o=e[0],i=e[1]*t,r=[Math.cos(i)*Math.sin(o*t)*63.78460826781007,63.78460826781007*Math.sin(i)];return(o<-90||o>90)&&(r.outside=!0),r},e.prototype.inverse=function(e){var o=e[0]/63.78460826781007,i=e[1]/63.78460826781007,r=Math.sqrt(o*o+i*i),n=Math.asin(r),s=Math.sin(n);return[Math.atan2(o*s,r*Math.cos(n))/t,Math.asin(r&&i*s/r)/t]},e}()}),o(e,"Maps/Projections/WebMercator.js",[],function(){var t=Math.PI/180;return function(){function e(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-200.3750834278071,y2:200.3750834278071},this.maxLatitude=85.0511287798}return e.prototype.forward=function(e){var o=Math.sin(e[1]*t),i=[63.78137*e[0]*t,63.78137*Math.log((1+o)/(1-o))/2];return Math.abs(e[1])>this.maxLatitude&&(i.outside=!0),i},e.prototype.inverse=function(e){return[e[0]/(63.78137*t),(2*Math.atan(Math.exp(e[1]/63.78137))-Math.PI/2)/t]},e}()}),o(e,"Maps/Projections/ProjectionRegistry.js",[e["Maps/Projections/LambertConformalConic.js"],e["Maps/Projections/EqualEarth.js"],e["Maps/Projections/Miller.js"],e["Maps/Projections/Orthographic.js"],e["Maps/Projections/WebMercator.js"]],function(t,e,o,i,r){return{EqualEarth:e,LambertConformalConic:t,Miller:o,Orthographic:i,WebMercator:r}}),o(e,"Maps/Projection.js",[e["Core/Geometry/PolygonClip.js"],e["Maps/Projections/ProjectionRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var i=this&&this.__spreadArray||function(t,e,o){if(o||2==arguments.length)for(var i,r=0,n=e.length;r<n;r++)!i&&r in e||(i||(i=Array.prototype.slice.call(e,0,r)),i[r]=e[r]);return t.concat(i||Array.prototype.slice.call(e))},r=t.clipLineString,n=t.clipPolygon,s=o.clamp,a=o.erase,l=2*Math.PI/360;function p(t){return t<-180&&(t+=360),t>180&&(t-=360),t}return function(){function t(e){void 0===e&&(e={}),this.hasCoordinates=!1,this.hasGeoProjection=!1,this.maxLatitude=90,this.options=e;var o=e.name,i=e.projectedBounds,r=e.rotation;this.rotator=r?this.getRotator(r):void 0;var n=o?t.registry[o]:void 0;n&&(this.def=new n(e));var s=this.def,a=this.rotator;s&&(this.maxLatitude=s.maxLatitude||90,this.hasGeoProjection=!0),a&&s?(this.forward=function(t){return s.forward(a.forward(t))},this.inverse=function(t){return a.inverse(s.inverse(t))}):s?(this.forward=function(t){return s.forward(t)},this.inverse=function(t){return s.inverse(t)}):a&&(this.forward=a.forward,this.inverse=a.inverse),this.bounds="world"===i?s&&s.bounds:i}return t.add=function(e,o){t.registry[e]=o},t.greatCircle=function(t,e,o){var i=Math.atan2,r=Math.cos,n=Math.sin,s=Math.sqrt,a=t[1]*l,p=t[0]*l,h=e[1]*l,c=e[0]*l,u=h-a,d=c-p,f=n(u/2)*n(u/2)+r(a)*r(h)*n(d/2)*n(d/2),y=2*i(s(f),s(1-f)),m=Math.round(6371e3*y/5e5),g=[];if(o&&g.push(t),m>1)for(var v=1/m,b=v;b<.999;b+=v){var x=n((1-b)*y)/n(y),M=n(b*y)/n(y),j=x*r(a)*r(p)+M*r(h)*r(c),C=x*r(a)*n(p)+M*r(h)*n(c),w=i(x*n(a)+M*n(h),s(j*j+C*C)),P=i(C,j);g.push([P/l,w/l])}return o&&g.push(e),g},t.insertGreatCircles=function(e){for(var o=e.length-1;o--;)if(Math.max(Math.abs(e[o][0]-e[o+1][0]),Math.abs(e[o][1]-e[o+1][1]))>10){var r=t.greatCircle(e[o],e[o+1]);r.length&&e.splice.apply(e,i([o+1,0],r,!1))}},t.toString=function(t){var e=t||{},o=e.name,i=e.rotation;return[o,i&&i.join(",")].join(";")},t.prototype.lineIntersectsBounds=function(t){var e,o=this.bounds||{},i=o.x1,r=o.x2,n=o.y1,s=o.y2,a=function(t,e,o){var i=t[0],r=t[1],n=e?0:1;if("number"==typeof o&&i[e]>=o!=r[e]>=o){var s=(o-i[e])/(r[e]-i[e]),a=i[n]+s*(r[n]-i[n]);return e?[a,o]:[o,a]}},l=t[0];return(e=a(t,0,i))?(l=e,t[1]=e):(e=a(t,0,r))&&(l=e,t[1]=e),(e=a(t,1,n))?l=e:(e=a(t,1,s))&&(l=e),l},t.prototype.getRotator=function(t){var e=t[0]*l,o=(t[1]||0)*l,i=(t[2]||0)*l,r=Math.cos(o),n=Math.sin(o),s=Math.cos(i),a=Math.sin(i);if(0!==e||0!==o||0!==i)return{forward:function(t){var o=t[0]*l+e,i=t[1]*l,p=Math.cos(i),h=Math.cos(o)*p,c=Math.sin(o)*p,u=Math.sin(i),d=u*r+h*n;return[Math.atan2(c*s-d*a,h*r-u*n)/l,Math.asin(d*s+c*a)/l]},inverse:function(t){var o=t[0]*l,i=t[1]*l,p=Math.cos(i),h=Math.cos(o)*p,c=Math.sin(o)*p,u=Math.sin(i),d=u*s-c*a;return[(Math.atan2(c*s+u*a,h*r+d*n)-e)/l,Math.asin(d*r-h*n)/l]}}},t.prototype.forward=function(t){return t},t.prototype.inverse=function(t){return t},t.prototype.cutOnAntimeridian=function(e,o){for(var r,n=[],l=[e],h=0,c=e.length;h<c;++h){var u=e[h],d=e[h-1];if(!h){if(!o)continue;d=e[e.length-1]}var f=d[0],y=u[0];if((f<-90||f>90)&&(y<-90||y>90)&&f>0!=y>0){var m=s((180-(f+360)%360)/((y+360)%360-(f+360)%360),0,1),g=d[1]+m*(u[1]-d[1]);n.push({i:h,lat:g,direction:f<0?1:-1,previousLonLat:d,lonLat:u})}}if(n.length){if(o){n.length%2==1&&(r=n.slice().sort(function(t,e){return Math.abs(e.lat)-Math.abs(t.lat)})[0],a(n,r));for(var h=n.length-2;h>=0;){var v=n[h].i,b=p(180+1e-6*n[h].direction),x=p(180-1e-6*n[h].direction),M=e.splice.apply(e,i([v,n[h+1].i-v],t.greatCircle([b,n[h].lat],[b,n[h+1].lat],!0),!1));M.push.apply(M,t.greatCircle([x,n[h+1].lat],[x,n[h].lat],!0)),l.push(M),h-=2}if(r)for(var j=0;j<l.length;j++){var C=r.direction,g=r.lat,w=l[j],P=w.indexOf(r.lonLat);if(P>-1){for(var S=(g<0?-1:1)*this.maxLatitude,f=p(180+1e-6*C),y=p(180-1e-6*C),A=t.greatCircle([f,g],[f,S],!0),L=f+120*C;L>-180&&L<180;L+=120*C)A.push([L,S]);A.push.apply(A,t.greatCircle([y,S],[y,r.lat],!0)),w.splice.apply(w,i([P,0],A,!1));break}}}else for(var h=n.length;h--;){var v=n[h].i,M=e.splice(v,e.length,[p(180+1e-6*n[h].direction),n[h].lat]);M.unshift([p(180-1e-6*n[h].direction),n[h].lat]),l.push(M)}}return l},t.prototype.path=function(e){var o,i=this,s=this.bounds,a=this.def,l=this.rotator,p=[],h="Polygon"===e.type||"MultiPolygon"===e.type,c=this.hasGeoProjection,u=!a||!1!==a.antimeridianCutting,d=u?l:void 0,f=u&&a||this;s&&(o=[[s.x1,s.y1],[s.x2,s.y1],[s.x2,s.y2],[s.x1,s.y2]]);var y=function(e){var a=e.map(function(t){if(u){d&&(t=d.forward(t));var e=t[0];1e-6>Math.abs(e-180)&&(e=e<180?179.999999:180.000001),t=[e,t[1]]}return t}),l=[a];c&&(t.insertGreatCircles(a),u&&(l=i.cutOnAntimeridian(a,h))),l.forEach(function(e){if(!(e.length<2)){var i,a,l=!1,d=!1,y=function(t){l?p.push(["L",t[0],t[1]]):(p.push(["M",t[0],t[1]]),l=!0)},m=!1,g=!1,v=e.map(function(t){var e=f.forward(t);return e.outside?m=!0:g=!0,e[1]===1/0?e[1]=1e10:e[1]===-1/0&&(e[1]=-1e10),e});if(u){if(h&&v.push(v[0]),m){if(!g)return;if(o){if(h)v=n(v,o);else if(s){r(v,o).forEach(function(t){l=!1,t.forEach(y)});return}}}v.forEach(y)}else for(var b=0;b<v.length;b++){var x=e[b],M=v[b];M.outside?d=!0:(h&&!i&&(i=x,e.push(x),v.push(M)),d&&a&&(h&&c?t.greatCircle(a,x).forEach(function(t){return y(f.forward(t))}):l=!1),y(M),a=x,d=!1)}}})};return"LineString"===e.type?y(e.coordinates):"MultiLineString"===e.type?e.coordinates.forEach(function(t){return y(t)}):"Polygon"===e.type?(e.coordinates.forEach(function(t){return y(t)}),p.length&&p.push(["Z"])):"MultiPolygon"===e.type&&(e.coordinates.forEach(function(t){t.forEach(function(t){return y(t)})}),p.length&&p.push(["Z"])),p},t.registry=e,t}()}),o(e,"Maps/MapView.js",[e["Core/Globals.js"],e["Maps/MapViewDefaults.js"],e["Maps/GeoJSONComposition.js"],e["Maps/MapUtilities.js"],e["Maps/Projection.js"],e["Core/Utilities.js"]],function(t,e,o,i,r,n){var s,a=this&&this.__extends||(s=function(t,e){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}s(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),l=this&&this.__spreadArray||function(t,e,o){if(o||2==arguments.length)for(var i,r=0,n=e.length;r<n;r++)!i&&r in e||(i||(i=Array.prototype.slice.call(e,0,r)),i[r]=e[r]);return t.concat(i||Array.prototype.slice.call(e))},p=t.composed,h=o.topo2geo,c=i.boundsFromPath,u=i.pointInPolygon,d=n.addEvent,f=n.clamp,y=n.fireEvent,m=n.isArray,g=n.isNumber,v=n.isObject,b=n.isString,x=n.merge,M=n.pick,j=n.pushUnique,C=n.relativeLength,w={};function P(t,e){var o=e.width,i=e.height;return Math.log(400.979322/Math.max((t.x2-t.x1)/(o/256),(t.y2-t.y1)/(i/256)))/Math.log(2)}function S(t){var e,o;t.seriesOptions.mapData&&(null===(e=this.mapView)||void 0===e||e.recommendMapView(this,[this.options.chart.map,t.seriesOptions.mapData],null===(o=this.options.drilldown)||void 0===o?void 0:o.mapZooming))}var A=function(){function t(o,i){var n,s=this;this.allowTransformAnimation=!0,this.eventsToUnbind=[],this.insets=[],this.padding=[0,0,0,0],this.recommendedMapView={},this instanceof L||this.recommendMapView(o,l([o.options.chart.map],(o.options.series||[]).map(function(t){return t.mapData}),!0)),this.userOptions=i||{};var a=x(e,this.recommendedMapView,i),p=null===(n=this.recommendedMapView)||void 0===n?void 0:n.insets,h=i&&i.insets;p&&h&&(a.insets=t.mergeInsets(p,h)),this.chart=o,this.center=a.center,this.options=a,this.projection=new r(a.projection),this.playingField=o.plotBox,this.zoom=a.zoom||0,this.minZoom=a.minZoom,this.createInsets(),this.eventsToUnbind.push(d(o,"afterSetChartSize",function(){s.playingField=s.getField(),(void 0===s.minZoom||s.minZoom===s.zoom)&&(s.fitToBounds(void 0,void 0,!1),!s.chart.hasRendered&&g(s.userOptions.zoom)&&(s.zoom=s.userOptions.zoom),s.userOptions.center&&x(!0,s.center,s.userOptions.center))})),this.setUpEvents()}return t.compose=function(e){j(p,"MapView")&&(w=e.maps,d(e,"afterInit",function(){this.mapView=new t(this,this.options.mapView)},{order:0}),d(e,"addSeriesAsDrilldown",S),d(e,"afterDrillUp",S))},t.compositeBounds=function(t){if(t.length)return t.slice(1).reduce(function(t,e){return t.x1=Math.min(t.x1,e.x1),t.y1=Math.min(t.y1,e.y1),t.x2=Math.max(t.x2,e.x2),t.y2=Math.max(t.y2,e.y2),t},x(t[0]))},t.mergeInsets=function(t,e){var o=function(t){var e={};return t.forEach(function(t,o){e[t&&t.id||"i".concat(o)]=t}),e},i=x(o(t),o(e));return Object.keys(i).map(function(t){return i[t]})},t.prototype.createInsets=function(){var t=this,e=this.options,o=e.insets;o&&o.forEach(function(o){var i=new L(t,x(e.insetOptions,o));t.insets.push(i)})},t.prototype.fitToBounds=function(t,e,o,i){void 0===o&&(o=!0);var r=t||this.getProjectedBounds();if(r){var n=M(e,t?0:this.options.padding),s=this.getField(!1),a=m(n)?n:[n,n,n,n];this.padding=[C(a[0],s.height),C(a[1],s.width),C(a[2],s.height),C(a[3],s.width)],this.playingField=this.getField();var l=P(r,this.playingField);t||(this.minZoom=l);var p=this.projection.inverse([(r.x2+r.x1)/2,(r.y2+r.y1)/2]);this.setView(p,l,o,i)}},t.prototype.getField=function(t){void 0===t&&(t=!0);var e=t?this.padding:[0,0,0,0];return{x:e[3],y:e[0],width:this.chart.plotWidth-e[1]-e[3],height:this.chart.plotHeight-e[0]-e[2]}},t.prototype.getGeoMap=function(t){if(b(t))return w[t]&&"Topology"===w[t].type?h(w[t]):w[t];if(v(t,!0)){if("FeatureCollection"===t.type)return t;if("Topology"===t.type)return h(t)}},t.prototype.getMapBBox=function(){var t=this.getProjectedBounds(),e=this.getScale();if(t){var o=this.padding,i=this.projectedUnitsToPixels({x:t.x1,y:t.y2});return{width:(t.x2-t.x1)*e+o[1]+o[3],height:(t.y2-t.y1)*e+o[0]+o[2],x:i.x-o[3],y:i.y-o[0]}}},t.prototype.getProjectedBounds=function(){var e=this.projection,o=this.chart.series.reduce(function(t,e){var o=e.getProjectedBounds&&e.getProjectedBounds();return o&&!1!==e.options.affectsMapView&&t.push(o),t},[]),i=this.options.fitToGeometry;if(i){if(!this.fitToGeometryCache){if("MultiPoint"===i.type){var r=i.coordinates.map(function(t){return e.forward(t)}),n=r.map(function(t){return t[0]}),s=r.map(function(t){return t[1]});this.fitToGeometryCache={x1:Math.min.apply(0,n),x2:Math.max.apply(0,n),y1:Math.min.apply(0,s),y2:Math.max.apply(0,s)}}else this.fitToGeometryCache=c(e.path(i))}return this.fitToGeometryCache}return this.projection.bounds||t.compositeBounds(o)},t.prototype.getScale=function(){return 256/400.979322*Math.pow(2,this.zoom)},t.prototype.getSVGTransform=function(){var t=this.playingField,e=t.x,o=t.y,i=t.width,r=t.height,n=this.projection.forward(this.center),s=this.projection.hasCoordinates?-1:1,a=this.getScale(),l=a*s,p=e+i/2-n[0]*a,h=o+r/2-n[1]*l;return{scaleX:a,scaleY:l,translateX:p,translateY:h}},t.prototype.lonLatToPixels=function(t){var e=this.lonLatToProjectedUnits(t);if(e)return this.projectedUnitsToPixels(e)},t.prototype.lonLatToProjectedUnits=function(t){var e=this.chart,o=e.mapTransforms;if(o){for(var i in o)if(Object.hasOwnProperty.call(o,i)&&o[i].hitZone){var r=e.transformFromLatLon(t,o[i]);if(r&&u(r,o[i].hitZone.coordinates[0]))return r}return e.transformFromLatLon(t,o.default)}for(var n=0,s=this.insets;n<s.length;n++){var a=s[n];if(a.options.geoBounds&&u({x:t.lon,y:t.lat},a.options.geoBounds.coordinates[0])){var l=a.projection.forward([t.lon,t.lat]),p=a.projectedUnitsToPixels({x:l[0],y:l[1]});return this.pixelsToProjectedUnits(p)}}var h=this.projection.forward([t.lon,t.lat]);if(!h.outside)return{x:h[0],y:h[1]}},t.prototype.projectedUnitsToLonLat=function(t){var e=this.chart,o=e.mapTransforms;if(o){for(var i in o)if(Object.hasOwnProperty.call(o,i)&&o[i].hitZone&&u(t,o[i].hitZone.coordinates[0]))return e.transformToLatLon(t,o[i]);return e.transformToLatLon(t,o.default)}for(var r=this.projectedUnitsToPixels(t),n=0,s=this.insets;n<s.length;n++){var a=s[n];if(a.hitZone&&u(r,a.hitZone.coordinates[0])){var l=a.pixelsToProjectedUnits(r),p=a.projection.inverse([l.x,l.y]);return{lon:p[0],lat:p[1]}}}var h=this.projection.inverse([t.x,t.y]);return{lon:h[0],lat:h[1]}},t.prototype.recommendMapView=function(e,o,i){var r,n=this;void 0===i&&(i=!1),this.recommendedMapView={};var s=o.map(function(t){return n.getGeoMap(t)}),a=[];s.forEach(function(t){if(t&&(Object.keys(n.recommendedMapView).length||(n.recommendedMapView=t["hc-recommended-mapview"]||{}),t.bbox)){var e=t.bbox,o=e[0],i=e[1],r=e[2],s=e[3];a.push({x1:o,y1:i,x2:r,y2:s})}});var l=a.length&&t.compositeBounds(a);y(this,"onRecommendMapView",{geoBounds:l,chart:e},function(){if(l&&this.recommendedMapView){if(!this.recommendedMapView.projection){var t=l.x1,e=l.y1,o=l.x2,i=l.y2;this.recommendedMapView.projection=o-t>180&&i-e>90?{name:"EqualEarth",parallels:[0,0],rotation:[0]}:{name:"LambertConformalConic",parallels:[e,i],rotation:[-(t+o)/2]}}this.recommendedMapView.insets||(this.recommendedMapView.insets=void 0)}}),this.geoMap=s[0],i&&e.hasRendered&&!(null===(r=e.userOptions.mapView)||void 0===r?void 0:r.projection)&&this.recommendedMapView&&this.update(this.recommendedMapView)},t.prototype.redraw=function(t){this.chart.series.forEach(function(t){t.useMapGeometry&&(t.isDirty=!0)}),this.chart.redraw(t)},t.prototype.setView=function(t,e,o,i){void 0===o&&(o=!0),t&&(this.center=t),"number"==typeof e&&("number"==typeof this.minZoom&&(e=Math.max(e,this.minZoom)),"number"==typeof this.options.maxZoom&&(e=Math.min(e,this.options.maxZoom)),g(e)&&(this.zoom=e));var r=this.getProjectedBounds();if(r){var n=this.projection.forward(this.center),s=this.playingField,a=s.x,l=s.y,p=s.width,h=s.height,c=this.getScale(),u=this.projectedUnitsToPixels({x:r.x1,y:r.y1}),d=this.projectedUnitsToPixels({x:r.x2,y:r.y2}),f=[(r.x1+r.x2)/2,(r.y1+r.y2)/2];if(!this.chart.series.some(function(t){return t.isDrilling})){var m=u.x,v=d.y,b=d.x,x=u.y;b-m<p?n[0]=f[0]:m<a&&b<a+p?n[0]+=Math.max(m-a,b-p-a)/c:b>a+p&&m>a&&(n[0]+=Math.min(b-p-a,m-a)/c),x-v<h?n[1]=f[1]:v<l&&x<l+h?n[1]-=Math.max(v-l,x-h-l)/c:x>l+h&&v>l&&(n[1]-=Math.min(x-h-l,v-l)/c),this.center=this.projection.inverse(n)}this.insets.forEach(function(t){t.options.field&&(t.hitZone=t.getHitZone(),t.playingField=t.getField())}),this.render()}y(this,"afterSetView"),o&&this.redraw(i)},t.prototype.projectedUnitsToPixels=function(t){var e=this.getScale(),o=this.projection.forward(this.center),i=this.playingField,r=i.x+i.width/2,n=i.y+i.height/2;return{x:r-e*(o[0]-t.x),y:n+e*(o[1]-t.y)}},t.prototype.pixelsToLonLat=function(t){return this.projectedUnitsToLonLat(this.pixelsToProjectedUnits(t))},t.prototype.pixelsToProjectedUnits=function(t){var e=t.x,o=t.y,i=this.getScale(),r=this.projection.forward(this.center),n=this.playingField,s=n.x+n.width/2,a=n.y+n.height/2;return{x:r[0]+(e-s)/i,y:r[1]-(o-a)/i}},t.prototype.setUpEvents=function(){var t,e,o,i=this,r=this.chart,n=function(n){var s=r.pointer,a=s.lastTouches,l=s.pinchDown,p=i.projection,h=n.touches,c=r.mouseDownX,u=r.mouseDownY,d=0;if((null==l?void 0:l.length)===1?(c=l[0].chartX,u=l[0].chartY):(null==l?void 0:l.length)===2&&(c=(l[0].chartX+l[1].chartX)/2,u=(l[0].chartY+l[1].chartY)/2),(null==h?void 0:h.length)===2&&a&&(d=Math.log(Math.sqrt(Math.pow(a[0].chartX-a[1].chartX,2)+Math.pow(a[0].chartY-a[1].chartY,2))/Math.sqrt(Math.pow(h[0].chartX-h[1].chartX,2)+Math.pow(h[0].chartY-h[1].chartY,2)))/Math.log(.5)),g(c)&&g(u)){var y="".concat(c,",").concat(u),m=n.originalEvent,v=m.chartX,b=m.chartY;(null==h?void 0:h.length)===2&&(v=(h[0].chartX+h[1].chartX)/2,b=(h[0].chartY+h[1].chartY)/2),y!==e&&(e=y,t=i.projection.forward(i.center),o=(i.projection.options.rotation||[0,0]).slice());var x=p.def&&p.def.bounds,M=x&&P(x,i.playingField)||-1/0;if("Orthographic"===p.options.name&&2>((null==h?void 0:h.length)||0)&&(i.minZoom||1/0)<1.3*M){var j=440/(i.getScale()*Math.min(r.plotWidth,r.plotHeight));if(o){var C=(c-v)*j-o[0],w=f(-o[1]-(u-b)*j,-80,80),S=i.zoom;i.update({projection:{rotation:[-C,-w]}},!1),i.fitToBounds(void 0,void 0,!1),i.zoom=S,r.redraw(!1)}}else if(g(v)&&g(b)){var A=i.getScale(),L=i.projection.hasCoordinates?1:-1,O=i.projection.inverse([t[0]+(c-v)/A,t[1]-(u-b)/A*L]);isNaN(O[0]+O[1])||i.zoomBy(d,O,void 0,!1)}n.preventDefault()}};d(r,"pan",n),d(r,"touchpan",n),d(r,"selection",function(t){if(t.resetSelection)i.zoomBy();else{var e=t.x-r.plotLeft,o=t.y-r.plotTop,n=i.pixelsToProjectedUnits({x:e,y:o}),s=n.y,a=n.x,l=i.pixelsToProjectedUnits({x:e+t.width,y:o+t.height}),p=l.y,h=l.x;i.fitToBounds({x1:a,y1:s,x2:h,y2:p},void 0,!0,!t.originalEvent.touches&&void 0),/^touch/.test(t.originalEvent.type)||r.showResetZoom(),t.preventDefault()}})},t.prototype.render=function(){this.group||(this.group=this.chart.renderer.g("map-view").attr({zIndex:4}).add())},t.prototype.update=function(t,e,o){void 0===e&&(e=!0);var i=t.projection,n=i&&r.toString(i)!==r.toString(this.options.projection),s=!1;x(!0,this.userOptions,t),x(!0,this.options,t),"insets"in t&&(this.insets.forEach(function(t){return t.destroy()}),this.insets.length=0,s=!0),(n||"fitToGeometry"in t)&&delete this.fitToGeometryCache,(n||s)&&(this.chart.series.forEach(function(t){var e=t.transformGroups;if(t.clearBounds&&t.clearBounds(),t.isDirty=!0,t.isDirtyData=!0,s&&e)for(;e.length>1;){var o=e.pop();o&&o.destroy()}}),n&&(this.projection=new r(this.options.projection)),s&&this.createInsets(),!t.center&&Object.hasOwnProperty.call(t,"zoom")&&!g(t.zoom)&&this.fitToBounds(void 0,void 0,!1)),t.center||g(t.zoom)?this.setView(this.options.center,t.zoom,!1):"fitToGeometry"in t&&this.fitToBounds(void 0,void 0,!1),e&&this.chart.redraw(o)},t.prototype.zoomBy=function(t,e,o,i){var r=this.chart,n=this.projection.forward(this.center);if("number"==typeof t){var s=this.zoom+t,a=void 0,l=void 0,p=void 0;if(o){var h=o[0],c=o[1],u=this.getScale(),d=h-r.plotLeft-r.plotWidth/2,f=c-r.plotTop-r.plotHeight/2;l=n[0]+d/u,p=n[1]+f/u}if("number"==typeof l&&"number"==typeof p){var u=1-Math.pow(2,this.zoom)/Math.pow(2,s),d=n[0]-l,f=n[1]-p;n[0]-=d*u,n[1]+=f*u,a=this.projection.inverse(n)}this.setView(e||a,s,void 0,i)}else this.fitToBounds(void 0,void 0,void 0,i)},t}(),L=function(t){function e(e,o){var i=t.call(this,e.chart,o)||this;if(i.id=o.id,i.mapView=e,i.options=x({center:[0,0]},e.options.insetOptions,o),i.allBounds=[],i.options.geoBounds){var r=e.projection.path(i.options.geoBounds);i.geoBoundsProjectedBox=c(r),i.geoBoundsProjectedPolygon=r.map(function(t){return[t[1]||0,t[2]||0]})}return i}return a(e,t),e.prototype.getField=function(e){void 0===e&&(e=!0);var o=this.hitZone;if(o){var i=e?this.padding:[0,0,0,0],r=o.coordinates[0],n=r.map(function(t){return t[0]}),s=r.map(function(t){return t[1]}),a=Math.min.apply(0,n)+i[3],l=Math.max.apply(0,n)-i[1],p=Math.min.apply(0,s)+i[0],h=Math.max.apply(0,s)-i[2];if(g(a)&&g(p))return{x:a,y:p,width:l-a,height:h-p}}return t.prototype.getField.call(this,e)},e.prototype.getHitZone=function(){var t=this.chart,e=this.mapView,o=this.options,i=(o.field||{}).coordinates;if(i){var r=i[0];if("percent"===o.units){var n="mapBoundingBox"===o.relativeTo&&e.getMapBBox()||x(t.plotBox,{x:0,y:0});r=r.map(function(t){return[C("".concat(t[0],"%"),n.width,n.x),C("".concat(t[1],"%"),n.height,n.y)]})}return{type:"Polygon",coordinates:[r]}}},e.prototype.getProjectedBounds=function(){return A.compositeBounds(this.allBounds)},e.prototype.isInside=function(t){var e=this.geoBoundsProjectedBox,o=this.geoBoundsProjectedPolygon;return!!(e&&t.x>=e.x1&&t.x<=e.x2&&t.y>=e.y1&&t.y<=e.y2&&o&&u(t,o))},e.prototype.render=function(){var t=this.chart,e=this.mapView,o=this.options,i=o.borderPath||o.field;if(i&&e.group){var r=!0;this.border||(this.border=t.renderer.path().addClass("highcharts-mapview-inset-border").add(e.group),r=!1),t.styledMode||this.border.attr({stroke:o.borderColor,"stroke-width":o.borderWidth});var n=Math.round(this.border.strokeWidth())%2/2,s="mapBoundingBox"===o.relativeTo&&e.getMapBBox()||e.playingField,a=(i.coordinates||[]).reduce(function(e,i){return i.reduce(function(e,i,r){var a=i[0],l=i[1];return"percent"===o.units&&(a=t.plotLeft+C("".concat(a,"%"),s.width,s.x),l=t.plotTop+C("".concat(l,"%"),s.height,s.y)),a=Math.floor(a)+n,l=Math.floor(l)+n,e.push(0===r?["M",a,l]:["L",a,l]),e},e)},[]);this.border[r?"animate":"attr"]({d:a})}},e.prototype.destroy=function(){this.border&&(this.border=this.border.destroy()),this.eventsToUnbind.forEach(function(t){return t()})},e.prototype.setUpEvents=function(){},e}(A);return A}),o(e,"Series/Map/MapSeries.js",[e["Core/Animation/AnimationUtilities.js"],e["Series/ColorMapComposition.js"],e["Series/CenteredUtilities.js"],e["Core/Globals.js"],e["Core/Chart/MapChart.js"],e["Series/Map/MapPoint.js"],e["Series/Map/MapSeriesDefaults.js"],e["Maps/MapView.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o,i,r,n,s,a,l,p){var h,c=this&&this.__extends||(h=function(t,e){return(h=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}h(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),u=this&&this.__spreadArray||function(t,e,o){if(o||2==arguments.length)for(var i,r=0,n=e.length;r<n;r++)!i&&r in e||(i||(i=Array.prototype.slice.call(e,0,r)),i[r]=e[r]);return t.concat(i||Array.prototype.slice.call(e))},d=t.animObject,f=t.stop,y=i.noop,m=r.splitPath,g=l.seriesTypes,v=g.column,b=g.scatter,x=p.extend,M=p.find,j=p.fireEvent,C=p.getNestedProperty,w=p.isArray,P=p.defined,S=p.isNumber,A=p.isObject,L=p.merge,O=p.objectEach,T=p.pick,_=p.splat,z=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.processedData=[],e}return c(e,t),e.prototype.animate=function(t){var e=this.chart,o=this.group,i=d(this.options.animation);t?o.attr({translateX:e.plotLeft+e.plotWidth/2,translateY:e.plotTop+e.plotHeight/2,scaleX:.001,scaleY:.001}):o.animate({translateX:e.plotLeft,translateY:e.plotTop,scaleX:1,scaleY:1},i)},e.prototype.clearBounds=function(){this.points.forEach(function(t){delete t.bounds,delete t.insetIndex,delete t.projectedPath}),delete this.bounds},e.prototype.doFullTranslate=function(){return!!(this.isDirtyData||this.chart.isResizing||!this.hasRendered)},e.prototype.drawMapDataLabels=function(){t.prototype.drawDataLabels.call(this),this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)},e.prototype.drawPoints=function(){var t=this,e=this,o=this.chart,i=this.group,r=this.transformGroups,n=void 0===r?[]:r,s=o.mapView,a=o.renderer;if(s){this.transformGroups=n,n[0]||(n[0]=a.g().add(i));for(var l=0,p=s.insets.length;l<p;++l)n[l+1]||n.push(a.g().add(i));this.doFullTranslate()&&(this.points.forEach(function(t){var e=t.graphic;t.group=n["number"==typeof t.insetIndex?t.insetIndex+1:0],e&&e.parentGroup!==t.group&&e.add(t.group)}),v.prototype.drawPoints.apply(this),this.points.forEach(function(i){var r=i.graphic;if(r){var n=r.animate,s="";i.name&&(s+="highcharts-name-"+i.name.replace(/ /g,"-").toLowerCase()),i.properties&&i.properties["hc-key"]&&(s+=" highcharts-key-"+i.properties["hc-key"].toString().toLowerCase()),s&&r.addClass(s),o.styledMode&&r.css(t.pointAttribs(i,i.selected&&"select"||void 0)),r.attr({visibility:!i.visible&&(i.visible||i.isNull)?"hidden":"inherit"}),r.animate=function(t,i,s){var a=S(t["stroke-width"])&&!S(r["stroke-width"]),l=S(r["stroke-width"])&&!S(t["stroke-width"]);if(a||l){var p=T(e.getStrokeWidth(e.options),1)/(o.mapView&&o.mapView.getScale()||1);a&&(r["stroke-width"]=p),l&&(t["stroke-width"]=p)}return n.call(r,t,i,l?function(){r.element.removeAttribute("stroke-width"),delete r["stroke-width"],s&&s.apply(this,arguments)}:s)}}})),n.forEach(function(i,r){var n=(0===r?s:s.insets[r-1]).getSVGTransform(),l=T(t.getStrokeWidth(t.options),1),p=n.scaleX,h=n.scaleY>0?1:-1,c=function(o){(e.points||[]).forEach(function(e){var i,r=e.graphic;r&&r["stroke-width"]&&(i=t.getStrokeWidth(e.options))&&r.attr({"stroke-width":i/o})})};if(a.globalAnimation&&o.hasRendered&&s.allowTransformAnimation){var u=Number(i.attr("translateX")),y=Number(i.attr("translateY")),m=Number(i.attr("scaleX")),g=function(t,e){var o=m+(p-m)*e.pos;i.attr({translateX:u+(n.translateX-u)*e.pos,translateY:y+(n.translateY-y)*e.pos,scaleX:o,scaleY:o*h,"stroke-width":l/o}),c(o)},v=L(d(a.globalAnimation)),b=v.step;v.step=function(){b&&b.apply(this,arguments),g.apply(this,arguments)},i.attr({animator:0}).animate({animator:1},v,(function(){"boolean"!=typeof a.globalAnimation&&a.globalAnimation.complete&&a.globalAnimation.complete({applyDrilldown:!0}),j(this,"mapZoomComplete")}).bind(t))}else f(i),i.attr(L(n,{"stroke-width":l/p})),c(p)}),this.isDrilling||this.drawMapDataLabels()}},e.prototype.getProjectedBounds=function(){var t=this;if(!this.bounds&&this.chart.mapView){var e=this.chart.mapView,o=e.insets,i=e.projection,r=[];(this.points||[]).forEach(function(e){if(e.path||e.geometry){if("string"==typeof e.path?e.path=m(e.path):w(e.path)&&"M"===e.path[0]&&(e.path=t.chart.renderer.pathToSegments(e.path)),!e.bounds){var n=e.getProjectedBounds(i);if(n){e.labelrank=T(e.labelrank,(n.x2-n.x1)*(n.y2-n.y1));var s=n.midX,a=n.midY;if(o&&S(s)&&S(a)){var l=M(o,function(t){return t.isInside({x:s,y:a})});l&&(delete e.projectedPath,(n=e.getProjectedBounds(l.projection))&&l.allBounds.push(n),e.insetIndex=o.indexOf(l))}e.bounds=n}}e.bounds&&void 0===e.insetIndex&&r.push(e.bounds)}}),this.bounds=a.compositeBounds(r)}return this.bounds},e.prototype.getStrokeWidth=function(t){var e=this.pointAttrToOptions;return t[e&&e["stroke-width"]||"borderWidth"]},e.prototype.hasData=function(){return!!this.processedXData.length},e.prototype.pointAttribs=function(t,e){var o,i=t.series.chart,r=i.mapView,n=i.styledMode?this.colorAttribs(t):v.prototype.pointAttribs.call(this,t,e),s=this.getStrokeWidth(t.options);if(e){var a=L(this.options.states&&this.options.states[e],t.options.states&&t.options.states[e]||{}),l=this.getStrokeWidth(a);P(l)&&(s=l),n.stroke=null!==(o=a.borderColor)&&void 0!==o?o:t.color}s&&r&&(s/=r.getScale());var p=this.getStrokeWidth(this.options);return n.dashstyle&&r&&S(p)&&(s=p/r.getScale()),t.visible||(n.fill=this.options.nullColor),P(s)?n["stroke-width"]=s:delete n["stroke-width"],n["stroke-linecap"]=n["stroke-linejoin"]=this.options.linecap,n},e.prototype.updateData=function(){return!this.processedData&&t.prototype.updateData.apply(this,arguments)},e.prototype.setData=function(e,o,i,r){void 0===o&&(o=!0),delete this.bounds,t.prototype.setData.call(this,e,!1,void 0,r),this.processData(),this.generatePoints(),o&&this.chart.redraw(i)},e.prototype.processData=function(){var t,e,o,r=this.options,s=r.data,a=this.chart,l=a.options.chart,p=this.joinBy,h=r.keys||this.pointArrayMap,c=[],u={},d=this.chart.mapView,f=d&&(A(r.mapData,!0)?d.getGeoMap(r.mapData):d.geoMap),y=a.mapTransforms=l.mapTransforms||f&&f["hc-transform"]||a.mapTransforms;y&&O(y,function(t){t.rotation&&(t.cosAngle=Math.cos(t.rotation),t.sinAngle=Math.sin(t.rotation))}),w(r.mapData)?o=r.mapData:f&&"FeatureCollection"===f.type&&(this.mapTitle=f.title,o=i.geojson(f,this.type,this)),this.processedData=[];var m=this.processedData;if(s)for(var g=void 0,v=0,b=s.length;v<b;++v){if(S(g=s[v]))m[v]={value:g};else if(w(g)){var x=0;m[v]={},!r.keys&&g.length>h.length&&"string"==typeof g[0]&&(m[v]["hc-key"]=g[0],++x);for(var M=0;M<h.length;++M,++x)h[M]&&void 0!==g[x]&&(h[M].indexOf(".")>0?n.prototype.setNestedProperty(m[v],g[x],h[M]):m[v][h[M]]=g[x])}else m[v]=s[v];p&&"_i"===p[0]&&(m[v]._i=v)}if(o){this.mapData=o,this.mapMap={};for(var v=0;v<o.length;v++)e=(t=o[v]).properties,t._i=v,p[0]&&e&&e[p[0]]&&(t[p[0]]=e[p[0]]),u[t[p[0]]]=t;if(this.mapMap=u,p[1]){var j=p[1];m.forEach(function(t){var e=C(j,t);u[e]&&c.push(u[e])})}if(r.allAreas){if(p[1]){var P=p[1];m.forEach(function(t){c.push(C(P,t))})}var T="|"+c.map(function(t){return t&&t[p[0]]}).join("|")+"|";o.forEach(function(t){p[0]&&-1!==T.indexOf("|"+t[p[0]]+"|")||m.push(L(t,{value:null}))})}}this.processedXData=Array(m.length)},e.prototype.setOptions=function(e){var o=t.prototype.setOptions.call(this,e),i=o.joinBy;return null===o.joinBy&&(i="_i"),(i=this.joinBy=_(i))[1]||(i[1]=i[0]),o},e.prototype.translate=function(){var t=this.doFullTranslate(),e=this.chart.mapView,o=e&&e.projection;if(this.chart.hasRendered&&(this.isDirtyData||!this.hasRendered)&&(this.processData(),this.generatePoints(),delete this.bounds,!e||e.userOptions.center||S(e.userOptions.zoom)||e.zoom!==e.minZoom?this.getProjectedBounds():e.fitToBounds(void 0,void 0,!1)),e){var i=e.getSVGTransform();this.points.forEach(function(r){var s=S(r.insetIndex)&&e.insets[r.insetIndex].getSVGTransform()||i;s&&r.bounds&&S(r.bounds.midX)&&S(r.bounds.midY)&&(r.plotX=r.bounds.midX*s.scaleX+s.translateX,r.plotY=r.bounds.midY*s.scaleY+s.translateY),t&&(r.shapeType="path",r.shapeArgs={d:n.getProjectedPath(r,o)}),r.hiddenInDataClass||(r.projectedPath&&!r.projectedPath.length?r.setVisible(!1):r.visible||r.setVisible(!0))})}j(this,"afterTranslate")},e.prototype.update=function(e){var o,i=this;e.mapData&&(null===(o=this.chart.mapView)||void 0===o||o.recommendMapView(this.chart,u([this.chart.options.chart.map],(this.chart.options.series||[]).map(function(t,o){return o===i._i?e.mapData:t.mapData}),!0),!0)),t.prototype.update.apply(this,arguments)},e.defaultOptions=L(b.defaultOptions,s),e}(b);return x(z.prototype,{type:"map",axisTypes:e.seriesMembers.axisTypes,colorAttribs:e.seriesMembers.colorAttribs,colorKey:e.seriesMembers.colorKey,directTouch:!0,drawDataLabels:y,drawGraph:y,forceDL:!0,getCenter:o.getCenter,getExtremesFromAll:!0,getSymbol:y,isCartesian:!1,parallelArrays:e.seriesMembers.parallelArrays,pointArrayMap:e.seriesMembers.pointArrayMap,pointClass:n,preserveAspectRatio:!0,searchPoint:y,trackerGroups:e.seriesMembers.trackerGroups,useMapGeometry:!0}),e.compose(z),l.registerSeriesType("map",z),z}),o(e,"Series/MapLine/MapLineSeriesDefaults.js",[],function(){return{lineWidth:1,fillColor:"none",legendSymbol:"lineMarker"}}),o(e,"Series/MapLine/MapLineSeries.js",[e["Series/MapLine/MapLineSeriesDefaults.js"],e["Series/Map/MapSeries.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o,i){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),s=i.extend,a=i.merge,l=function(o){function i(){return null!==o&&o.apply(this,arguments)||this}return n(i,o),i.prototype.pointAttribs=function(t,e){var i=o.prototype.pointAttribs.call(this,t,e);return i.fill=this.options.fillColor,i},i.defaultOptions=a(e.defaultOptions,t),i}(e);return s(l.prototype,{type:"mapline",colorProp:"stroke",pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"}}),o.registerSeriesType("mapline",l),l}),o(e,"Series/MapPoint/MapPointPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,i=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),r=t.seriesTypes.scatter,n=e.isNumber;return function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i(e,t),e.prototype.isValid=function(){return!!(this.options.geometry||n(this.x)&&n(this.y)||n(this.options.lon)&&n(this.options.lat))},e}(r.prototype.pointClass)}),o(e,"Series/MapPoint/MapPointSeriesDefaults.js",[],function(){return{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}},legendSymbol:"lineMarker"}}),o(e,"Series/MapPoint/MapPointSeries.js",[e["Core/Globals.js"],e["Series/MapPoint/MapPointPoint.js"],e["Series/MapPoint/MapPointSeriesDefaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"]],function(t,e,o,i,r,n){var s,a=this&&this.__extends||(s=function(t,e){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}s(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),l=t.noop,p=i.seriesTypes,h=p.map,c=p.scatter,u=n.extend,d=n.fireEvent,f=n.isNumber,y=n.merge,m=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.clearBounds=h.prototype.clearBounds,e}return a(e,t),e.prototype.drawDataLabels=function(){t.prototype.drawDataLabels.call(this),this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)},e.prototype.projectPoint=function(t){var e=this.chart.mapView;if(e){var o=t.geometry,i=t.lon,r=t.lat,n=o&&"Point"===o.type&&o.coordinates;if(f(i)&&f(r)&&(n=[i,r]),n)return e.lonLatToProjectedUnits({lon:n[0],lat:n[1]})}},e.prototype.translate=function(){var t=this,e=this.chart.mapView;if(this.processedXData||this.processData(),this.generatePoints(),this.getProjectedBounds&&this.isDirtyData&&(delete this.bounds,this.getProjectedBounds()),e){var o=e.getSVGTransform(),i=e.projection.hasCoordinates;this.points.forEach(function(r){var n,s=r.x,a=void 0===s?void 0:s,l=r.y,p=void 0===l?void 0:l,h=f(r.insetIndex)&&e.insets[r.insetIndex].getSVGTransform()||o,c=t.projectPoint(r.options)||r.properties&&t.projectPoint(r.properties);if(c?(a=c.x,p=c.y):r.bounds&&(a=r.bounds.midX,p=r.bounds.midY,h&&f(a)&&f(p)&&(r.plotX=a*h.scaleX+h.translateX,r.plotY=p*h.scaleY+h.translateY,n=!0)),f(a)&&f(p)){if(!n){var u=e.projectedUnitsToPixels({x:a,y:p});r.plotX=u.x,r.plotY=i?u.y:t.chart.plotHeight-u.y}}else r.y=r.plotX=r.plotY=void 0;r.isInside=t.isPointInside(r),r.zone=t.zones.length?r.getZone():void 0})}d(this,"afterTranslate")},e.defaultOptions=y(c.defaultOptions,o),e}(c);return r.prototype.symbols.mapmarker=function(t,e,o,i,r){var n,s,a=r&&"legend"===r.context;a?(n=t+o/2,s=e+i):r&&"number"==typeof r.anchorX&&"number"==typeof r.anchorY?(n=r.anchorX,s=r.anchorY):(n=t+o/2,s=e+i/2,e-=i);var l=a?i/3:i/2;return[["M",n,s],["C",n,s,n-l,e+1.5*l,n-l,e+l],["A",l,l,1,1,1,n+l,e+l],["C",n+l,e+1.5*l,n,s,n,s],["Z"]]},u(m.prototype,{type:"mappoint",axisTypes:["colorAxis"],forceDL:!0,isCartesian:!1,pointClass:e,searchPoint:l,useMapGeometry:!0}),i.registerSeriesType("mappoint",m),m}),o(e,"Series/Bubble/BubbleLegendDefaults.js",[],function(){return{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"0.9em",color:"#000000"},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}}),o(e,"Series/Bubble/BubbleLegendItem.js",[e["Core/Color/Color.js"],e["Core/Templating.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,o,i){var r=t.parse,n=o.noop,s=i.arrayMax,a=i.arrayMin,l=i.isNumber,p=i.merge,h=i.pick,c=i.stableSort;return function(){function t(t,e){this.setState=n,this.init(t,e)}return t.prototype.init=function(t,e){this.options=t,this.visible=!0,this.chart=e.chart,this.legend=e},t.prototype.addToLegend=function(t){t.splice(this.options.legendIndex,0,this)},t.prototype.drawLegendSymbol=function(t){var e,o=h(t.options.itemDistance,20),i=this.legendItem||{},r=this.options,n=r.ranges,s=r.connectorDistance;if(!n||!n.length||!l(n[0].value)){t.options.bubbleLegend.autoRanges=!0;return}c(n,function(t,e){return e.value-t.value}),this.ranges=n,this.setOptions(),this.render();var a=this.getMaxLabelSize(),p=this.ranges[0].radius,u=2*p;e=(e=s-p+a.width)>0?e:0,this.maxLabel=a,this.movementX="left"===r.labels.align?e:0,i.labelWidth=u+e+o,i.labelHeight=u+a.height/2},t.prototype.setOptions=function(){var t=this.ranges,e=this.options,o=this.chart.series[e.seriesIndex],i=this.legend.baseline,n={zIndex:e.zIndex,"stroke-width":e.borderWidth},s={zIndex:e.zIndex,"stroke-width":e.connectorWidth},a={align:this.legend.options.rtl||"left"===e.labels.align?"right":"left",zIndex:e.zIndex},l=o.options.marker.fillOpacity,c=this.chart.styledMode;t.forEach(function(u,d){c||(n.stroke=h(u.borderColor,e.borderColor,o.color),n.fill=h(u.color,e.color,1!==l?r(o.color).setOpacity(l).get("rgba"):o.color),s.stroke=h(u.connectorColor,e.connectorColor,o.color)),t[d].radius=this.getRangeRadius(u.value),t[d]=p(t[d],{center:t[0].radius-t[d].radius+i}),c||p(!0,t[d],{bubbleAttribs:p(n),connectorAttribs:p(s),labelAttribs:a})},this)},t.prototype.getRangeRadius=function(t){var e=this.options,o=this.options.seriesIndex,i=this.chart.series[o],r=e.ranges[0].value,n=e.ranges[e.ranges.length-1].value,s=e.minSize,a=e.maxSize;return i.getRadius.call(this,n,r,s,a,t)},t.prototype.render=function(){var t=this.legendItem||{},e=this.chart.renderer,o=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]}),t.symbol=e.g("bubble-legend"),t.label=e.g("bubble-legend-item").css(this.legend.itemStyle||{}),t.symbol.translateX=0,t.symbol.translateY=0,t.symbol.add(t.label),t.label.add(t.group);for(var i=0,r=this.ranges;i<r.length;i++){var n=r[i];n.value>=o&&this.renderRange(n)}this.hideOverlappingLabels()},t.prototype.renderRange=function(t){var e=this.ranges[0],o=this.legend,i=this.options,r=i.labels,n=this.chart,s=n.series[i.seriesIndex],a=n.renderer,l=this.symbols,p=l.labels,h=t.center,c=Math.abs(t.radius),u=i.connectorDistance||0,d=r.align,f=o.options.rtl,y=i.borderWidth,m=i.connectorWidth,g=e.radius||0,v=h-c-y/2+m/2,b=(v%1?1:.5)-(m%2?0:.5),x=a.styledMode,M=f||"left"===d?-u:u;"center"===d&&(M=0,i.connectorDistance=0,t.labelAttribs.align="center"),l.bubbleItems.push(a.circle(g,h+b,c).attr(x?{}:t.bubbleAttribs).addClass((x?"highcharts-color-"+s.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(i.className||"")).add(this.legendItem.symbol)),l.connectors.push(a.path(a.crispLine([["M",g,v],["L",g+M,v]],i.connectorWidth)).attr(x?{}:t.connectorAttribs).addClass((x?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(i.connectorClassName||"")).add(this.legendItem.symbol));var j=a.text(this.formatLabel(t)).attr(x?{}:t.labelAttribs).css(x?{}:r.style).addClass("highcharts-bubble-legend-labels "+(i.labels.className||"")).add(this.legendItem.symbol),C={x:g+M+i.labels.x,y:v+i.labels.y+.4*j.getBBox().height};j.attr(C),p.push(j),j.placed=!0,j.alignAttr=C},t.prototype.getMaxLabelSize=function(){var t,e;return this.symbols.labels.forEach(function(o){e=o.getBBox(!0),t=t?e.width>t.width?e:t:e}),t||{}},t.prototype.formatLabel=function(t){var o=this.options,i=o.labels.formatter,r=o.labels.format,n=this.chart.numberFormatter;return r?e.format(r,t):i?i.call(t):n(t.value,1)},t.prototype.hideOverlappingLabels=function(){var t=this.chart,e=this.options.labels.allowOverlap,o=this.symbols;!e&&o&&(t.hideOverlappingLabels(o.labels),o.labels.forEach(function(t,e){t.newOpacity?t.newOpacity!==t.oldOpacity&&o.connectors[e].show():o.connectors[e].hide()}))},t.prototype.getRanges=function(){var t,e,o=this.legend.bubbleLegend,i=o.chart.series,r=o.options.ranges,n=Number.MAX_VALUE,c=-Number.MAX_VALUE;return i.forEach(function(t){t.isBubble&&!t.ignoreSeries&&(e=t.zData.filter(l)).length&&(n=h(t.options.zMin,Math.min(n,Math.max(a(e),!1===t.options.displayNegative?t.options.zThreshold:-Number.MAX_VALUE))),c=h(t.options.zMax,Math.max(c,s(e))))}),t=n===c?[{value:c}]:[{value:n},{value:(n+c)/2},{value:c,autoRanges:!0}],r.length&&r[0].radius&&t.reverse(),t.forEach(function(e,o){r&&r[o]&&(t[o]=p(r[o],e))}),t},t.prototype.predictBubbleSizes=function(){var t,e=this.chart,o=e.legend.options,i=o.floating,r="horizontal"===o.layout,n=r?e.legend.lastLineHeight:0,s=e.plotSizeX,a=e.plotSizeY,l=e.series[this.options.seriesIndex],p=l.getPxExtremes(),h=Math.ceil(p.minPxSize),c=Math.ceil(p.maxPxSize),u=l.options.maxSize;return i||!/%$/.test(u)?t=c:(t=(Math.min(a,s)+n)*(u=parseFloat(u))/100/(u/100+1),(r&&a-t>=s||!r&&s-t>=a)&&(t=c)),[h,Math.ceil(t)]},t.prototype.updateRanges=function(t,e){var o=this.legend.options.bubbleLegend;o.minSize=t,o.maxSize=e,o.ranges=this.getRanges()},t.prototype.correctSizes=function(){var t=this.legend,e=this.chart.series[this.options.seriesIndex].getPxExtremes();Math.abs(Math.ceil(e.maxPxSize)-this.options.maxSize)>1&&(this.updateRanges(this.options.minSize,e.maxPxSize),t.render())},t}()}),o(e,"Series/Bubble/BubbleLegendComposition.js",[e["Series/Bubble/BubbleLegendDefaults.js"],e["Series/Bubble/BubbleLegendItem.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,o,i,r){var n=o.setOptions,s=i.composed,a=r.addEvent,l=r.objectEach,p=r.pushUnique,h=r.wrap;function c(t,e,o){var i,r,n,s=this.legend,a=u(this)>=0;s&&s.options.enabled&&s.bubbleLegend&&s.options.bubbleLegend.autoRanges&&a?(i=s.bubbleLegend.options,r=s.bubbleLegend.predictBubbleSizes(),s.bubbleLegend.updateRanges(r[0],r[1]),i.placed||(s.group.placed=!1,s.allItems.forEach(function(t){(n=t.legendItem||{}).group&&(n.group.translateY=void 0)})),s.render(),this.getMargins(),this.axes.forEach(function(t){t.visible&&t.render(),i.placed||(t.setScale(),t.updateNames(),l(t.ticks,function(t){t.isNew=!0,t.isNewLabel=!0}))}),i.placed=!0,this.getMargins(),t.call(this,e,o),s.bubbleLegend.correctSizes(),m(s,d(s))):(t.call(this,e,o),s&&s.options.enabled&&s.bubbleLegend&&(s.render(),m(s,d(s))))}function u(t){for(var e=t.series,o=0;o<e.length;){if(e[o]&&e[o].isBubble&&e[o].visible&&e[o].zData.length)return o;o++}return -1}function d(t){var e,o,i,r=t.allItems,n=[],s=r.length,a=0,l=0;for(a=0;a<s;a++)if(o=r[a].legendItem||{},i=(r[a+1]||{}).legendItem||{},o.labelHeight&&(r[a].itemHeight=o.labelHeight),r[a]===r[s-1]||o.y!==i.y){for(n.push({height:0}),e=n[n.length-1];l<=a;l++)r[l].itemHeight>e.height&&(e.height=r[l].itemHeight);e.step=a}return n}function f(t){var o=this.bubbleLegend,i=this.options,r=i.bubbleLegend,n=u(this.chart);o&&o.ranges&&o.ranges.length&&(r.ranges.length&&(r.autoRanges=!!r.ranges[0].autoRanges),this.destroyItem(o)),n>=0&&i.enabled&&r.enabled&&(r.seriesIndex=n,this.bubbleLegend=new e(r,this),this.bubbleLegend.addToLegend(t.allItems))}function y(t){if(t.defaultPrevented)return!1;var e,o=this.chart,i=this.visible,r=this.chart.legend;r&&r.bubbleLegend&&(this.visible=!i,this.ignoreSeries=i,e=u(o)>=0,r.bubbleLegend.visible!==e&&(r.update({bubbleLegend:{enabled:e}}),r.bubbleLegend.visible=e),this.visible=i)}function m(t,e){var o,i,r,n,s=t.allItems,a=t.options.rtl,l=0;s.forEach(function(t,s){(n=t.legendItem||{}).group&&(o=n.group.translateX||0,i=n.y||0,((r=t.movementX)||a&&t.ranges)&&(r=a?o-t.options.maxSize/2:o+r,n.group.attr({translateX:r})),s>e[l].step&&l++,n.group.attr({translateY:Math.round(i+e[l].height/2)}),n.y=i+e[l].height/2)})}return{compose:function(e,o,i){p(s,"Series.BubbleLegend")&&(n({legend:{bubbleLegend:t}}),h(e.prototype,"drawChartBox",c),a(o,"afterGetAllItems",f),a(i,"legendItemClick",y))}}}),o(e,"Series/Bubble/BubblePoint.js",[e["Core/Series/Point.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var i,r=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),n=e.seriesTypes.scatter.prototype.pointClass,s=o.extend,a=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return r(o,e),o.prototype.haloPath=function(e){return t.prototype.haloPath.call(this,0===e?0:(this.marker&&this.marker.radius||0)+e)},o}(n);return s(a.prototype,{ttBelow:!1}),a}),o(e,"Series/Bubble/BubbleSeries.js",[e["Series/Bubble/BubbleLegendComposition.js"],e["Series/Bubble/BubblePoint.js"],e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o,i,r,n){var s,a=this&&this.__extends||(s=function(t,e){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}s(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),l=o.parse,p=i.composed,h=i.noop,c=r.series,u=r.seriesTypes,d=u.column.prototype,f=u.scatter,y=n.addEvent,m=n.arrayMax,g=n.arrayMin,v=n.clamp,b=n.extend,x=n.isNumber,M=n.merge,j=n.pick,C=n.pushUnique;function w(){var t,e=this,o=this.len,i=this.coll,r=this.isXAxis,n=this.min,s=r?"xData":"yData",a=(this.max||0)-(n||0),l=0,p=o,h=o/a;("xAxis"===i||"yAxis"===i)&&(this.series.forEach(function(o){if(o.bubblePadding&&o.reserveSpace()){e.allowZoomOutside=!0,t=!0;var i=o[s];if(r&&((o.onPoint||o).getRadii(0,0,o),o.onPoint&&(o.radii=o.onPoint.radii)),a>0){for(var c=i.length;c--;)if(x(i[c])&&e.dataMin<=i[c]&&i[c]<=e.max){var u=o.radii&&o.radii[c]||0;l=Math.min((i[c]-n)*h-u,l),p=Math.max((i[c]-n)*h+u,p)}}}}),t&&a>0&&!this.logarithmic&&(p-=o,h*=(o+Math.max(0,l)-Math.min(p,o))/o,[["min","userMin",l],["max","userMax",p]].forEach(function(t){void 0===j(e.options[t[0]],e[t[1]])&&(e[t[0]]+=t[2]/h)})))}var P=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return a(o,e),o.compose=function(e,o,i,r){t.compose(o,i,r),C(p,"Series.Bubble")&&y(e,"foundExtremes",w)},o.prototype.animate=function(t){!t&&this.points.length<this.options.animationLimit&&this.points.forEach(function(t){var e=t.graphic;e&&e.width&&(this.hasRendered||e.attr({x:t.plotX,y:t.plotY,width:1,height:1}),e.animate(this.markerAttribs(t),this.options.animation))},this)},o.prototype.getRadii=function(){var t,e,o,i=this.zData,r=this.yData,n=[],s=this.chart.bubbleZExtremes,a=this.getPxExtremes(),l=a.minPxSize,p=a.maxPxSize;if(!s){var h,c=Number.MAX_VALUE,u=-Number.MAX_VALUE;this.chart.series.forEach(function(t){if(t.bubblePadding&&t.reserveSpace()){var e=(t.onPoint||t).getZExtremes();e&&(c=Math.min(j(c,e.zMin),e.zMin),u=Math.max(j(u,e.zMax),e.zMax),h=!0)}}),h?(s={zMin:c,zMax:u},this.chart.bubbleZExtremes=s):s={zMin:0,zMax:0}}for(e=0,t=i.length;e<t;e++)o=i[e],n.push(this.getRadius(s.zMin,s.zMax,l,p,o,r&&r[e]));this.radii=n},o.prototype.getRadius=function(t,e,o,i,r,n){var s=this.options,a="width"!==s.sizeBy,l=s.zThreshold,p=e-t,h=.5;if(null===n||null===r)return null;if(x(r)){if(s.sizeByAbsoluteValue&&(r=Math.abs(r-l),e=p=Math.max(e-l,Math.abs(t-l)),t=0),r<t)return o/2-1;p>0&&(h=(r-t)/p)}return a&&h>=0&&(h=Math.sqrt(h)),Math.ceil(o+h*(i-o))/2},o.prototype.hasData=function(){return!!this.processedXData.length},o.prototype.pointAttribs=function(t,e){var o=this.options.marker.fillOpacity,i=c.prototype.pointAttribs.call(this,t,e);return 1!==o&&(i.fill=l(i.fill).setOpacity(o).get("rgba")),i},o.prototype.translate=function(){e.prototype.translate.call(this),this.getRadii(),this.translateBubble()},o.prototype.translateBubble=function(){for(var t=this.data,e=this.options,o=this.radii,i=this.getPxExtremes().minPxSize,r=t.length;r--;){var n=t[r],s=o?o[r]:0;"z"===this.zoneAxis&&(n.negative=(n.z||0)<(e.zThreshold||0)),x(s)&&s>=i/2?(n.marker=b(n.marker,{radius:s,width:2*s,height:2*s}),n.dlBox={x:n.plotX-s,y:n.plotY-s,width:2*s,height:2*s}):(n.shapeArgs=n.plotY=n.dlBox=void 0,n.isInside=!1)}},o.prototype.getPxExtremes=function(){var t=Math.min(this.chart.plotWidth,this.chart.plotHeight),e=function(e){var o;return"string"==typeof e&&(o=/%$/.test(e),e=parseInt(e,10)),o?t*e/100:e},o=e(j(this.options.minSize,8)),i=Math.max(e(j(this.options.maxSize,"20%")),o);return{minPxSize:o,maxPxSize:i}},o.prototype.getZExtremes=function(){var t=this.options,e=(this.zData||[]).filter(x);if(e.length){var o=j(t.zMin,v(g(e),!1===t.displayNegative?t.zThreshold||0:-Number.MAX_VALUE,Number.MAX_VALUE)),i=j(t.zMax,m(e));if(x(o)&&x(i))return{zMin:o,zMax:i}}},o.defaultOptions=M(f.defaultOptions,{dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,e=this.point.z;return x(e)?t(e,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"}),o}(f);return b(P.prototype,{alignDataLabel:d.alignDataLabel,applyZones:h,bubblePadding:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:e,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"}),y(P,"updatedData",function(t){delete t.target.chart.bubbleZExtremes}),y(P,"remove",function(t){delete t.target.chart.bubbleZExtremes}),r.registerSeriesType("bubble",P),P}),o(e,"Series/MapBubble/MapBubblePoint.js",[e["Series/Bubble/BubblePoint.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o){var i,r=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),n=e.seriesTypes.map.prototype.pointClass.prototype,s=o.extend,a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r(e,t),e.prototype.isValid=function(){return"number"==typeof this.z},e}(t);return s(a.prototype,{applyOptions:n.applyOptions,getProjectedBounds:n.getProjectedBounds}),a}),o(e,"Series/MapBubble/MapBubbleSeries.js",[e["Series/Bubble/BubbleSeries.js"],e["Series/MapBubble/MapBubblePoint.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,o,i){var r,n=this&&this.__extends||(r=function(t,e){return(r=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),s=o.seriesTypes,a=s.map.prototype,l=s.mappoint.prototype,p=i.extend,h=i.merge,c=function(e){function o(){var t=null!==e&&e.apply(this,arguments)||this;return t.clearBounds=a.clearBounds,t}return n(o,e),o.prototype.searchPoint=function(t,e){return this.searchKDTree({plotX:t.chartX-this.chart.plotLeft,plotY:t.chartY-this.chart.plotTop},e,t)},o.prototype.translate=function(){l.translate.call(this),this.getRadii(),this.translateBubble()},o.prototype.updateParallelArrays=function(t,o,i){e.prototype.updateParallelArrays.call(this,t,o,i);var r=this.processedXData,n=this.xData;r&&n&&(r.length=n.length)},o.defaultOptions=h(t.defaultOptions,{lineWidth:0,animationLimit:500,joinBy:"hc-key",tooltip:{pointFormat:"{point.name}: {point.z}"}}),o}(t);return p(c.prototype,{type:"mapbubble",axisTypes:["colorAxis"],getProjectedBounds:a.getProjectedBounds,isCartesian:!1,pointArrayMap:["z"],pointClass:e,processData:a.processData,projectPoint:l.projectPoint,kdAxisArray:["plotX","plotY"],setData:a.setData,setOptions:a.setOptions,updateData:a.updateData,useMapGeometry:!0,xyFromShape:!0}),o.registerSeriesType("mapbubble",c),c}),o(e,"Series/Heatmap/HeatmapPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var o,i=this&&this.__extends||(o=function(t,e){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function i(){this.constructor=t}o(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}),r=t.seriesTypes.scatter.prototype.pointClass,n=e.clamp,s=e.defined,a=e.extend,l=e.pick,p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i(e,t),e.prototype.applyOptions=function(e,o){return(this.isNull||null===this.value)&&delete this.color,t.prototype.applyOptions.call(this,e,o),this.formatPrefix=this.isNull||null===this.value?"null":"point",this},e.prototype.getCellAttributes=function(){for(var t=this.series,e=t.options,o=(e.colsize||1)/2,i=(e.rowsize||1)/2,r=t.xAxis,a=t.yAxis,p=this.options.marker||t.options.marker,h=t.pointPlacementToXValue(),c=l(this.pointPadding,e.pointPadding,0),u={x1:n(Math.round(r.len-r.translate(this.x-o,!1,!0,!1,!0,-h)),-r.len,2*r.len),x2:n(Math.round(r.len-r.translate(this.x+o,!1,!0,!1,!0,-h)),-r.len,2*r.len),y1:n(Math.round(a.translate(this.y-i,!1,!0,!1,!0)),-a.len,2*a.len),y2:n(Math.round(a.translate(this.y+i,!1,!0,!1,!0)),-a.len,2*a.len)},d=0,f=[["width","x"],["height","y"]];d<f.length;d++){var y=f[d],m=y[0],g=y[1],v=g+"1",b=g+"2",x=Math.abs(u[v]-u[b]),M=p&&p.lineWidth||0,j=Math.abs(u[v]+u[b])/2,C=p&&p[m];if(s(C)&&C<x){var w=C/2+M/2;u[v]=j-w,u[b]=j+w}c&&(("x"===g&&r.reversed||"y"===g&&!a.reversed)&&(v=b,b=g+"1"),u[v]+=c,u[b]-=c)}return u},e.prototype.haloPath=function(t){if(!t)return[];var e=this.shapeArgs||{},o=e.x,i=void 0===o?0:o,r=e.y,n=void 0===r?0:r,s=e.width,a=void 0===s?0:s,l=e.height,p=void 0===l?0:l;return[["M",i-t,n-t],["L",i-t,n+p+t],["L",i+a+t,n+p+t],["L",i+a+t,n-t],["Z"]]},e.prototype.isValid=function(){return this.value!==1/0&&this.value!==-1/0},e}(r);return a(p.prototype,{dataLabelOnNull:!0,moveToTopOnHover:!0,ttBelow:!1}),p}),o(e,"Series/Heatmap/HeatmapSeriesDefaults.js",[e["Core/Utilities.js"]],function(t){var e=t.isNumber;return{animation:!1,borderRadius:0,borderWidth:0,interpolation:!1,nullColor:"#f7f7f7",dataLabels:{formatter:function(){var t=this.series.chart.numberFormatter,o=this.point.value;return e(o)?t(o,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:"allow",padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}},legendSymbol:"rectangle"}}),o(e,"Series/InterpolationUtilities.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){var o=t.doc,i=e.defined,r=e.pick;return{colorFromPoint:function(t,e){var o=e.series.colorAxis;if(o){var n=o.toColor(t||0,e).split(")")[0].split("(")[1].split(",").map(function(t){return r(parseFloat(t),parseInt(t,10))});return n[3]=255*r(n[3],1),i(t)&&e.visible||(n[3]=0),n}return[0,0,0,0]},getContext:function(t){var e=t.canvas,i=t.context;return e&&i?(i.clearRect(0,0,e.width,e.height),i):(t.canvas=o.createElement("canvas"),t.context=t.canvas.getContext("2d",{willReadFrequently:!0})||void 0,t.context)}}}),o(e,"Series/Heatmap/HeatmapSeries.js",[e["Core/Color/Color.js"],e["Series/ColorMapComposition.js"],e["Series/Heatmap/HeatmapPoint.js"],e["Series/Heatmap/HeatmapSeriesDefaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"],e["Series/InterpolationUtilities.js"]],function(t,e,o,i,r,n,s,a){var l,p=this&&this.__extends||(l=function(t,e){return(l=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}l(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),h=this&&this.__assign||function(){return(h=Object.assign||function(t){for(var e,o=1,i=arguments.length;o<i;o++)for(var r in e=arguments[o])Object.prototype.hasOwnProperty.call(e,r)&&(t[r]=e[r]);return t}).apply(this,arguments)},c=r.series,u=r.seriesTypes,d=u.column,f=u.scatter,y=n.prototype.symbols,m=s.addEvent,g=s.extend,v=s.fireEvent,b=s.isNumber,x=s.merge,M=s.pick,j=a.colorFromPoint,C=a.getContext,w=function(e){function o(){var t=null!==e&&e.apply(this,arguments)||this;return t.valueMax=NaN,t.valueMin=NaN,t.isDirtyCanvas=!0,t}return p(o,e),o.prototype.drawPoints=function(){var t=this,e=t.options,o=e.interpolation,i=e.marker||{};if(o){var r=t.image,n=t.chart,s=t.xAxis,a=t.yAxis,l=s.reversed,p=s.len,u=a.reversed,d=a.len,f={width:p,height:d};if(!r||t.isDirtyData||t.isDirtyCanvas){var y=C(t),m=t.canvas,g=t.options,v=g.colsize,b=g.rowsize,x=t.points,M=t.points.length,w=n.colorAxis&&n.colorAxis[0];if(m&&y&&w){var P=s.getExtremes(),S=P.min,A=P.max,L=a.getExtremes(),O=L.min,T=L.max,_=A-S,z=T-O,D=Math.round(_/(void 0===v?1:v)/8*8),B=Math.round(z/(void 0===b?1:b)/8*8),k=[[D,D/_,void 0!==l&&l,"ceil"],[B,B/z,!(void 0!==u&&u),"floor"]].map(function(t){var e=t[0],o=t[1],i=t[2],r=t[3];return i?function(t){return Math[r](e-o*t)}:function(t){return Math[r](o*t)}}),E=k[0],I=k[1],V=m.width=D+1,U=V*(m.height=B+1),X=(M-1)/U,N=new Uint8ClampedArray(4*U);t.buildKDTree();for(var G=0;G<U;G++){var R=x[Math.ceil(X*G)],Y=R.x,W=R.y;N.set(j(R.value,R),4*Math.ceil(V*I(W-O)+E(Y-S)))}y.putImageData(new ImageData(N,V),0,0),r?r.attr(h(h({},f),{href:m.toDataURL("image/png",1)})):(t.directTouch=!1,t.image=n.renderer.image(m.toDataURL("image/png",1)).attr(f).add(t.group))}t.isDirtyCanvas=!1}else(r.width!==p||r.height!==d)&&r.attr(f)}else(i.enabled||t._hasPointMarkers)&&(c.prototype.drawPoints.call(t),t.points.forEach(function(e){e.graphic&&(e.graphic[t.chart.styledMode?"css":"animate"](t.colorAttribs(e)),null===e.value&&e.graphic.addClass("highcharts-null-point"))}))},o.prototype.getExtremes=function(){var t=c.prototype.getExtremes.call(this,this.valueData),e=t.dataMin,o=t.dataMax;return b(e)&&(this.valueMin=e),b(o)&&(this.valueMax=o),c.prototype.getExtremes.call(this)},o.prototype.getValidPoints=function(t,e){return c.prototype.getValidPoints.call(this,t,e,!0)},o.prototype.hasData=function(){return!!this.processedXData.length},o.prototype.init=function(){e.prototype.init.apply(this,arguments);var t=this.options;t.pointRange=M(t.pointRange,t.colsize||1),this.yAxis.axisPointRange=t.rowsize||1,y.ellipse=y.circle,t.marker&&b(t.borderRadius)&&(t.marker.r=t.borderRadius)},o.prototype.markerAttribs=function(t,e){var o=t.shapeArgs||{};if(t.hasImage)return{x:t.plotX,y:t.plotY};if(e&&"normal"!==e){var i=t.options.marker||{},r=this.options.marker||{},n=r.states&&r.states[e]||{},s=i.states&&i.states[e]||{},a=(s.width||n.width||o.width||0)+(s.widthPlus||n.widthPlus||0),l=(s.height||n.height||o.height||0)+(s.heightPlus||n.heightPlus||0);return{x:(o.x||0)+((o.width||0)-a)/2,y:(o.y||0)+((o.height||0)-l)/2,width:a,height:l}}return o},o.prototype.pointAttribs=function(e,o){var i=c.prototype.pointAttribs.call(this,e,o),r=this.options||{},n=this.chart.options.plotOptions||{},s=n.series||{},a=n.heatmap||{},l=e&&e.options.borderColor||r.borderColor||a.borderColor||s.borderColor,p=e&&e.options.borderWidth||r.borderWidth||a.borderWidth||s.borderWidth||i["stroke-width"];if(i.stroke=e&&e.marker&&e.marker.lineColor||r.marker&&r.marker.lineColor||l||this.color,i["stroke-width"]=p,o&&"normal"!==o){var h=x(r.states&&r.states[o],r.marker&&r.marker.states&&r.marker.states[o],e&&e.options.states&&e.options.states[o]||{});i.fill=h.color||t.parse(i.fill).brighten(h.brightness||0).get(),i.stroke=h.lineColor||i.stroke}return i},o.prototype.translate=function(){var t=this.options,e=t.borderRadius,o=t.marker,i=o&&o.symbol||"rect",r=y[i]?i:"rect",n=-1!==["circle","square"].indexOf(r);this.generatePoints();for(var s=0,a=this.points;s<a.length;s++){var l=a[s],p=l.getCellAttributes(),h=Math.min(p.x1,p.x2),c=Math.min(p.y1,p.y2),u=Math.max(Math.abs(p.x2-p.x1),0),d=Math.max(Math.abs(p.y2-p.y1),0);if(l.hasImage=0===(l.marker&&l.marker.symbol||i||"").indexOf("url"),n){var f=Math.abs(u-d);h=Math.min(p.x1,p.x2)+(u<d?0:f/2),c=Math.min(p.y1,p.y2)+(u<d?f/2:0),u=d=Math.min(u,d)}l.hasImage&&(l.marker={width:u,height:d}),l.plotX=l.clientX=(p.x1+p.x2)/2,l.plotY=(p.y1+p.y2)/2,l.shapeType="path",l.shapeArgs=x(!0,{x:h,y:c,width:u,height:d},{d:y[r](h,c,u,d,{r:b(e)?e:0})})}v(this,"afterTranslate")},o.defaultOptions=x(f.defaultOptions,i),o}(f);return m(w,"afterDataClassLegendClick",function(){this.isDirtyCanvas=!0,this.drawPoints()}),g(w.prototype,{axisTypes:e.seriesMembers.axisTypes,colorKey:e.seriesMembers.colorKey,directTouch:!0,getExtremesFromAll:!0,parallelArrays:e.seriesMembers.parallelArrays,pointArrayMap:["y","value"],pointClass:o,specialGroup:"group",trackerGroups:e.seriesMembers.trackerGroups,alignDataLabel:d.prototype.alignDataLabel,colorAttribs:e.seriesMembers.colorAttribs,getSymbol:c.prototype.getSymbol}),e.compose(w),r.registerSeriesType("heatmap",w),w}),o(e,"masters/modules/map.src.js",[e["Core/Globals.js"],e["Maps/MapNavigation.js"],e["Series/ColorMapComposition.js"],e["Series/MapBubble/MapBubbleSeries.js"],e["Maps/GeoJSONComposition.js"],e["Core/Chart/MapChart.js"],e["Maps/MapView.js"],e["Maps/Projection.js"]],function(t,e,o,i,r,n,s,a){return t.ColorMapComposition=o,t.MapChart=t.MapChart||n,t.MapNavigation=t.MapNavigation||e,t.MapView=t.MapView||s,t.Projection=t.Projection||a,t.mapChart=t.Map=t.MapChart.mapChart,t.maps=t.MapChart.maps,t.geojson=r.geojson,t.topo2geo=r.topo2geo,r.compose(t.Chart),i.compose(t.Axis,t.Chart,t.Legend,t.Series),e.compose(n,t.Pointer,t.SVGRenderer),s.compose(n),t})});