<?php

namespace Modules\Achat\Models;

use CodeIgniter\Model;

class Achat extends Model
{
    protected $table            = 'ac_achat';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['province_id', 'branche_id', 'description', 'code_projet', 'code_donneur', 'code_activite', 'code_atlas', 'nom_projet', 'partenaire', 'unite_id', 'quantite', 'prix_unitaire', 'budget_total', 'budget_disponible', 'date_acquisition', 'date_lancement', 'nom_acheteur', 'procedures', 'date_depot', 'date_attribution', 'montant_marche', 'date_probable_livraison', 'lieu_livraison', 'responsable', 'statut_id','user_id'];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
