<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/achat", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                

                <div class="row">
                    <?php


                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$achat->id]); ?>
                <div class="row mb-3">

                    <?php

                    $province = [
                        'type'  => 'hidden',
                        'name'  => 'province_id_load',
                        'id'    => 'province_id_load',
                        'value' => $achat->province_id,
                    ];

                    echo form_input($province);

                    $branche = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $achat->branche_id,
                    ];

                    echo form_input($branche);
                    ?>

                    <div class="col-md-3">
                        <?= form_label("Province"); ?>
                        <?php
                        echo form_dropdown('province_id', $provinces, set_value('province_id', $achat->province_id), "class = 'form-control' id='province_id'");
                        ?>
                    </div>
                    <div class="col-md-3">
                        <?= form_label("Branche"); ?>
                        <?php
                        echo form_dropdown('branche_id', [], set_value('branche_id', $achat->branche_id), "class = 'form-control' id='branche_id'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Description du marché"); ?>

                        <?php
                        $description = [
                            'type'  => 'text',
                            'name'  => 'description',
                            'id'    => 'description',
                            'value' => set_value('description', $achat->description),
                            'placeholder' => "Description du marché",
                            'class' => 'form-control',
                        ];

                        echo form_input($description);
                        ?>
                        <?= !empty(validation_show_error('description')) ? "<p class='text-danger'>" . validation_show_error('description') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Code du projet"); ?>

                        <?php
                        $code_projet = [
                            'type'  => 'text',
                            'name'  => 'code_projet',
                            'id'    => 'code_projet',
                            'value' => set_value('code_projet', $achat->code_projet),
                            'placeholder' => "Code du projet",
                            'class' => 'form-control',
                        ];

                        echo form_input($code_projet);
                        ?>
                        <?= !empty(validation_show_error('code_projet')) ? "<p class='text-danger'>" . validation_show_error('code_projet') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Code du donneur"); ?>

                        <?php
                        $code_donneur = [
                            'type'  => 'text',
                            'name'  => 'code_donneur',
                            'id'    => 'code_donneur',
                            'value' => set_value('code_donneur', $achat->code_donneur),
                            'placeholder' => "Code du donneur",
                            'class' => 'form-control',
                        ];

                        echo form_input($code_donneur);
                        ?>
                        <?= !empty(validation_show_error('code_donneur')) ? "<p class='text-danger'>" . validation_show_error('code_donneur') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Code d'activité"); ?>

                        <?php
                        $code_activite = [
                            'type'  => 'text',
                            'name'  => 'code_activite',
                            'id'    => 'code_activite',
                            'value' => set_value('code_activite', $achat->code_activite),
                            'placeholder' => "Code d'activité",
                            'class' => 'form-control',
                        ];

                        echo form_input($code_activite);
                        ?>
                        <?= !empty(validation_show_error('code_activite')) ? "<p class='text-danger'>" . validation_show_error('code_activite') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Code ATLAS"); ?>

                        <?php
                        $code_atlas = [
                            'type'  => 'text',
                            'name'  => 'code_atlas',
                            'id'    => 'code_atlas',
                            'value' => set_value('code_activite', $achat->code_atlas),
                            'placeholder' => "Code ATLAS",
                            'class' => 'form-control',
                        ];

                        echo form_input($code_atlas);
                        ?>
                        <?= !empty(validation_show_error('code_atlas')) ? "<p class='text-danger'>" . validation_show_error('code_atlas') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nom du projet"); ?>

                        <?php
                        $nom_projet = [
                            'type'  => 'text',
                            'name'  => 'nom_projet',
                            'id'    => 'nom_projet',
                            'value' => set_value('nom_projet', $achat->nom_projet),
                            'placeholder' => "Nom du projet",
                            'class' => 'form-control',
                        ];

                        echo form_input($nom_projet);
                        ?>
                        <?= !empty(validation_show_error('nom_projet')) ? "<p class='text-danger'>" . validation_show_error('nom_projet') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Partenaire"); ?>

                        <?php
                        $partenaire = [
                            'type'  => 'text',
                            'name'  => 'partenaire',
                            'id'    => 'partenaire',
                            'value' => set_value('partenaire', $achat->partenaire),
                            'placeholder' => "Partenaire",
                            'class' => 'form-control',
                        ];

                        echo form_input($partenaire);
                        ?>
                        <?= !empty(validation_show_error('partenaire')) ? "<p class='text-danger'>" . validation_show_error('partenaire') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Unité"); ?>
                        <?php
                        echo form_dropdown('unite_id', $unites, set_value('unite_id', $achat->unite_id), "class = 'form-control' id='unite_id'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Quantité"); ?>

                        <?php
                        $quantite = [
                            'type'  => 'text',
                            'name'  => 'quantite',
                            'id'    => 'quantite',
                            'value' => set_value('quantite', $achat->quantite),
                            'placeholder' => "Quantité",
                            'class' => 'form-control',
                        ];

                        echo form_input($quantite);
                        ?>
                        <?= !empty(validation_show_error('quantite')) ? "<p class='text-danger'>" . validation_show_error('quantite') . "</p>" : "" ?>
                    </div>


                    <div class="col-md-3">
                        <?= form_label("Prix unitaire"); ?>

                        <?php
                        $prix_unitaire = [
                            'type'  => 'text',
                            'name'  => 'prix_unitaire',
                            'id'    => 'prix_unitaire',
                            'value' => set_value('prix_unitaire', $achat->prix_unitaire),
                            'placeholder' => "Prix unitaire",
                            'class' => 'form-control',
                        ];

                        echo form_input($prix_unitaire);
                        ?>
                        <?= !empty(validation_show_error('prix_unitaire')) ? "<p class='text-danger'>" . validation_show_error('prix_unitaire') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Budget total"); ?>

                        <?php
                        $budget_total = [
                            'type'  => 'text',
                            'name'  => 'budget_total',
                            'id'    => 'budget_total',
                            'value' => set_value('budget_total', $achat->budget_total),
                            'placeholder' => "Budget total",
                            'class' => 'form-control',
                        ];

                        echo form_input($budget_total);
                        ?>
                        <?= !empty(validation_show_error('budget_total')) ? "<p class='text-danger'>" . validation_show_error('budget_total') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Budget disponible"); ?>

                        <?php
                        $budget_disponible = [
                            'type'  => 'text',
                            'name'  => 'budget_disponible',
                            'id'    => 'budget_disponible',
                            'value' => set_value('budget_disponible', $achat->budget_disponible),
                            'placeholder' => "Budget disponible",
                            'class' => 'form-control',
                        ];

                        echo form_input($budget_disponible);
                        ?>
                        <?= !empty(validation_show_error('budget_disponible')) ? "<p class='text-danger'>" . validation_show_error('budget_disponible') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <!-- <font color='red'>*</font> -->
                        <?= form_label("Date d'acquisition "); ?>
                        <?php $date_acquisition = $achat->date_acquisition ? $achat->date_acquisition : set_value('date_acquisition') ?>
                        <div class="input-group date" id="date_acquisition" data-target-input="nearest">
                            <?= form_input('date_acquisition', $date_acquisition, "class='form-control datetimepicker-input', id='date_acquisition' placeholder='Date d_acquisition'") ?>
                            <div class="input-group-append" data-target="#date_acquisition" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('date_acquisition')) ? "<p class='text-danger'>" . validation_show_error('date_acquisition') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <!-- <font color='red'>*</font> -->
                        <?= form_label("Date de lancement "); ?>
                        <?php $date_lancement = $achat->date_lancement ? $achat->date_lancement : set_value('date_lancement') ?>
                        <div class="input-group date" id="date_lancement" data-target-input="nearest">
                            <?= form_input('date_lancement', $date_lancement, "class='form-control datetimepicker-input', id='date_lancement' placeholder='Date de lancement'") ?>
                            <div class="input-group-append" data-target="#date_lancement" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('date_lancement')) ? "<p class='text-danger'>" . validation_show_error('date_lancement') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nom de l'acheteur"); ?>

                        <?php
                        $nom_acheteur = [
                            'type'  => 'text',
                            'name'  => 'nom_acheteur',
                            'id'    => 'nom_acheteur',
                            'value' => set_value('nom_acheteur', $achat->nom_acheteur),
                            'placeholder' => "Nom de l'acheteur",
                            'class' => 'form-control',
                        ];

                        echo form_input($nom_acheteur);
                        ?>
                        <?= !empty(validation_show_error('nom_acheteur')) ? "<p class='text-danger'>" . validation_show_error('nom_acheteur') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Procedures"); ?>

                        <?php
                        $procedures = [
                            'type'  => 'text',
                            'name'  => 'procedures',
                            'id'    => 'procedures',
                            'value' => set_value('procedures', $achat->procedures),
                            'placeholder' => "Procedures",
                            'class' => 'form-control',
                        ];

                        echo form_input($procedures);
                        ?>
                        <?= !empty(validation_show_error('procedures')) ? "<p class='text-danger'>" . validation_show_error('procedures') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <!-- <font color='red'>*</font> -->
                        <?= form_label("Date de dépôt"); ?>
                        <?php $date_depot = $achat->date_depot ? $achat->date_depot : set_value('date_depot') ?>
                        <div class="input-group date" id="date_depot" data-target-input="nearest">
                            <?= form_input('date_depot', $date_depot, "class='form-control datetimepicker-input', id='date_depot' placeholder='Date de dépôt'") ?>
                            <div class="input-group-append" data-target="#date_depot" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('date_depot')) ? "<p class='text-danger'>" . validation_show_error('date_depot') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <!-- <font color='red'>*</font> -->
                        <?= form_label("Date d'attribution"); ?>
                        <?php $date_attribution = $achat->date_attribution ? $achat->date_attribution : set_value('date_attribution') ?>
                        <div class="input-group date" id="date_attribution" data-target-input="nearest">
                            <?= form_input('date_attribution', $date_attribution, "class='form-control datetimepicker-input', id='date_attribution' placeholder='Date d_attribution'") ?>
                            <div class="input-group-append" data-target="#date_attribution" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('date_attribution')) ? "<p class='text-danger'>" . validation_show_error('date_attribution') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Montant du marché"); ?>

                        <?php
                        $montant_marche = [
                            'type'  => 'text',
                            'name'  => 'montant_marche',
                            'id'    => 'montant_marche',
                            'value' => set_value('montant_marche', $achat->montant_marche),
                            'placeholder' => "Montant du marché",
                            'class' => 'form-control',
                        ];

                        echo form_input($montant_marche);
                        ?>
                        <?= !empty(validation_show_error('montant_marche')) ? "<p class='text-danger'>" . validation_show_error('montant_marche') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <!-- <font color='red'>*</font> -->
                        <?= form_label("Date probable livraison"); ?>
                        <?php $date_probable_livraison = $achat->date_probable_livraison ? $achat->date_probable_livraison : set_value('date_probable_livraison') ?>
                        <div class="input-group date" id="date_probable_livraison" data-target-input="nearest">
                            <?= form_input('date_probable_livraison', $date_probable_livraison, "class='form-control datetimepicker-input', id='date_probable_livraison' placeholder='Date probable livraison'") ?>
                            <div class="input-group-append" data-target="#date_probable_livraison" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('date_probable_livraison')) ? "<p class='text-danger'>" . validation_show_error('date_probable_livraison') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Lieu de livraison"); ?>

                        <?php
                        $lieu_livraison = [
                            'type'  => 'text',
                            'name'  => 'lieu_livraison',
                            'id'    => 'lieu_livraison',
                            'value' => set_value('lieu_livraison', $achat->lieu_livraison),
                            'placeholder' => "Lieu de livraison",
                            'class' => 'form-control',
                        ];

                        echo form_input($lieu_livraison);
                        ?>
                        <?= !empty(validation_show_error('lieu_livraison')) ? "<p class='text-danger'>" . validation_show_error('lieu_livraison') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Responsable"); ?>
                        <?php
                        echo form_dropdown('responsable', $responsables, set_value('responsable', $achat->responsable), "class = 'form-control' id='responsable'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Statut"); ?>
                        <?php
                        echo form_dropdown('statut_id', $statuts, set_value('statut_id', $achat->statut_id), "class = 'form-control' id='statut_id'");
                        ?>
                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>

            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>