<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/achat", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php

                    use App\Traits\CommonTrait;
                    use Modules\Administration\Traits\UserTrait;
                    use Modules\Params\Models\BrancheModel;
                    use Modules\Params\Models\ProvinceModel;
                    use Modules\Params\Models\StatutAchat;
                    use Modules\Params\Models\UniteAchat;

                    ?>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <?= form_label("Province"); ?><br>
                        <?= $achat->province_id > 0 ? CommonTrait::formatData(new ProvinceModel(), $achat->province_id) : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Branche"); ?><br>
                        <?= $achat->branche_id > 0 ? CommonTrait::formatData(new BrancheModel(), $achat->branche_id) : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Description du marché"); ?><br>
                        <?= $achat->description ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Code du projet"); ?><br>
                        <?= $achat->code_projet ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Code du donneur"); ?><br>
                        <?= $achat->code_donneur ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Code d'activité"); ?><br>
                        <?= $achat->code_activite ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Code ATLAS"); ?><br>
                        <?= $achat->code_atlas ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nom du projet"); ?><br>
                        <?= $achat->nom_projet ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Partenaire"); ?><br>
                        <?= $achat->partenaire ?>
                    </div>


                    <div class="col-md-3">
                        <?= form_label("Unité"); ?><br>
                        <?= $achat->unite_id > 0 ? CommonTrait::formatData(new UniteAchat(), $achat->unite_id) : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Quantité"); ?><br>
                        <?= $achat->quantite ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Prix unitaire"); ?><br>
                        <?= $achat->prix_unitaire ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Budget total"); ?><br>
                        <?= $achat->budget_total ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Budget disponible"); ?><br>
                        <?= $achat->budget_disponible ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date d'acquisition"); ?><br>
                        <?= $achat->date_acquisition ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date de lancement"); ?><br>
                        <?= $achat->date_lancement ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Nom de l'acheteur"); ?><br>
                        <?= $achat->nom_acheteur ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Procedures"); ?><br>
                        <?= $achat->procedures ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date de dépôt"); ?><br>
                        <?= $achat->date_depot ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date d'attribution"); ?><br>
                        <?= $achat->date_attribution ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Montant du marché"); ?><br>
                        <?= $achat->montant_marche ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date probable livraison"); ?><br>
                        <?= $achat->date_probable_livraison ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Lieu de livraison"); ?><br>
                        <?= $achat->lieu_livraison ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("responsable"); ?><br>
                        <?php
                        $responsable = UserTrait::user($achat->responsable);
                        echo  $responsable ? $responsable->nom . ' ' . $responsable->prenom : "";
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Statut"); ?><br>
                        <?= $achat->statut_id > 0 ? CommonTrait::formatData(new StatutAchat(), $achat->statut_id) : ""  ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Créer le "); ?><br>
                        <?= $achat->created_at ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Créer par"); ?><br>
                        <?php
                        $user = UserTrait::user($achat->user_id);
                        echo  !empty($user) ? $user->nom . ' ' . $user->prenom : "";
                        ?>
                    </div>
                </div>
            </div>
    </section>
</div>


<?= $this->endSection(); ?>