<?php

namespace Modules\Administration\Libraries;

class User
{

    public static function rules($id = NULL, $password = ""): array
    {
        $rules = [];

        if ($id > 0) {
            $rules['username'] = [
                'rules'  => "required|min_length[4]|max_length[50]|is_unique[users.username, id, {$id}]",
                'errors' => [
                    'is_unique' => lang("Administration.absence_form_is_unique"),
                ],
            ];
            if (!empty($password)) {
                $rules['password'] = ['rules'  => 'matches[confirm_password]'];
                $rules['confirm_password'] = ['rules'  => 'required|matches[password]'];
            }
        } else {
            $rules['username'] = ['rules'  => 'required|is_unique[users.username]'];
            $rules['email'] = ['rules'  => 'required|valid_email|is_unique[auth_identities.secret]'];
        }
        $rules['prenom'] = ['rules'  => 'required|min_length[2]|max_length[100]'];
        $rules['nom'] = ['rules'  => 'required|min_length[2]|max_length[100]'];
        $rules['telephone'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }

    public static function tableRowsOld($datas, $locale)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas)) {
            foreach ($datas as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->prenom;
                $sub_array[] =  $data->nom;
                $sub_array[] =  $data->telephone;
                $sub_array[] =  $data->email;
                $sub_array[] =  $data->username;
                $sub_array[] =  $data->active == 0 ? lang("Params.yesno_n") : lang("Params.yesno_y");
                $sub_array[] =  implode(',', $data->getGroups());
                $option = "-";
                if (\auth()->user()->inGroup('secretaire','admin') || \auth()->user()->hasPermission('admin.manage')) {
                    $option = anchor($locale . "/admin/user/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return  $array_data;
    }

    public static function tableRows($datas, $locale)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas)) {
            foreach ($datas as $data) {

                //Modal
                $print = $data->active == 0 ? lang("Params.yesno_n") : lang("Params.yesno_y");
                $descr  = $data->active == 0 ? lang("Administration.user_btn_enable_descr") : lang("Administration.user_btn_disable_descr");
                $bouton  = $data->active == 0 ? lang("Administration.user_btn_enable") : lang("Administration.user_btn_disable");

                $option = "<a href='#' data-toggle='modal' data-target='#modal-activer-" . $data->id . "'>$print</a>
                                        
                <div class='modal fade' id='modal-activer-" . $data->id . "'>
                <div class='modal-dialog modal-md'>
                    <div class='modal-content'>
                        <div class='modal-header'>
                            <h4 class='modal-title'>$descr</h4>
                            <button type='button' class='close' data-dismiss='modal' aria-label='Close'>
                                <span aria-hidden='true'>&times;</span>
                            </button>
                        </div>                    
                        <div class='modal-body'>
                            <div class='row'>
                             " . $descr . " " . $data->nom . " " . $data->prenom . "</b>?
                            </div>                            
                        </div>                    
                        <div class='modal-footer justify-content-between'>
                            <button type='button' class='btn btn-default' data-dismiss='modal'>" . lang("Params.btn_close") . "</button>
                            <a href='" . base_url($locale . '/admin/enableDesable/' . $data->id . '/' . (int)$data->active) . "' class='btn btn-danger'>" . $bouton . "</a>
                        </div>
                    </div>
                    <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->";
                //Fin modal
                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->nom;
                $sub_array[] =  $data->prenom;
                $sub_array[] =  $data->telephone;
                $sub_array[] =  $data->email;
                $sub_array[] =  $data->username;
                $sub_array[] =  $option;
                $sub_array[] =  implode(',', $data->getGroups());
                $option = "-";
                if (\auth()->user()->inGroup('secretaire','admin') || \auth()->user()->hasPermission('admin.manage')) {
                    $option = anchor($locale . "/admin/user/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return  $array_data;
    }
}
