<?php

namespace Modules\Administration\Traits;

use Modules\Administration\Models\User;

class UserTrait
{
    public static function user($userId)
    {
        return (new User())->find($userId);
    }

    private static function users()
    {
        return (new User())->findAll();
    }

    public static function usersArrayFormat($userId = NULL)
    {
        $users = [];
        $users[""] = "Sélectionner";

        foreach (self::users() as $user) {
            $users[$user->id] =  $user->nom . " " . $user->prenom;
        }

        return $userId > 0 ? $users[$userId] : $users;
    }
}
