<?php

namespace Modules\Achat\Config;

// Create a new instance of our RouteCollection class.
$routes->group("{locale}/inv", ["namespace" => "\Modules\Inventaire\Controllers", 'filter' => ['appAuth']], function ($routes) {

    //Routes for Equipements
    $routes->get("equipement", "Equipement::index");
    $routes->get("equipement/add", "Equipement::add");
    $routes->post("equipement/save", "Equipement::save");
    $routes->get("equipement/add/(:num)", "Equipement::add");
    $routes->get("equipement/detail/(:num)", "Equipement::detail");
    $routes->post("equipement/data", "Equipement::fecth");
    $routes->get("equipement/delete/(:num)", "Equipement::delete", ['filter' => 'permission:inv.delete']);
    $routes->get("equipement/export/(:num)", "Equipement::export");
   
    //Routes for Mobilier
    $routes->get("mobilier", "Mobilier::index");
    $routes->get("mobilier/add", "Mobilier::add");
    $routes->post("mobilier/save", "Mobilier::save");
    $routes->get("mobilier/add/(:num)", "Mobilier::add");
    $routes->get("mobilier/detail/(:num)", "Mobilier::detail");
    $routes->post("mobilier/data", "Mobilier::fecth");
    $routes->get("mobilier/delete/(:num)", "Mobilier::delete", ['filter' => 'permission:inv.delete']);
    $routes->get("mobilier/export/(:num)", "Mobilier::export");
});