<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/inv/equipement", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php

                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$equipement->id]); ?>
                <div class="row mb-3">

                    <?php

                    $province = [
                        'type'  => 'hidden',
                        'name'  => 'province_id_load',
                        'id'    => 'province_id_load',
                        'value' => $equipement->province_id,
                    ];

                    echo form_input($province);

                    $branche = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $equipement->branche_id,
                    ];

                    echo form_input($branche);
                    ?>

                    <div class="col-md-3">
                        <?= form_label("Province"); ?>
                        <?php
                        echo form_dropdown('province_id', $provinces, set_value('province_id', $equipement->province_id), "class = 'form-control' id='province_id'");
                        ?>
                    </div>
                    <div class="col-md-3">
                        <?= form_label("Branche"); ?>
                        <?php
                        echo form_dropdown('branche_id', [], set_value('branche_id', $equipement->branche_id), "class = 'form-control' id='branche_id'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Description"); ?>
                        <?php
                        echo form_dropdown('type_inventaire_id', $types, set_value('type_inventaire_id', $equipement->type_inventaire_id), "class = 'form-control' id='type_inventaire_id'");
                        ?>
                    </div>

                    
                    <div class="col-md-3">
                        <?= form_label("Marque/Modèle"); ?>

                        <?php
                        $marque = [
                            'type'  => 'text',
                            'name'  => 'marque',
                            'id'    => 'marque',
                            'value' => set_value('marque', $equipement->marque),
                            'placeholder' => "Marque/Modèle",
                            'class' => 'form-control',
                        ];

                        echo form_input($marque);
                        ?>
                        <?= !empty(validation_show_error('marque')) ? "<p class='text-danger'>" . validation_show_error('marque') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("No de série"); ?>

                        <?php
                        $num_serie = [
                            'type'  => 'text',
                            'name'  => 'num_serie',
                            'id'    => 'num_serie',
                            'value' => set_value('num_serie', $equipement->num_serie),
                            'placeholder' => "No de série",
                            'class' => 'form-control',
                        ];

                        echo form_input($num_serie);
                        ?>
                        <?= !empty(validation_show_error('num_serie')) ? "<p class='text-danger'>" . validation_show_error('num_serie') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Projet-achateur"); ?>

                        <?php
                        $acheteur = [
                            'type'  => 'text',
                            'name'  => 'acheteur',
                            'id'    => 'acheteur',
                            'value' => set_value('acheteur', $equipement->acheteur),
                            'placeholder' => "Projet achateur",
                            'class' => 'form-control',
                        ];

                        echo form_input($acheteur);
                        ?>
                        <?= !empty(validation_show_error('acheteur')) ? "<p class='text-danger'>" . validation_show_error('acheteur') . "</p>" : "" ?>
                    </div>


                    <div class="col-md-3">
                        <?= form_label("Partenaire"); ?>

                        <?php
                        $partenaire = [
                            'type'  => 'text',
                            'name'  => 'partenaire',
                            'id'    => 'partenaire',
                            'value' => set_value('partenaire', $equipement->partenaire),
                            'placeholder' => "Partenaire",
                            'class' => 'form-control',
                        ];

                        echo form_input($partenaire);
                        ?>
                        <?= !empty(validation_show_error('partenaire')) ? "<p class='text-danger'>" . validation_show_error('partenaire') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Affection"); ?>

                        <?php
                        $affectation = [
                            'type'  => 'text',
                            'name'  => 'affectation',
                            'id'    => 'affectation',
                            'value' => set_value('affectation', $equipement->affectation),
                            'placeholder' => "Affection",
                            'class' => 'form-control',
                        ];

                        echo form_input($affectation);
                        ?>
                        <?= !empty(validation_show_error('affectation')) ? "<p class='text-danger'>" . validation_show_error('affectation') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Service utilisateur"); ?>

                        <?php
                        $service_utilisateur = [
                            'type'  => 'text',
                            'name'  => 'service_utilisateur',
                            'id'    => 'service_utilisateur',
                            'value' => set_value('service_utilisateur', $equipement->service_utilisateur),
                            'placeholder' => "Service utilisateur",
                            'class' => 'form-control',
                        ];

                        echo form_input($service_utilisateur);
                        ?>
                        <?= !empty(validation_show_error('service_utilisateur')) ? "<p class='text-danger'>" . validation_show_error('service_utilisateur') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Acte de transfert/cession"); ?>

                        <?php
                        $acte_transfert = [
                            'type'  => 'text',
                            'name'  => 'acte_transfert',
                            'id'    => 'acte_transfert',
                            'value' => set_value('acte_transfert', $equipement->acte_transfert),
                            'placeholder' => "Acte de transfert/cession",
                            'class' => 'form-control',
                        ];

                        echo form_input($acte_transfert);
                        ?>
                        <?= !empty(validation_show_error('acte_transfert')) ? "<p class='text-danger'>" . validation_show_error('acte_transfert') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Annee d'acquisition"); ?>

                        <?php
                        $annee_acquisition = [
                            'type'  => 'text',
                            'name'  => 'annee_acquisition',
                            'id'    => 'annee_acquisition',
                            'value' => set_value('annee_acquisition', $equipement->annee_acquisition),
                            'placeholder' => "Annee d'acquisition",
                            'class' => 'form-control',
                        ];

                        echo form_input($annee_acquisition);
                        ?>
                        <?= !empty(validation_show_error('annee_acquisition')) ? "<p class='text-danger'>" . validation_show_error('annee_acquisition') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Valeur d'acquisition"); ?>

                        <?php
                        $valeur_acquisition = [
                            'type'  => 'text',
                            'name'  => 'valeur_acquisition',
                            'id'    => 'valeur_acquisition',
                            'value' => set_value('valeur_acquisition', $equipement->valeur_acquisition),
                            'placeholder' => "Valeur d'acquisition",
                            'class' => 'form-control',
                        ];

                        echo form_input($valeur_acquisition);
                        ?>
                        <?= !empty(validation_show_error('valeur_acquisition')) ? "<p class='text-danger'>" . validation_show_error('valeur_acquisition') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Valeur residuelle"); ?>

                        <?php
                        $valeur_residuelle = [
                            'type'  => 'text',
                            'name'  => 'valeur_residuelle',
                            'id'    => 'valeur_residuelle',
                            'value' => set_value('valeur_residuelle', $equipement->valeur_residuelle),
                            'placeholder' => "Valeur residuelle",
                            'class' => 'form-control',
                        ];

                        echo form_input($valeur_residuelle);
                        ?>
                        <?= !empty(validation_show_error('valeur_residuelle')) ? "<p class='text-danger'>" . validation_show_error('valeur_residuelle') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Etat du matériel"); ?>
                        <?php
                        echo form_dropdown('etat_materiel_id', $etats, set_value('etat_materiel_id', $equipement->etat_materiel_id), "class = 'form-control' id='etat_materiel_id'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Observation"); ?>

                        <?php
                        $observation = [
                            'type'  => 'text',
                            'name'  => 'observation',
                            'id'    => 'observation',
                            'value' => set_value('observation', $equipement->observation),
                            'placeholder' => "Observation",
                            'class' => 'form-control',
                        ];

                        echo form_input($observation);
                        ?>
                        <?= !empty(validation_show_error('observation')) ? "<p class='text-danger'>" . validation_show_error('observation') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>

            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>