<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/inv/equipement", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php

                    use App\Traits\CommonTrait;
                    use Modules\Administration\Traits\UserTrait;
                    use Modules\Params\Models\BrancheModel;
                    use Modules\Params\Models\EtatEquiment;
                    use Modules\Params\Models\TypeInventaire;
                    use Modules\Params\Models\ProvinceModel;

                    ?>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <?= form_label("Province"); ?><br>
                        <?= $equipement->province_id > 0 ? CommonTrait::formatData(new ProvinceModel(), $equipement->province_id) : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Branche"); ?><br>
                        <?= $equipement->branche_id > 0 ? CommonTrait::formatData(new BrancheModel(), $equipement->branche_id) : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Description"); ?><br>
                        <?= //$equipement->description 
                        $equipement->type_inventaire_id > 0 ? CommonTrait::formatData(new TypeInventaire(), $equipement->type_inventaire_id) : ""?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Marque/Modèle"); ?><br>
                        <?= $equipement->marque ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("No de série"); ?><br>
                        <?= $equipement->num_serie ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Projet-achateur"); ?><br>
                        <?= $equipement->acheteur ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Partenaire"); ?><br>
                        <?= $equipement->partenaire ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Affection"); ?><br>
                        <?= $equipement->affectation ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Service utilisateur"); ?><br>
                        <?= $equipement->service_utilisateur ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Acte de transfert/cession"); ?><br>
                        <?= $equipement->acte_transfert ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Annee d'acquisition"); ?><br>
                        <?= $equipement->annee_acquisition ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Valeur d'acquisition"); ?><br>
                        <?= $equipement->valeur_acquisition ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Valeur residuelle"); ?><br>
                        <?= $equipement->valeur_residuelle ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Etat du matériel"); ?><br>
                        <?= $equipement->etat_materiel_id > 0 ? CommonTrait::formatData(new EtatEquiment(), $equipement->etat_materiel_id) : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Observation"); ?><br>
                        <?= $equipement->observation ?>
                    </div>


                    <div class="col-md-3">
                        <?= form_label("Créer le "); ?><br>
                        <?= $equipement->created_at ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Créer par"); ?><br>
                        <?php
                        $user = UserTrait::user($equipement->user_id);
                        echo  !empty($user) ? $user->nom . ' ' . $user->prenom : "";
                        ?>
                    </div>
                </div>
            </div>
    </section>
</div>


<?= $this->endSection(); ?>