<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/inv/mobilier", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php

                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$mobilier->id]); ?>
                <div class="row mb-3">

                    <?php

                    $province = [
                        'type'  => 'hidden',
                        'name'  => 'province_id_load',
                        'id'    => 'province_id_load',
                        'value' => $mobilier->province_id,
                    ];

                    echo form_input($province);

                    $branche = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $mobilier->branche_id,
                    ];

                    echo form_input($branche);
                    ?>

                    <div class="col-md-3">
                        <?= form_label("Province"); ?>
                        <?php
                        echo form_dropdown('province_id', $provinces, set_value('province_id', $mobilier->province_id), "class = 'form-control' id='province_id'");
                        ?>
                    </div>
                    <div class="col-md-3">
                        <?= form_label("Branche"); ?>
                        <?php
                        echo form_dropdown('branche_id', [], set_value('branche_id', $mobilier->branche_id), "class = 'form-control' id='branche_id'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Description"); ?>

                        <?php
                        $description = [
                            'type'  => 'text',
                            'name'  => 'description',
                            'id'    => 'description',
                            'value' => set_value('description', $mobilier->description),
                            'placeholder' => "Description",
                            'class' => 'form-control',
                        ];

                        echo form_input($description);
                        ?>
                        <?= !empty(validation_show_error('description')) ? "<p class='text-danger'>" . validation_show_error('description') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Marque/Modèle"); ?>

                        <?php
                        $marque = [
                            'type'  => 'text',
                            'name'  => 'marque',
                            'id'    => 'marque',
                            'value' => set_value('marque', $mobilier->marque),
                            'placeholder' => "Marque/Modèle",
                            'class' => 'form-control',
                        ];

                        echo form_input($marque);
                        ?>
                        <?= !empty(validation_show_error('marque')) ? "<p class='text-danger'>" . validation_show_error('marque') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Condition"); ?>

                        <?php
                        $conditions = [
                            'type'  => 'text',
                            'name'  => 'conditions',
                            'id'    => 'conditions',
                            'value' => set_value('conditions', $mobilier->conditions),
                            'placeholder' => "Condition",
                            'class' => 'form-control',
                        ];

                        echo form_input($conditions);
                        ?>
                        <?= !empty(validation_show_error('conditions')) ? "<p class='text-danger'>" . validation_show_error('conditions') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Localisation"); ?>

                        <?php
                        $localisation = [
                            'type'  => 'text',
                            'name'  => 'localisation',
                            'id'    => 'localisation',
                            'value' => set_value('localisation', $mobilier->localisation),
                            'placeholder' => "Localisation",
                            'class' => 'form-control',
                        ];

                        echo form_input($localisation);
                        ?>
                        <?= !empty(validation_show_error('localisation')) ? "<p class='text-danger'>" . validation_show_error('localisation') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Responsable"); ?>
                        <?php
                        echo form_dropdown('responsable', $responsables, set_value('responsable', $mobilier->responsable), "class = 'form-control' id='responsable'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <!-- <font color='red'>*</font> -->
                        <?= form_label("Date d'achat"); ?>
                        <?php $date_achat = $mobilier->date_achat ? $mobilier->date_achat : set_value('date_achat') ?>
                        <div class="input-group date" id="date_achat" data-target-input="nearest">
                            <?= form_input('date_achat', $date_achat, "class='form-control datetimepicker-input', id='date_achat' placeholder='Date d_achat'") ?>
                            <div class="input-group-append" data-target="#date_achat" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('date_achat')) ? "<p class='text-danger'>" . validation_show_error('date_achat') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Lieu achat"); ?>

                        <?php
                        $lieu_achat = [
                            'type'  => 'text',
                            'name'  => 'lieu_achat',
                            'id'    => 'lieu_achat',
                            'value' => set_value('lieu_achat', $mobilier->lieu_achat),
                            'placeholder' => "Lieu achat",
                            'class' => 'form-control',
                        ];

                        echo form_input($lieu_achat);
                        ?>
                        <?= !empty(validation_show_error('lieu_achat')) ? "<p class='text-danger'>" . validation_show_error('lieu_achat') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Valeur"); ?>

                        <?php
                        $valeur = [
                            'type'  => 'text',
                            'name'  => 'valeur',
                            'id'    => 'valeur',
                            'value' => set_value('valeur', $mobilier->valeur),
                            'placeholder' => "Valeur",
                            'class' => 'form-control',
                        ];

                        echo form_input($valeur);
                        ?>
                        <?= !empty(validation_show_error('valeur')) ? "<p class='text-danger'>" . validation_show_error('valeur') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Fournisseur"); ?>

                        <?php
                        $fournisseur = [
                            'type'  => 'text',
                            'name'  => 'fournisseur',
                            'id'    => 'fournisseur',
                            'value' => set_value('fournisseur', $mobilier->fournisseur),
                            'placeholder' => "Fournisseur",
                            'class' => 'form-control',
                        ];

                        echo form_input($fournisseur);
                        ?>
                        <?= !empty(validation_show_error('fournisseur')) ? "<p class='text-danger'>" . validation_show_error('fournisseur') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Origine"); ?>

                        <?php
                        $origine = [
                            'type'  => 'text',
                            'name'  => 'origine',
                            'id'    => 'origine',
                            'value' => set_value('origine', $mobilier->origine),
                            'placeholder' => "Origine",
                            'class' => 'form-control',
                        ];

                        echo form_input($origine);
                        ?>
                        <?= !empty(validation_show_error('origine')) ? "<p class='text-danger'>" . validation_show_error('fournioriginesseur') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Valeur d'acquisition"); ?>

                        <?php
                        $valeur_acquisition = [
                            'type'  => 'text',
                            'name'  => 'valeur_acquisition',
                            'id'    => 'valeur_acquisition',
                            'value' => set_value('valeur_acquisition', $mobilier->valeur_acquisition),
                            'placeholder' => "Valeur d'acquisition",
                            'class' => 'form-control',
                        ];

                        echo form_input($valeur_acquisition);
                        ?>
                        <?= !empty(validation_show_error('valeur_acquisition')) ? "<p class='text-danger'>" . validation_show_error('valeur_acquisition') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Statut"); ?>
                        <?php
                        echo form_dropdown('statut_mobilier_id', $statuts, set_value('statut_mobilier_id', $mobilier->statut_mobilier_id), "class = 'form-control' id='statut_mobilier_id'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Accessoire"); ?>

                        <?php
                        $accessoire = [
                            'type'  => 'text',
                            'name'  => 'accessoire',
                            'id'    => 'accessoire',
                            'value' => set_value('accessoire', $mobilier->accessoire),
                            'placeholder' => "Accessoire",
                            'class' => 'form-control',
                        ];

                        echo form_input($accessoire);
                        ?>
                        <?= !empty(validation_show_error('accessoire')) ? "<p class='text-danger'>" . validation_show_error('accessoire') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>

            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>