<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/inv/equipement", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php

                    use App\Traits\CommonTrait;
                    use Modules\Administration\Traits\UserTrait;
                    use Modules\Params\Models\BrancheModel;
                    use Modules\Params\Models\ProvinceModel;
                    use Modules\Params\Models\StatutMobilier;

                    ?>
                </div>

                <div class="row mb-3">
                    <div class="col-md-3">
                        <?= form_label("Province"); ?><br>
                        <?= $mobilier->province_id > 0 ? CommonTrait::formatData(new ProvinceModel(), $mobilier->province_id) : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Branche"); ?><br>
                        <?= $mobilier->branche_id > 0 ? CommonTrait::formatData(new BrancheModel(), $mobilier->branche_id) : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Description"); ?><br>
                        <?= $mobilier->description ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Marque/Modèle"); ?><br>
                        <?= $mobilier->marque ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Condition"); ?><br>
                        <?= $mobilier->conditions ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Localisation"); ?><br>
                        <?= $mobilier->localisation ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Responsable"); ?><br>
                        <?php
                        $resp = UserTrait::user($mobilier->responsable);
                        echo  !empty($resp) ? $resp->nom . ' ' . $resp->prenom : "";
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date d'achat"); ?><br>
                        <?= $mobilier->date_achat ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Lieu achat"); ?><br>
                        <?= $mobilier->lieu_achat ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Valeur"); ?><br>
                        <?= $mobilier->valeur ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Fournisseur"); ?><br>
                        <?= $mobilier->fournisseur ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Origine"); ?><br>
                        <?= $mobilier->origine ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Valeur d'acquisition"); ?><br>
                        <?= $mobilier->valeur_acquisition ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Statut"); ?><br>
                        <?= $mobilier->statut_mobilier_id > 0 ? CommonTrait::formatData(new StatutMobilier(), $mobilier->statut_mobilier_id) : "" ?>
                    </div>


                    <div class="col-md-3">
                        <?= form_label("Accessoire"); ?><br>
                        <?= $mobilier->valeur_acquisition ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Créer le "); ?><br>
                        <?= $mobilier->created_at ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Créer par"); ?><br>
                        <?php
                        $user = UserTrait::user($mobilier->user_id);
                        echo  !empty($user) ? $user->nom . ' ' . $user->prenom : "";
                        ?>
                    </div>
                </div>
            </div>
    </section>
</div>


<?= $this->endSection(); ?>