<?php

namespace Administratio\Config\Config;

// Create a new instance of our RouteCollection class.
$routes->group("{locale}/params", ["namespace" => "\Modules\Params\Controllers", 'filter' => ['appAuth']], function ($routes) {

    //Routes for provinces
    $routes->get("province", "ProvinceController::index");
    $routes->get("province/(:num)", "ProvinceController::index");
    $routes->post("province/save", "ProvinceController::save");
    $routes->post("province/data", "ProvinceController::fecth");
    $routes->get("province/delete/(:num)", "ProvinceController::delete", ['filter' => 'permission:params.delete']);


    //Routes for Province
    $routes->get("branche", "BrancheController::index");
    $routes->get("branche/(:num)", "BrancheController::index");
    $routes->post("branche/save", "BrancheController::save");
    $routes->get("branches/(:num)/(:num)", "BrancheController::branches");
    $routes->post("branche/data", "BrancheController::fecth");
    $routes->get("branche/delete/(:num)", "BrancheController::delete", ['filter' => 'permission:params.delete']);

    //Routes for statut
    $routes->get("statut_achat", "StatutAchat::index");
    $routes->get("statut_achat/(:num)", "StatutAchat::index");
    $routes->post("statut_achat/save", "StatutAchat::save");
    $routes->post("statut_achat/data", "StatutAchat::fecth");
    $routes->get("statut_achat/delete/(:num)", "StatutAchat::delete", ['filter' => 'permission:params.delete']);

    //Routes for unite
    $routes->get("unite", "UniteAchat::index");
    $routes->get("unite/(:num)", "UniteAchat::index");
    $routes->post("unite/save", "UniteAchat::save");
    $routes->post("unite/data", "UniteAchat::fecth");
    $routes->get("unite/delete/(:num)", "UniteAchat::delete", ['filter' => 'permission:params.delete']);

    //Routes for statut
    $routes->get("statut_mobilier", "StatutMobilier::index");
    $routes->get("statut_mobilier/(:num)", "StatutMobilier::index");
    $routes->post("statut_mobilier/save", "StatutMobilier::save");
    $routes->post("statut_mobilier/data", "StatutMobilier::fecth");
    $routes->get("statut_mobilier/delete/(:num)", "StatutMobilier::delete", ['filter' => 'permission:params.delete']);

    //Routes for statut
    $routes->get("etat_equipement", "EtatEquiment::index");
    $routes->get("etat_equipement/(:num)", "EtatEquiment::index");
    $routes->post("etat_equipement/save", "EtatEquiment::save");
    $routes->post("etat_equipement/data", "EtatEquiment::fecth");
    $routes->get("etat_equipement/delete/(:num)", "EtatEquiment::delete", ['filter' => 'permission:params.delete']);
});
