<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\StatutMobilier as ModelsStatutMobilier;
use Psr\Log\LoggerInterface;
use stdClass;

class StatutMobilier extends BaseController
{
    public ModelsStatutMobilier $statut_mobilier_model;
    protected string $viewPath;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->statut_mobilier_model = new ModelsStatutMobilier();
        $this->viewPath = "Modules\\Params\\Views\\";
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/statut_mobilier/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/statut_mobilier/save";
        $this->viewData['statut'] =  $this->initStatutMobilier($id);

        return view($this->viewPath . 'statut_mobilier/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/statut_mobilier/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/statut_mobilier/save";
            $this->viewData['statut'] =  $this->initStatutMobilier($id);

            return view($this->viewPath . 'statut_mobilier/add', $this->viewData);
        } else {

            $unStatutMobilier = $this->unStatutMobilier();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le statut de mobilier <b> " . $unStatutMobilier['description'] . "</b> a été modifiée</div>");
                $stmt = $this->statut_mobilier_model->update($id, $unStatutMobilier);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le statut de mobilier <b> " . $unStatutMobilier['description'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->statut_mobilier_model->save($unStatutMobilier);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/statut_mobilier'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->statut_mobilier_model->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le statut de mobilier a été suprimé</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/statut_mobilier'));
        }
    }

    private function unStatutMobilier()
    {
        $statut_mobilier = [];
        $statut_mobilier['description'] = $this->request->getPost('description');

        return $statut_mobilier;
    }

    private function initStatutMobilier($id = NULL)
    {
        $statut_mobilier = NULL;
        if ($id) {
            $statut_mobilier = $this->statut_mobilier_model->find($id);
        } else {
            $statut_mobilier = new stdClass();
            $statut_mobilier->id = 0;
            $statut_mobilier->description = "";
        }

        return $statut_mobilier;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->statut_mobilier_model, $search_column, $order_column);
        $output = $this->formatStatutMobiliers($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatStatutMobiliers($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = anchor($locale . "/params/statut_mobilier/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']);

                if (\auth()->user()->inGroup('secretaire', 'admin') ||  \auth()->user()->hasPermission('params.delete')) {
                    $option .= anchor($locale . "/params/statut_mobilier/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
