<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\UniteAchat as ModelsUniteAchat;
use Psr\Log\LoggerInterface;
use stdClass;

class UniteAchat extends BaseController
{
    public ModelsUniteAchat $unite_model;
    protected string $viewPath;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->unite_model = new ModelsUniteAchat();
        $this->viewPath = "Modules\\Params\\Views\\";
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/unite/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/unite/save";
        $this->viewData['unite'] =  $this->initUnite($id);

        return view($this->viewPath . 'unite/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/unite/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/unite/save";
            $this->viewData['unite'] =  $this->initUnite($id);

            return view($this->viewPath . 'unite/add', $this->viewData);
        } else {

            $unUnite = $this->unUnite();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>L'unité <b> " . $unUnite['description'] . "</b> a été modifiée</div>");
                $stmt = $this->unite_model->update($id, $unUnite);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>L'unité <b> " . $unUnite['description'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->unite_model->save($unUnite);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/unite'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->unite_model->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>L'unité a été suprimé</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/unite'));
        }
    }

    private function unUnite()
    {
        $statut_achat = [];
        $statut_achat['description'] = $this->request->getPost('description');

        return $statut_achat;
    }

    private function initUnite($id = NULL)
    {
        $statut_achat = NULL;
        if ($id) {
            $statut_achat = $this->unite_model->find($id);
        } else {
            $statut_achat = new stdClass();
            $statut_achat->id = 0;
            $statut_achat->description = "";
        }

        return $statut_achat;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->unite_model, $search_column, $order_column);
        $output = $this->formatStatutAchats($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatStatutAchats($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = anchor($locale . "/params/unite/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']);

                if (\auth()->user()->inGroup('secretaire', 'admin') || \auth()->user()->hasPermission('params.delete')) {
                    $option .= anchor($locale . "/params/unite/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
