<?php

namespace Modules\Params\Database\Migrations;

use CodeIgniter\Database\Migration;

class ProvinceMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 5,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'latitude' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
            ],
            'longitude' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
            ],
            'description' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('params_provinces');
    }

    public function down()
    {
        $this->forge->dropTable('params_provinces');        
    }
}
