<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold">Branches</h3>

            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$branche->id]); ?>
                <div class="row mb-3">
                    <div class="col-md-3">
                        <?= form_label(lang('Params.province_form_descr'), 'descr'); ?>
                        <?php
                        $description = [
                            'type'  => 'text',
                            'name'  => 'description',
                            'id'    => 'description',
                            'value' => set_value('description', $branche->description),
                            'placeholder' => lang("Params.province_form_descr"),
                            'class' => 'form-control',
                        ];

                        echo form_input($description);                        
                        ?>
                        <?= !empty(validation_show_error('description')) ? "<p class='text-danger'>" . validation_show_error('description') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-3">
                        <?= form_label("Province", 'descr'); ?>
                        <?php
                        echo form_dropdown('province_id', $provinces, set_value('province_id', $branche->province_id), "class = 'form-control' id='province_id'");
                        ?>
                        <?= !empty(validation_show_error('province_id')) ? "<p class='text-danger'>" . validation_show_error('province_id') . "</p>" : "" ?>
    
                    </div>


                    <div class="col-md-2">
                        <?= form_label(lang('Params.province_form_lat'), 'lat'); ?>
                        <?php

                        $latitude = [
                            'type'  => 'text',
                            'name'  => 'latitude',
                            'id'    => 'latitude',
                            'value' => set_value('latitude', $branche->latitude),
                            'placeholder' => lang("Params.province_form_lat"),
                            'class' => 'form-control',
                        ];
                        echo form_input($latitude);
                        ?>
                        <?= !empty(validation_show_error('latitude')) ? "<p class='text-danger'>" . validation_show_error('latitude') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-2">
                        <?= form_label(lang('Params.province_form_long'), 'long'); ?>
                        <?php

                        $longitude = [
                            'type'  => 'text',
                            'name'  => 'longitude',
                            'id'    => 'longitude',
                            'value' => set_value('longitude', $branche->longitude),
                            'placeholder' => lang("Params.province_form_long"),
                            'class' => 'form-control',
                        ];
                        echo form_input($longitude);
                        ?>
                        <?= !empty(validation_show_error('longitude')) ? "<p class='text-danger'>" . validation_show_error('longitude') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


                <?php

                use CodeIgniter\View\Table;

                $table = new Table();

                $template = [
                    'table_open' => '<table class="table table-bordered" id="tables">',
                ];
                $table->setTemplate($template);
                $table->setHeading("#", "PROVINCE", 'Branche', lang("Params.province_form_lat"), lang("Params.province_form_long"), lang("Params.btn_option"));


                echo $table->generate();
                ?>
            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>