<?php

declare(strict_types=1);

/**
 * This file is part of CodeIgniter Shield.
 *
 * (c) CodeIgniter Foundation <admin@codeigniter.com>
 *
 * For the full copyright and license information, please view
 * the LICENSE file that was distributed with this source code.
 */

namespace Config;

use CodeIgniter\Shield\Config\AuthGroups as ShieldAuthGroups;

class AuthGroups extends ShieldAuthGroups
{
    /**
     * --------------------------------------------------------------------
     * Default Group
     * --------------------------------------------------------------------
     * The group that a newly registered user is added to.
     */
    public string $defaultGroup = 'user';

    /**
     * --------------------------------------------------------------------
     * Groups
     * --------------------------------------------------------------------
     * An associative array of the available groups in the system, where the keys
     * are the group names and the values are arrays of the group info.
     *
     * Whatever value you assign as the key will be used to refer to the group
     * when using functions such as:
     *      $user->addGroup('superadmin');
     *
     * @var array<string, array<string, string>>
     *
     * @see https://codeigniter4.github.io/shield/quick_start_guide/using_authorization/#change-available-groups for more info
     */
    public array $groups = [        
        'admin' => [
            'title'       => 'Administrateur',
        ],
        'secretaire' => [
            'title'       => 'Secretaire Général',
        ],
        'user' => [
            'title'       => 'Utilisateur simple',
        ],

    ];

    /**
     * --------------------------------------------------------------------
     * Permissions
     * --------------------------------------------------------------------
     * The available permissions in the system.
     *
     * If a permission is not listed here it cannot be used.
     */
    public array $permissions = [
        'admin.manage'        => 'Create, edit, delete admin Module info',
        'admin.ban'        => 'Ban|unBan infos admin module',
        'params.manage'       =>'Create, edit, delete params Module info',
        'params.delete'        => 'Read infos params module',
        'inv.manage'       =>'Create, edit, view inventaire Module info',
        'inv.delete'        => 'Delete infos inventaire module',
        'achat.manage'       =>'Create, edit, view achat Module info',
        'achat.delete'        => 'Delete infos achat module',
    ];

    /**
     * --------------------------------------------------------------------
     * Permissions Matrix
     * --------------------------------------------------------------------
     * Maps permissions to groups.
     *
     * This defines group-level permissions.
     */
    public array $matrix = [
        'admin' => [
            'admin.*',
            'inv.*',
            'params.*',
            'achat.*',
        ],
        'secretaire' => [
            'admin.*',
            'params.manage',
            'achat.manage',
            'inv.manage',

        ],
        'user' => [
            'params.manage',
            'achat.manage',
            'inv.manage'
        ],
    ];
}
