<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->setAutoRoute(false);
$routes->get('/', 'Home::homePage');
$routes->get('/{locale}/home', 'Home::home', ['filter' => 'appAuth']);
$routes->get('/{locale}', 'Home::index');
// $routes->get('/{locale}/page', 'Home::loadPage', ['filter' => 'appAuth']);
$routes->get('/{locale}/invalide_access', 'Home::invalid_access', ['filter' => 'appAuth']);

$routes->group('{locale}', static function ($routes) {
	service('auth')->routes($routes);
});


$modules_path = ROOTPATH . 'Modules/';
$modules = scandir($modules_path);

foreach ($modules as $module) {
	if ($module === '.' || $module === '..') {
		continue;
	}

	if (is_dir($modules_path) . '/' . $module) {
		$routes_path = $modules_path . $module . '/Config/Routes.php';
		if (file_exists($routes_path)) {
			require $routes_path;
		} else {
			continue;
		}
	}
}