<?php

namespace App\Libraries;

class DatatableQuery
{


    private static function order_field($order_column = []): string
    {
        return isset($_POST['order']) ? $order_column[$_POST['order']['0']['column']] : "id";
    }

    private static function order(): string
    {
        return !empty($_POST['order']['0']['dir']) ? $_POST['order']['0']['dir'] : "DESC";
    }

    private static function offset()
    {
        return $_POST['length'] != -1 ? $_POST['start'] : 0;
    }

    private static function limit()
    {
        return $_POST['length'] != -1 ? $_POST['length'] : 10;
    }

    public static function build_query($model, $search_column = [], $order_column = [])
    {
        $query = $model->orderBy(self::order_field($order_column), self::order());
        $queryFiltered = $model->orderBy(self::order_field($order_column), self::order());

        if (trim($_POST['search']['value']) != "") {
            for ($i = 0; $i < count($search_column); $i++) {
                if ($i == 0) {
                    $query->like($search_column[$i], "%" . $_POST['search']['value'] . "%");
                    $queryFiltered->like($search_column[$i], "%" . $_POST['search']['value'] . "%");
                } else {
                    $query->orLike($search_column[$i], "%" . $_POST['search']['value'] . "%");
                    $queryFiltered->orLike($search_column[$i], "%" . $_POST['search']['value'] . "%");
                }
            }
        }

        $fetch_data = $query->offset((int)self::offset())->limit((int)self::limit())->findAll();

        return [
            'data' => $fetch_data,
            'recordsTotal' => count($model->findAll()),
            "recordsFiltered" => count($queryFiltered->findAll()),
        ];
    }
}
