<?php

namespace App\Traits;

trait CommonTrait
{
    public static function yesno($descr = "Option", $key = 0): array|string
    {

        $options = [
            "" => $descr,
            1 => "Oui",
            2 => "Non",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    public static function ouiNon($descr = "Option", $key = 0): array|string
    {

        $options = [
            "" => $descr,
            "OUI" => "Oui",
            "NON" => "Non",
        ];

        return $key > 0 ? $options[$key] : $options;
    }

    
    public static function genres($gen = NULL): array|string
    {

        $genres =  [
            "" => "Choix",
            "HOMME" => "HOMME",
            "FEMME" => "FEMME",
            // "AUTRE" => "AUTRE",
            "NON_SPECIFIE" => "NON SPECIFIE",
        ];

        return $gen != "" ? $genres[$gen] : $genres;
    }

    public static function status(): array
    {

        return [
            "" => "Choix (Statut)",
            "SINGLE" => "Celibataire",
            "MARIED" => "Mariee",
            "DIVORCED" => "Divorce",
            "VEUF" => "Veuf(ve)",
            "CONC" => "Concubinage/Union libre",
        ];
    }


    public static function getData($instanceModel, $id)
    {
        if ($id) {
            return $instanceModel->find($id);
        }
        return $instanceModel->findAll();
    }

    public static function formatData($instanceModel, $id = 0)
    {
        $data = self::getData($instanceModel, $id);
        $array = NULL;
        if ($data) {
            if ($id) {
                $array = $data->description;
            } else {
                $array[] = " - Sélectionner - ";
                // $array[1000] = "Indéfini";

                foreach ($data as $value) {
                    $array[$value->id] = $value->description;
                }
            }
        }

        return $array;
    }

}
