<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= lang("Administration.user_list_title") ?></h3>

                <?php if (\auth()->user()->inGroup('secretaire','admin') || \auth()->user()->hasPermission('admin.manage')) { ?>
                    <span class="float-right">
                        <?= anchor($locale . "/admin/user", "<i class='fa fa-file'></i>" . lang("Params.btn_new"), ['class' => 'btn btn-primary btn-sm']) ?>
                    </span>
                <?php } ?>

            </div>
            <div class="card-body">
                <?php

                if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>".session()->getFlashdata('message')."</div>";
                }

                use CodeIgniter\View\Table;
                use Modules\Administration\Libraries\User;


                $table = new Table();

                $template = [
                    'table_open' => '<table class="table table-bordered" id="myList">',
                ];
                $table->setTemplate($template);
                $table->setHeading(
                    "#",
                    lang('Administration.user_form_firstName'),
                    lang('Administration.user_form_lastName'),
                    lang('Administration.user_form_mobile'),
                    lang('Administration.user_form_email'),
                    lang('Administration.user_form_username'),
                    lang('Administration.user_form_active'),
                    lang('Administration.user_form_groups'),
                    lang('Params.btn_option')
                );

                if ($users) {
                    foreach (User::tableRows($users, $locale) as $data) {
                        $table->addRow($data);
                    }
                }

                echo $table->generate();
                ?>
            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>