<?php
// Initialisation des variables de session
session_start();
$user_id = $_SESSION['user_id'];
$profil_id = $_SESSION['profil_id'];

//Verfication si l'utilisateur est authentifié
if ($user_id < 1) {
  // Si non on fait une redirection sur la page d'authefication
  header('Location: ./index.php');
}

//Recuperation de l'partenaire_id s'il envoie
$partenaire_id = @$_POST['partenaireid'];
?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="">
  <meta name="author" content="CRB Team">

  <title>Gestion de partenaire - liste des indicateurs</title>




  <link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
  <link href="./assets/css/datatables.min.css" rel="stylesheet">
  <link href="./assets/css/button.datatables.min.css" rel="stylesheet">

  <script type="text/javascript" src="./assets/js/jquery.js"></script>
  <script type="text/javascript" src="./assets/js/datatables.min.js"></script>
  <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>
</head>

<body style="background-image:url(./photo/map_un.png); background-repeat : no-repeat; background-size : cover">
  <?php
  include('sous_menu_projet.php');
  ?>
  <div class="container-fluid">
    <div class="row">
      <legend>
        Liste des indicateurs

        <?php if ($profil_id != 5) { ?>

          <div class="pull-right">
            <p id="btn_new"></p>
          </div>
        <?php } ?>
      </legend>
    </div>

    <!-- Filtre du partenaire qu'il faut afficher les indicateurs -->
    <div class="row" style="margin-bottom: 20px">
      <div class="col-md-3">
        <label>Sélectionner un partenaire</label>
      </div>
      <div class="col-md-4">
        <input type="hidden" name="partenaire_id" id="partenaire_id" value="<?= $partenaire_id ?>">
        <form action="details_indicateur.php" method="POST">
          <select id="partenaires" name="partenaireid" class="form-control">
            <option value="0"> - sélectionner - </option>
          </select>

      </div><input type="submit" class='btn btn-primary btn-sm' value="Rechercher" name="Rech" /a>
    </div>
    <!-- La ou, il faut afficher les indicateurs recuperés si le partenaire est selectionné -->







    <!-- Affichage du message -->


    <table id='mespartenaires' class='table table-striped display' style='background:whitesmoke'>
      <thead>
        <tr>
          <th>#</th>
          <th>PARTENAIRE</th>
          <th>CODE ACTIVITE</th>
          <th>ACTIVITE</th>
          <th>INDICATEUR</th>
          <th>TYPE CIBLE</th>
          <th>VALEUR DE BASE</th>
          <th>CIBLE</th>
          <th>RESULTAT ATTEINT</th>
          <th>%</th>
          <th>TYPE INDICATEUR</th>
          <th>REALISATION</th>
        </tr>
      </thead>
      <tbody>

        <?php
        include('connexion.php');
        // $mysqli = new mysqli("localhost", "root", "", "crb_care");


        if (isset($_POST['partenaireid'])) {



          //Recuperation des indicateurs du partenaire ayant partenaire_id precedent
          $sql = "SELECT * FROM indicateurs WHERE partenaire_id = $partenaire_id ORDER BY indicateur_nom ASC";
          //Excecution de la reque
          $results = $mysqli->query($sql);

          $message = "";
          $table = "";

          //Verification s'il y a des donnees retournees par la requete
          if ($results->num_rows > 0) {
            //Creation du tableau qui va contenir les donnees

            //Extration des donnees retournees par la requete dans un tableau
            $indicateurs = $results->fetch_all(MYSQLI_ASSOC);


            $i = 1;
            //Boucle de remplissage des donnees dans une table qu'on va afficher
            foreach ($indicateurs as $indicateur) {

              echo "<tr><td>" . $i . "</td>";
              $idtache = $indicateur['id_tache'];
              $type_cible_id = $indicateur['type_cible_id'];
              $idindicateur = $indicateur['indicateur_id'];
              $partenaire_id = $indicateur['partenaire_id'];
              $sql_tache = $mysqli->query("SELECT * FROM taches WHERE tache_id =$idtache ");
              $tach = $sql_tache->fetch_array(MYSQLI_ASSOC);

              //PARTENAIRE
              $sql_part = $mysqli->query("SELECT * FROM partenaires WHERE partenaire_id = $partenaire_id ");
              $partenaire = $sql_part->fetch_array(MYSQLI_ASSOC);

              //TYPE DE CIBLE 
              $typecible = '';
              if ($type_cible_id > 0) {
                $sql_typ_cible = $mysqli->query("SELECT * FROM type_cible WHERE id = $type_cible_id ");
                $type_cible = $sql_typ_cible->fetch_array(MYSQLI_ASSOC);
                $typecible = !empty($type_cible)?$type_cible['description']:"";
              }

              //RESULTATS
              $sql_tache1 = $mysqli->query("SELECT SUM(cible_atteint) as nbTotal FROM tache_indicateur WHERE indicateur_id =$idindicateur ");
              $tach1 = $sql_tache1->fetch_array(MYSQLI_ASSOC);

              //FEMMES
              //$sql_tache2 = $mysqli->query("SELECT sum(f) as f FROM tache_indicateur WHERE indicateur_id =$idindicateur ");
              //$tach2 = $sql_tache2->fetch_array(MYSQLI_ASSOC);

              echo  "<td>" . $partenaire['partenaire_name'] . " " . $partenaire['partenaire_code'] . "</td>";
              echo  "<td>" . $tach['tache_code'] . "</td>";
              echo  "<td>" . $tach['tache_nom'] . "</td>";
              echo  "<td>" . $indicateur['indicateur_nom'] . "</td>";
              echo  "<td>" .  $typecible . "</td>";
              echo  "<td>" . $indicateur['valeur_base'] . "</td>";
              echo  "<td>" . $indicateur['cible'] . "</td>";
              echo  "<td>" . $tach1['nbTotal'] . "</td>";
              $pourcentage = round(($tach1['nbTotal'] * 100) / $indicateur['cible'], 1);
              echo  "<td>" . $pourcentage . "</td>";
              echo  "<td>" . $indicateur['description'] . "</td><td>";

              //Les differentes options editer,supprimer,etc.

              if ($_SESSION['profil_id'] == 1) {
                echo  "<a href='./indicateur_editer.php?indicateur_id=" . $indicateur['indicateur_id'] . "&partenaire_id=" . $indicateur['partenaire_id'] . "'><span class='glyphicon glyphicon-edit'></a>||";
              }

              echo  "<a href='./indicateurs_histo.php?indicateur_id=" . $indicateur['indicateur_id'] . "&partenaire_id=" . $indicateur['partenaire_id'] . "'><span  class='glyphicon glyphicon-plus'></a>";

              if ($_SESSION['profil_id'] == 1) {
                echo  "||<a href='#' class='text-danger' data-toggle='modal' data-target='#myModal" . $indicateur['indicateur_id'] . "'><span  class='glyphicon glyphicon-trash'></a>
                     <div class='modal fade' id='myModal" . $indicateur['indicateur_id'] . "' role='dialog'>
                        <div class='modal-dialog'>

                          <div class='modal-content'>
                            <div class='modal-body'>
                              <p>Voulez-vous vraiement supprimer <b>" . $indicateur['indicateur_nom'] . "</b>?</p>
                            </div>
                            <div class='modal-footer'>
                              <button type='button' class='btn btn-default btn-sm' data-dismiss='modal'>Anuller</button>
                              <a href='./indicateur_supprimer.php?indicateur_id=" . $indicateur['indicateur_id'] . "&partenaire_id=" . $indicateur['partenaire_id'] . "' class='btn btn-danger btn-sm'>Confirmer</a>
                            </div>
                          </div>

                        </div>
                      </div>";
              }
              echo  "</td></tr>";
              $i++;
            }
          } else {
            //S'il n'y a pas d'indicateur on retourne ce message
            $message = "Il n'y a aucun indicateur pour ce partenaire.";
          }
        }
        ?>
      </tbody>

    </table>

    <div id="message"></div>

  </div>
  <?php
  //include('footer.php');
  ?>
</body>


<script type="text/javascript">
  $(document).ready(function() {
    // alert('ok');
    // $("#btn_new").html(data.btn_new);
    //Recuperation des partenaires selectionnables
    var partenaire_ids = $("#partenaire_id").val();

    $.ajax({
      url: './model/model_partenaires_liste_selection.php',
      type: 'POST',
      dataType: 'JSON',
      data: {
        partenaire_id: partenaire_ids
      },
      success: function(data) {
        $("#partenaires").html(data.partenaires);
        $("#btn_new").html(data.btn_new);
      }
    });

    //SI le partenaire_id n'est pas null au chargement de la page, on fait la Recuperation des indicateurs correspondants

    $.ajax({
      url: './model/model_indicateur_liste.php?partenaire_id=' + partenaire_ids,
      type: 'GET',
      dataType: 'JSON',
      success: function(data) {

        $("#tbody").html(data.indicateurs);
        $("#message").html(data.message);
        $("#btn_new").html(data.btn_new);
      }
    });


    //Si on change le partenaire selectionné, on fait la Recuperation des indicateurs du partenaire selectionné
    $("#partenaires8").change(function() {
      var partenaire_id = $("#partenaires").val();


      $.ajax({
        url: './model/model_indicateur_liste.php?partenaire_id=' + partenaire_id,
        type: 'GET',
        dataType: 'JSON',
        success: function(data) {

          $("#tbody").html(data.indicateurs);

          $("#message").html(data.message);
          $("#btn_new").html(data.btn_new);
        }
      });

    });

  });
</script>

<script type="text/javascript">
  $(document).ready(function() {
    $('#mespartenaires').DataTable({
      language: {
        "sProcessing": "Traitement en cours...",
        "sSearch": "Rechercher&nbsp;:",
        "sLengthMenu": "Afficher _MENU_ &eacute;l&eacute;ments",
        "sInfo": "Affichage de l'&eacute;l&eacute;ment _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
        "sInfoEmpty": "Affichage de l'&eacute;l&eacute;ment 0 &agrave; 0 sur 0 &eacute;l&eacute;ment",
        "sInfoFiltered": "(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)",
        "sInfoPostFix": "",
        "sLoadingRecords": "Chargement en cours...",
        "sZeroRecords": "Aucun &eacute;l&eacute;ment &agrave; afficher",
        "sEmptyTable": "Aucune donn&eacute;e disponible dans le tableau",
        "oPaginate": {
          "sFirst": "Premier",
          "sPrevious": "Pr&eacute;c&eacute;dent",
          "sNext": "Suivant",
          "sLast": "Dernier"
        },
        "oAria": {
          "sSortAscending": ": activer pour trier la colonne par ordre croissant",
          "sSortDescending": ": activer pour trier la colonne par ordre d&eacute;croissant"
        }
      },
      dom: 'Bfrtlip',
      buttons: [{
          extend: 'copy',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8]
          }
        },
        {
          extend: 'csv',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8]
          }
        },
        {
          extend: 'excel',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8]
          }
        },
        {
          extend: 'pdf',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8]
          }
        },
        {
          extend: 'print',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8]
          }
        }
      ]
    });
  });
</script>

</html>