<?php
// Initialisation des variables de session

  session_start();
  $user_id = $_SESSION['user_id'];
  $profil_id = $_SESSION['profil_id'];
  
  //Verfication si l'utilisateur est authentifié

  if($user_id < 1){
    // Si non on fait une redirection sur la page d'authefication
    header('Location: ./index.php');
  }

  // Connection a la base de donnees
  //$mysqli = new mysqli("localhost","root","","crb_care");
   include ('connexion.php');

  // Recuperation de l'ID du partenaire et de la tache concerné
  $partenaire_id = isset($_GET['partenaire_id'])?$_GET['partenaire_id']:null;
  $tache_id = isset($_GET['tache_id'])?$_GET['tache_id']:null;

  // Selection du partenaire
  $sql_partenaire = "SELECT * FROM partenaires WHERE partenaire_id = $partenaire_id";
  $stm_partenaire = $mysqli->query($sql_partenaire);
  $partenaire = $stm_partenaire->fetch_array(MYSQLI_ASSOC);

  // Selection de la tache a decaisser le budget
  $sql_tache = "SELECT * FROM taches WHERE tache_id = $tache_id";
  $stm_tache = $mysqli->query($sql_tache);
  $tache = $stm_tache->fetch_array(MYSQLI_ASSOC);

  $mysqli -> close();

?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="CRB Team">

	<title>Gestion de partenaire - Décaissement</title>
	<link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
	<script type="text/javascript" src="./assets/js/jquery.js"></script>
    <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>

</head>
<body style="background-image:url(./photo/map_un.png); background-repeat : no-repeat; background-size : cover">
  <?php
    include('sous_menu_projet.php');
    ?>
   <div class="container">
   	  <div class="row">
   	  	<legend>
   	  		Décaissements
   	  	    <div class="pull-right">
	   	  		<a class="btn btn-primary btn-sm" href="./tache_liste.php?partenaire_id=<?=$partenaire_id?>"style="color: #fff;background-color: #FFA833">Liste des activités</a>
	   	  	</div>
	   	</legend>
   	  </div>
      <!-- informations en rapport avec partenaire et la tache a decaisser -->
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="./tache_liste.php?partenaire_id=<?=$partenaire_id?>"><?=$partenaire['partenaire_name']." (<b>".$partenaire['partenaire_code']?></b></a></li>
          <li class="breadcrumb-item"><a href="#"><?=$tache['tache_nom']."(<b>".$tache['tache_code']?></b>)</a></li>
          <li class="breadcrumb-item active" aria-current="page">Montant disponible:<b><?= number_format(($tache['budget']-$tache['budget_decaisse']),0,'',' ')?> BIF</b></li>
        </ol>
      </nav>
	<div class="col-md-12" style='background:whitesmoke'>
   	    <p id="message"></p>

        <div class="row">
          <!-- Le champ du montant a decaisser -->
          <div class="col-md-3">
             Budget consommé<br>
             <input type="number" name="montant" id="montant" class="form-control">
   	  		 <input type="hidden" name="tache_id" id="tache_id" value="<?=$tache_id?>">
   	  		 <p id="error_montant" class="text-danger"></p>
          </div>

          <!-- Le champ du commentaire du decaissement -->
          <div class="col-md-4">
   	  		 Description<br>
             <input type="text" name="commentaire" id="commentaire" class="form-control">
          </div>
          <!-- Le boutton d'enregistrement du decaissement -->
          <div class="col-md-2" style="margin-top: 20px">
   	  		 <button class="btn btn-primary btn-sm btn-block" id="save" style="color: #fff;background-color: #FFA833">Enregister</button>
   	  	  </div>
   	  	</div>
	</div>
        <!-- Espace d'affichage de l'historique du decaissement de la tache selectionnée -->
        <div id='decaissements' style='background:whitesmoke'></div>
   </div>
   <?php
    include('footer.php');
    ?>
</body>
<script type="text/javascript">
	$(document).ready(function(){
   // Appel un fonction qui recupere l'historique de decaissement
    getList();
// recuperation de l'historique de decaissement
    function getList(){
      var tache_id = $("#tache_id").val();
        if(tache_id > 0){
            $.ajax({
                url: './model/model_tache_decaissement_liste.php?tache_id='+tache_id,
                type: 'GET',
                dataType: 'JSON',
                success:function(data){
                  $("#decaissements").html(data.decaissements);
                }
            });
        }
      }

        //Sauvegarder mon decaissement
    //Lors du click sur le boutton enregistrer
      $("#save").click(function(){
        // recuperation des informations du formulaire de decaissement
      	var tache_id = $("#tache_id").val();
      	var montant = $("#montant").val();
      	var commentaire = $("#commentaire").val();

       // Vides les variables contenats les messages d'erreurs
        $("#error_montant").html(" ");
	      $("#message").html(" ");

        // Validation de l'ID de la tache
      	if(tache_id < 1){
            $("#message").html("Il faut verifier l'ID de la tache");
      	}

        // Validation du montant a decaisser sur la tache
      	if(montant < 1){
            $("#error_montant").html("Le champ <b>Montant</b> est réquis");
      	}

       //Si tous es valide
      	if(montant >0 && tache_id > 0){
          //Envoie des informations du decaissemnt sur la tache
          $.ajax({
                url: './model/model_tache_decaissement.php',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    montant:montant,
                	  tache_id:tache_id,
                    commentaire:commentaire
                },
                success:function(data){
                  // Messag de l'operation
                    $("#message").html(data.message);
          					if(data.status == 201){
                      //Si l'operation a bien passe on vide les champs
          						$("#montant").val('');
                      $("#commentaire").val('');
                      //Si l'operation a bien passe, on recharge la liste de l'historique de decaissement
                      getList();
          					}

                }
            });
      	}
      });

	});
</script>
</html>
