<?php
// Initialisation des variables de session
session_start();

  $user_id = isset($_SESSION['user_id']);
  $profil_id = isset($_SESSION['profil_id']);

  //Verfication si l'utilisateur est authentifié
  if($user_id > 0){
    // Si oui on fait une redirection sur la liste des projets
    header('Location: ./dashboard.php');
  }
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="CRB Team">

	<title>Gestion de projet - Connection</title>
  <link href="./assets/css/bootstrap.min.css" rel="stylesheet">
	<link href="./assets/css/sticky-footer.css" rel="stylesheet">
	<script type="text/javascript" src="./assets/js/jquery.js"></script>
    <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>
</head>
<body>
  <div class="container" style="margin-top: 80px">

  	<div class="col-md-offset-4 col-md-4">
  		<legend class="text-primary text-center">
  			<h3>Se connecter</h3>
  		</legend>
      <p id="message" style="margin-bottom: 10px"></p>
  	</div>
  	<!-- Debut du formulaire de connection  -->
  	<form method="POST" action="#">
			<!-- Champ pour le nom d'utilisateur -->
	  	<div class="col-md-offset-4 col-md-4" style="margin-bottom: 10px">
	  		<div class="input-group">
	          <span class="input-group-addon" id="basic-addon1">
	          	<i class="glyphicon glyphicon-user"></i>
	          </span>
	  	      <input type="text" id="username" name="username" placeholder="Nom d'utilisateur" class="form-control">
	  	    </div>
	  	</div>
       <!-- Champ pour le mot de passe  -->
	  	<div class="col-md-offset-4 col-md-4" style="margin-bottom: 10px">
	  		<div class="input-group">
	          <span class="input-group-addon" id="basic-addon1">
	          	<i class="glyphicon glyphicon-lock"></i>
	          </span>
	  	      <input type="password" id="password" name="password" placeholder="Mot de passe" class="form-control">
	  	    </div>
	  	</div>
     <!-- Bouton pour la connection  -->
	  	<div class="col-md-offset-4 col-md-4">
	  	   <button type='button' class="btn btn-primary bt-md btn-block" id="login">
	  		  Connection
	  	   </button>
	  	</div>
    </form>
  </div>
  <?php
   include('footer.php');
   ?>
</body>
<script type="text/javascript">
	$(document).ready(function(){

			// Lors du click sur le bouton Connection
      $("#login").click(function(){

				//Recuperation du nom d'utilisateur et mot de passe
        var username = $("#username").val();
      	var password = $("#password").val();

				// Envoie des identifiants de connection sur le fichier(model_login.php) qui gerer l'authentification
      	$.ajax({
                url: './model/model_login.php',
                type: 'POST',
                dataType: 'JSON',
                data:{username:username,password:password},
                success:function(data){
									// Affichage du message du success
                  $("#message").html(data.message);
										// En cas de succes lors de l'authentification
                  if(data.status == 200){
										// On fait une redirection sur une autre page apres 2 secondes
                    setTimeout(function(){
                      window.location.href = './dashboard.php';
                    }, 2000);
                  }
                }
            });

      });
	});
</script>
</html>
