<?php
// Initialisation des variables de session
  session_start();
  $user_id = $_SESSION['user_id'];
  $profil_id = $_SESSION['profil_id'];

  //Verfication si l'utilisateur est authentifié
  if($user_id < 1){
    // Si non on fait une redirection sur la page d'authefication
    header('Location: ./index.php');
  }

  //Recuperation de l'partenaire_id s'il envoie
  $partenaire_id = isset($_GET['partenaire_id'])?$_GET['partenaire_id']:null;
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="CRB Team">

	<title>Gestion de partenaire - liste des indicateurs</title>
  
  
   <link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
  <link href="./assets/css/datatables.min.css" rel="stylesheet">
  <link href="./assets/css/button.datatables.min.css" rel="stylesheet">

	<script type="text/javascript" src="./assets/js/jquery.js"></script>
  <script type="text/javascript" src="./assets/js/datatables.min.js"></script>
  <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>
</head>
<body style="background-image:url(./photo/map_un.png); background-repeat : no-repeat; background-size : cover">
  <?php
    include('sous_menu_projet.php');
    ?>
	<div class="container-fluid">
   	  <div class="row">
   	  	<legend>
   	  		Liste des indicateurs

   	  	    <div class="pull-right">
	   	  		  <p id="btn_new"></p>
	   	  	</div>
	   	</legend>
   	  </div>

      <!-- Filtre du partenaire qu'il faut afficher les indicateurs -->
      <div class="row" style="margin-bottom: 20px">
        <div class="col-md-3">
          <label>Sélectionner un partenaire</label>
        </div>
        <div class="col-md-4">
          <input type="hidden" name="partenaire_id" id="partenaire_id" value="<?=$partenaire_id?>">
		      
          <form action="details_indicateur.php" method="POST">
          <select id="partenaires" name="partenaireid" class="form-control">
            <option value="0"> - sélectionner - </option>
          </select>
		  
        </div><input type="submit" class='btn btn-primary btn-sm' value="Rechercher" name="Rech" /> 
      </div>
      <!-- La ou, il faut afficher les indicateurs recuperés si le partenaire est selectionné -->
	  
    

	  
	  
	
	 
      <!-- Affichage du message -->
   	 
	  
	  	<table id='mespartenaires' class='table table-striped display' style='background:whitesmoke'>
		 <thead>
	               <tr>
	                   <th>#</th>
	                   <th>CODE ACTIVITE</th>
					    <th>ACTIVITE</th>
	                   <th>INDICATEUR</th>
					    <th>VALEUR DE BASE</th>
	                   <th>CIBLE</th>
					    <th>HOMMES</th>
						 <th>FEMMES</th>
                     <th>RESULTAT ATTEINT</th>
					<th>%</th>
	                   <th>TYPE INDICATEURS</th>
					   

  <th>REALISATION</th>

	</tr>
	 </thead>
	 <tbody id='tbody'>
	
	 
	 </tbody>
	   
	  	</table> 
		
		 <div id="message"></div>

   	</div>
    <?php
     //include('footer.php');
     ?>
</body>


<script type="text/javascript">
	$(document).ready(function(){
    //Recuperation des partenaires selectionnables
    var partenaire_ids = $("#partenaire_id").val();
    $.ajax({
            url: './model/model_partenaires_liste_selection.php',
            type: 'POST',
            dataType: 'JSON',
            data:{partenaire_id:partenaire_ids},
            success:function(data){
              $("#partenaires").html(data.partenaires);
            }
        });

    //SI le partenaire_id n'est pas null au chargement de la page, on fait la Recuperation des indicateurs correspondants
    if(partenaire_ids > 0){
       $.ajax({
            url: './model/model_indicateur_liste.php?partenaire_id='+partenaire_ids,
            type: 'GET',
            dataType: 'JSON',
            success:function(data){
              $("#tbody").html(data.indicateurs);
              $("#message").html(data.message);
              $("#btn_new").html(data.btn_new);
            }
        });
      }

      //Si on change le partenaire selectionné, on fait la Recuperation des indicateurs du partenaire selectionné
    $("#partenaires8").change(function(){
      var partenaire_id = $("#partenaires").val();

      if(partenaire_id > 0){
       $.ajax({
            url: './model/model_indicateur_liste.php?partenaire_id='+partenaire_id,
            type: 'GET',
            dataType: 'JSON',
            success:function(data){
				
              $("#tbody").html(data.indicateurs);
			  
              $("#message").html(data.message);
              $("#btn_new").html(data.btn_new);
            }
        });
      }
    });

	});

</script>

<script type="text/javascript">
  $(document).ready( function () {
     $('#mespartenaires').DataTable(
       {
        language: {
            "sProcessing":     "Traitement en cours...",
            "sSearch":         "Rechercher&nbsp;:",
            "sLengthMenu":     "Afficher _MENU_ &eacute;l&eacute;ments",
            "sInfo":           "Affichage de l'&eacute;l&eacute;ment _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
            "sInfoEmpty":      "Affichage de l'&eacute;l&eacute;ment 0 &agrave; 0 sur 0 &eacute;l&eacute;ment",
            "sInfoFiltered":   "(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)",
            "sInfoPostFix":    "",
            "sLoadingRecords": "Chargement en cours...",
            "sZeroRecords":    "Aucun &eacute;l&eacute;ment &agrave; afficher",
            "sEmptyTable":     "Aucune donn&eacute;e disponible dans le tableau",
            "oPaginate": {
                "sFirst":      "Premier",
                "sPrevious":   "Pr&eacute;c&eacute;dent",
                "sNext":       "Suivant",
                "sLast":       "Dernier"
            },
            "oAria": {
                "sSortAscending":  ": activer pour trier la colonne par ordre croissant",
                "sSortDescending": ": activer pour trier la colonne par ordre d&eacute;croissant"
            }
        },
       dom: 'Bfrtlip',
       buttons: [
        {
           extend: 'copy',
           exportOptions: {
                columns: [0,1,2,3,4,5,6,7,8,9]
            }
           },
           {
           extend: 'csv',
           exportOptions: {
                columns: [0,1,2,3,4,5,6,7,8,9]
            }
           },
           {
           extend: 'excel',
           exportOptions: {
                columns: [0,1,2,3,4,5,6,7,8,9]
            }
           },
           {
           extend: 'pdf',
           exportOptions: {
                columns: [0,1,2,3,4,5,6,7,8,9]
            }
           },
           {
           extend: 'print',
           exportOptions: {
                columns: [0,1,2,3,4,5,6,7,8,9]
            }
           }
    ]
    }
     );
  } );
</script>

</html>
