<?php
// Initialisation des variables de session
session_start();
$user_id = $_SESSION['user_id'];
$profil_id = $_SESSION['profil_id'];
$partenaire_id = $_SESSION['partenaire_id'];

//Verfication si l'utilisateur est authentifié
if ($user_id < 1) {
  // Si non on fait une redirection sur la page d'authefication
  header('Location: ./index.php');
}

//Connection a la base de donnees
//$mysqli = new mysqli("localhost", "root", "", "crb_care");
 include ('connexion.php');

//Recuperation de toute les periodes ou nous avons des donnees
$sql = "SELECT DISTINCT(pr.periode) AS periode FROM partenaires as pr JOIN indicateurs as ind ON ind.partenaire_id = pr.partenaire_id";
$results = $mysqli->query($sql);

//Recuperation de tous les partenaires
if ($profil_id == 14)
  $sql_partenaire = "SELECT * FROM partenaires WHERE partenaire_id = $partenaire_id";
else
  $sql_partenaire = "SELECT * FROM partenaires";

$result_partenaire = $mysqli->query($sql_partenaire);

//Recuperation du partenaire_id
$partenaire_id = isset($_POST['partenaire_id']) ? $_POST['partenaire_id'] : $partenaire_id;
$periode = isset($_POST['periode']) ? $_POST['periode'] : "";

if (empty($partenaire_id)) {
  $sql_budget = "SELECT * FROM partenaires_annees where partenaire_id =0";
  $stmt_budgets = $mysqli->query($sql_budget);
  $budgets = $stmt_budgets->fetch_all(MYSQLI_ASSOC);
} else {
  $sql_budget = "SELECT * FROM partenaires_annees WHERE partenaire_id = $partenaire_id";
  $stmt_budgets = $mysqli->query($sql_budget);
  $budgets = $stmt_budgets->fetch_all(MYSQLI_ASSOC);
}


//Faire une condition des selection
$condition = "";
//Verification si le partenaire et la periode ont été selectionés
if ($partenaire_id > 0 && $periode > 0) {
  $condition = "WHERE pr.partenaire_id = $partenaire_id AND ind.annee_partenaire = '$periode'";
  //Si le partenaire seul est selectionné
} elseif ($partenaire_id > 0 && $periode < 1) {
  $condition = "WHERE pr.partenaire_id = $partenaire_id";
  //Si la periode seule est selectionnée
} elseif ($partenaire_id < 1 && $periode > 0) {
  $condition = "WHERE pr.periode = '$periode'";
}

//Selection des indicateurs en fonction des filtre selectionnés
$requete = "SELECT pr.*,ind.*, t.tache_code, t.tache_nom FROM partenaires as pr JOIN indicateurs as ind ON ind.partenaire_id = pr.partenaire_id JOIN taches as t ON t.tache_id = ind.id_tache $condition";
$stmnt_indicat = $mysqli->query($requete);

$mysqli->close();

?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="">
  <meta name="author" content="CRB Team">

  <title>Gestion de partenaire - Synthèse des indicateurs</title>
  <link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
  <link href="./assets/css/datatables.min.css" rel="stylesheet">
  <link href="./assets/css/button.datatables.min.css" rel="stylesheet">

  <script type="text/javascript" src="./assets/js/jquery.js"></script>
  <script type="text/javascript" src="./assets/js/datatables.min.js"></script>
  <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>
</head>

<body style="background-image:url(./photo/map_un.png); background-repeat : no-repeat; background-size : cover">
  <?php
  include('sous_menu_projet.php');

  ?>
  <div class="container-fluid">
    <div class="row" style="margin-top:-4px">
      <legend>
        Rapport de synthèse

        <div class="pull-right">
          <a href="./indicateur_liste.php" class='btn btn-primary btn-sm'>Liste</a>
        </div>
      </legend>
    </div>
    <div class="col-md-12" style='background:whitesmoke'>
      <form name="myform" action="indicateur_synthese.php" method="POST" style="margin-top:-8px">

        <div class="row" style="margin-bottom: 20px">
          <!-- Filtres -->
          <!-- Filtre des partenaires -->
          <div class="col-md-4">
            <label>Projet</label>
            <?php
            $partenaires = $result_partenaire->fetch_all(MYSQLI_ASSOC);
            ?>
            <select class="form-control" id="partenaire_id" name="partenaire_id" onchange="changeDonnees();">
              <option value="0"> - Sélectionner - </option>
              <?php
              foreach ($partenaires as $partenaire) {
              ?>
                <option <?php if ($partenaire['partenaire_id'] == $partenaire_id) echo 'selected'; ?> value="<?= $partenaire['partenaire_id'] ?>"><?= $partenaire['partenaire_name'] . " (" . $partenaire['partenaire_code'] . ")" ?></option>
              <?php
              }
              ?>
            </select>
          </div>

          <!-- Filtre des periodes -->
          <div class="col-md-4">
            <label>Période</label>
            <?php
            $results = $results->fetch_all(MYSQLI_ASSOC);
            //Recuperation des annees budgets du partenaire

            ?>
            <select class="form-control" id="periode" name="periode" onchange="changeDonnees();">
              <option value="0"> - Sélectionner - </option>
              <?php
              foreach ($budgets  as $result) {
              ?>
                <option <?php if ($result['annee_partenaire'] == isset($_POST['periode'])) echo 'selected'; ?> value="<?php echo $result['annee_partenaire'] ?>"><?php echo $result['annee_partenaire'] ?></option>
              <?php
              }
              ?>
            </select>
          </div>
        </div>
      </form>
    </div>

    <!-- Champ d'affichage des indicateurs -->
    <table class='table table-striped' id="mesindicateurs" style="margin-top:-4px;background:whitesmoke">
      <thead>
        <tr>
          <th>#</th>
          <th>PARTENAIRE</th>
          <th>CODE ACTIVITE</th>
          <th>ACTIVITE</th>
          <th>INDICATEUR</th>
          <th>VALEUR BASE</th>
          <th>CIBLE</th>
          <th>RESULTAT ATTEINT</th>
          <th>TAUX</th>
        </tr>
      </thead>
      <tbody>
        <?php
        //Recuperer les indicateurs retournées par la requete sous formé d'un tableau
        $indicateurs = $stmnt_indicat->fetch_all(MYSQLI_ASSOC);
        //$mysqli = new mysqli("localhost", "root", "", "crb_care");

        $i = 1;
        //Boucle pour nous aider a remplir nos donnees dans une table qui sera afficher sur la liste
        
        foreach ($indicateurs as $indicateur) {
         
          echo "<tr><td>" . $i . "</td>";
          echo  "<td>" . $indicateur['partenaire_name']." ".$indicateur['partenaire_code']. "</td>";
          echo "<td>" . $indicateur['tache_code'] . "</td>";
          echo "<td>" . $indicateur['tache_nom'] . "</td>";
          echo "<td>" . $indicateur['indicateur_nom'] . "</td>";
          echo "<td>" . $indicateur['valeur_base']. "</td>";


          echo "<td>" . $indicateur['cible'] . "</td>";
          echo "<td>" . $indicateur['cible_atteint'] . "</td>";
          echo "<td>" . number_format($indicateur['cible_atteint'] * 100 / $indicateur['cible'], 2, '.', ' ') . "%</td>";
          echo "</tr>";

          $i++;
        }
        ?>
      </tbody>
    </table>
    <!-- Champ d'affichage des messages apres operations-->
    <div id="message"></div>

  </div>
  <?php
  //include('footer.php');
  ?>
</body>
<script type="text/javascript">
  function changeDonnees() {
    myform.submit();
  }
</script>
<script type="text/javascript">
  $(document).ready(function() {
    $('#mesindicateurs').DataTable({
      language: {
        "sProcessing": "Traitement en cours...",
        "sSearch": "Rechercher&nbsp;:",
        "sLengthMenu": "Afficher _MENU_ &eacute;l&eacute;ments",
        "sInfo": "Affichage de l'&eacute;l&eacute;ment _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
        "sInfoEmpty": "Affichage de l'&eacute;l&eacute;ment 0 &agrave; 0 sur 0 &eacute;l&eacute;ment",
        "sInfoFiltered": "(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)",
        "sInfoPostFix": "",
        "sLoadingRecords": "Chargement en cours...",
        "sZeroRecords": "Aucun &eacute;l&eacute;ment &agrave; afficher",
        "sEmptyTable": "Aucune donn&eacute;e disponible dans le tableau",
        "oPaginate": {
          "sFirst": "Premier",
          "sPrevious": "Pr&eacute;c&eacute;dent",
          "sNext": "Suivant",
          "sLast": "Dernier"
        },
        "oAria": {
          "sSortAscending": ": activer pour trier la colonne par ordre croissant",
          "sSortDescending": ": activer pour trier la colonne par ordre d&eacute;croissant"
        }
      },
      dom: 'Bfrtlip',
      buttons: [{
          extend: 'copy',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7]
          }
        },
        {
          extend: 'csv',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7]
          }
        },
        {
          extend: 'excel',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7]
          }
        },
        {
          extend: 'pdf',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7]
          }
        },
        {
          extend: 'print',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7]
          }
        }
      ]
    });
  });
</script>

</html>