<?php
// Initialisation des variables de session
session_start();

$user_id = $_SESSION['user_id'];
$profil_id = $_SESSION['profil_id'];
$partenaire_id = $_SESSION['partenaire_id'];
$groupe_id = $_SESSION['groupe_id'];

if ($_SESSION['user_id'] < 1 || $_SESSION['profil_id'] == 14) {
  // Si non on fait une redirection sur la page d'authefication
  header('Location: ./index.php');
}

// Connection a la base de donnees
//$mysqli = new mysqli("localhost","root","","crb_care");
include('connexion.php');

// Recuperation des periodes ou il y a des partenaires
$sql = "SELECT DISTINCT(periode) AS periode FROM partenaires";
$results = $mysqli->query($sql);

//Recuperation des partenaires
//Si la periode a été selectionnée

$periode_id = isset($_POST['periode_id']) ? $_POST['periode_id'] : "";
//Une condition de selection
$condition = ($periode_id > 0) ? "WHERE periode = " . $periode_id : "";
$sql_partenaires = "SELECT pr.*,COUNT(tc.tache_id) as nbTaches, SUM(tc.budget_decaisse) as mntDec, pv.nom as province, cm.nom as commune FROM partenaires AS pr
                  LEFT JOIN taches AS tc ON tc.partenaire_id = pr.partenaire_id
                  LEFT JOIN provinces AS pv ON pv.id = pr.province_id
                  LEFT JOIN communes AS cm ON cm.id = pr.commune_id
                  $condition
                  GROUP BY pr.partenaire_id ORDER BY pr.partenaire_id DESC";
$results_partenaires = $mysqli->query($sql_partenaires);

$mysqli->close();
?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="">
  <meta name="author" content="CRB Team">

  <title>Gestion de partenaire - Liste</title>
  <link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
  <link href="./assets/css/datatables.min.css" rel="stylesheet">
  <link href="./assets/css/button.datatables.min.css" rel="stylesheet">

  <script type="text/javascript" src="./assets/js/jquery.js"></script>
  <script type="text/javascript" src="./assets/js/datatables.min.js"></script>
  <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>
</head>

<body style="background-image:url(./photo/map_un.png); background-repeat : no-repeat; background-size : cover">
  <?php
  include('sous_menu_projet.php');
  ?>
  <div class="container-fluid" style="margin-bottom:10px">
    <div class="row" style="margin-left:12px; margin-right:12px">
      <legend>
        Liste des partenaires
        <?php if ($profil_id != 5) { ?>
          <div class="pull-right">
            <a class="btn btn-primary btn-sm" href="./partenaire_nouveau.php" style="color: #fff;background-color: #FFA833"> Créer un projet</a>
          </div>
        <?php } ?>
      </legend>
    </div>
    <!-- Filtre des periodes -->
    <form action="partenaire_liste.php" method="POST" name='myform' style="margin-top:-4px">
      <div class="row" style="margin: 4px">
        <div class="col-md-1">Période</div>
        <div class="col-md-3">
          <?php
          // Formattage des donnees recuperés en tableau cle=>value
          $results = $results->fetch_all(MYSQLI_ASSOC);
          /*
			  echo "<pre>";
			  print_r($results);
			  echo "</pre>";
			  */
          ?>
          <!-- Filtre selectionnable -->
          <select class="form-control" id="periode_id" name="periode_id" onchange="changePeriode();">
            <option value="0"> - Sélectionner - </option>
            <?php
            foreach ($results as $result) {
            ?>
              <option value="<?= $result['periode'] ?>"><?= $result['periode'] ?></option>
            <?php
            }
            ?>
          </select>
        </div>
      </div>
    </form>
    <!-- Espace d'affichage des projets -->
    <table id='mesprojets' class='table table-striped display' style='background:whitesmoke'>
      <thead>
        <tr>
          <th>#</th>
          <th>CODE DONNEUR</th>
          <th>CODE PROJET</th>
          <th>PERIODE</th>
          <th>NOM DU PROJET</th>
          <th>BUDGET PREVISIONNEL</th>
          <th>BUDGET CONSOMME</th>
          <th>TAUX</th>
          <th>ACTIVITES</th>
          <th>Z.I</th>
          <?php if ($profil_id == 1) { ?>
            <th>BUDGET</th>
            <th>OPTIONS</th>
          <?php } ?>
        </tr>
      </thead>
      <tbody>
        <?php
        //verifier le les donnees recuperer ne sont pas vide
        if ($results_partenaires->num_rows > 0) {
          //Formatter les donnees recuperer en tableau cle => valueur
          $partenaires = $results_partenaires->fetch_all(MYSQLI_ASSOC);
          $i = 1;
          //remplir le tableau a afficher sur la liste a l'aide d'une boucle qui parcours les resulatts recuperes

          foreach ($partenaires as $partenaire) {
            //recuperer les taches correspondant au partenaire en cours
            $partenaire_id = $partenaire['partenaire_id'];
            $budget = (($partenaire['budget'] > 0) ? $partenaire['budget'] : 1);

            $taux = number_format(($partenaire['mntDec'] * 100) / $budget, 2, '.', '');
            echo "<tr><td>" . $i . "</td>";
            echo "<td>" . $partenaire['partenaire_code'] . "</td>";
            echo "<td>" . $partenaire['projet_code'] . "</td>";
            echo "<td>" . $partenaire['periode'] . "ans (De " . $partenaire['annee_debut'] . ")</td>";
            echo "<td>" . $partenaire['partenaire_name'] . "</td>";
            echo "<td>" . number_format((float)$partenaire['budget'], 0, '', ' ') . "</td>";
            echo "<td>" . number_format((float)$partenaire['mntDec'], 0, '', ' ') . "</td>";
            echo "<td><b>" . $taux . "</b>%</td>";
            echo "<td>" . $partenaire['nbTaches'] . "</td>";
            echo "<td><a href='./partenaire_zone.php?partenaire_id=" . $partenaire['partenaire_id'] . "'>Zone</a></td>";

            if ($profil_id == 1) {
              echo "<td><a href='./partenaire_budget.php?partenaire_id=" . $partenaire['partenaire_id'] . "'>Budget</a></td>";
              echo "<td>
            		             <a href='./partenaire_editer.php?partenaire_id=" . $partenaire['partenaire_id'] . "'>
                               <span class='glyphicon glyphicon-edit'></span>
                             </a>||
            		             <a href='./tache_liste.php?partenaire_id=" . $partenaire['partenaire_id'] . "'>
                               <span class='glyphicon glyphicon-tasks'></span>
                             </a>||
                             <a href='./rapport_decaissement.php?partenaire_id=" . $partenaire['partenaire_id'] . "'>
                               <span class='glyphicon glyphicon-stats'></span>
                             </a>||
            		             <a href='#' class='text-danger' data-toggle='modal' data-target='#myModal" . $partenaire['partenaire_id'] . "'>
                               <span class='glyphicon glyphicon-trash'></span>
                             </a>
                             <div class='modal fade' id='myModal" . $partenaire['partenaire_id'] . "' role='dialog'>
                                <div class='modal-dialog'>

                                  <div class='modal-content'>
                                    <div class='modal-body'>
                                      <p id='message" . $partenaire['partenaire_id'] . "'></p>
                                      <p>Voulez-vous vraiement supprimer <b>" . $partenaire['partenaire_name'] . "</b>?</p>
                                    </div>
                                    <div class='modal-footer'>
                                      <button type='button' class='btn btn-default btn-sm' data-dismiss='modal'>Anuller</button>
                                      <button onclick='supprimer()' id='" . $partenaire['partenaire_id'] . "' class='btn btn-danger btn-sm'>Confirmer</button>
                                    </div>
                                  </div>

                                </div>
                              </div>
            		           </td>";
            }
            echo "</tr>";
            $i++;
          }
        }
        ?>
      </tbody>
    </table>
  </div>
  <?php
  //  include('footer.php');
  ?>
</body>
<script type="text/javascript">
  $(document).ready(function() {
    $('#mesprojets').DataTable({
      language: {
        "sProcessing": "Traitement en cours...",
        "sSearch": "Rechercher&nbsp;:",
        "sLengthMenu": "Afficher _MENU_ &eacute;l&eacute;ments",
        "sInfo": "Affichage de l'&eacute;l&eacute;ment _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
        "sInfoEmpty": "Affichage de l'&eacute;l&eacute;ment 0 &agrave; 0 sur 0 &eacute;l&eacute;ment",
        "sInfoFiltered": "(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)",
        "sInfoPostFix": "",
        "sLoadingRecords": "Chargement en cours...",
        "sZeroRecords": "Aucun &eacute;l&eacute;ment &agrave; afficher",
        "sEmptyTable": "Aucune donn&eacute;e disponible dans le tableau",
        "oPaginate": {
          "sFirst": "Premier",
          "sPrevious": "Pr&eacute;c&eacute;dent",
          "sNext": "Suivant",
          "sLast": "Dernier"
        },
        "oAria": {
          "sSortAscending": ": activer pour trier la colonne par ordre croissant",
          "sSortDescending": ": activer pour trier la colonne par ordre d&eacute;croissant"
        }
      },
      dom: 'Bfrtlip',
      buttons: [{
          extend: 'copy',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
          }
        },
        {
          extend: 'csv',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
          }
        },
        {
          extend: 'excel',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
          }
        },
        {
          extend: 'pdf',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
          }
        },
        {
          extend: 'print',
          exportOptions: {
            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
          }
        }
      ]
    });
  });
</script>

<script type="text/javascript">
  function changePeriode() {
    myform.submit();
  }
  // Fonction pour supprimer un projet
  function supprimer() {
    // recuperation d'un ID projet a supprimer
    const partenaire_id = event.target.id;
    // Demander a la page model_projet_delete.php de supprimer le partenaire_id
    $.ajax({
      url: './model/model_partenaire_delete.php',
      type: 'POST',
      data: {
        partenaire_id: partenaire_id
      },
      dataType: 'JSON',
      success: function(data) {
        // Affichage du message apres operation
        $("#message" + partenaire_id).html(data.message);

        if (data.status == 200) {
          // redirection apres le succes de l'operation
          setTimeout(function() {
            window.location.href = './partenaire_liste.php';
          }, 1000);
        }

      }
    });
  }
</script>

</html>