<?php
// Initialisation des variables de session

  session_start();
  $user_id = $_SESSION['user_id'];
  $profil_id = $_SESSION['profil_id'];
  $partenaire_id = $_SESSION['partenaire_id'];
  $groupe_id = $_SESSION['groupe_id'];

  //Verfication si l'utilisateur est authentifié

  if($user_id < 1 || $profil_id == 14){
    // Si non on fait une redirection sur la page d'authefication
    header('Location: ./index.php');
  }

  // Connection a la base de donnees
  // $mysqli = new mysqli("localhost","root","","crb_care");
  include ('connexion.php');
 
  //Recuperation des provinces
  $sql_province = "SELECT * FROM provinces";
  $provinces = $mysqli->query($sql_province);
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="CRB Team">

	<title>Gestion de projets - Nouveau</title>
	<link href="./assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="./assets/css/sticky-footer.css" rel="stylesheet">
	<script type="text/javascript" src="./assets/js/jquery.js"></script>
    <script type="text/javascript" src="./assets/js/bootstrap.min.js"></script>

</head>
<body style="background-image:url(./photo/map_un.png); background-repeat : no-repeat; background-size : cover">
   <?php
    include('sous_menu_projet.php');
    ?>
   <div class="container">
   	  <div class="row">
   	  	<legend>
   	  		Nouveau

   	  	    <div class="pull-right">
	   	  		<a class="btn btn-primary btn-sm" href="./partenaire_liste.php"style="color: #fff;background-color: #FFA833">Liste des projets</a>
	   	  	</div>
	   	</legend>
   	  </div>

      <!-- Zone d'affichage des messages  -->
	  <div class="col-md-12" style='background:whitesmoke'>
   	     <p id="message"></p>
   	  	<div class="row">
          <!-- Champ du code du projet -->
            <div class="col-md-3">
   	  		 Code projet<br>
   	  		 <input type="text" name="projet_code" id="projet_code" class="form-control">
   	  		 <p id="error_projet_code" class="text-danger"></p>
   	  	    </div>
          
           <!-- Champ du code partenaire -->
          
   	  		<div class="col-md-3">
   	  		 Code Donneur<br>
   	  		 <input type="text" name="partenaire_code" id="partenaire_code" class="form-control">
   	  		 <p id="error_partenaire_code" class="text-danger"></p>
   	  	    </div>
   	  	    
   	  	  

            <!-- Champ du nom  du partenaire -->
   	  	    <div class="col-md-6">
   	  		  Nom du projet<br>
   	  		  <textarea class="form-control" name="partenaire_name" id="partenaire_name"></textarea>
            <p id="error_partenaire_name" class="text-danger"></p>
   	  	    </div>
   	  	</div>
   	  	<div class="row">
          <!-- Champ de la periode du projet -->
   	  		<div class="col-md-6">

   	  		  Période (nombre d'année(s))<br>
            <select class="form-control" name="periode" id="periode">
              <option value="0"> - Sélectionner - </option>
              <?php

              for ($i=1; $i < 6; $i++) {
               ?>
                <option value="<?=$i?>"><?=$i?></option>
               <?php
              }
            ?>
            </select>

   	  	    </div>
            <!-- Champ de l'année debut du projet -->
   	  	    <div class="col-md-6">
   	  		  Année début<br>
   	  		  <input type="text" name="annee_debut" id="annee_debut" class="form-control">
   	  	    </div>
   	  	</div>
        
        <!-- Boutton d'enregistrement du projet -->
   	  	<div class="row" style="margin-top: 20px">
           <div class="col-md-6">
          <button class="btn btn-primary btn-sm" id="save"style="color: #fff;background-color: #FFA833">Enregister</button>
           </div>
        </div>
   </div>
    </div>
   <?php
    //include('footer.php');
    ?>
</body>
<script type="text/javascript">
	$(document).ready(function(){

    // Lors du click sur le bouton Enregistrer
      $("#save").click(function(){
        // Recuperation des informations du formulaire

      	var partenaire_code = $("#partenaire_code").val();
      	var projet_code = $("#projet_code").val();
      	var partenaire_name = $("#partenaire_name").val();
      	var periode = $("#periode").val();
      	var annee_debut = $("#annee_debut").val();

        // Vider les champs des messages d'erreurs
      $("#error_partenaire_code").html(" ");
		  $("#error_partenaire_name").html(" ");
		  $("#error_periode").html(" ");
		  $("#error_annee_debut").html(" ");
		  $("#error_projet_code").html(" ");



      // Validation du code du partenaire
      	if(projet_code.length < 2){
          // message si le champ est invalide
            $("#error_projet_code").html("Le champ <b>code projet</b> est réquis");
      	}
      	
      	// Validation du code du projet
      	if(partenaire_code.length < 2){
          // message si le champ est invalide
            $("#error_partenaire_code").html("Le champ <b>code partenaire</b> est réquis");
      	}
      	
      	
        // Validation du nom du projet
      	if(partenaire_name.length < 2){
          // message si le champ est invalide
            $("#error_partenaire_name").html("Le champ <b>nom du partenaire</b> est réquis");
      	}

        // Validation de la periode du projet
      	if(periode > 1){
          // message si le champ est invalide
            $("#error_periode").html("Le champ <b>période</b> est réquis");
      	}


        // Validation du budget du projet
      	if(annee_debut > 1){
          // message si le champ est invalide
            $("#error_annee_debut").html("Le champ <b>année budget</b> est réquis");
      	}

       

        // Si les champs obligatoires sont valides
      	if(partenaire_code !='' && projet_code !='' && partenaire_name !='' && periode >0 && annee_debut >0){
          // Envoie des donnees a enregistrer par la methode POST
          $.ajax({
                url: './model/model_partenaire_save.php',
                type: 'POST',
                dataType: 'JSON',
                data: {
                    partenaire_code:partenaire_code,
                    projet_code:projet_code,
                    partenaire_name:partenaire_name,
                    periode:periode,
                    annee_debut:annee_debut
                },
                success:function(data){
                  // Message retourne apres operation
                  $("#message").html(data.message);

                  if(data.status == 200){
                    // Si l'operation a bien passé on fait une redirection apres 1 seconde sur la liste des projet
                    setTimeout(function(){
                        window.location.href = './partenaire_liste.php';
                    }, 1000);
                  }

                }
            });
      	}
      });

	});
</script>
</html>
