<?php

namespace Modules\Formation\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Formation\Models\FormationModel;
use Modules\Params\Models\BrancheModel;
use Modules\Params\Models\CollineModel;
use Modules\Params\Models\CommuneModel;
use Modules\Params\Models\TypeFormationModel;
use Psr\Log\LoggerInterface;
use stdClass;
use UConverter;

use function PHPUnit\Framework\fileExists;

class FormationController extends BaseController
{
    public FormationModel $formationModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->formationModel = new FormationModel();
    }

    public function index()
    {
        $this->viewData['url_list'] = "/formation/data";
        $this->viewData['js'] = "Common.js";
        $this->viewData['title'] = "Liste des formations";
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());

        return view('formation/index', $this->viewData);
    }
        public function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "Volontaire.js";
        $this->viewData['route'] = "/formation/save";
        $this->viewData['formation'] =  $this->initFormation($id);
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
        $this->viewData['typeFormations'] = CommonTrait::formatData(new TypeFormationModel());
        $this->viewData['certifiants'] = CommonTrait::ouiNon();
        if ($id > 0)
            $title = "Editer une formation";
        else
            $title = "Nouvelle formation";

        $this->viewData['title'] = $title;

        return view('formation/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/formation/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/formation/save";
            $this->viewData['formation'] =  $this->initFormation($id);
            $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
            $this->viewData['typeFormations'] = CommonTrait::formatData(new TypeFormationModel());
            $this->viewData['certifiants'] = CommonTrait::ouiNon();
            if ($id > 0)
                $title = "Editer une formation";
            else
                $title = "Nouvelle formation";

            $this->viewData['title'] = $title;


            return view('formation/add', $this->viewData);
        } else {

            $uneFormation = $this->uneFormation();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation <b>" . $uneFormation['intituleFormation'] . "</b> a été modifiée</div>");
                $stmt = $this->formationModel->update($id, $uneFormation);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation <b>" . $uneFormation['intituleFormation'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->formationModel->save($uneFormation);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/formation'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->formationModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/formation'));
        }
    }

    private function uneFormation()
    {
        $formation = [];
        $formation['intituleFormation'] = $this->request->getPost('intituleFormation');
        $formation['brancheId'] = $this->request->getPost('brancheId');
        $formation['communeId'] = $this->request->getPost('communeId');
        $formation['zoneId'] = $this->request->getPost('zoneId');
        $formation['collineId'] = $this->request->getPost('collineId');
        $formation['lieuFormation'] = $this->request->getPost('lieuFormation');
        $formation['typeFormationId'] = $this->request->getPost('typeFormationId');
        $formation['nbParticipantHomme'] = $this->request->getPost('nbParticipantHomme');
        $formation['nbParticipantFemme'] = $this->request->getPost('nbParticipantFemme');
        $formation['certifiant'] = $this->request->getPost('certifiant');
        $formation['dateDebut'] = $this->request->getPost('dateDebut');
        $formation['dateFin'] = $this->request->getPost('dateFin');
        $formation['nbHeureDuree'] = $this->request->getPost('nbHeureDuree');
        $formation['commentaire'] = $this->request->getPost('commentaire');
        $formation['userId'] = \auth()->user()->id;

        $file = $this->request->getFile('pathFile');
        if ($file->isValid() && !$file->hasMoved()) {
            $newName = $file->getRandomName();
            $file->move('files/formation', $newName);
            $formation['pathFile'] = $newName;
        }

        return $formation;
    }

    private function initFormation($id = NULL)
    {
        $formation = NULL;
        if ($id) {
            $formation = $this->formationModel->find($id);
        } else {
            $formation = new stdClass();
            $formation->id = 0;
            $formation->intituleFormation = "";
            $formation->brancheId = NULL;
            $formation->communeId = NULL;
            $formation->zoneId = NULL;
            $formation->collineId = NULL;
            $formation->lieuFormation = '';
            $formation->typeFormationId = NULL;
            $formation->nbParticipantHomme = 0;
            $formation->nbParticipantFemme = 0;
            $formation->certifiant = NULL;
            $formation->dateDebut = NULL;
            $formation->dateFin = NULL;
            $formation->nbHeureDuree = 0;
            $formation->commentaire = "";
            $formation->pathFile = "";
        }

        return $formation;
    }

    private function _rules()
    {
        $rules = [];
        $rules['intituleFormation'] = ['rules'  => 'required'];
        $rules['brancheId'] = ['rules'  => 'required'];
        $rules['communeId'] = ['rules'  => 'required'];
        $rules['zoneId'] = ['rules'  => 'required'];
        $rules['collineId'] = ['rules'  => 'required'];
        $rules['lieuFormation'] = ['rules'  => 'required'];
        $rules['typeFormationId'] = ['rules'  => 'required'];
        $rules['nbParticipantHomme'] = ['rules'  => 'required|is_natural'];
        $rules['nbParticipantFemme'] = ['rules'  => 'required|is_natural'];
        $rules['certifiant'] = ['rules'  => 'required'];
        $rules['dateDebut'] = ['rules'  => 'required'];
        $rules['dateFin'] = ['rules'  => 'required'];
        $rules['nbHeureDuree'] = ['rules'  => 'required|decimal'];
        $rules['commentaire'] = ['rules'  => 'required'];

        return $rules;
    }

    function fecth()
    {
        $search_column = ['intituleFormation', 'brancheId', 'communeId', 'zoneId', 'collineId', 'lieuFormation', 'typeFormationId', 'nbParticipantHomme', 'nbParticipantFemme', 'certifiant', 'dateDebut', 'dateFin', 'nbHeureDuree', 'commentaire','pathFile'];
        $order_column = ['intituleFormation', 'brancheId', 'communeId', 'zoneId', 'collineId', 'lieuFormation', 'typeFormationId', 'nbParticipantHomme', 'nbParticipantFemme', 'certifiant', 'dateDebut', 'dateFin', 'nbHeureDuree', 'commentaire','pathFile'];

        $formationMdl = $this->formationModel;
        if (\auth()->user()->inGroup('brancheManager')) {
            $formationMdl->where('brancheId', \auth()->user()->brancheId);
        }

        if (\auth()->user()->inGroup('communeManager')) {
            $formationMdl->where('communeId', \auth()->user()->communeId);
        }

        if ($this->request->getPost('brancheId') > 0) {
            $formationMdl->where('brancheId', $this->request->getPost('brancheId'));
        }

        $fetch_data = DatatableQuery::build_query($formationMdl, $search_column, $order_column);
        $output = $this->formatBranches($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatBranches($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->intituleFormation;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $data->brancheId);
                $sub_array[] =  CommonTrait::formatData(new CommuneModel(), $data->communeId);
                $sub_array[] =  $data->lieuFormation;
                $sub_array[] =  CommonTrait::formatData(new TypeFormationModel(), $data->typeFormationId);
                $sub_array[] =  $data->nbParticipantHomme;
                $sub_array[] =  $data->nbParticipantFemme;
                $sub_array[] =  $data->certifiant;
                // $sub_array[] =  $data->dateDebut;
                // $sub_array[] =  $data->dateFin;
                $sub_array[] =  $data->nbHeureDuree;
                $sub_array[] = !empty($data->pathFile)? anchor(base_url()."files/formation/".$data->pathFile, '...'.substr($data->pathFile,-8), "target='_blank'"):"";

                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                    $option = anchor($locale . "/formation/add/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " "
                        . anchor($locale . "/formation/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
    function export(){
        $uri = current_url(true);
        $brancheId = $uri->getSegment(4);

        if ($brancheId > 0) {
            $branche = CommonTrait::formatData(new BrancheModel(), $brancheId);
        } else {
            $branche = "Toutes les branches";
        }

        $fileName = str_replace(' ', '', $branche);        
        $csv_file_name = "rapportExport/formation/formation_" . $fileName . ".csv";
        $file = fopen($csv_file_name, 'w');

        $arrays = [];
        $arrays[0] = ['', $this->formatText("Formations")];
        $arrays[1] = ['', $this->formatText($branche)];
        $arrays[2] = [];
        $arrays[3] = [
            '#', 
            $this->formatText('Formation'),  
            $this->formatText('Branche'),  
            $this->formatText('Commune'), 
            $this->formatText('Colline'), 
            $this->formatText('Lieu formation'), 
            $this->formatText('Type de  formation'), 
            $this->formatText('Partipants Homme(s)'), 
            $this->formatText("Partipants Femme(s)"), 
            $this->formatText('Certifié'),  
            $this->formatText('Date Début'), 
            $this->formatText('Date Fin'), 
            $this->formatText("Durée(nombre d'Heures)"), 
            $this->formatText('Commentaire')
        ];

        if ($brancheId > 0) {
            $formations = $this->formationModel->where('brancheId', $brancheId)->findAll();
        } else {
            $formations = $this->formationModel->findAll();
        }

        $i = 1;
        foreach ($formations as $formation) {
            $sub_array = [];
            $sub_array[] = $i;
            $sub_array[] =  $this->formatText($formation->intituleFormation);
            $sub_array[] =  $this->formatText(CommonTrait::formatData(new BrancheModel(), $formation->brancheId));
            $sub_array[] =  $this->formatText(CommonTrait::formatData(new CommuneModel(), $formation->communeId));
            $sub_array[] =  $this->formatText(CommonTrait::formatData(new CollineModel(), $formation->collineId));
            $sub_array[] =  $this->formatText( $formation->lieuFormation);
            $sub_array[] =  $this->formatText(CommonTrait::formatData(new TypeFormationModel(), $formation->typeFormationId));
            $sub_array[] =  $formation->nbParticipantHomme;
            $sub_array[] =  $formation->nbParticipantFemme;
            $sub_array[] =  $formation->certifiant;
            $sub_array[] =  $formation->dateDebut;
            $sub_array[] =  $formation->dateFin;
            $sub_array[] =  $formation->nbHeureDuree;
            $sub_array[] =  $formation->commentaire;

            $arrays[] = $sub_array;
            $i++;
        }


        foreach ($arrays as $array) {
            fputcsv($file, $array);
        }
        fclose($file);
        $btn = anchor($csv_file_name, "Exporter un <i class='fa fa-file-csv'></i>", ['class' => 'text-success', 'target' => '_blank']);

        $status = 0;
        if (fileExists($csv_file_name)) {
            $status = 1;
        }

        return $this->response->setJSON(['status' => $status, 'btnExport' => $btn]);
    }

    function formatText($string = "")
    {
        return UConverter::transcode($string, 'ISO-8859-1', 'UTF8');
    }
}
