<?php

namespace Modules\PS\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\BrancheModel;
use Modules\Params\Models\CommuneModel;
use Modules\PS\Models\CouvertureSanitaireModel;
use Psr\Log\LoggerInterface;
use stdClass;
use UConverter;

use function PHPUnit\Framework\fileExists;

class CouvertureSanitaireController extends BaseController
{
    public CouvertureSanitaireModel $couvertureSanitaireModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->couvertureSanitaireModel = new CouvertureSanitaireModel();
    }

    public function index()
    {
        $this->viewData['url_list'] = "/ps/couvertureSanitaire/data";
        $this->viewData['title'] = "Liste des couverture sanitaires";
        $this->viewData['js'] = "Common.js";
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
        
        return view('ps/couvertureSanitaire/index', $this->viewData);
    }
    public function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $this->viewData['url_list'] = "/ps/couvertureSanitaire/data";
        $this->viewData['js'] = "Volontaire.js";
        $this->viewData['route'] = "/ps/couvertureSanitaire/save";
        $this->viewData['couvertureSanitaire'] =  $this->initCouvertureSanitaire($id);
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
        $this->viewData['lieux'] = CommonTrait::lieuEvacuations();
        $this->viewData['personneRassablants'] = CommonTrait::tailleGroupe();

        if ($id > 0)
            $title = "Editer une couverture sanitaire";
        else
            $title = "Nouvelle couverture sanitaire";

        $this->viewData['title'] = $title;


        return view('ps/couvertureSanitaire/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/ps/couvertureSanitaire/data";
            $this->viewData['js'] = "Volontaire.js";
            $this->viewData['route'] = "/ps/couvertureSanitaire/save";
            $this->viewData['couvertureSanitaire'] =  $this->initCouvertureSanitaire($id);
            $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
            $this->viewData['lieux'] = CommonTrait::lieuEvacuations();
            $this->viewData['personneRassablants'] = CommonTrait::tailleGroupe();

            if ($id > 0)
                $title = "Editer une couverture sanitaire";
            else
                $title = "Nouvelle couverture sanitaire";

            $this->viewData['title'] = $title;


            return view('ps/couvertureSanitaire/add', $this->viewData);
        } else {

            $uneCouvertureSanitaire = $this->uneCouvertureSanitaire();

            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La couverture sanitaire  a été modifiée</div>");
                $stmt = $this->couvertureSanitaireModel->update($id, $uneCouvertureSanitaire);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La couverture sanitaire  a été bien enregistrée</div>");
                $stmt = $this->couvertureSanitaireModel->save($uneCouvertureSanitaire);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/ps/couvertureSanitaire'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(6);

        $stmnt = $this->couvertureSanitaireModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>La couverture sanitaire a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/ps/couvertureSanitaire'));
        }
    }

    private function uneCouvertureSanitaire()
    {
        $couvertureSanitaire = [];
        $couvertureSanitaire['brancheId'] = $this->request->getPost('brancheId');
        $couvertureSanitaire['communeId'] = $this->request->getPost('communeId');
        $couvertureSanitaire['activite'] = $this->request->getPost('activite');
        $couvertureSanitaire['dateEvenement'] = $this->request->getPost('dateEvenement');
        $couvertureSanitaire['partenaireOrganisation'] = $this->request->getPost('partenaireOrganisation');
        $couvertureSanitaire['personneRassamblant'] = $this->request->getPost('personneRassamblant');
        $couvertureSanitaire['nbSecouriste'] = $this->request->getPost('nbSecouriste');
        $couvertureSanitaire['hommeSecouru'] = $this->request->getPost('hommeSecouru');
        $couvertureSanitaire['femmeSecouru'] = $this->request->getPost('femmeSecouru');
        $couvertureSanitaire['hommeEvacue'] = $this->request->getPost('hommeEvacue');
        $couvertureSanitaire['femmeEvacue'] = $this->request->getPost('femmeEvacue');
        $couvertureSanitaire['lieuEvacuation'] = $this->request->getPost('lieuEvacuation');
        $couvertureSanitaire['hommeDECES'] = $this->request->getPost('hommeDECES');
        $couvertureSanitaire['femmeDECES'] = $this->request->getPost('femmeDECES');
        $couvertureSanitaire['nbHemorragieGrave'] = $this->request->getPost('nbHemorragieGrave');
        $couvertureSanitaire['nbUrgenceInconscience'] = $this->request->getPost('nbUrgenceInconscience');
        $couvertureSanitaire['nbAVC'] = $this->request->getPost('nbAVC');
        $couvertureSanitaire['nbUrgCasUrg'] = $this->request->getPost('nbUrgCasUrg');
        $couvertureSanitaire['nbUrgAvalSuff'] = $this->request->getPost('nbUrgAvalSuff');
        $couvertureSanitaire['nbUrgDoulPoitrin'] = $this->request->getPost('nbUrgDoulPoitrin');
        $couvertureSanitaire['nbUrgEmpoison'] = $this->request->getPost('nbUrgEmpoison');
        $couvertureSanitaire['nbUrgAccouchement'] = $this->request->getPost('nbUrgAccouchement');
        $couvertureSanitaire['nbBlessBlessurePeau'] = $this->request->getPost('nbBlessBlessurePeau');
        $couvertureSanitaire['nbBlessSaignementNez'] = $this->request->getPost('nbBlessSaignementNez');
        $couvertureSanitaire['nbBlessBrulure'] = $this->request->getPost('nbBlessBrulure');
        $couvertureSanitaire['nbBlessPiqureMorsure'] = $this->request->getPost('nbBlessPiqureMorsure');
        $couvertureSanitaire['nbBlessBlessureMuscule'] = $this->request->getPost('nbBlessBlessureMuscule');
        $couvertureSanitaire['nbBlessArticulMembre'] = $this->request->getPost('nbBlessArticulMembre');
        $couvertureSanitaire['nbBlessBlessureTete'] = $this->request->getPost('nbBlessBlessureTete');
        $couvertureSanitaire['nbBlessCou'] = $this->request->getPost('nbBlessCou');
        $couvertureSanitaire['nbBlessDos'] = $this->request->getPost('nbBlessDos');
        $couvertureSanitaire['nbBlessBlessureYeux'] = $this->request->getPost('nbBlessBlessureYeux');
        $couvertureSanitaire['nbBlessAutre'] = $this->request->getPost('nbBlessAutre');
        $couvertureSanitaire['nbMaladieEvan'] = $this->request->getPost('nbMaladieEvan');
        $couvertureSanitaire['nbMaladieFievre'] = $this->request->getPost('nbMaladieFievre');
        $couvertureSanitaire['nbMaladieConvul'] = $this->request->getPost('nbMaladieConvul');
        $couvertureSanitaire['nbMaladieDiarrhe'] = $this->request->getPost('nbMaladieDiarrhe');
        $couvertureSanitaire['nbMaladieErupt'] = $this->request->getPost('nbMaladieErupt');
        $couvertureSanitaire['nbMaladieAutre'] = $this->request->getPost('nbMaladieAutre');
        $couvertureSanitaire['userId'] = \auth()->user()->id;

        return $couvertureSanitaire;
    }

    private function initCouvertureSanitaire($id = NULL)
    {
        $couvertureSanitaire = NULL;
        if ($id) {
            $couvertureSanitaire = $this->couvertureSanitaireModel->find($id);
        } else {

            $couvertureSanitaire = new stdClass();
            $couvertureSanitaire->id = 0;
            $couvertureSanitaire->brancheId = 0;
            $couvertureSanitaire->communeId = 0;
            $couvertureSanitaire->activite = "";
            $couvertureSanitaire->dateEvenement = "";
            $couvertureSanitaire->partenaireOrganisation = NULL;
            $couvertureSanitaire->personneRassamblant = NULL;
            $couvertureSanitaire->nbSecouriste = 0;
            $couvertureSanitaire->hommeSecouru = 0;
            $couvertureSanitaire->femmeSecouru = 0;
            $couvertureSanitaire->hommeEvacue = 0;
            $couvertureSanitaire->femmeEvacue = 0;
            $couvertureSanitaire->lieuEvacuation = NULL;
            $couvertureSanitaire->hommeDECES = 0;
            $couvertureSanitaire->femmeDECES = 0;
            $couvertureSanitaire->nbHemorragieGrave = 0;
            $couvertureSanitaire->nbUrgenceInconscience = 0;
            $couvertureSanitaire->nbAVC = 0;
            $couvertureSanitaire->nbUrgCasUrg = 0;
            $couvertureSanitaire->nbUrgAvalSuff = 0;
            $couvertureSanitaire->nbUrgDoulPoitrin = 0;
            $couvertureSanitaire->nbUrgEmpoison = 0;
            $couvertureSanitaire->nbUrgAccouchement = 0;
            $couvertureSanitaire->nbBlessBlessurePeau = 0;
            $couvertureSanitaire->nbBlessSaignementNez = 0;
            $couvertureSanitaire->nbBlessBrulure = 0;
            $couvertureSanitaire->nbBlessPiqureMorsure = 0;
            $couvertureSanitaire->nbBlessBlessureMuscule = 0;
            $couvertureSanitaire->nbBlessArticulMembre = 0;
            $couvertureSanitaire->nbBlessBlessureTete = 0;
            $couvertureSanitaire->nbBlessCou = 0;
            $couvertureSanitaire->nbBlessDos = 0;
            $couvertureSanitaire->nbBlessBlessureYeux = 0;
            $couvertureSanitaire->nbBlessAutre = 0;
            $couvertureSanitaire->nbMaladieEvan = 0;
            $couvertureSanitaire->nbMaladieFievre = 0;
            $couvertureSanitaire->nbMaladieConvul = 0;
            $couvertureSanitaire->nbMaladieDiarrhe = 0;
            $couvertureSanitaire->nbMaladieErupt = 0;
            $couvertureSanitaire->nbMaladieAutre = 0;
        }

        return $couvertureSanitaire;
    }

    private function _rules()
    {
        $rules = [];
        $rules['brancheId'] = ['rules'  => 'required'];
        $rules['communeId'] = ['rules'  => 'required'];
        $rules['activite'] = ['rules'  => 'required'];
        $rules['dateEvenement'] = ['rules'  => 'required'];
        // $rules['partenaireOrganisation'] = ['rules'  => 'required'];

        return $rules;
    }

    function fecth()
    {
        $search_column = ['brancheId','activite', 'communeId', 'dateEvenement', 'partenaireOrganisation', 'personneRassamblant', 'nbSecouriste', 'hommeSecouru', 'femmeSecouru', 'hommeEvacue', 'femmeEvacue', 'lieuEvacuation', 'hommeDECES', 'femmeDECES', 'nbHemorragieGrave', 'nbUrgenceInconscience', 'nbAVC', 'nbUrgCasUrg', 'nbUrgAvalSuff', 'nbUrgDoulPoitrin', 'nbUrgEmpoison', 'nbUrgAccouchement', 'nbBlessBlessurePeau', 'nbBlessSaignementNez', 'nbBlessBrulure', 'nbBlessPiqureMorsure', 'nbBlessBlessureMuscule', 'nbBlessArticulMembre', 'nbBlessBlessureTete', 'nbBlessCou', 'nbBlessDos', 'nbBlessBlessureYeux', 'nbBlessAutre', 'nbMaladieEvan', 'nbMaladieFievre', 'nbMaladieConvul', 'nbMaladieDiarrhe', 'nbMaladieErupt', 'nbMaladieAutre', 'userId'];
        $order_column = ['brancheId','activite', 'communeId', 'dateEvenement', 'partenaireOrganisation', 'personneRassamblant', 'nbSecouriste', 'hommeSecouru', 'femmeSecouru', 'hommeEvacue', 'femmeEvacue', 'lieuEvacuation', 'hommeDECES', 'femmeDECES', 'nbHemorragieGrave', 'nbUrgenceInconscience', 'nbAVC', 'nbUrgCasUrg', 'nbUrgAvalSuff', 'nbUrgDoulPoitrin', 'nbUrgEmpoison', 'nbUrgAccouchement', 'nbBlessBlessurePeau', 'nbBlessSaignementNez', 'nbBlessBrulure', 'nbBlessPiqureMorsure', 'nbBlessBlessureMuscule', 'nbBlessArticulMembre', 'nbBlessBlessureTete', 'nbBlessCou', 'nbBlessDos', 'nbBlessBlessureYeux', 'nbBlessAutre', 'nbMaladieEvan', 'nbMaladieFievre', 'nbMaladieConvul', 'nbMaladieDiarrhe', 'nbMaladieErupt', 'nbMaladieAutre', 'userId'];

        $couvertureSanitaireMdl = $this->couvertureSanitaireModel;
        if (\auth()->user()->inGroup('brancheManager')) {
            $couvertureSanitaireMdl->where('brancheId', \auth()->user()->brancheId);
        }

        if (\auth()->user()->inGroup('communeManager')) {
            $couvertureSanitaireMdl->where('communeId', \auth()->user()->communeId);
        }

        if ($this->request->getPost('brancheId') > 0) {
            $couvertureSanitaireMdl->where('brancheId', $this->request->getPost('brancheId'));
        }

        $fetch_data = DatatableQuery::build_query($couvertureSanitaireMdl, $search_column, $order_column);
        $output = $this->formatCouvertureSanitaires($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatCouvertureSanitaires($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $data->brancheId);
                $sub_array[] =  CommonTrait::formatData(new CommuneModel(), $data->communeId);
                $sub_array[] =  $data->activite;
                $sub_array[] =  $data->dateEvenement;
                $sub_array[] =  $data->partenaireOrganisation;
                $sub_array[] =  CommonTrait::tailleGroupe($data->personneRassamblant);
                $sub_array[] =  $data->nbSecouriste;
                $sub_array[] =  $data->hommeSecouru + $data->femmeSecouru;
                $sub_array[] =  CommonTrait::lieuEvacuations($data->lieuEvacuation);
                $sub_array[] =  $data->hommeDECES + $data->femmeDECES;

                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                    $option = anchor($locale . "/ps/couvertureSanitaire/add/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " "
                        . anchor($locale . "/ps/couvertureSanitaire/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }

    function export(){
        $uri = current_url(true);
        $brancheId = $uri->getSegment(5);

        if ($brancheId > 0) {
            $branche = CommonTrait::formatData(new BrancheModel(), $brancheId);
        } else {
            $branche = "Toutes les branches";
        }

        $fileName = str_replace(' ', '', $branche);        
        $csv_file_name = "rapportExport/couverture/couverture_" . $fileName . ".csv";
        $file = fopen($csv_file_name, 'w');

        $arrays = [];
        $arrays[0] = ['', $this->formatText(" Premiers Secours - Couverture sanitaire")];
        $arrays[1] = ['', $this->formatText($branche)];
        $arrays[2] = [];
        $arrays[3] = [
            '#',  
            $this->formatText('Branche'),  
            $this->formatText('Commune'), 
            $this->formatText('Activité'), 
            $this->formatText("Date de l'événément"), 
            $this->formatText("Partenaire /Organisation"), 
            $this->formatText("Nombre de personnes rassemblant l'événement"), 
            $this->formatText("Nombre des secouristes présents"), 
            $this->formatText("Hommes ( cas secourus)"),  
            $this->formatText("Femmes ( cas secourus)"),  
            $this->formatText("Total des cas secourus"), 
            $this->formatText("Nombre de cas évacués (Hommes)"), 
            $this->formatText("Nombre de cas évacués (Hemmes)"), 
            $this->formatText("Total  de cas évacués"), 
            $this->formatText("Lieu d'évacuation:"), 
            $this->formatText("Nombre des cas de décès ( Hommes)"), 
            $this->formatText("Nombre des cas de décès ( Femmes)"), 
            $this->formatText("Total des cas de décès"), 
            $this->formatText("Nombre de cas d'urgence-Hémorragie grave et choc"), 
            $this->formatText("Nombre de cas d'urgence-Inconscience"), 
            $this->formatText("Accident vasculaire cérébral (AVC)"), 
            $this->formatText("Nombre de cas d'urgence-Nombre de cas d'urgence"), 
            $this->formatText("Nombre de cas d'urgence - Avaler de travers – suffoquer"), 
            $this->formatText("Nombre de cas d'urgence - Douleur à la poitrine"), 
            $this->formatText("Nombre de cas d'urgence - Empoisonnement"), 
            $this->formatText("Nombre de cas d'urgence - Accouchement d'urgence"), 
            $this->formatText("Nombre de blessés- Blessures de la peau"), 
            $this->formatText("Nombre de blessés- Saignement de nez"), 
            $this->formatText("Nombre de blessés- Brûlures"), 
            $this->formatText("Nombre de blessés- Piqûres et morsures"), 
            $this->formatText("Nombre de blessés- Blessures aux muscles"), 
            $this->formatText("Nombre de blessés-Articulations et membres"), 
            $this->formatText("Nombre de blessés-Blessures à la tête"), 
            $this->formatText("Nombre de blessés- au cou"), 
            $this->formatText("Nombre de blessés-  au dos"), 
            $this->formatText("Nombre de blessés- Blessures aux yeux"), 
            $this->formatText("Nombre de blessés- autres"), 
            $this->formatText("Nombre de cas de maladies-Évanouissement"), 
            $this->formatText("Nombre de cas de maladies- Fièvre"), 
            $this->formatText("Nombre de cas de maladies-Convulsions"), 
            $this->formatText("Nombre de cas de maladies- Diarrhée"), 
            $this->formatText("Nombre de cas de maladies-Éruptions cutanées"), 
            $this->formatText("Nombre de cas de maladies-Autres"), 
        ];      

        if ($brancheId > 0) {
            $couvertures = $this->couvertureSanitaireModel->where('brancheId', $brancheId)->findAll();
        } else {
            $couvertures = $this->couvertureSanitaireModel->findAll();
        }

        $i = 1;
        foreach ($couvertures as $couverture) {
            $sub_array = [];
            $sub_array[] = $i;
            $sub_array[] =  $this->formatText(CommonTrait::formatData(new BrancheModel(), $couverture->brancheId));
            $sub_array[] =  $this->formatText(CommonTrait::formatData(new CommuneModel(), $couverture->communeId));
            $sub_array[] =  $this->formatText($couverture->activite);
            $sub_array[] =  $couverture->dateEvenement;
            $sub_array[] =  $this->formatText( $couverture->partenaireOrganisation);
            $sub_array[] =  CommonTrait::tailleGroupe($couverture->personneRassamblant);
            $sub_array[] =  $couverture->nbSecouriste;
            $sub_array[] =  $couverture->hommeSecouru;
            $sub_array[] =  $couverture->femmeSecouru;
            $sub_array[] =  $couverture->hommeSecouru + $couverture->femmeSecouru;
            $sub_array[] =  $couverture->hommeEvacue;
            $sub_array[] =  $couverture->femmeEvacue;
            $sub_array[] =  $couverture->hommeEvacue + $couverture->femmeEvacue;
            $sub_array[] =  $this->formatText(CommonTrait::lieuEvacuations($couverture->lieuEvacuation));
            $sub_array[] =  $couverture->hommeDECES;
            $sub_array[] =  $couverture->femmeDECES;
            $sub_array[] =  $couverture->hommeDECES + $couverture->femmeDECES;
            $sub_array[] =  $couverture->nbHemorragieGrave;
            $sub_array[] =  $couverture->nbUrgenceInconscience;
            $sub_array[] =  $couverture->nbAVC;
            $sub_array[] =  $couverture->nbUrgCasUrg;
            $sub_array[] =  $couverture->nbUrgAvalSuff;
            $sub_array[] =  $couverture->nbUrgDoulPoitrin;
            $sub_array[] =  $couverture->nbUrgEmpoison;
            $sub_array[] =  $couverture->nbUrgAccouchement;
            $sub_array[] =  $couverture->nbBlessBlessurePeau;
            $sub_array[] =  $couverture->nbBlessSaignementNez;
            $sub_array[] =  $couverture->nbBlessBrulure;
            $sub_array[] =  $couverture->nbBlessPiqureMorsure;
            $sub_array[] =  $couverture->nbBlessBlessureMuscule;
            $sub_array[] =  $couverture->nbBlessArticulMembre;
            $sub_array[] =  $couverture->nbBlessBlessureTete;
            $sub_array[] =  $couverture->nbBlessCou;
            $sub_array[] =  $couverture->nbBlessDos;
            $sub_array[] =  $couverture->nbBlessBlessureYeux;
            $sub_array[] =  $couverture->nbBlessAutre;
            $sub_array[] =  $couverture->nbMaladieEvan;
            $sub_array[] =  $couverture->nbMaladieFievre;
            $sub_array[] =  $couverture->nbMaladieConvul;
            $sub_array[] =  $couverture->nbMaladieDiarrhe;
            $sub_array[] =  $couverture->nbMaladieErupt;
            $sub_array[] =  $couverture->nbMaladieAutre;
    

            $arrays[] = $sub_array;
            $i++;
        }


        foreach ($arrays as $array) {
            fputcsv($file, $array);
        }
        fclose($file);
        $btn = anchor($csv_file_name, "Exporter un <i class='fa fa-file-csv'></i>", ['class' => 'text-success', 'target' => '_blank']);

        $status = 0;
        if (fileExists($csv_file_name)) {
            $status = 1;
        }

        return $this->response->setJSON(['status' => $status, 'btnExport' => $btn]);
    }

    function formatText($string = "")
    {
        return UConverter::transcode($string, 'ISO-8859-1', 'UTF8');
    }
}
