<?php

namespace Modules\PS\Database\Migrations;

use CodeIgniter\Database\Migration;

class MaterielMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'brancheId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeId' => [
                'type' => 'INT',
                'constraint' => '11'
            ],
            'nbManuelPSEnfant' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbBrancards' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbManequinEnfant' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbManequinEnAdulte' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbAttele' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbBoiteImage' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbBoiteImage' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbCouverture' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbManuelPSBlessureRoute' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbManuelPSBlessurePRepondant' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbManequinBebe' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbKitPS' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbBallonInsuflatteurOxygene' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbDefibrillateurAutoExtern' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'masquePoche' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'existeTrousseSecour' => [
                'type' => 'BOOLEAN',
                'default' => false,
            ],

            'nbTrousseSecour' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbGrantProprePaire' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbBetadineFlacon' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbBettolFlacon' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbAntalgiquePommadeTube' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbAntalgiqueSprayTube' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbAntalgiqueComprimeCP' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbPaireCiseauPiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbPinceKocherPiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbMasqueFacialPiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbServietteEssuiMain' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'ouateRouleau' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbCompresseSterilePiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'echarpeDrapTriangulaire' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'sparadrapPerforeRouleau' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'sparadrapEtanchePiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'bandeElastiquePiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'ambuBuccalEnfantPiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'ambuBuccalAdultePiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'ambuBuccalNourrissonPiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbSavonPiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbThermometrePiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbThermosPiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'nbSROPiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'picettePiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'lameRasoirPiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'sacPoubellePiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'carnetTroussePiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],

            'styloPiece' => [
                'type' => 'INT',
                'constraint' => '11',
                'default' => NULL
            ],
            'userId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'dateEnregistrement DATETIME default NULL',
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('ps_materiels');
    }

    public function down()
    {
        $this->forge->dropTable('ps_materiels');
    }
}
