<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\ProfessionModel;
use Psr\Log\LoggerInterface;
use stdClass;

class ProfessionController extends BaseController
{
    public ProfessionModel $professionModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->professionModel = new ProfessionModel();
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/profession/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/profession/save";
        $this->viewData['profession'] =  $this->initProfession($id);

        return view('params/profession/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/profession/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/profession/save";
            $this->viewData['profession'] =  $this->initProfession($id);

            return view('params/profession/add', $this->viewData);
        } else {

            $uneDomaineActivite = $this->uneDomaineActivite();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La profession <b>" . $uneDomaineActivite['description'] . "</b> a été modifiée</div>");
                $stmt = $this->professionModel->update($id, $uneDomaineActivite);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La profession <b>" . $uneDomaineActivite['description'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->professionModel->save($uneDomaineActivite);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/profession'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->professionModel->delete($id);
        
        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>La profession a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/profession'));
        }
        
    }

    private function uneDomaineActivite()
    {
        $branche = [];
        $branche['description'] = $this->request->getPost('description');

        return $branche;
    }

    private function initProfession($id = NULL)
    {
        $branche = NULL;
        if ($id) {
            $branche = $this->professionModel->find($id);
        } else {
            $branche = new stdClass();
            $branche->id = 0;
            $branche->description = "";
        }

        return $branche;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->professionModel, $search_column, $order_column);
        $output = $this->formatProfession($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatProfession($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                $option = anchor($locale . "/params/profession/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " " 
                        . anchor($locale . "/params/profession/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
