<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\TypeInfrastructure as ModelsTypeInfrastructure;
use Psr\Log\LoggerInterface;
use stdClass;

class TypeInfrastructure extends BaseController
{
    public ModelsTypeInfrastructure $typeInfrastructureModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->typeInfrastructureModel = new ModelsTypeInfrastructure();
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/typeInfrastructure/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/typeInfrastructure/save";
        $this->viewData['infrastructure'] =  $this->initTypeInfrastructure($id);

        return view('params/typeInfrastructure/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/typeInfrastructure/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/typeInfrastructure/save";
            $this->viewData['infrastructure'] =  $this->initTypeInfrastructure($id);

            return view('params/typeInfrastructure/add', $this->viewData);
        } else {

            $unTypeInfrastructure = $this->unTypeInfrastructure();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le type d'infrastructure <b>" . $unTypeInfrastructure['description'] . "</b> a été modifié</div>");
                $stmt = $this->typeInfrastructureModel->update($id, $unTypeInfrastructure);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le type d'infrastructure <b>" . $unTypeInfrastructure['description'] . "</b> a été bien enregistré</div>");
                $stmt = $this->typeInfrastructureModel->save($unTypeInfrastructure);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/typeInfrastructure'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->typeInfrastructureModel->delete($id);
        
        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le type d'infrastructure a été suprimé</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/typeInfrastructure'));
        }
        
    }

    private function unTypeInfrastructure()
    {
        $unTypeInfrastructure = [];
        $unTypeInfrastructure['description'] = $this->request->getPost('description');

        return $unTypeInfrastructure;
    }

    private function initTypeInfrastructure($id = NULL)
    {
        $typeInfrastructure = NULL;
        if ($id) {
            $typeInfrastructure = $this->typeInfrastructureModel->find($id);
        } else {
            $typeInfrastructure = new stdClass();
            $typeInfrastructure->id = 0;
            $typeInfrastructure->description = "";
        }

        return $typeInfrastructure;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->typeInfrastructureModel, $search_column, $order_column);
        $output = $this->formatInfrastructure($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatInfrastructure($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                $option = anchor($locale . "/params/typeInfrastructure/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " " 
                        . anchor($locale . "/params/typeInfrastructure/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
