<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\TypePremierSecourModel;
use Psr\Log\LoggerInterface;
use stdClass;

class TypePremierSecourController extends BaseController
{
    public TypePremierSecourModel $typePremierSecourModel;

    function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->typePremierSecourModel = new TypePremierSecourModel();
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/typePremierSecour/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/typePremierSecour/save";
        $this->viewData['typePremierSecour'] =  $this->initTypePremierSecour($id);

        return view('params/typePremierSecour/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/typePremierSecour/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/typePremierSecour/save";
            $this->viewData['typePremierSecour'] =  $this->initTypePremierSecour($id);

            return view('params/typePremierSecour/add', $this->viewData);
        } else {

            $unTypePremierSecour = $this->unTypePremierSecour();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type premier secour <b>" . $unTypePremierSecour['description'] . "</b> a été modifié</div>");
                $stmt = $this->typePremierSecourModel->update($id, $unTypePremierSecour);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type premier secour <b>" . $unTypePremierSecour['description'] . "</b> a été bien enregistré</div>");
                $stmt = $this->typePremierSecourModel->save($unTypePremierSecour);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/typePremierSecour'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->typePremierSecourModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Un type premier secour a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/typePremierSecour'));
        }
    }

    private function unTypePremierSecour()
    {
        $typeFormation = [];
        $typeFormation['description'] = $this->request->getPost('description');

        return $typeFormation;
    }

    private function initTypePremierSecour($id = NULL)
    {
        $typeFormation = NULL;
        if ($id) {
            $typeFormation = $this->typePremierSecourModel->find($id);
        } else {
            $typeFormation = new stdClass();
            $typeFormation->id = 0;
            $typeFormation->description = "";
        }

        return $typeFormation;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->typePremierSecourModel, $search_column, $order_column);
        $output = $this->formatTypePremierSecour($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatTypePremierSecour($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                    $option = anchor($locale . "/params/typePremierSecour/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " "
                        . anchor($locale . "/params/typePremierSecour/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
