<?php

namespace Modules\Params\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Params\Models\TypeStaff as ModelsTypeStaff;
use Psr\Log\LoggerInterface;
use stdClass;

class TypeStaff extends BaseController
{
    public ModelsTypeStaff  $typeStaffModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->typeStaffModel = new ModelsTypeStaff();
    }

    public function index()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/params/typeStaff/data";
        $this->viewData['js'] = "";
        $this->viewData['route'] = "/params/typeStaff/save";
        $this->viewData['staff'] =  $this->initTypeStaff($id);

        return view('params/typeStaff/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/params/typeStaff/data";
            $this->viewData['js'] = "";
            $this->viewData['route'] = "/params/typeStaff/save";
            $this->viewData['staff'] =  $this->initTypeStaff($id);

            return view('params/typeStaff/add', $this->viewData);
        } else {

            $unTypeStaff = $this->unTypeStaff();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le type de staff <b>" . $unTypeStaff['description'] . "</b> a été modifié</div>");
                $stmt = $this->typeStaffModel->update($id, $unTypeStaff);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le type de staff <b>" . $unTypeStaff['description'] . "</b> a été bien enregistré</div>");
                $stmt = $this->typeStaffModel->save($unTypeStaff);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/params/typeStaff'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->typeStaffModel->delete($id);
        
        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>Le type d'attestation a été suprimé</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/params/typeStaff'));
        }
        
    }

    private function unTypeStaff()
    {
        $unTypeStaff = [];
        $unTypeStaff['description'] = $this->request->getPost('description');

        return $unTypeStaff;
    }

    private function initTypeStaff($id = NULL)
    {
        $typeStaff = NULL;
        if ($id) {
            $typeStaff = $this->typeStaffModel->find($id);
        } else {
            $typeStaff = new stdClass();
            $typeStaff->id = 0;
            $typeStaff->description = "";
        }

        return $typeStaff;
    }

    private function _rules()
    {
        $rules = [];
        $rules['description'] = ['rules'  => 'required|min_length[2]|max_length[100]'];

        return $rules;
    }



    function fecth()
    {
        $search_column = ['id', 'description'];
        $order_column = ['id', 'description'];

        $fetch_data = DatatableQuery::build_query($this->typeStaffModel, $search_column, $order_column);
        $output = $this->formatProfession($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatProfession($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->description;
                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                $option = anchor($locale . "/params/typeStaff/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " " 
                        . anchor($locale . "/params/typeStaff/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }
}
