<?php

namespace Modules\Params\Database\Migrations;

use CodeIgniter\Database\Migration;

class CollineMigration extends Migration
{
    public function up()
    {

        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],

            'description' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'zoneId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'latitude' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'longitude' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', TRUE);
        $this->forge->createTable('params_collines');
    }

    public function down()
    {
        $this->forge->dropTable('params_collines');
    }
}
