<?php

namespace Modules\Volontaire\Controllers;

use App\Controllers\BaseController;
use App\Traits\ExperienceTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Volontaire\Models\Experience as ModelsExperience;
use Psr\Log\LoggerInterface;
use stdClass;

class Experience extends BaseController
{
    protected ModelsExperience $experienceModel;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->experienceModel = new ModelsExperience();
    }
    public function index()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $experiences = $this->experienceModel->where('userId', \auth()->user()->id)->findAll();
        $this->viewData['experiences'] = $experiences;
        $this->viewData['types'] = ExperienceTrait::types();
        $this->viewData['positions'] = ExperienceTrait::positions();

        return view('volonatire/experience/index', $this->viewData);
    }

    function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $experience =  $this->initExperience($id);
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";
        $this->viewData['experience'] = $experience;
        $this->viewData['types'] = ExperienceTrait::types();
        $this->viewData['positions'] = ExperienceTrait::positions();

        return view('volonatire/experience/add', $this->viewData);
    }


    public function save()
    {

        if (!$this->validate($this->valideForm())) {
            $id = $this->request->getPost('id');
            $experience =  $this->initExperience($id);

            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";
            $this->viewData['types'] = ExperienceTrait::types();
            $this->viewData['positions'] = ExperienceTrait::positions();
            $this->viewData['experience'] = $experience;

            return view('volonatire/experience/add', $this->viewData);
        } else {
            $id = $this->request->getPost('id');

            if ($id) {
                $stmnt = $this->experienceModel->update($id, $this->experience());
            } else {
                $stmnt = $this->experienceModel->save($this->experience());
            }

            if ($stmnt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Expérience enregistrée avec succès</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/experiences'));
            }
        }
    }


    private function experience()
    {
        $experience = [];

        $experience['typeId'] = $this->request->getPost('typeId');
        $experience['employeur'] = $this->request->getPost('employeur');
        $experience['departement'] = $this->request->getPost('departement');
        $experience['position'] = $this->request->getPost('position');
        $experience['champTravail'] = $this->request->getPost('champTravail');
        $experience['dateDebut'] = $this->request->getPost('dateDebut');
        $experience['dateFin'] = $this->request->getPost('dateFin');
        $experience['userId'] = \auth()->user()->id;

        return $experience;
    }

    private function valideForm()
    {
        $rules = [];
        $rules['typeId']      = ['rules'  => 'required'];
        $rules['employeur']     = ['rules'  => 'required'];
        $rules['position']     = ['rules'  => 'required'];
        $rules['dateDebut']     = ['rules'  => 'required'];
        $rules['champTravail']     = ['rules'  => 'required'];

        return $rules;
    }

    function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->experienceModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>L'expérience est supprimée avec succès</alert>");
            return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/experiences'));
        }
    }

    function initExperience($id)
    {
        if ($id) {
            $experience = $this->experienceModel->find($id);
        } else {
            $experience = new stdClass();
            $experience->id = 0;
            $experience->typeId = 0;
            $experience->employeur = "";
            $experience->position = "";
            $experience->departement = "";
            $experience->champTravail = "";
            $experience->dateDebut = '';
            $experience->dateFin = '';
        }       

        return $experience;
    }
}
