<?php

namespace Modules\Volontaire\Controllers;

use App\Controllers\BaseController;
use App\Traits\LanguageTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Volontaire\Models\Language as ModelsLanguage;
use Psr\Log\LoggerInterface;

class Language extends BaseController
{
    protected ModelsLanguage $languageModel;

    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->languageModel = new ModelsLanguage();
    }
    public function index()
    {
        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "";

        $languages = $this->languageModel->where('userId', \auth()->user()->id)->findAll();
        $this->viewData['languages'] = $languages;
        $this->viewData['langues'] = LanguageTrait::langues();
        $this->viewData['niveaux'] = LanguageTrait::niveaux();

        return view('volonatire/language', $this->viewData);
    }

    public function save()
    {

        if (!$this->validate($this->valideForm())) {
            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";

            $languages = $this->languageModel->where('userId', \auth()->user()->id)->findAll();
            $this->viewData['languages'] = $languages;
            $this->viewData['langues'] = LanguageTrait::langues();
            $this->viewData['niveaux'] = LanguageTrait::niveaux();

            return view('volonatire/language', $this->viewData);
        } else {
            $langueId = $this->request->getPost('langueId');
            $check_langue = $this->languageModel->asObject()->where(['langueId'=>$langueId,'userId'=> \auth()->user()->id])->first();

            if(!empty($check_langue)){
                $stmnt = $this->languageModel->update($check_langue->id, $this->language());
            }else{
                $stmnt = $this->languageModel->save($this->language());
            }
            if ($stmnt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Compétence linguistique enregistrée avec succès</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/language'));
            }
        }
    }

    public function edit()
    {

        $id = $this->request->getPost('id');

        if (!$this->validate($this->valideForm())) {
            $this->viewData['url_list'] = "";
            $this->viewData['js'] = "";

            $languages = $this->languageModel->where('userId', \auth()->user()->id)->findAll();
            $this->viewData['languages'] = $languages;
            $this->viewData['langues'] = LanguageTrait::langues();
            $this->viewData['niveaux'] = LanguageTrait::niveaux();

            return view('volonatire/language', $this->viewData);
        } else {

            $stmnt = $this->languageModel->update($id, $this->language());
            if ($stmnt) {
                $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Compétence linguistique éditée avec succès</alert>");
                return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/language'));
            }
        }
    }

    private function language()
    {
        $language = [];

        $language['langueId'] = $this->request->getPost('langueId');
        $language['niveauOral'] = $this->request->getPost('niveauOral');
        $language['niveauEcrit'] = $this->request->getPost('niveauEcrit');
        $language['niveauLire'] = $this->request->getPost('niveauLire');
        $language['userId'] = \auth()->user()->id;

        return $language;
    }

    private function valideForm()
    {
        $rules = [];
        $rules['langueId']      = ['rules'  => 'required'];
        $rules['niveauEcrit']     = ['rules'  => 'required'];
        $rules['niveauLire']     = ['rules'  => 'required'];
        $rules['niveauOral']     = ['rules'  => 'required'];

        return $rules;
    }

    function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->languageModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<alert class='ml-2 alert alert-success'>Compétence linguistique est supprimée avec succès</alert>");
            return redirect()->to(site_url($this->viewData['locale'] . '/volontaire/language'));
        }
    }
}
