<?php

namespace Modules\data\Database\Migrations;

use CodeIgniter\Database\Migration;

class AmbulanceMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'brancheId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'zoneId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'collineId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'numImmatriculation' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'chauffeur' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'gardeMalade' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'telephone' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'dateDepart' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'lieuEvacuation' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'typeEvacuationId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'destinationPatient' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'patient' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'sexe' => [
                'type'       => 'ENUM',
                'constraint' => ['HOMME', 'FEMME','NON_SPECIFIE'],
                'default'    => 'NON_SPECIFIE',
            ],
            'agePatient' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'diagnostic' => [
                'type' => 'VARCHAR',
                'constraint' => '250',
                'default'    => NULL,
            ],
            'modeEvacuationId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'coutServiceAmbulance' => [
                'type' => 'VARCHAR',
                'constraint' => '250',
                'default'    => NULL,
            ],
            'coutDepense' => [
                'type' => 'VARCHAR',
                'constraint' => '250',
                'default'    => NULL,
            ],
            'dateRetour' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default'    => NULL,
            ],
            'userId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('dt_ambulanciers');
    }

    public function down()
    {
        $this->forge->dropTable('dt_ambulanciers');
    }
}
