<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/formation", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    // print_r(validation_list_errors());

                    // echo "<pre>";
                    // print_r($menageModele);
                    // echo "</pre>";
                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$menageModele->id]); ?>
                <div class="row mb-3">

                    <?php

                    $br = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $menageModele->brancheId,
                    ];

                    echo form_input($br);

                    $cm = [
                        'type'  => 'hidden',
                        'name'  => 'commune_id_load',
                        'id'    => 'commune_id_load',
                        'value' => $menageModele->communeId,
                    ];

                    echo form_input($cm);

                    $zn = [
                        'type'  => 'hidden',
                        'name'  => 'zone_id_load',
                        'id'    => 'zone_id_load',
                        'value' => $menageModele->zoneId,
                    ];

                    echo form_input($zn);

                    $cl = [
                        'type'  => 'hidden',
                        'name'  => 'colline_id_load',
                        'id'    => 'colline_id_load',
                        'value' => $menageModele->collineId,
                    ];

                    echo form_input($cl);
                    ?>

                    <div class="col-md-4">
                        <?= form_label("Branche"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId', $menageModele->brancheId), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Commune"); ?>
                        <?php
                        echo form_dropdown('communeId', [], set_value('communeId', $menageModele->communeId), "class = 'form-control' id='communeId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Zone"); ?>
                        <?php
                        echo form_dropdown('zoneId', [], set_value('zoneId', $menageModele->zoneId), "class = 'form-control' id='zoneId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Colline"); ?>
                        <?php
                        echo form_dropdown('collineId', [], set_value('collineId', $menageModele->collineId), "class = 'form-control' id='collineId'");
                        ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Nombre de menage en transformation"); ?>

                        <?php
                        $nbMenageEnTransformation = [
                            'type'  => 'text',
                            'name'  => 'nbMenageEnTransformation',
                            'id'    => 'nbMenageEnTransformation',
                            'value' => set_value('nbMenageEnTransformation', $menageModele->nbMenageEnTransformation),
                            'placeholder' => "Nombre de menage en transformation",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbMenageEnTransformation);
                        ?>
                        <?= !empty(validation_show_error('nbMenageEnTransformation')) ? "<p class='text-danger'>" . validation_show_error('nbMenageEnTransformation') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Nombre de menage a certifier"); ?>

                        <?php
                        $nbMenageACertifier = [
                            'type'  => 'text',
                            'name'  => 'nbMenageACertifier',
                            'id'    => 'nbMenageACertifier',
                            'value' => set_value('nbMenageACertifier', $menageModele->nbMenageACertifier),
                            'placeholder' => "Nombre de menage a certifier",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbMenageACertifier);
                        ?>
                        <?= !empty(validation_show_error('nbMenageACertifier')) ? "<p class='text-danger'>" . validation_show_error('nbMenageACertifier') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-4">
                        <?= form_label("Nombre de menage deja certifie"); ?>

                        <?php
                        $nbMenageDejaCertifier = [
                            'type'  => 'text',
                            'name'  => 'nbMenageDejaCertifier',
                            'id'    => 'nbMenageDejaCertifier',
                            'value' => set_value('nbMenageDejaCertifier', $menageModele->nbMenageDejaCertifier),
                            'placeholder' => "Nombre de menage deja certifie",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbMenageDejaCertifier);
                        ?>
                        <?= !empty(validation_show_error('nbMenageDejaCertifier')) ? "<p class='text-danger'>" . validation_show_error('nbMenageDejaCertifier') . "</p>" : "" ?>
                    </div>


                    <div class="col-md-4">
                        <?= form_label("Commentaire"); ?>

                        <?php
                        $commentaire = [
                            'type'  => 'text',
                            'name'  => 'commentaire',
                            'id'    => 'commentaire',
                            'value' => set_value('commentaire', $menageModele->commentaire),
                            'placeholder' => "Commentaire",
                            'class' => 'form-control',
                        ];

                        echo form_input($commentaire);
                        ?>
                        <?= !empty(validation_show_error('commentaire')) ? "<p class='text-danger'>" . validation_show_error('commentaire') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Annee de certification", 'descr'); ?>
                        <?php
                        echo form_dropdown('anneeCertification', $years, set_value('anneeCertification'), "class = 'form-control' id='anneeCertification'");
                        ?>
                        <?= !empty(validation_show_error('anneeCertification')) ? "<p class='text-danger'>" . validation_show_error('anneeCertification') . "</p>" : "" ?>

                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>