<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/couvertureSanitaire", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php
                    if (!empty(session()->getFlashdata('message'))) {
                        echo session()->getFlashdata('message');
                    }
                    ?>
                </div>

                <?php echo form_open($locale . $route, NULL, ['id' => (string)$couvertureSanitaire->id]); ?>
                <div class="row mb-3">
                    
                    <?php

                    $br = [
                        'type'  => 'hidden',
                        'name'  => 'branche_id_load',
                        'id'    => 'branche_id_load',
                        'value' => $couvertureSanitaire->brancheId,
                    ];

                    echo form_input($br);

                    $cm = [
                        'type'  => 'hidden',
                        'name'  => 'commune_id_load',
                        'id'    => 'commune_id_load',
                        'value' => $couvertureSanitaire->communeId,
                    ];

                    echo form_input($cm);
                    ?>

                    <div class="col-md-3">
                        <?= form_label("Branche <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId', $couvertureSanitaire->brancheId), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Commune <font color='red'>*</font>"); ?>
                        <?php
                        echo form_dropdown('communeId', [], set_value('communeId', $couvertureSanitaire->communeId), "class = 'form-control' id='communeId'");
                        ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Evénement <font color='red'>*</font>"); ?>

                        <?php
                        $activite = [
                            'type'  => 'text',
                            'name'  => 'activite',
                            'id'    => 'activite',
                            'value' => set_value('activite', $couvertureSanitaire->activite),
                            'placeholder' => "Evénement",
                            'class' => 'form-control',
                        ];

                        echo form_input($activite);
                        ?>
                        <?= !empty(validation_show_error('activite')) ? "<p class='text-danger'>" . validation_show_error('activite') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date de l'événément <font color='red'>*</font>"); ?>
                        <?php $date = $couvertureSanitaire->dateEvenement ? $couvertureSanitaire->dateEvenement : set_value('dateEvenement') ?>
                        <div class="input-group date" id="dateEvenement" data-target-input="nearest">
                            <?= form_input('dateEvenement', $date, "class='form-control datetimepicker-input', id='dateEvenement' placeholder='Date de l-Evenement'") ?>
                            <div class="input-group-append" data-target="#dateEvenement" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <?= !empty(validation_show_error('dateEvenement')) ? "<p class='text-danger'>" . validation_show_error('dateEvenement') . "</p>" : "" ?>

                    </div>
                    
                    <div class="col-md-3">
                    <?= form_label("Partenaire /Organisation"); ?>

                        <?php
                        $partenaireOrganisation = [
                            'type'  => 'text',
                            'name'  => 'partenaireOrganisation',
                            'id'    => 'partenaireOrganisation',
                            'value' => set_value('partenaireOrganisation', $couvertureSanitaire->partenaireOrganisation),
                            'placeholder' => "Partenaire /Organisation",
                            'class' => 'form-control',
                        ];

                        echo form_input($partenaireOrganisation);
                        ?>
                        <?= !empty(validation_show_error('partenaireOrganisation')) ? "<p class='text-danger'>" . validation_show_error('partenaireOrganisation') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Personnes rassemblant l'événement"); ?>
                        <?php
                        echo form_dropdown('personneRassamblant', $personneRassablants, set_value('personneRassamblant', $couvertureSanitaire->personneRassamblant), "class = 'form-control' id='personneRassamblant'");
                        ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nombre des secouristes présents"); ?>

                        <?php
                        $nbSecouriste = [
                            'type'  => 'text',
                            'name'  => 'nbSecouriste',
                            'id'    => 'nbSecouriste',
                            'value' => set_value('nbSecouriste', $couvertureSanitaire->nbSecouriste),
                            'placeholder' => "Nbre des secouristes présents",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbSecouriste);
                        ?>
                        <?= !empty(validation_show_error('nbSecouriste')) ? "<p class='text-danger'>" . validation_show_error('nbSecouriste') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Hommes ( cas secourus)"); ?>

                        <?php
                        $hommeSecouru = [
                            'type'  => 'text',
                            'name'  => 'hommeSecouru',
                            'id'    => 'hommeSecouru',
                            'value' => set_value('hommeSecouru', $couvertureSanitaire->hommeSecouru),
                            'placeholder' => "Hommes ( cas secourus)",
                            'class' => 'form-control',
                        ];

                        echo form_input($hommeSecouru);
                        ?>
                        <?= !empty(validation_show_error('hommeSecouru')) ? "<p class='text-danger'>" . validation_show_error('hommeSecouru') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Femmes ( cas secourus)"); ?>

                        <?php
                        $femmeSecouru = [
                            'type'  => 'text',
                            'name'  => 'femmeSecouru',
                            'id'    => 'femmeSecouru',
                            'value' => set_value('femmeSecouru', $couvertureSanitaire->femmeSecouru),
                            'placeholder' => "Femmes ( cas secourus)",
                            'class' => 'form-control',
                        ];

                        echo form_input($femmeSecouru);
                        ?>
                        <?= !empty(validation_show_error('femmeSecouru')) ? "<p class='text-danger'>" . validation_show_error('femmeSecouru') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nombre de cas évacués (Hommes)"); ?>

                        <?php
                        $hommeEvacue = [
                            'type'  => 'text',
                            'name'  => 'hommeEvacue',
                            'id'    => 'hommeEvacue',
                            'value' => set_value('hommeEvacue', $couvertureSanitaire->hommeEvacue),
                            'placeholder' => "Nombre de cas évacués (Hommes)",
                            'class' => 'form-control',
                        ];

                        echo form_input($hommeEvacue);
                        ?>
                        <?= !empty(validation_show_error('hommeEvacue')) ? "<p class='text-danger'>" . validation_show_error('hommeEvacue') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nombre de cas évacués (Femmes)"); ?>

                        <?php
                        $femmeEvacue = [
                            'type'  => 'text',
                            'name'  => 'femmeEvacue',
                            'id'    => 'femmeEvacue',
                            'value' => set_value('femmeEvacue', $couvertureSanitaire->femmeEvacue),
                            'placeholder' => "Nombre de cas évacués (Femmes)",
                            'class' => 'form-control',
                        ];

                        echo form_input($femmeEvacue);
                        ?>
                        <?= !empty(validation_show_error('femmeEvacue')) ? "<p class='text-danger'>" . validation_show_error('femmeEvacue') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Lieu d'évacuation"); ?>
                        <?php
                        echo form_dropdown('lieuEvacuation', $lieux, set_value('lieuEvacuation', $couvertureSanitaire->lieuEvacuation), "class = 'form-control' id='lieuEvacuation'");
                        ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nombre des cas de décès ( Hommes)"); ?>

                        <?php
                        $hommeDECES = [
                            'type'  => 'text',
                            'name'  => 'hommeDECES',
                            'id'    => 'hommeDECES',
                            'value' => set_value('hommeDECES', $couvertureSanitaire->hommeDECES),
                            'placeholder' => "Nombre des cas de décès ( Hommes)",
                            'class' => 'form-control',
                        ];

                        echo form_input($hommeDECES);
                        ?>
                        <?= !empty(validation_show_error('hommeDECES')) ? "<p class='text-danger'>" . validation_show_error('hommeDECES') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nombre des cas de décès ( Femmes)"); ?>

                        <?php
                        $femmeDECES = [
                            'type'  => 'text',
                            'name'  => 'femmeDECES',
                            'id'    => 'femmeDECES',
                            'value' => set_value('femmeDECES', $couvertureSanitaire->femmeDECES),
                            'placeholder' => "Nombre des cas de décès ( Femmes)",
                            'class' => 'form-control',
                        ];

                        echo form_input($femmeDECES);
                        ?>
                        <?= !empty(validation_show_error('femmeDECES')) ? "<p class='text-danger'>" . validation_show_error('femmeDECES') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre urgence-Hémorragie grave et choc"); ?>

                        <?php
                        $nbHemorragieGrave = [
                            'type'  => 'text',
                            'name'  => 'nbHemorragieGrave',
                            'id'    => 'nbHemorragieGrave',
                            'value' => set_value('nbHemorragieGrave', $couvertureSanitaire->nbHemorragieGrave),
                            'placeholder' => " Nombre de cas d'urgence-Hémorragie grave et choc",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbHemorragieGrave);
                        ?>
                        <?= !empty(validation_show_error('nbHemorragieGrave')) ? "<p class='text-danger'>" . validation_show_error('nbHemorragieGrave') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre de cas d'urgence-Inconscience"); ?>

                        <?php
                        $nbUrgenceInconscience = [
                            'type'  => 'text',
                            'name'  => 'nbUrgenceInconscience',
                            'id'    => 'nbUrgenceInconscience',
                            'value' => set_value('nbUrgenceInconscience', $couvertureSanitaire->nbUrgenceInconscience),
                            'placeholder' => "Nombre de cas d'urgence-Inconscience",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbUrgenceInconscience);
                        ?>
                        <?= !empty(validation_show_error('nbUrgenceInconscience')) ? "<p class='text-danger'>" . validation_show_error('nbUrgenceInconscience') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Accident vasculaire cérébral (AVC)"); ?>

                        <?php
                        $nbAVC = [
                            'type'  => 'text',
                            'name'  => 'nbAVC',
                            'id'    => 'nbAVC',
                            'value' => set_value('nbAVC', $couvertureSanitaire->nbAVC),
                            'placeholder' => "Accident vasculaire cérébral (AVC)",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbAVC);
                        ?>
                        <?= !empty(validation_show_error('nbAVC')) ? "<p class='text-danger'>" . validation_show_error('nbAVC') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre urgence-Nombre de cas d'urgence"); ?>

                        <?php
                        $nbUrgCasUrg = [
                            'type'  => 'text',
                            'name'  => 'nbUrgCasUrg',
                            'id'    => 'nbUrgCasUrg',
                            'value' => set_value('nbUrgCasUrg', $couvertureSanitaire->nbUrgCasUrg),
                            'placeholder' => "Nbre urgence-Nombre de cas d'urgence",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbUrgCasUrg);
                        ?>
                        <?= !empty(validation_show_error('nbUrgCasUrg')) ? "<p class='text-danger'>" . validation_show_error('nbUrgCasUrg') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre urgence-Avaler de travers – suffoquer"); ?>

                        <?php
                        $nbUrgAvalSuff = [
                            'type'  => 'text',
                            'name'  => 'nbUrgAvalSuff',
                            'id'    => 'nbUrgAvalSuff',
                            'value' => set_value('nbUrgAvalSuff', $couvertureSanitaire->nbUrgAvalSuff),
                            'placeholder' => "Nbre urgence-Avaler de travers – suffoquer",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbUrgAvalSuff);
                        ?>
                        <?= !empty(validation_show_error('nbUrgAvalSuff')) ? "<p class='text-danger'>" . validation_show_error('nbUrgAvalSuff') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre urgence - Douleur à la poitrine"); ?>

                        <?php
                        $nbUrgDoulPoitrin = [
                            'type'  => 'text',
                            'name'  => 'nbUrgDoulPoitrin',
                            'id'    => 'nbUrgDoulPoitrin',
                            'value' => set_value('nbUrgDoulPoitrin', $couvertureSanitaire->nbUrgDoulPoitrin),
                            'placeholder' => "Nbre urgence - Douleur à la poitrine",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbUrgDoulPoitrin);
                        ?>
                        <?= !empty(validation_show_error('nbUrgDoulPoitrin')) ? "<p class='text-danger'>" . validation_show_error('nbUrgDoulPoitrin') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre urgence - Empoisonnement"); ?>

                        <?php
                        $nbUrgEmpoison = [
                            'type'  => 'text',
                            'name'  => 'nbUrgEmpoison',
                            'id'    => 'nbUrgEmpoison',
                            'value' => set_value('nbUrgEmpoison', $couvertureSanitaire->nbUrgEmpoison),
                            'placeholder' => "Nbre urgence - Empoisonnement",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbUrgEmpoison);
                        ?>
                        <?= !empty(validation_show_error('nbUrgEmpoison')) ? "<p class='text-danger'>" . validation_show_error('nbUrgEmpoison') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre urgence - Accouchement d'urgence"); ?>

                        <?php
                        $nbUrgAccouchement = [
                            'type'  => 'text',
                            'name'  => 'nbUrgAccouchement',
                            'id'    => 'nbUrgAccouchement',
                            'value' => set_value('nbUrgAccouchement', $couvertureSanitaire->nbUrgAccouchement),
                            'placeholder' => "Nbre urgence - Accouchement d'urgence",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbUrgAccouchement);
                        ?>
                        <?= !empty(validation_show_error('nbUrgAccouchement')) ? "<p class='text-danger'>" . validation_show_error('nbUrgAccouchement') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- Blessures de la peau"); ?>

                        <?php
                        $nbBlessBlessurePeau = [
                            'type'  => 'text',
                            'name'  => 'nbBlessBlessurePeau',
                            'id'    => 'nbBlessBlessurePeau',
                            'value' => set_value('nbBlessBlessurePeau', $couvertureSanitaire->nbBlessBlessurePeau),
                            'placeholder' => "Nbre blessés- Blessures de la peau",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessBlessurePeau);
                        ?>
                        <?= !empty(validation_show_error('nbBlessBlessurePeau')) ? "<p class='text-danger'>" . validation_show_error('nbBlessBlessurePeau') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- Saignement de nez"); ?>

                        <?php
                        $nbBlessSaignementNez = [
                            'type'  => 'text',
                            'name'  => 'nbBlessSaignementNez',
                            'id'    => 'nbBlessSaignementNez',
                            'value' => set_value('nbBlessSaignementNez', $couvertureSanitaire->nbBlessSaignementNez),
                            'placeholder' => "Nbre blessés- Saignement de nez",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessSaignementNez);
                        ?>
                        <?= !empty(validation_show_error('nbBlessSaignementNez')) ? "<p class='text-danger'>" . validation_show_error('nbBlessSaignementNez') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- Brûlures"); ?>

                        <?php
                        $nbBlessBrulure = [
                            'type'  => 'text',
                            'name'  => 'nbBlessBrulure',
                            'id'    => 'nbBlessBrulure',
                            'value' => set_value('nbBlessBrulure', $couvertureSanitaire->nbBlessBrulure),
                            'placeholder' => "Nbre blessés- Brûlures",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessBrulure);
                        ?>
                        <?= !empty(validation_show_error('nbBlessBrulure')) ? "<p class='text-danger'>" . validation_show_error('nbBlessBrulure') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- Piqûres et morsures"); ?>

                        <?php
                        $nbBlessPiqureMorsure = [
                            'type'  => 'text',
                            'name'  => 'nbBlessPiqureMorsure',
                            'id'    => 'nbBlessPiqureMorsure',
                            'value' => set_value('nbBlessPiqureMorsure', $couvertureSanitaire->nbBlessPiqureMorsure),
                            'placeholder' => "Nbre blessés- Piqûres et morsures",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessPiqureMorsure);
                        ?>
                        <?= !empty(validation_show_error('nbBlessPiqureMorsure')) ? "<p class='text-danger'>" . validation_show_error('nbBlessPiqureMorsure') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- Blessures aux muscles"); ?>

                        <?php
                        $nbBlessBlessureMuscule = [
                            'type'  => 'text',
                            'name'  => 'nbBlessBlessureMuscule',
                            'id'    => 'nbBlessBlessureMuscule',
                            'value' => set_value('nbBlessBlessureMuscule', $couvertureSanitaire->nbBlessBlessureMuscule),
                            'placeholder' => "Nbre blessés-Blessures aux muscles",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessBlessureMuscule);
                        ?>
                        <?= !empty(validation_show_error('nbBlessBlessureMuscule')) ? "<p class='text-danger'>" . validation_show_error('nbBlessBlessureMuscule') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- Articulations et membres"); ?>

                        <?php
                        $nbBlessArticulMembre = [
                            'type'  => 'text',
                            'name'  => 'nbBlessArticulMembre',
                            'id'    => 'nbBlessArticulMembre',
                            'value' => set_value('nbBlessArticulMembre', $couvertureSanitaire->nbBlessArticulMembre),
                            'placeholder' => "Nbre blessés-Articulations et membres",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessArticulMembre);
                        ?>
                        <?= !empty(validation_show_error('nbBlessArticulMembre')) ? "<p class='text-danger'>" . validation_show_error('nbBlessArticulMembre') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- Blessures à la tête"); ?>

                        <?php
                        $nbBlessBlessureTete = [
                            'type'  => 'text',
                            'name'  => 'nbBlessBlessureTete',
                            'id'    => 'nbBlessBlessureTete',
                            'value' => set_value('nbBlessBlessureTete', $couvertureSanitaire->nbBlessBlessureTete),
                            'placeholder' => "Nbre blessés-Blessures à la tête",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessBlessureTete);
                        ?>
                        <?= !empty(validation_show_error('nbBlessBlessureTete')) ? "<p class='text-danger'>" . validation_show_error('nbBlessBlessureTete') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- au cou"); ?>

                        <?php
                        $nbBlessCou = [
                            'type'  => 'text',
                            'name'  => 'nbBlessCou',
                            'id'    => 'nbBlessCou',
                            'value' => set_value('nbBlessCou', $couvertureSanitaire->nbBlessCou),
                            'placeholder' => "Nbre blessés-au cou",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessCou);
                        ?>
                        <?= !empty(validation_show_error('nbBlessCou')) ? "<p class='text-danger'>" . validation_show_error('nbBlessCou') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- au dos"); ?>

                        <?php
                        $nbBlessDos = [
                            'type'  => 'text',
                            'name'  => 'nbBlessDos',
                            'id'    => 'nbBlessDos',
                            'value' => set_value('nbBlessDos', $couvertureSanitaire->nbBlessDos),
                            'placeholder' => "Nbre blessés-au dos",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessDos);
                        ?>
                        <?= !empty(validation_show_error('nbBlessDos')) ? "<p class='text-danger'>" . validation_show_error('nbBlessDos') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- Blessures aux yeux"); ?>

                        <?php
                        $nbBlessBlessureYeux = [
                            'type'  => 'text',
                            'name'  => 'nbBlessBlessureYeux',
                            'id'    => 'nbBlessBlessureYeux',
                            'value' => set_value('nbBlessBlessureYeux', $couvertureSanitaire->nbBlessBlessureYeux),
                            'placeholder' => "Nbre blessés-Blessures aux yeux",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessBlessureYeux);
                        ?>
                        <?= !empty(validation_show_error('nbBlessBlessureYeux')) ? "<p class='text-danger'>" . validation_show_error('nbBlessBlessureYeux') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre blessés- autres"); ?>

                        <?php
                        $nbBlessAutre = [
                            'type'  => 'text',
                            'name'  => 'nbBlessAutre',
                            'id'    => 'nbBlessAutre',
                            'value' => set_value('nbBlessAutre', $couvertureSanitaire->nbBlessAutre),
                            'placeholder' => "Nbre blessés-autres",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbBlessAutre);
                        ?>
                        <?= !empty(validation_show_error('nbBlessAutre')) ? "<p class='text-danger'>" . validation_show_error('nbBlessAutre') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre maladies-Évanouissement"); ?>

                        <?php
                        $nbMaladieEvan = [
                            'type'  => 'text',
                            'name'  => 'nbMaladieEvan',
                            'id'    => 'nbMaladieEvan',
                            'value' => set_value('nbMaladieEvan', $couvertureSanitaire->nbMaladieEvan),
                            'placeholder' => "Nbre maladies-Évanouissement",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbMaladieEvan);
                        ?>
                        <?= !empty(validation_show_error('nbMaladieEvan')) ? "<p class='text-danger'>" . validation_show_error('nbMaladieEvan') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre maladies-Fièvre"); ?>

                        <?php
                        $nbMaladieFievre = [
                            'type'  => 'text',
                            'name'  => 'nbMaladieFievre',
                            'id'    => 'nbMaladieFievre',
                            'value' => set_value('nbMaladieFievre', $couvertureSanitaire->nbMaladieFievre),
                            'placeholder' => "Nbre maladies-Fièvre",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbMaladieFievre);
                        ?>
                        <?= !empty(validation_show_error('nbMaladieFievre')) ? "<p class='text-danger'>" . validation_show_error('nbMaladieFievre') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre maladies-Convulsions"); ?>

                        <?php
                        $nbMaladieConvul = [
                            'type'  => 'text',
                            'name'  => 'nbMaladieConvul',
                            'id'    => 'nbMaladieConvul',
                            'value' => set_value('nbMaladieConvul', $couvertureSanitaire->nbMaladieConvul),
                            'placeholder' => "Nbre maladies-Convulsions",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbMaladieConvul);
                        ?>
                        <?= !empty(validation_show_error('nbMaladieConvul')) ? "<p class='text-danger'>" . validation_show_error('nbMaladieConvul') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre maladies-Diarrhée"); ?>

                        <?php
                        $nbMaladieDiarrhe = [
                            'type'  => 'text',
                            'name'  => 'nbMaladieDiarrhe',
                            'id'    => 'nbMaladieDiarrhe',
                            'value' => set_value('nbMaladieDiarrhe', $couvertureSanitaire->nbMaladieDiarrhe),
                            'placeholder' => "Nbre maladies-Diarrhée",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbMaladieDiarrhe);
                        ?>
                        <?= !empty(validation_show_error('nbMaladieDiarrhe')) ? "<p class='text-danger'>" . validation_show_error('nbMaladieDiarrhe') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre maladies-Éruptions cutanées"); ?>

                        <?php
                        $nbMaladieErupt = [
                            'type'  => 'text',
                            'name'  => 'nbMaladieErupt',
                            'id'    => 'nbMaladieErupt',
                            'value' => set_value('nbMaladieErupt', $couvertureSanitaire->nbMaladieErupt),
                            'placeholder' => "Nbre maladies-Éruptions cutanées",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbMaladieErupt);
                        ?>
                        <?= !empty(validation_show_error('nbMaladieErupt')) ? "<p class='text-danger'>" . validation_show_error('nbMaladieDiarrhe') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-3">
                    <?= form_label("Nbre maladies-Autres"); ?>

                        <?php
                        $nbMaladieAutre = [
                            'type'  => 'text',
                            'name'  => 'nbMaladieAutre',
                            'id'    => 'nbMaladieAutre',
                            'value' => set_value('nbMaladieAutre', $couvertureSanitaire->nbMaladieAutre),
                            'placeholder' => "Nbre maladies-Autres",
                            'class' => 'form-control',
                        ];

                        echo form_input($nbMaladieAutre);
                        ?>
                        <?= !empty(validation_show_error('nbMaladieAutre')) ? "<p class='text-danger'>" . validation_show_error('nbMaladieAutre') . "</p>" : "" ?>
                    </div>

                    <div class="col-md-1 mt-4">
                        <?php
                        echo form_submit("mysubmit", lang("Params.btn_save"), "class='btn btn-primary btn-sm mt-1'");
                        ?>
                    </div>
                </div>
                <?php echo form_close(); ?>


            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>