<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/ps/formations", "<i class='fa fa-tasks'></i> " . lang("Params.btn_list"), ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php

                    use App\Traits\CommonTrait;
                    use CodeIgniter\View\Table;
                    use Modules\Params\Models\BrancheModel;
                    use Modules\Params\Models\CommuneModel;
                    use Modules\Params\Models\TypePremierSecourModel;

                    ?>
                </div>

                <div class="row mb-3">

                    <div class="col-md-3">
                        <?= form_label("Intitule de la formation"); ?><br>
                        <?= $formation->intituleFormation ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Branche"); ?><br>
                        <?= CommonTrait::formatData(new BrancheModel(), $formation->brancheId) ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Commune"); ?><br>
                        <?= CommonTrait::formatData(new CommuneModel(), $formation->communeId) ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Formateur1 ( Nom et prénom)"); ?><br>
                        <?= $formation->formateurUnNomPrenom ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Formateur2 ( Nom et prénom)"); ?><br>
                        <?= $formation->formateurDeuxNomPrenom ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date de formation "); ?><br>
                        <?= $formation->dateFormation ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Catégorie de formation"); ?><br>
                        <?= CommonTrait::categorieFormation($formation->categorieId) ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Niveau de formation"); ?><br>
                        <?= CommonTrait::niveauFormation($formation->niveauId) ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Type de formation"); ?><br>
                        <?= CommonTrait::formatData(new TypePremierSecourModel(), $formation->typeFormationId) ?>
                    </div>

                    <div class="col-md-3">
                        <?= form_label("Date d'expiration du certificat (2ans  après formation)"); ?><br>
                        <?= $formation->dateExpiration ?>
                    </div>
                </div>



                <?php

                if (!empty($membres)) {


                    $table = new Table();

                    $template = [
                        'table_open' => '<table class="table table-bordered" id="myList">',
                    ];

                    $table->setTemplate($template);
                    $table->setHeading("#", "PARTICIPANT", "TELEPHONE", "CNI", "BRANCHE", "COMMUNE", "CERTIFICAT", "OPTIONS");
                    $i = 1;
                    foreach ($membres as $membre) {
                        $sub_array = [];
                        $sub_array[] = $i;
                        $sub_array[] = $membre->nomParticipant . " " . $membre->prenomParticipant;
                        $sub_array[] = $membre->telephone;
                        $sub_array[] = $membre->cniParticipant;
                        $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $membre->brancheResidenceId);
                        $sub_array[] = CommonTrait::formatData(new CommuneModel(), $membre->communeResidenceId);
                        $sub_array[] = $membre->certificat;
                        $sub_array[] = anchor($locale . "/ps/formations/certificat/" . $membre->id, "<i class='fa fa-file-pdf'></i>", ['class' => 'text-info', 'target' => '_blank']);

                        $table->addRow($sub_array);
                        $i++;
                    }
                    echo $table->generate();
                }
                ?>

            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>