<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content mt-3">
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title text-bold"><?= $title ?></h3>

                <span class="float-right">
                    <?= anchor($locale . "/ps/materiel/add", "<i class='fa fa-pencil'></i> Nouvelle", ['class' => 'btn btn-primary btn-sm']) ?>
                </span>
            </div>

            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <?= form_label("Branche"); ?>
                        <?php
                        echo form_dropdown('brancheId', $branches, set_value('brancheId'), "class = 'form-control' id='brancheId'");
                        ?>
                    </div>
                    <div class="col-md-3"></div>

                    <div class="col-md-2 mt-5">
                        <button class='btn btn-info' id='materielExport'>Generer <i class='fa fa-file-csv'></i></button>
                    </div>
                    <div class="col-md-2 ml-1 mt-5" id>
                        <p id="materielExportBtn"></p>
                    </div>
                </div>
                <div class="table-responsive">
                    <?php

                    use CodeIgniter\View\Table;


                    $table = new Table();

                    $template = [
                        'table_open' => '<table class="table table-bordered" id="tables">',
                    ];

                    $table->setTemplate($template);
                    $table->setHeading("#", "BRANCHE", "COMMUNE", "MANUEL ENFANT", "BRANCARDS", "MANEQUIN(E)", "MANEQUIN(A)", "ATTELE", "BOITE IMAGE",  "EXITE TROUSSE", "ENREGISTRER", "OPTIONS");
                    // $table->setHeading("#","LOCALITE", "MANUEL ENFANT", "BRANCARDS", "MANEQUIN(E)", "MANEQUIN(A)", "ATTELE", "BOITE IMAGE", "COUVERTURE", "BLESSURE ROUTE", "BLESSURE PREPONDANT", "MANEQUIN(B)", "KIT-PS", "BALLON I-OXY", "DEFIBRILLATEUR", "MASQUE", "EXITE TROUSSE", "ENREGISTRER", "OPTIONS");

                    echo $table->generate();
                    ?>
                </div>
            </div>
        </div>


    </section>
</div>


<?= $this->endSection(); ?>