<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>
<?php 
  use App\Traits\CommonTrait;
use Modules\Params\Models\ProfessionModel;

?>
<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <div class="card card-info card-outline">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-md-4 text-center">
                                <h1>
                                    <?php if (empty($volontaire->passportImagePath)) { ?>
                                        <i class="bi bi-person-fill"></i>
                                    <?php } else { ?>
                                        <img src="<?= base_url() .'uploads/passport/'.$volontaire->passportImagePath ?>" width="100px" height="100px" />
                                    <?php } ?>
                                </h1>
                                <h4 class="badge badge-success">
                                    Disponible
                                </h4>
                            </div>
                            <div class="col-md-8">
                                <h5><b>Bonjour</b></h5>
                                <h4 class="text-uppercase">
                                    <?= anchor($locale . "/volontaire/identite", \auth()->user()->nom . ", " . \auth()->user()->prenom, ['class' => '']) ?>
                                </h4>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" style="border-left:1px solid #bfbfbf">
                        <h4>Coordonnés</h4>
                        <b>Téléphone:</b><?=$volontaire->telephone?> <br />             
                        <b>E-mail:</b><?=$volontaire->email?> <br />             
                        <b>Profession:</b><?= $volontaire->professionId > 0 ?CommonTrait::formatData(new ProfessionModel(), $volontaire->professionId):""?> <br />             
                        
                    </div>
                    <div class="col-md-4" style="border-left:1px solid #bfbfbf">
                        <h4>Etudes</h4>
                        <?php if($etudes){
                            foreach ($etudes as $etude) {
                                echo $etude->descriptionQualification." ".$etude->dateFin."<br>";
                            }
                        }?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <?php 
                          use App\Traits\LanguageTrait;
                        ?>
                        <h4>Langues</h4>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Langue</th>
                                    <th>Ecrit</th>
                                    <th>Lire</th>
                                    <th>Oral</th>
                                </tr>
                            </thead>
                            <tbody>
                        <?php foreach ($mesLangues as $mesLangue) { ?>
                            <tr>
                                <td><?=$langues[$mesLangue->langueId]?></td>
                                <td><?= LanguageTrait::niveaux($mesLangue->niveauEcrit)?></td>
                                <td><?= LanguageTrait::niveaux($mesLangue->niveauLire)?></td>
                                <td><?= LanguageTrait::niveaux($mesLangue->niveauOral)?></td>
                            </tr>
                        <?php }?>
                        </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>


<?= $this->endSection(); ?>