<?= $this->extend("layout/index"); ?>
<?= $this->section('content'); ?>

<div class="content-wrapper" style="min-height: 357.039px;">
    <section class="content">
        <h2 class="text-bold"><?= \auth()->user()->nom . ", " . \auth()->user()->prenom ?></h2>

        <div class="row" style="margin-top:10px">

            <div class="col-md-9">
                <?php if (!empty(session()->getFlashdata('message'))) {
                    echo "<div class='row'>" . session()->getFlashdata('message') . "</div>";
                } ?>
                <?php
                $id = (string)$experience->id;
                echo form_open_multipart($locale . "/volontaire/experience/save", 'class="email" id="myform"', ['id' => $id]); ?>

                <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title text-bold">
                            Expérience
                        </h3>
                        <p class='text-bold float-right'>
                            <font color='red'>*</font> Champ est obligatoire
                        </p>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <?= form_label("Type d'emploi <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('typeId', $types, set_value('typeId', $experience->typeId), "class = 'form-control' id='typeId'");
                                ?>
                                <?= !empty(validation_show_error('typeId')) ? "<p class='text-danger'>" . validation_show_error('typeId') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Employeur <font color='red'>*</font>"); ?>
                                <?php
                                $employeur = [
                                    'type'  => 'text',
                                    'name'  => 'employeur',
                                    'id'    => 'employeur',
                                    'value' => set_value('employeur', $experience->employeur),
                                    'placeholder' => "Employeur",
                                    'class' => 'form-control',
                                ];

                                echo form_input($employeur);
                                ?>
                                <?= !empty(validation_show_error('employeur')) ? "<p class='text-danger'>" . validation_show_error('employeur') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Position <font color='red'>*</font>"); ?>
                                <?php
                                echo form_dropdown('position', $positions, set_value('position', $experience->position), "class = 'form-control' id='position'");
                                ?>
                                <?= !empty(validation_show_error('position')) ? "<p class='text-danger'>" . validation_show_error('position') . "</p>" : "" ?>

                            </div>

                            <div class="col-md-6">
                                <?= form_label("Departement"); ?>
                                <?php
                                $departement = [
                                    'type'  => 'text',
                                    'name'  => 'departement',
                                    'id'    => 'departement',
                                    'value' => set_value('departement', $experience->departement),
                                    'placeholder' => "Departement",
                                    'class' => 'form-control',
                                ];

                                echo form_input($departement);
                                ?>
                                <?= !empty(validation_show_error('departement')) ? "<p class='text-danger'>" . validation_show_error('departement') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Champ de travail <font color='red'>*</font>"); ?>
                                <?php
                                $champTravail = [
                                    'type'  => 'text',
                                    'name'  => 'champTravail',
                                    'id'    => 'champTravail',
                                    'value' => set_value('champTravail', $experience->champTravail),
                                    'placeholder' => "Champ de travail",
                                    'class' => 'form-control',
                                ];

                                echo form_input($champTravail);
                                ?>
                                <?= !empty(validation_show_error('champTravail')) ? "<p class='text-danger'>" . validation_show_error('champTravail') . "</p>" : "" ?>
                            </div>
         
                            <div class="col-md-6">
                                <?= form_label("Date de début <font color='red'>*</font>"); ?>
                                <?php $date = set_value('dateDebut', $experience->dateDebut) ?>
                                <div class="input-group date" id="dateDebut" data-target-input="nearest">
                                    <?= form_input('dateDebut', $date, "class='form-control datetimepicker-input', id='dateDebut' placeholder='Date de début'") ?>
                                    <div class="input-group-append" data-target="#dateDebut" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('dateDebut')) ? "<p class='text-danger'>" . validation_show_error('dateDebut') . "</p>" : "" ?>
                            </div>

                            <div class="col-md-6">
                                <?= form_label("Date fin"); ?>
                                <?php $date = set_value('dateFin', $experience->dateFin) ?>
                                <div class="input-group date" id="dateFin" data-target-input="nearest">
                                    <?= form_input('dateFin', $date, "class='form-control datetimepicker-input', id='dateFin' placeholder='Date fin'") ?>
                                    <div class="input-group-append" data-target="#dateFin" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                    </div>
                                </div>
                                <?= !empty(validation_show_error('dateFin')) ? "<p class='text-danger'>" . validation_show_error('dateFin') . "</p>" : "" ?>
                            </div>

                        </div>
                    </div>
                    <div class="card-header">
                        <?php
                        echo form_submit("mysubmit", "Enregistrer", "class='btn btn-primary btn-sm'");
                        echo anchor($locale . '/volontaire/experiences', 'Retour', 'class="btn btn-default btn-sm"');
                        ?>
                    </div>
                </div>

                <?php echo form_close(); ?>
            </div>

    </section>
</div>

<?= $this->endSection(); ?>