!/**
 * Highmaps JS v11.4.0 (2024-03-04)
 *
 * Highmaps as a plugin for Highcharts or Highcharts Stock.
 *
 * (c) 2011-2024 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,s){t.hasOwnProperty(e)||(t[e]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Core/Axis/Color/ColorAxisComposition.js",[e["Core/Color/Color.js"],e["Core/Utilities.js"]],function(t,e){var i;let{parse:s}=t,{addEvent:o,extend:r,merge:a,pick:n,splat:l}=e;return function(t){let e;function i(){let{userOptions:t}=this;this.colorAxis=[],t.colorAxis&&(t.colorAxis=l(t.colorAxis),t.colorAxis.map(t=>new e(this,t)))}function h(t){let e=this.chart.colorAxis||[],i=e=>{let i=t.allItems.indexOf(e);-1!==i&&(this.destroyItem(t.allItems[i]),t.allItems.splice(i,1))},s=[],o,r;for(e.forEach(function(t){(o=t.options)&&o.showInLegend&&(o.dataClasses&&o.visible?s=s.concat(t.getDataClassLegendSymbols()):o.visible&&s.push(t),t.series.forEach(function(t){(!t.options.showInLegend||o.dataClasses)&&("point"===t.options.legendType?t.points.forEach(function(t){i(t)}):i(t))}))}),r=s.length;r--;)t.allItems.unshift(s[r])}function p(t){t.visible&&t.item.legendColor&&t.item.legendItem.symbol.attr({fill:t.item.legendColor})}function d(t){this.chart.colorAxis?.forEach(e=>{e.update({},t.redraw)})}function c(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}function u(){let t=this.axisTypes;t?-1===t.indexOf("colorAxis")&&t.push("colorAxis"):this.axisTypes=["colorAxis"]}function m(t){let e=this,i=t?"show":"hide";e.visible=e.options.visible=!!t,["graphic","dataLabel"].forEach(function(t){e[t]&&e[t][i]()}),this.series.buildKDTree()}function g(){let t=this,e=this.data.length?this.data:this.points,i=this.options.nullColor,s=this.colorAxis,o=this.colorKey;e.forEach(e=>{let r=e.getNestedProperty(o),a=e.options.color||(e.isNull||null===e.value?i:s&&void 0!==r?s.toColor(r,e):e.color||t.color);a&&e.color!==a&&(e.color=a,"point"===t.options.legendType&&e.legendItem&&e.legendItem.label&&t.chart.legend.colorizeItem(e,e.visible))})}function f(){this.elem.attr("fill",s(this.start).tweenTo(s(this.end),this.pos),void 0,!0)}function b(){this.elem.attr("stroke",s(this.start).tweenTo(s(this.end),this.pos),void 0,!0)}t.compose=function(t,s,l,y,x){let M=s.prototype,C=l.prototype,j=x.prototype;M.collectionsWithUpdate.includes("colorAxis")||(e=t,M.collectionsWithUpdate.push("colorAxis"),M.collectionsWithInit.colorAxis=[M.addColorAxis],o(s,"afterGetAxes",i),function(t){let i=t.prototype.createAxis;t.prototype.createAxis=function(t,s){if("colorAxis"!==t)return i.apply(this,arguments);let o=new e(this,a(s.axis,{index:this[t].length,isX:!1}));return this.isDirtyLegend=!0,this.axes.forEach(t=>{t.series=[]}),this.series.forEach(t=>{t.bindAxes(),t.isDirtyData=!0}),n(s.redraw,!0)&&this.redraw(s.animation),o}}(s),C.fillSetter=f,C.strokeSetter=b,o(y,"afterGetAllItems",h),o(y,"afterColorizeItem",p),o(y,"afterUpdate",d),r(j,{optionalAxis:"colorAxis",translateColors:g}),r(j.pointClass.prototype,{setVisible:m}),o(x,"afterTranslate",c,{order:1}),o(x,"bindAxes",u))},t.pointSetVisible=m}(i||(i={})),i}),i(e,"Core/Axis/Color/ColorAxisDefaults.js",[],function(){return{lineWidth:0,minPadding:0,maxPadding:0,gridLineColor:"#ffffff",gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{distance:8,overflow:"justify",rotation:0},minColor:"#e6e9ff",maxColor:"#0022ff",tickLength:5,showInLegend:!0}}),i(e,"Core/Axis/Color/ColorAxisLike.js",[e["Core/Color/Color.js"],e["Core/Utilities.js"]],function(t,e){var i,s;let{parse:o}=t,{merge:r}=e;return(s=i||(i={})).initDataClasses=function(t){let e=this.chart,i=this.legendItem=this.legendItem||{},s=this.options,a=t.dataClasses||[],n,l,h=e.options.chart.colorCount,p=0,d;this.dataClasses=l=[],i.labels=[];for(let t=0,i=a.length;t<i;++t)n=r(n=a[t]),l.push(n),(e.styledMode||!n.color)&&("category"===s.dataClassColor?(e.styledMode||(h=(d=e.options.colors||[]).length,n.color=d[p]),n.colorIndex=p,++p===h&&(p=0)):n.color=o(s.minColor).tweenTo(o(s.maxColor),i<2?.5:t/(i-1)))},s.initStops=function(){let t=this.options,e=this.stops=t.stops||[[0,t.minColor||""],[1,t.maxColor||""]];for(let t=0,i=e.length;t<i;++t)e[t].color=o(e[t][1])},s.normalizedValue=function(t){let e=this.max||0,i=this.min||0;return this.logarithmic&&(t=this.logarithmic.log2lin(t)),1-(e-t)/(e-i||1)},s.toColor=function(t,e){let i,s,o,r,a,n;let l=this.dataClasses,h=this.stops;if(l){for(n=l.length;n--;)if(s=(a=l[n]).from,o=a.to,(void 0===s||t>=s)&&(void 0===o||t<=o)){r=a.color,e&&(e.dataClass=n,e.colorIndex=a.colorIndex);break}}else{for(i=this.normalizedValue(t),n=h.length;n--&&!(i>h[n][0]););s=h[n]||h[n+1],i=1-((o=h[n+1]||s)[0]-i)/(o[0]-s[0]||1),r=s.color.tweenTo(o.color,i)}return r},i}),i(e,"Core/Axis/Color/ColorAxis.js",[e["Core/Axis/Axis.js"],e["Core/Axis/Color/ColorAxisComposition.js"],e["Core/Axis/Color/ColorAxisDefaults.js"],e["Core/Axis/Color/ColorAxisLike.js"],e["Core/Defaults.js"],e["Core/Legend/LegendSymbol.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,a,n){let{defaultOptions:l}=o,{series:h}=a,{defined:p,extend:d,fireEvent:c,isArray:u,isNumber:m,merge:g,pick:f,relativeLength:b}=n;l.colorAxis=g(l.xAxis,i);class y extends t{static compose(t,i,s,o){e.compose(y,t,i,s,o)}constructor(t,e){super(t,e),this.coll="colorAxis",this.visible=!0,this.init(t,e)}init(t,e){let i=t.options.legend||{},s=e.layout?"vertical"!==e.layout:"vertical"!==i.layout;this.side=e.side||s?2:1,this.reversed=e.reversed||!s,this.opposite=!s,super.init(t,e,"colorAxis"),this.userOptions=e,u(t.userOptions.colorAxis)&&(t.userOptions.colorAxis[this.index]=e),e.dataClasses&&this.initDataClasses(e),this.initStops(),this.horiz=s,this.zoomEnabled=!1}hasData(){return!!(this.tickPositions||[]).length}setTickPositions(){if(!this.dataClasses)return super.setTickPositions()}setOptions(t){let e=g(l.colorAxis,t,{showEmpty:!1,title:null,visible:this.chart.options.legend.enabled&&!1!==t.visible});super.setOptions(e),this.options.crosshair=this.options.marker}setAxisSize(){let t=this.chart,e=this.legendItem?.symbol,{width:i,height:s}=this.getSize();e&&(this.left=+e.attr("x"),this.top=+e.attr("y"),this.width=i=+e.attr("width"),this.height=s=+e.attr("height"),this.right=t.chartWidth-this.left-i,this.bottom=t.chartHeight-this.top-s,this.pos=this.horiz?this.left:this.top),this.len=(this.horiz?i:s)||y.defaultLegendLength}getOffset(){let t=this.legendItem?.group,e=this.chart.axisOffset[this.side];if(t){this.axisParent=t,super.getOffset();let i=this.chart.legend;i.allItems.forEach(function(t){t instanceof y&&t.drawLegendSymbol(i,t)}),i.render(),this.chart.getMargins(!0),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width),this.chart.axisOffset[this.side]=e}}setLegendColor(){let t=this.horiz,e=this.reversed,i=e?1:0,s=e?0:1,o=t?[i,0,s,0]:[0,s,0,i];this.legendColor={linearGradient:{x1:o[0],y1:o[1],x2:o[2],y2:o[3]},stops:this.stops}}drawLegendSymbol(t,e){let i=e.legendItem||{},s=t.padding,o=t.options,r=this.options.labels,a=f(o.itemDistance,10),n=this.horiz,{width:l,height:h}=this.getSize(),p=f(o.labelPadding,n?16:30);this.setLegendColor(),i.symbol||(i.symbol=this.chart.renderer.symbol("roundedRect").attr({r:o.symbolRadius??3,zIndex:1}).add(i.group)),i.symbol.attr({x:0,y:(t.baseline||0)-11,width:l,height:h}),i.labelWidth=l+s+(n?a:f(r.x,r.distance)+(this.maxLabelLength||0)),i.labelHeight=h+s+(n?p:0)}setState(t){this.series.forEach(function(e){e.setState(t)})}setVisible(){}getSeriesExtremes(){let t=this.series,e,i,s,o,r,a,n=t.length,l,d;for(this.dataMin=1/0,this.dataMax=-1/0;n--;){if(i=(a=t[n]).colorKey=f(a.options.colorKey,a.colorKey,a.pointValKey,a.zoneAxis,"y"),o=a.pointArrayMap,r=a[i+"Min"]&&a[i+"Max"],a[i+"Data"])e=a[i+"Data"];else if(o){if(e=[],s=o.indexOf(i),l=a.yData,s>=0&&l)for(d=0;d<l.length;d++)e.push(f(l[d][s],l[d]))}else e=a.yData;if(r)a.minColorValue=a[i+"Min"],a.maxColorValue=a[i+"Max"];else{let t=h.prototype.getExtremes.call(a,e);a.minColorValue=t.dataMin,a.maxColorValue=t.dataMax}p(a.minColorValue)&&p(a.maxColorValue)&&(this.dataMin=Math.min(this.dataMin,a.minColorValue),this.dataMax=Math.max(this.dataMax,a.maxColorValue)),r||h.prototype.applyExtremes.call(a)}}drawCrosshair(t,e){let i;let s=this.legendItem||{},o=e&&e.plotX,r=e&&e.plotY,a=this.pos,n=this.len;e&&((i=this.toPixels(e.getNestedProperty(e.series.colorKey)))<a?i=a-2:i>a+n&&(i=a+n+2),e.plotX=i,e.plotY=this.len-i,super.drawCrosshair(t,e),e.plotX=o,e.plotY=r,this.cross&&!this.cross.addedToColorAxis&&s.group&&(this.cross.addClass("highcharts-coloraxis-marker").add(s.group),this.cross.addedToColorAxis=!0,this.chart.styledMode||"object"!=typeof this.crosshair||this.cross.attr({fill:this.crosshair.color})))}getPlotLinePath(t){let e=this.left,i=t.translatedValue,s=this.top;return m(i)?this.horiz?[["M",i-4,s-6],["L",i+4,s-6],["L",i,s],["Z"]]:[["M",e,i],["L",e-6,i+6],["L",e-6,i-6],["Z"]]:super.getPlotLinePath(t)}update(t,e){let i=this.chart.legend;this.series.forEach(t=>{t.isDirtyData=!0}),(t.dataClasses&&i.allItems||this.dataClasses)&&this.destroyItems(),super.update(t,e),this.legendItem&&this.legendItem.label&&(this.setLegendColor(),i.colorizeItem(this,!0))}destroyItems(){let t=this.chart,e=this.legendItem||{};if(e.label)t.legend.destroyItem(this);else if(e.labels)for(let i of e.labels)t.legend.destroyItem(i);t.isDirtyLegend=!0}destroy(){this.chart.isDirtyLegend=!0,this.destroyItems(),super.destroy(...[].slice.call(arguments))}remove(t){this.destroyItems(),super.remove(t)}getDataClassLegendSymbols(){let t;let e=this,i=e.chart,s=e.legendItem&&e.legendItem.labels||[],o=i.options.legend,a=f(o.valueDecimals,-1),n=f(o.valueSuffix,""),l=t=>e.series.reduce((e,i)=>(e.push(...i.points.filter(e=>e.dataClass===t)),e),[]);return s.length||e.dataClasses.forEach((o,h)=>{let p=o.from,u=o.to,{numberFormatter:m}=i,g=!0;t="",void 0===p?t="< ":void 0===u&&(t="> "),void 0!==p&&(t+=m(p,a)+n),void 0!==p&&void 0!==u&&(t+=" - "),void 0!==u&&(t+=m(u,a)+n),s.push(d({chart:i,name:t,options:{},drawLegendSymbol:r.rectangle,visible:!0,isDataClass:!0,setState:t=>{for(let e of l(h))e.setState(t)},setVisible:function(){this.visible=g=e.visible=!g;let t=[];for(let e of l(h))e.setVisible(g),e.hiddenInDataClass=!g,-1===t.indexOf(e.series)&&t.push(e.series);i.legend.colorizeItem(this,g),t.forEach(t=>{c(t,"afterDataClassLegendClick")})}},o))}),s}getSize(){let{chart:t,horiz:e}=this,{legend:i,height:s,width:o}=this.options;return{width:f(p(o)?b(o,t.chartWidth):void 0,i?.symbolWidth,e?y.defaultLegendLength:12),height:f(p(s)?b(s,t.chartHeight):void 0,i?.symbolHeight,e?12:y.defaultLegendLength)}}}return y.defaultLegendLength=200,y.keepProps=["legendItem"],d(y.prototype,s),Array.prototype.push.apply(t.keepProps,y.keepProps),y}),i(e,"masters/modules/coloraxis.src.js",[e["Core/Globals.js"],e["Core/Axis/Color/ColorAxis.js"]],function(t,e){return t.ColorAxis=t.ColorAxis||e,t.ColorAxis.compose(t.Chart,t.Fx,t.Legend,t.Series),t}),i(e,"Maps/MapNavigationDefaults.js",[],function(){return{lang:{zoomIn:"Zoom in",zoomOut:"Zoom out"},mapNavigation:{buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{color:"#666666",fontSize:"1em",fontWeight:"bold"},theme:{fill:"#ffffff",stroke:"#e6e6e6","stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1}}}),i(e,"Maps/MapPointer.js",[e["Core/Utilities.js"]],function(t){var e;let{defined:i,extend:s,pick:o,wrap:r}=t;return function(t){let e,a=0;function n(t){let e=this.chart;t=this.normalize(t),e.options.mapNavigation.enableDoubleClickZoomTo?e.pointer.inClass(t.target,"highcharts-tracker")&&e.hoverPoint&&e.hoverPoint.zoomTo():e.isInsidePlot(t.chartX-e.plotLeft,t.chartY-e.plotTop)&&e.mapZoom(.5,void 0,void 0,t.chartX,t.chartY)}function l(t){let s=this.chart,o=i((t=this.normalize(t)).wheelDelta)&&-t.wheelDelta/120||t.deltaY||t.detail;Math.abs(o)>=1&&(a+=Math.abs(o),e&&clearTimeout(e),e=setTimeout(()=>{a=0},50)),a<10&&s.isInsidePlot(t.chartX-s.plotLeft,t.chartY-s.plotTop)&&s.mapView&&s.mapView.zoomBy(-((s.options.mapNavigation.mouseWheelSensitivity-1)*o),void 0,[t.chartX,t.chartY],!(1>Math.abs(o))&&void 0)}function h(t,e,i){let o=this.chart;if(e=t.call(this,e,i),o&&o.mapView){let t=o.mapView.pixelsToLonLat({x:e.chartX-o.plotLeft,y:e.chartY-o.plotTop});t&&s(e,t)}return e}function p(t){let e=this.chart.options.mapNavigation;e&&o(e.enableTouchZoom,e.enabled)&&(this.chart.zooming.pinchType="xy"),t.apply(this,[].slice.call(arguments,1))}t.compose=function(t){let e=t.prototype;e.onContainerDblClick||(s(e,{onContainerDblClick:n,onContainerMouseWheel:l}),r(e,"normalize",h),r(e,"zoomOption",p))}}(e||(e={})),e}),i(e,"Maps/MapSymbols.js",[],function(){let t;function e(e,i,s,o,r){if(r){let t=r?.r||0;r.brBoxY=i-t,r.brBoxHeight=o+t}return t.roundedRect(e,i,s,o,r)}function i(e,i,s,o,r){if(r){let t=r?.r||0;r.brBoxHeight=o+t}return t.roundedRect(e,i,s,o,r)}return{compose:function(s){(t=s.prototype.symbols).bottombutton=e,t.topbutton=i}}}),i(e,"Maps/MapNavigation.js",[e["Core/Defaults.js"],e["Core/Globals.js"],e["Maps/MapNavigationDefaults.js"],e["Maps/MapPointer.js"],e["Maps/MapSymbols.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r){let{setOptions:a}=t,{composed:n}=e,{addEvent:l,extend:h,merge:p,objectEach:d,pick:c,pushUnique:u}=r;function m(t){t&&(t.preventDefault&&t.preventDefault(),t.stopPropagation&&t.stopPropagation(),t.cancelBubble=!0)}class g{static compose(t,e,r){s.compose(e),o.compose(r),u(n,"Map.Navigation")&&(l(t,"beforeRender",function(){this.mapNavigation=new g(this),this.mapNavigation.update()}),a(i))}constructor(t){this.chart=t,this.navButtons=[]}update(t){let e=this,i=e.chart,s=e.navButtons,o=function(t){this.handler.call(i,t),m(t)},r=i.options.mapNavigation,a;for(t&&(r=i.options.mapNavigation=p(i.options.mapNavigation,t));s.length;)s.pop().destroy();if(!i.renderer.forExport&&c(r.enableButtons,r.enabled)){e.navButtonsGroup||(e.navButtonsGroup=i.renderer.g().attr({zIndex:7}).add()),d(r.buttons,(t,n)=>{t=p(r.buttonOptions,t),!i.styledMode&&t.theme&&((a=t.theme).style=p(t.theme.style,t.style));let{text:d,width:c=0,height:u=0,padding:g=0}=t,f=i.renderer.button("+"!==d&&"-"!==d&&d||"",0,0,o,a,void 0,void 0,void 0,"zoomIn"===n?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+({zoomIn:"zoom-in",zoomOut:"zoom-out"})[n]).attr({width:c,height:u,title:i.options.lang[n],padding:t.padding,zIndex:5}).add(e.navButtonsGroup);if("+"===d||"-"===d){let e=c+1,s=[["M",g+3,g+u/2],["L",g+e-3,g+u/2]];"+"===d&&s.push(["M",g+e/2,g+3],["L",g+e/2,g+u-3]),i.renderer.path(s).addClass("highcharts-button-symbol").attr(i.styledMode?{}:{stroke:t.style?.color,"stroke-width":3,"stroke-linecap":"round"}).add(f)}if(f.handler=t.onclick,l(f.element,"dblclick",m),s.push(f),h(t,{width:f.width,height:2*(f.height||0)}),i.hasLoaded)f.align(t,!1,t.alignTo);else{let e=l(i,"load",()=>{f.element&&f.align(t,!1,t.alignTo),e()})}});let t=(t,e)=>!(e.x>=t.x+t.width||e.x+e.width<=t.x||e.y>=t.y+t.height||e.y+e.height<=t.y);i.hasLoaded||l(i,"render",function(){let s=i.exportingGroup&&i.exportingGroup.getBBox();if(s){let i=e.navButtonsGroup.getBBox();if(t(s,i)){let t=-i.y-i.height+s.y-5,o=s.y+s.height-i.y+5,a=r.buttonOptions&&r.buttonOptions.verticalAlign;e.navButtonsGroup.attr({translateY:"bottom"===a?t:o})}}})}this.updateEvents(r)}updateEvents(t){let e=this.chart;c(t.enableDoubleClickZoom,t.enabled)||t.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||l(e.container,"dblclick",function(t){e.pointer.onContainerDblClick(t)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick()),c(t.enableMouseWheelZoom,t.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||l(e.container,"wheel",function(t){return e.pointer.inClass(t.target,"highcharts-no-mousewheel")||(e.pointer.onContainerMouseWheel(t),m(t)),!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())}}return g}),i(e,"Series/ColorMapComposition.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){var i;let{column:{prototype:s}}=t.seriesTypes,{addEvent:o,defined:r}=e;return function(t){function e(t){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:t&&"hover"===t.state?1:0})}t.pointMembers={dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return null!==this.value&&this.value!==1/0&&this.value!==-1/0&&(void 0===this.value||!isNaN(this.value))}},t.seriesMembers={colorKey:"value",axisTypes:["xAxis","yAxis","colorAxis"],parallelArrays:["x","y","value"],pointArrayMap:["value"],trackerGroups:["group","markerGroup","dataLabelsGroup"],colorAttribs:function(t){let e={};return r(t.color)&&(!t.state||"normal"===t.state)&&(e[this.colorProp||"fill"]=t.color),e},pointAttribs:s.pointAttribs},t.compose=function(t){return o(t.prototype.pointClass,"afterSetState",e),t}}(i||(i={})),i}),i(e,"Core/Chart/MapChart.js",[e["Core/Chart/Chart.js"],e["Core/Defaults.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"]],function(t,e,i,s){var o;let{getOptions:r}=e,{isNumber:a,merge:n,pick:l}=s;class h extends t{init(t,e){let i=r().credits,s=n({chart:{panning:{enabled:!0,type:"xy"},type:"map"},credits:{mapText:l(i.mapText,' \xa9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),mapTextFull:l(i.mapTextFull,"{geojson.copyright}")},mapView:{},tooltip:{followTouchMove:!1}},t);super.init(s,e)}mapZoom(t,e,i,s,o){this.mapView&&(a(t)&&(t=Math.log(t)/Math.log(.5)),this.mapView.zoomBy(t,a(e)&&a(i)?this.mapView.projection.inverse([e,i]):void 0,a(s)&&a(o)?[s,o]:void 0))}update(t){t.chart&&"map"in t.chart&&this.mapView?.recommendMapView(this,[t.chart.map,...(this.options.series||[]).map(t=>t.mapData)],!0),super.update.apply(this,arguments)}}return(o=h||(h={})).maps={},o.mapChart=function(t,e,i){return new o(t,e,i)},o.splitPath=function(t){let e;return e="string"==typeof t?(t=t.replace(/([A-Za-z])/g," $1 ").replace(/^\s*/,"").replace(/\s*$/,"")).split(/[ ,;]+/).map(t=>/[A-Za-z]/.test(t)?t:parseFloat(t)):t,i.prototype.pathToSegments(e)},h}),i(e,"Maps/MapUtilities.js",[],function(){return{boundsFromPath:function(t){let e=-Number.MAX_VALUE,i=Number.MAX_VALUE,s=-Number.MAX_VALUE,o=Number.MAX_VALUE,r;if(t.forEach(t=>{let a=t[t.length-2],n=t[t.length-1];"number"==typeof a&&"number"==typeof n&&(i=Math.min(i,a),e=Math.max(e,a),o=Math.min(o,n),s=Math.max(s,n),r=!0)}),r)return{x1:i,y1:o,x2:e,y2:s}},pointInPolygon:function(t,e){let i,s,o=!1,r=t.x,a=t.y;for(i=0,s=e.length-1;i<e.length;s=i++)e[i][1]>a!=e[s][1]>a&&r<(e[s][0]-e[i][0])*(a-e[i][1])/(e[s][1]-e[i][1])+e[i][0]&&(o=!o);return o}}}),i(e,"Series/Map/MapPoint.js",[e["Series/ColorMapComposition.js"],e["Maps/MapUtilities.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s){let{boundsFromPath:o}=e,r=i.seriesTypes.scatter.prototype.pointClass,{extend:a,isNumber:n,pick:l}=s;class h extends r{static getProjectedPath(t,e){return t.projectedPath||(e&&t.geometry?(e.hasCoordinates=!0,t.projectedPath=e.path(t.geometry)):t.projectedPath=t.path),t.projectedPath||[]}applyOptions(t,e){let i=this.series,s=super.applyOptions(t,e),o=i.joinBy;if(i.mapData&&i.mapMap){let t=o[1],e=super.getNestedProperty(t),r=void 0!==e&&i.mapMap[e];r?a(s,{...r,name:s.name??r.name}):-1!==i.pointArrayMap.indexOf("value")&&(s.value=s.value||null)}return s}getProjectedBounds(t){let e=o(h.getProjectedPath(this,t)),i=this.properties,s=this.series.chart.mapView;if(e){let o=i&&i["hc-middle-lon"],r=i&&i["hc-middle-lat"];if(s&&n(o)&&n(r)){let i=t.forward([o,r]);e.midX=i[0],e.midY=i[1]}else{let t=i&&i["hc-middle-x"],s=i&&i["hc-middle-y"];e.midX=e.x1+(e.x2-e.x1)*l(this.middleX,n(t)?t:.5);let o=l(this.middleY,n(s)?s:.5);this.geometry||(o=1-o),e.midY=e.y2-(e.y2-e.y1)*o}return e}}onMouseOver(t){s.clearTimeout(this.colorInterval),!this.isNull&&this.visible||this.series.options.nullInteraction?super.onMouseOver.call(this,t):this.series.onMouseOut()}setVisible(t){this.visible=this.options.visible=!!t,this.dataLabel&&this.dataLabel[t?"show":"hide"](),this.graphic&&this.graphic.attr(this.series.pointAttribs(this))}zoomTo(t){let e=this.series.chart,i=e.mapView,s=this.bounds;if(i&&s){let o=n(this.insetIndex)&&i.insets[this.insetIndex];if(o){let t=o.projectedUnitsToPixels({x:s.x1,y:s.y1}),e=o.projectedUnitsToPixels({x:s.x2,y:s.y2}),r=i.pixelsToProjectedUnits({x:t.x,y:t.y}),a=i.pixelsToProjectedUnits({x:e.x,y:e.y});s={x1:r.x,y1:r.y,x2:a.x,y2:a.y}}i.fitToBounds(s,void 0,!1),this.series.isDirty=!0,e.redraw(t)}}}return a(h.prototype,{dataLabelOnNull:t.pointMembers.dataLabelOnNull,moveToTopOnHover:t.pointMembers.moveToTopOnHover,isValid:t.pointMembers.isValid}),h}),i(e,"Series/Map/MapSeriesDefaults.js",[e["Core/Utilities.js"]],function(t){let{isNumber:e}=t;return{affectsMapView:!0,animation:!1,dataLabels:{crop:!1,formatter:function(){let{numberFormatter:t}=this.series.chart,{value:i}=this.point;return e(i)?t(i,-1):this.point.name},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},linecap:"round",marker:null,nullColor:"#f7f7f7",stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:"#e6e6e6",borderWidth:1,joinBy:"hc-key",states:{hover:{halo:void 0,borderColor:"#666666",borderWidth:2},normal:{animation:!0},select:{color:"#cccccc"}},legendSymbol:"rectangle"}}),i(e,"Maps/MapViewDefaults.js",[],function(){return{center:[0,0],fitToGeometry:void 0,maxZoom:void 0,padding:0,projection:{name:void 0,parallels:void 0,rotation:void 0},zoom:void 0,insetOptions:{borderColor:"#cccccc",borderWidth:1,padding:"10%",relativeTo:"mapBoundingBox",units:"percent"}}}),i(e,"Maps/GeoJSONComposition.js",[e["Core/Globals.js"],e["Core/Templating.js"],e["Core/Utilities.js"]],function(t,e,i){var s;let{win:o}=t,{format:r}=e,{error:a,extend:n,merge:l,wrap:h}=i;return function(t){function e(t){return this.mapView&&this.mapView.lonLatToProjectedUnits(t)}function i(t){return this.mapView&&this.mapView.projectedUnitsToLonLat(t)}function s(t,e){let i=this.options.chart.proj4||o.proj4;if(!i){a(21,!1,this);return}let{jsonmarginX:s=0,jsonmarginY:r=0,jsonres:n=1,scale:l=1,xoffset:h=0,xpan:p=0,yoffset:d=0,ypan:c=0}=e,u=i(e.crs,[t.lon,t.lat]),m=e.cosAngle||e.rotation&&Math.cos(e.rotation),g=e.sinAngle||e.rotation&&Math.sin(e.rotation),f=e.rotation?[u[0]*m+u[1]*g,-u[0]*g+u[1]*m]:u;return{x:((f[0]-h)*l+p)*n+s,y:-(((d-f[1])*l+c)*n-r)}}function p(t,e){let i=this.options.chart.proj4||o.proj4;if(!i){a(21,!1,this);return}if(null===t.y)return;let{jsonmarginX:s=0,jsonmarginY:r=0,jsonres:n=1,scale:l=1,xoffset:h=0,xpan:p=0,yoffset:d=0,ypan:c=0}=e,u={x:((t.x-s)/n-p)/l+h,y:((t.y-r)/n+c)/l+d},m=e.cosAngle||e.rotation&&Math.cos(e.rotation),g=e.sinAngle||e.rotation&&Math.sin(e.rotation),f=i(e.crs,"WGS84",e.rotation?{x:u.x*m+-(u.y*g),y:u.x*g+u.y*m}:u);return{lat:f.y,lon:f.x}}function d(t,e){e||(e=Object.keys(t.objects)[0]);let i=t.objects[e];if(i["hc-decoded-geojson"]&&i["hc-decoded-geojson"].title===t.title)return i["hc-decoded-geojson"];let s=t.arcs;if(t.transform){let e,i,o;let r=t.arcs,{scale:a,translate:n}=t.transform;s=[];for(let t=0,l=r.length;t<l;++t){let l=r[t];s.push(e=[]),i=0,o=0;for(let t=0,s=l.length;t<s;++t)e.push([(i+=l[t][0])*a[0]+n[0],(o+=l[t][1])*a[1]+n[1]])}}let o=t=>"number"==typeof t[0]?t.reduce((t,e,i)=>{let o=e<0?s[~e]:s[e];return e<0?(o=o.slice(0,0===i?o.length:o.length-1)).reverse():i&&(o=o.slice(1)),t.concat(o)},[]):t.map(o),r=i.geometries,a=[];for(let t=0,e=r.length;t<e;++t)a.push({type:"Feature",properties:r[t].properties,geometry:{type:r[t].type,coordinates:r[t].coordinates||o(r[t].arcs)}});let n={type:"FeatureCollection",copyright:t.copyright,copyrightShort:t.copyrightShort,copyrightUrl:t.copyrightUrl,features:a,"hc-recommended-mapview":i["hc-recommended-mapview"],bbox:t.bbox,title:t.title};return i["hc-decoded-geojson"]=n,n}function c(t,e){e=l(!0,this.options.credits,e),this.mapCredits&&(e.href=void 0),t.call(this,e),this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})}t.compose=function(t){let o=t.prototype;o.transformFromLatLon||(o.fromLatLonToPoint=e,o.fromPointToLatLon=i,o.transformFromLatLon=s,o.transformToLatLon=p,h(o,"addCredits",c))},t.geojson=function(t,e="map",i){let s=[],o="Topology"===t.type?d(t):t,a=o.features;for(let t=0,i=a.length;t<i;++t){let i;let o=a[t],r=o.geometry||{},l=r.type,h=r.coordinates,p=o.properties;if(("map"===e||"mapbubble"===e)&&("Polygon"===l||"MultiPolygon"===l)?h.length&&(i={geometry:{coordinates:h,type:l}}):"mapline"===e&&("LineString"===l||"MultiLineString"===l)?h.length&&(i={geometry:{coordinates:h,type:l}}):"mappoint"===e&&"Point"===l&&h.length&&(i={geometry:{coordinates:h,type:l}}),i){let t=p&&(p.name||p.NAME),e=p&&p.lon,o=p&&p.lat;s.push(n(i,{lat:"number"==typeof o?o:void 0,lon:"number"==typeof e?e:void 0,name:"string"==typeof t?t:void 0,properties:p}))}}return i&&o.copyrightShort&&(i.chart.mapCredits=r(i.chart.options.credits?.mapText,{geojson:o}),i.chart.mapCreditsFull=r(i.chart.options.credits?.mapTextFull,{geojson:o})),s},t.topo2geo=d}(s||(s={})),s}),i(e,"Core/Geometry/PolygonClip.js",[],function(){function t(t,s,o=!0){let r=s[s.length-1],a,n,l,h=t;for(let t=0;t<s.length;t++){let p=h;a=s[t],h=[],n=o?p[p.length-1]:p[0];for(let t=0;t<p.length;t++)e(r,a,l=p[t])?(e(r,a,n)||h.push(i(r,a,n,l)),h.push(l)):e(r,a,n)&&h.push(i(r,a,n,l)),n=l;r=a}return h}function e(t,e,i){return(e[0]-t[0])*(i[1]-t[1])>(e[1]-t[1])*(i[0]-t[0])}function i(t,e,i,s){let o=[t[0]-e[0],t[1]-e[1]],r=[i[0]-s[0],i[1]-s[1]],a=t[0]*e[1]-t[1]*e[0],n=i[0]*s[1]-i[1]*s[0],l=1/(o[0]*r[1]-o[1]*r[0]),h=[(a*r[0]-n*o[0])*l,(a*r[1]-n*o[1])*l];return h.isIntersection=!0,h}return{clipLineString:function(e,i){let s=[],o=t(e,i,!1);for(let t=1;t<o.length;t++)o[t].isIntersection&&o[t-1].isIntersection&&(s.push(o.splice(0,t)),t=0),t===o.length-1&&s.push(o);return s},clipPolygon:t}}),i(e,"Maps/Projections/LambertConformalConic.js",[],function(){let t=Math.sign||(t=>0===t?0:t>0?1:-1),e=Math.PI/180,i=Math.PI/2,s=t=>Math.tan((i+t)/2);return class{constructor(i){let o=(i.parallels||[]).map(t=>t*e),r=o[0]||0,a=o[1]??r,n=Math.cos(r);"object"==typeof i.projectedBounds&&(this.projectedBounds=i.projectedBounds);let l=r===a?Math.sin(r):Math.log(n/Math.cos(a))/Math.log(s(a)/s(r));1e-10>Math.abs(l)&&(l=1e-10*(t(l)||1)),this.n=l,this.c=n*Math.pow(s(r),l)/l}forward(t){let{c:o,n:r,projectedBounds:a}=this,n=t[0]*e,l=t[1]*e;o>0?l<-i+1e-6&&(l=-i+1e-6):l>i-1e-6&&(l=i-1e-6);let h=o/Math.pow(s(l),r),p=h*Math.sin(r*n)*63.78137,d=(o-h*Math.cos(r*n))*63.78137,c=[p,d];return a&&(p<a.x1||p>a.x2||d<a.y1||d>a.y2)&&(c.outside=!0),c}inverse(s){let{c:o,n:r}=this,a=s[0]/63.78137,n=o-s[1]/63.78137,l=t(r)*Math.sqrt(a*a+n*n),h=Math.atan2(a,Math.abs(n))*t(n);return n*r<0&&(h-=Math.PI*t(a)*t(n)),[h/r/e,(2*Math.atan(Math.pow(o/l,1/r))-i)/e]}}}),i(e,"Maps/Projections/EqualEarth.js",[],function(){let t=Math.sqrt(3)/2;return class{constructor(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-97.52595454902263,y2:97.52595454902263}}forward(e){let i=Math.PI/180,s=Math.asin(t*Math.sin(e[1]*i)),o=s*s,r=o*o*o;return[e[0]*i*Math.cos(s)*74.03120656864502/(t*(1.340264+-.24331799999999998*o+r*(.0062510000000000005+.034164*o))),74.03120656864502*s*(1.340264+-.081106*o+r*(893e-6+.003796*o))]}inverse(e){let i=e[0]/74.03120656864502,s=e[1]/74.03120656864502,o=180/Math.PI,r=s,a,n,l,h;for(let t=0;t<12&&(n=(a=r*r)*a*a,l=r*(1.340264+-.081106*a+n*(893e-6+.003796*a))-s,r-=h=l/(1.340264+-.24331799999999998*a+n*(.0062510000000000005+.034164*a)),!(1e-9>Math.abs(h)));++t);n=(a=r*r)*a*a;let p=o*t*i*(1.340264+-.24331799999999998*a+n*(.0062510000000000005+.034164*a))/Math.cos(r),d=o*Math.asin(Math.sin(r)/t);return Math.abs(p)>180?[NaN,NaN]:[p,d]}}}),i(e,"Maps/Projections/Miller.js",[],function(){let t=Math.PI/4,e=Math.PI/180;return class{constructor(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-146.91480769173063,y2:146.91480769173063}}forward(i){return[i[0]*e*63.78137,79.7267125*Math.log(Math.tan(t+.4*i[1]*e))]}inverse(i){return[i[0]/63.78137/e,2.5*(Math.atan(Math.exp(i[1]/63.78137*.8))-t)/e]}}}),i(e,"Maps/Projections/Orthographic.js",[],function(){let t=Math.PI/180;return class{constructor(){this.antimeridianCutting=!1,this.bounds={x1:-63.78460826781007,x2:63.78460826781007,y1:-63.78460826781007,y2:63.78460826781007}}forward(e){let i=e[0],s=e[1]*t,o=[Math.cos(s)*Math.sin(i*t)*63.78460826781007,63.78460826781007*Math.sin(s)];return(i<-90||i>90)&&(o.outside=!0),o}inverse(e){let i=e[0]/63.78460826781007,s=e[1]/63.78460826781007,o=Math.sqrt(i*i+s*s),r=Math.asin(o),a=Math.sin(r);return[Math.atan2(i*a,o*Math.cos(r))/t,Math.asin(o&&s*a/o)/t]}}}),i(e,"Maps/Projections/WebMercator.js",[],function(){let t=Math.PI/180;return class{constructor(){this.bounds={x1:-200.37508342789243,x2:200.37508342789243,y1:-200.3750834278071,y2:200.3750834278071},this.maxLatitude=85.0511287798}forward(e){let i=Math.sin(e[1]*t),s=[63.78137*e[0]*t,63.78137*Math.log((1+i)/(1-i))/2];return Math.abs(e[1])>this.maxLatitude&&(s.outside=!0),s}inverse(e){return[e[0]/(63.78137*t),(2*Math.atan(Math.exp(e[1]/63.78137))-Math.PI/2)/t]}}}),i(e,"Maps/Projections/ProjectionRegistry.js",[e["Maps/Projections/LambertConformalConic.js"],e["Maps/Projections/EqualEarth.js"],e["Maps/Projections/Miller.js"],e["Maps/Projections/Orthographic.js"],e["Maps/Projections/WebMercator.js"]],function(t,e,i,s,o){return{EqualEarth:e,LambertConformalConic:t,Miller:i,Orthographic:s,WebMercator:o}}),i(e,"Maps/Projection.js",[e["Core/Geometry/PolygonClip.js"],e["Maps/Projections/ProjectionRegistry.js"],e["Core/Utilities.js"]],function(t,e,i){let{clipLineString:s,clipPolygon:o}=t,{clamp:r,erase:a}=i,n=2*Math.PI/360;function l(t){return t<-180&&(t+=360),t>180&&(t-=360),t}class h{static add(t,e){h.registry[t]=e}static greatCircle(t,e,i){let{atan2:s,cos:o,sin:r,sqrt:a}=Math,l=t[1]*n,h=t[0]*n,p=e[1]*n,d=e[0]*n,c=p-l,u=d-h,m=r(c/2)*r(c/2)+o(l)*o(p)*r(u/2)*r(u/2),g=2*s(a(m),a(1-m)),f=Math.round(6371e3*g/5e5),b=[];if(i&&b.push(t),f>1){let t=1/f;for(let e=t;e<.999;e+=t){let t=r((1-e)*g)/r(g),i=r(e*g)/r(g),c=t*o(l)*o(h)+i*o(p)*o(d),u=t*o(l)*r(h)+i*o(p)*r(d),m=s(t*r(l)+i*r(p),a(c*c+u*u)),f=s(u,c);b.push([f/n,m/n])}}return i&&b.push(e),b}static insertGreatCircles(t){let e=t.length-1;for(;e--;)if(Math.max(Math.abs(t[e][0]-t[e+1][0]),Math.abs(t[e][1]-t[e+1][1]))>10){let i=h.greatCircle(t[e],t[e+1]);i.length&&t.splice(e+1,0,...i)}}static toString(t){let{name:e,rotation:i}=t||{};return[e,i&&i.join(",")].join(";")}constructor(t={}){this.hasCoordinates=!1,this.hasGeoProjection=!1,this.maxLatitude=90,this.options=t;let{name:e,projectedBounds:i,rotation:s}=t;this.rotator=s?this.getRotator(s):void 0;let o=e?h.registry[e]:void 0;o&&(this.def=new o(t));let{def:r,rotator:a}=this;r&&(this.maxLatitude=r.maxLatitude||90,this.hasGeoProjection=!0),a&&r?(this.forward=t=>r.forward(a.forward(t)),this.inverse=t=>a.inverse(r.inverse(t))):r?(this.forward=t=>r.forward(t),this.inverse=t=>r.inverse(t)):a&&(this.forward=a.forward,this.inverse=a.inverse),this.bounds="world"===i?r&&r.bounds:i}lineIntersectsBounds(t){let{x1:e,x2:i,y1:s,y2:o}=this.bounds||{},r=(t,e,i)=>{let[s,o]=t,r=e?0:1;if("number"==typeof i&&s[e]>=i!=o[e]>=i){let t=(i-s[e])/(o[e]-s[e]),a=s[r]+t*(o[r]-s[r]);return e?[a,i]:[i,a]}},a,n=t[0];return(a=r(t,0,e))?(n=a,t[1]=a):(a=r(t,0,i))&&(n=a,t[1]=a),(a=r(t,1,s))?n=a:(a=r(t,1,o))&&(n=a),n}getRotator(t){let e=t[0]*n,i=(t[1]||0)*n,s=(t[2]||0)*n,o=Math.cos(i),r=Math.sin(i),a=Math.cos(s),l=Math.sin(s);if(0!==e||0!==i||0!==s)return{forward:t=>{let i=t[0]*n+e,s=t[1]*n,h=Math.cos(s),p=Math.cos(i)*h,d=Math.sin(i)*h,c=Math.sin(s),u=c*o+p*r;return[Math.atan2(d*a-u*l,p*o-c*r)/n,Math.asin(u*a+d*l)/n]},inverse:t=>{let i=t[0]*n,s=t[1]*n,h=Math.cos(s),p=Math.cos(i)*h,d=Math.sin(i)*h,c=Math.sin(s),u=c*a-d*l;return[(Math.atan2(d*a+c*l,p*o+u*r)-e)/n,Math.asin(u*o-p*r)/n]}}}forward(t){return t}inverse(t){return t}cutOnAntimeridian(t,e){let i;let s=[],o=[t];for(let i=0,o=t.length;i<o;++i){let o=t[i],a=t[i-1];if(!i){if(!e)continue;a=t[t.length-1]}let n=a[0],l=o[0];if((n<-90||n>90)&&(l<-90||l>90)&&n>0!=l>0){let t=r((180-(n+360)%360)/((l+360)%360-(n+360)%360),0,1),e=a[1]+t*(o[1]-a[1]);s.push({i,lat:e,direction:n<0?1:-1,previousLonLat:a,lonLat:o})}}if(s.length){if(e){s.length%2==1&&(i=s.slice().sort((t,e)=>Math.abs(e.lat)-Math.abs(t.lat))[0],a(s,i));let e=s.length-2;for(;e>=0;){let i=s[e].i,r=l(180+1e-6*s[e].direction),a=l(180-1e-6*s[e].direction),n=t.splice(i,s[e+1].i-i,...h.greatCircle([r,s[e].lat],[r,s[e+1].lat],!0));n.push(...h.greatCircle([a,s[e+1].lat],[a,s[e].lat],!0)),o.push(n),e-=2}if(i)for(let t=0;t<o.length;t++){let{direction:e,lat:s}=i,r=o[t],a=r.indexOf(i.lonLat);if(a>-1){let t=(s<0?-1:1)*this.maxLatitude,o=l(180+1e-6*e),n=l(180-1e-6*e),p=h.greatCircle([o,s],[o,t],!0);for(let i=o+120*e;i>-180&&i<180;i+=120*e)p.push([i,t]);p.push(...h.greatCircle([n,t],[n,i.lat],!0)),r.splice(a,0,...p);break}}}else{let e=s.length;for(;e--;){let i=s[e].i,r=t.splice(i,t.length,[l(180+1e-6*s[e].direction),s[e].lat]);r.unshift([l(180-1e-6*s[e].direction),s[e].lat]),o.push(r)}}}return o}path(t){let e;let{bounds:i,def:r,rotator:a}=this,n=[],l="Polygon"===t.type||"MultiPolygon"===t.type,p=this.hasGeoProjection,d=!r||!1!==r.antimeridianCutting,c=d?a:void 0,u=d&&r||this;i&&(e=[[i.x1,i.y1],[i.x2,i.y1],[i.x2,i.y2],[i.x1,i.y2]]);let m=t=>{let r=t.map(t=>{if(d){c&&(t=c.forward(t));let e=t[0];1e-6>Math.abs(e-180)&&(e=e<180?179.999999:180.000001),t=[e,t[1]]}return t}),a=[r];p&&(h.insertGreatCircles(r),d&&(a=this.cutOnAntimeridian(r,l))),a.forEach(t=>{let r,a;if(t.length<2)return;let c=!1,m=!1,g=t=>{c?n.push(["L",t[0],t[1]]):(n.push(["M",t[0],t[1]]),c=!0)},f=!1,b=!1,y=t.map(t=>{let e=u.forward(t);return e.outside?f=!0:b=!0,e[1]===1/0?e[1]=1e10:e[1]===-1/0&&(e[1]=-1e10),e});if(d){if(l&&y.push(y[0]),f){if(!b)return;if(e){if(l)y=o(y,e);else if(i){s(y,e).forEach(t=>{c=!1,t.forEach(g)});return}}}y.forEach(g)}else for(let e=0;e<y.length;e++){let i=t[e],s=y[e];s.outside?m=!0:(l&&!r&&(r=i,t.push(i),y.push(s)),m&&a&&(l&&p?h.greatCircle(a,i).forEach(t=>g(u.forward(t))):c=!1),g(s),a=i,m=!1)}})};return"LineString"===t.type?m(t.coordinates):"MultiLineString"===t.type?t.coordinates.forEach(t=>m(t)):"Polygon"===t.type?(t.coordinates.forEach(t=>m(t)),n.length&&n.push(["Z"])):"MultiPolygon"===t.type&&(t.coordinates.forEach(t=>{t.forEach(t=>m(t))}),n.length&&n.push(["Z"])),n}}return h.registry=e,h}),i(e,"Maps/MapView.js",[e["Core/Globals.js"],e["Maps/MapViewDefaults.js"],e["Maps/GeoJSONComposition.js"],e["Maps/MapUtilities.js"],e["Maps/Projection.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r){let{composed:a}=t,{topo2geo:n}=i,{boundsFromPath:l,pointInPolygon:h}=s,{addEvent:p,clamp:d,fireEvent:c,isArray:u,isNumber:m,isObject:g,isString:f,merge:b,pick:y,pushUnique:x,relativeLength:M}=r,C={};function j(t,e){let{width:i,height:s}=e;return Math.log(400.979322/Math.max((t.x2-t.x1)/(i/256),(t.y2-t.y1)/(s/256)))/Math.log(2)}function v(t){t.seriesOptions.mapData&&this.mapView?.recommendMapView(this,[this.options.chart.map,t.seriesOptions.mapData],this.options.drilldown?.mapZooming)}class w{static compose(t){x(a,"MapView")&&(C=t.maps,p(t,"afterInit",function(){this.mapView=new w(this,this.options.mapView)},{order:0}),p(t,"addSeriesAsDrilldown",v),p(t,"afterDrillUp",v))}static compositeBounds(t){if(t.length)return t.slice(1).reduce((t,e)=>(t.x1=Math.min(t.x1,e.x1),t.y1=Math.min(t.y1,e.y1),t.x2=Math.max(t.x2,e.x2),t.y2=Math.max(t.y2,e.y2),t),b(t[0]))}static mergeInsets(t,e){let i=t=>{let e={};return t.forEach((t,i)=>{e[t&&t.id||`i${i}`]=t}),e},s=b(i(t),i(e));return Object.keys(s).map(t=>s[t])}constructor(t,i){this.allowTransformAnimation=!0,this.eventsToUnbind=[],this.insets=[],this.padding=[0,0,0,0],this.recommendedMapView={},this instanceof S||this.recommendMapView(t,[t.options.chart.map,...(t.options.series||[]).map(t=>t.mapData)]),this.userOptions=i||{};let s=b(e,this.recommendedMapView,i),r=this.recommendedMapView?.insets,a=i&&i.insets;r&&a&&(s.insets=w.mergeInsets(r,a)),this.chart=t,this.center=s.center,this.options=s,this.projection=new o(s.projection),this.playingField=t.plotBox,this.zoom=s.zoom||0,this.minZoom=s.minZoom,this.createInsets(),this.eventsToUnbind.push(p(t,"afterSetChartSize",()=>{this.playingField=this.getField(),(void 0===this.minZoom||this.minZoom===this.zoom)&&(this.fitToBounds(void 0,void 0,!1),!this.chart.hasRendered&&m(this.userOptions.zoom)&&(this.zoom=this.userOptions.zoom),this.userOptions.center&&b(!0,this.center,this.userOptions.center))})),this.setUpEvents()}createInsets(){let t=this.options,e=t.insets;e&&e.forEach(e=>{let i=new S(this,b(t.insetOptions,e));this.insets.push(i)})}fitToBounds(t,e,i=!0,s){let o=t||this.getProjectedBounds();if(o){let r=y(e,t?0:this.options.padding),a=this.getField(!1),n=u(r)?r:[r,r,r,r];this.padding=[M(n[0],a.height),M(n[1],a.width),M(n[2],a.height),M(n[3],a.width)],this.playingField=this.getField();let l=j(o,this.playingField);t||(this.minZoom=l);let h=this.projection.inverse([(o.x2+o.x1)/2,(o.y2+o.y1)/2]);this.setView(h,l,i,s)}}getField(t=!0){let e=t?this.padding:[0,0,0,0];return{x:e[3],y:e[0],width:this.chart.plotWidth-e[1]-e[3],height:this.chart.plotHeight-e[0]-e[2]}}getGeoMap(t){if(f(t))return C[t]&&"Topology"===C[t].type?n(C[t]):C[t];if(g(t,!0)){if("FeatureCollection"===t.type)return t;if("Topology"===t.type)return n(t)}}getMapBBox(){let t=this.getProjectedBounds(),e=this.getScale();if(t){let i=this.padding,s=this.projectedUnitsToPixels({x:t.x1,y:t.y2});return{width:(t.x2-t.x1)*e+i[1]+i[3],height:(t.y2-t.y1)*e+i[0]+i[2],x:s.x-i[3],y:s.y-i[0]}}}getProjectedBounds(){let t=this.projection,e=this.chart.series.reduce((t,e)=>{let i=e.getProjectedBounds&&e.getProjectedBounds();return i&&!1!==e.options.affectsMapView&&t.push(i),t},[]),i=this.options.fitToGeometry;if(i){if(!this.fitToGeometryCache){if("MultiPoint"===i.type){let e=i.coordinates.map(e=>t.forward(e)),s=e.map(t=>t[0]),o=e.map(t=>t[1]);this.fitToGeometryCache={x1:Math.min.apply(0,s),x2:Math.max.apply(0,s),y1:Math.min.apply(0,o),y2:Math.max.apply(0,o)}}else this.fitToGeometryCache=l(t.path(i))}return this.fitToGeometryCache}return this.projection.bounds||w.compositeBounds(e)}getScale(){return 256/400.979322*Math.pow(2,this.zoom)}getSVGTransform(){let{x:t,y:e,width:i,height:s}=this.playingField,o=this.projection.forward(this.center),r=this.projection.hasCoordinates?-1:1,a=this.getScale(),n=a*r,l=t+i/2-o[0]*a,h=e+s/2-o[1]*n;return{scaleX:a,scaleY:n,translateX:l,translateY:h}}lonLatToPixels(t){let e=this.lonLatToProjectedUnits(t);if(e)return this.projectedUnitsToPixels(e)}lonLatToProjectedUnits(t){let e=this.chart,i=e.mapTransforms;if(i){for(let s in i)if(Object.hasOwnProperty.call(i,s)&&i[s].hitZone){let o=e.transformFromLatLon(t,i[s]);if(o&&h(o,i[s].hitZone.coordinates[0]))return o}return e.transformFromLatLon(t,i.default)}for(let e of this.insets)if(e.options.geoBounds&&h({x:t.lon,y:t.lat},e.options.geoBounds.coordinates[0])){let i=e.projection.forward([t.lon,t.lat]),s=e.projectedUnitsToPixels({x:i[0],y:i[1]});return this.pixelsToProjectedUnits(s)}let s=this.projection.forward([t.lon,t.lat]);if(!s.outside)return{x:s[0],y:s[1]}}projectedUnitsToLonLat(t){let e=this.chart,i=e.mapTransforms;if(i){for(let s in i)if(Object.hasOwnProperty.call(i,s)&&i[s].hitZone&&h(t,i[s].hitZone.coordinates[0]))return e.transformToLatLon(t,i[s]);return e.transformToLatLon(t,i.default)}let s=this.projectedUnitsToPixels(t);for(let t of this.insets)if(t.hitZone&&h(s,t.hitZone.coordinates[0])){let e=t.pixelsToProjectedUnits(s),i=t.projection.inverse([e.x,e.y]);return{lon:i[0],lat:i[1]}}let o=this.projection.inverse([t.x,t.y]);return{lon:o[0],lat:o[1]}}recommendMapView(t,e,i=!1){this.recommendedMapView={};let s=e.map(t=>this.getGeoMap(t)),o=[];s.forEach(t=>{if(t&&(Object.keys(this.recommendedMapView).length||(this.recommendedMapView=t["hc-recommended-mapview"]||{}),t.bbox)){let[e,i,s,r]=t.bbox;o.push({x1:e,y1:i,x2:s,y2:r})}});let r=o.length&&w.compositeBounds(o);c(this,"onRecommendMapView",{geoBounds:r,chart:t},function(){if(r&&this.recommendedMapView){if(!this.recommendedMapView.projection){let{x1:t,y1:e,x2:i,y2:s}=r;this.recommendedMapView.projection=i-t>180&&s-e>90?{name:"EqualEarth",parallels:[0,0],rotation:[0]}:{name:"LambertConformalConic",parallels:[e,s],rotation:[-(t+i)/2]}}this.recommendedMapView.insets||(this.recommendedMapView.insets=void 0)}}),this.geoMap=s[0],i&&t.hasRendered&&!t.userOptions.mapView?.projection&&this.recommendedMapView&&this.update(this.recommendedMapView)}redraw(t){this.chart.series.forEach(t=>{t.useMapGeometry&&(t.isDirty=!0)}),this.chart.redraw(t)}setView(t,e,i=!0,s){t&&(this.center=t),"number"==typeof e&&("number"==typeof this.minZoom&&(e=Math.max(e,this.minZoom)),"number"==typeof this.options.maxZoom&&(e=Math.min(e,this.options.maxZoom)),m(e)&&(this.zoom=e));let o=this.getProjectedBounds();if(o){let t=this.projection.forward(this.center),{x:e,y:i,width:s,height:r}=this.playingField,a=this.getScale(),n=this.projectedUnitsToPixels({x:o.x1,y:o.y1}),l=this.projectedUnitsToPixels({x:o.x2,y:o.y2}),h=[(o.x1+o.x2)/2,(o.y1+o.y2)/2];if(!this.chart.series.some(t=>t.isDrilling)){let o=n.x,p=l.y,d=l.x,c=n.y;d-o<s?t[0]=h[0]:o<e&&d<e+s?t[0]+=Math.max(o-e,d-s-e)/a:d>e+s&&o>e&&(t[0]+=Math.min(d-s-e,o-e)/a),c-p<r?t[1]=h[1]:p<i&&c<i+r?t[1]-=Math.max(p-i,c-r-i)/a:c>i+r&&p>i&&(t[1]-=Math.min(c-r-i,p-i)/a),this.center=this.projection.inverse(t)}this.insets.forEach(t=>{t.options.field&&(t.hitZone=t.getHitZone(),t.playingField=t.getField())}),this.render()}c(this,"afterSetView"),i&&this.redraw(s)}projectedUnitsToPixels(t){let e=this.getScale(),i=this.projection.forward(this.center),s=this.playingField,o=s.x+s.width/2,r=s.y+s.height/2;return{x:o-e*(i[0]-t.x),y:r+e*(i[1]-t.y)}}pixelsToLonLat(t){return this.projectedUnitsToLonLat(this.pixelsToProjectedUnits(t))}pixelsToProjectedUnits(t){let{x:e,y:i}=t,s=this.getScale(),o=this.projection.forward(this.center),r=this.playingField,a=r.x+r.width/2,n=r.y+r.height/2;return{x:o[0]+(e-a)/s,y:o[1]-(i-n)/s}}setUpEvents(){let t,e,i;let{chart:s}=this,o=o=>{let{lastTouches:r,pinchDown:a}=s.pointer,n=this.projection,l=o.touches,{mouseDownX:h,mouseDownY:p}=s,c=0;if(a?.length===1?(h=a[0].chartX,p=a[0].chartY):a?.length===2&&(h=(a[0].chartX+a[1].chartX)/2,p=(a[0].chartY+a[1].chartY)/2),l?.length===2&&r&&(c=Math.log(Math.sqrt(Math.pow(r[0].chartX-r[1].chartX,2)+Math.pow(r[0].chartY-r[1].chartY,2))/Math.sqrt(Math.pow(l[0].chartX-l[1].chartX,2)+Math.pow(l[0].chartY-l[1].chartY,2)))/Math.log(.5)),m(h)&&m(p)){let r=`${h},${p}`,{chartX:a,chartY:u}=o.originalEvent;l?.length===2&&(a=(l[0].chartX+l[1].chartX)/2,u=(l[0].chartY+l[1].chartY)/2),r!==e&&(e=r,t=this.projection.forward(this.center),i=(this.projection.options.rotation||[0,0]).slice());let g=n.def&&n.def.bounds,f=g&&j(g,this.playingField)||-1/0;if("Orthographic"===n.options.name&&2>(l?.length||0)&&(this.minZoom||1/0)<1.3*f){let t=440/(this.getScale()*Math.min(s.plotWidth,s.plotHeight));if(i){let e=(h-a)*t-i[0],o=d(-i[1]-(p-u)*t,-80,80),r=this.zoom;this.update({projection:{rotation:[-e,-o]}},!1),this.fitToBounds(void 0,void 0,!1),this.zoom=r,s.redraw(!1)}}else if(m(a)&&m(u)){let e=this.getScale(),i=this.projection.hasCoordinates?1:-1,s=this.projection.inverse([t[0]+(h-a)/e,t[1]-(p-u)/e*i]);isNaN(s[0]+s[1])||this.zoomBy(c,s,void 0,!1)}o.preventDefault()}};p(s,"pan",o),p(s,"touchpan",o),p(s,"selection",t=>{if(t.resetSelection)this.zoomBy();else{let e=t.x-s.plotLeft,i=t.y-s.plotTop,{y:o,x:r}=this.pixelsToProjectedUnits({x:e,y:i}),{y:a,x:n}=this.pixelsToProjectedUnits({x:e+t.width,y:i+t.height});this.fitToBounds({x1:r,y1:o,x2:n,y2:a},void 0,!0,!t.originalEvent.touches&&void 0),/^touch/.test(t.originalEvent.type)||s.showResetZoom(),t.preventDefault()}})}render(){this.group||(this.group=this.chart.renderer.g("map-view").attr({zIndex:4}).add())}update(t,e=!0,i){let s=t.projection,r=s&&o.toString(s)!==o.toString(this.options.projection),a=!1;b(!0,this.userOptions,t),b(!0,this.options,t),"insets"in t&&(this.insets.forEach(t=>t.destroy()),this.insets.length=0,a=!0),(r||"fitToGeometry"in t)&&delete this.fitToGeometryCache,(r||a)&&(this.chart.series.forEach(t=>{let e=t.transformGroups;if(t.clearBounds&&t.clearBounds(),t.isDirty=!0,t.isDirtyData=!0,a&&e)for(;e.length>1;){let t=e.pop();t&&t.destroy()}}),r&&(this.projection=new o(this.options.projection)),a&&this.createInsets(),!t.center&&Object.hasOwnProperty.call(t,"zoom")&&!m(t.zoom)&&this.fitToBounds(void 0,void 0,!1)),t.center||m(t.zoom)?this.setView(this.options.center,t.zoom,!1):"fitToGeometry"in t&&this.fitToBounds(void 0,void 0,!1),e&&this.chart.redraw(i)}zoomBy(t,e,i,s){let o=this.chart,r=this.projection.forward(this.center);if("number"==typeof t){let a,n,l;let h=this.zoom+t;if(i){let[t,e]=i,s=this.getScale(),a=t-o.plotLeft-o.plotWidth/2,h=e-o.plotTop-o.plotHeight/2;n=r[0]+a/s,l=r[1]+h/s}if("number"==typeof n&&"number"==typeof l){let t=1-Math.pow(2,this.zoom)/Math.pow(2,h),e=r[0]-n,i=r[1]-l;r[0]-=e*t,r[1]+=i*t,a=this.projection.inverse(r)}this.setView(e||a,h,void 0,s)}else this.fitToBounds(void 0,void 0,void 0,s)}}class S extends w{constructor(t,e){if(super(t.chart,e),this.id=e.id,this.mapView=t,this.options=b({center:[0,0]},t.options.insetOptions,e),this.allBounds=[],this.options.geoBounds){let e=t.projection.path(this.options.geoBounds);this.geoBoundsProjectedBox=l(e),this.geoBoundsProjectedPolygon=e.map(t=>[t[1]||0,t[2]||0])}}getField(t=!0){let e=this.hitZone;if(e){let i=t?this.padding:[0,0,0,0],s=e.coordinates[0],o=s.map(t=>t[0]),r=s.map(t=>t[1]),a=Math.min.apply(0,o)+i[3],n=Math.max.apply(0,o)-i[1],l=Math.min.apply(0,r)+i[0],h=Math.max.apply(0,r)-i[2];if(m(a)&&m(l))return{x:a,y:l,width:n-a,height:h-l}}return super.getField.call(this,t)}getHitZone(){let{chart:t,mapView:e,options:i}=this,{coordinates:s}=i.field||{};if(s){let o=s[0];if("percent"===i.units){let s="mapBoundingBox"===i.relativeTo&&e.getMapBBox()||b(t.plotBox,{x:0,y:0});o=o.map(t=>[M(`${t[0]}%`,s.width,s.x),M(`${t[1]}%`,s.height,s.y)])}return{type:"Polygon",coordinates:[o]}}}getProjectedBounds(){return w.compositeBounds(this.allBounds)}isInside(t){let{geoBoundsProjectedBox:e,geoBoundsProjectedPolygon:i}=this;return!!(e&&t.x>=e.x1&&t.x<=e.x2&&t.y>=e.y1&&t.y<=e.y2&&i&&h(t,i))}render(){let{chart:t,mapView:e,options:i}=this,s=i.borderPath||i.field;if(s&&e.group){let o=!0;this.border||(this.border=t.renderer.path().addClass("highcharts-mapview-inset-border").add(e.group),o=!1),t.styledMode||this.border.attr({stroke:i.borderColor,"stroke-width":i.borderWidth});let r=Math.round(this.border.strokeWidth())%2/2,a="mapBoundingBox"===i.relativeTo&&e.getMapBBox()||e.playingField,n=(s.coordinates||[]).reduce((e,s)=>s.reduce((e,s,o)=>{let[n,l]=s;return"percent"===i.units&&(n=t.plotLeft+M(`${n}%`,a.width,a.x),l=t.plotTop+M(`${l}%`,a.height,a.y)),n=Math.floor(n)+r,l=Math.floor(l)+r,e.push(0===o?["M",n,l]:["L",n,l]),e},e),[]);this.border[o?"animate":"attr"]({d:n})}}destroy(){this.border&&(this.border=this.border.destroy()),this.eventsToUnbind.forEach(t=>t())}setUpEvents(){}}return w}),i(e,"Series/Map/MapSeries.js",[e["Core/Animation/AnimationUtilities.js"],e["Series/ColorMapComposition.js"],e["Series/CenteredUtilities.js"],e["Core/Globals.js"],e["Core/Chart/MapChart.js"],e["Series/Map/MapPoint.js"],e["Series/Map/MapSeriesDefaults.js"],e["Maps/MapView.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r,a,n,l,h){let{animObject:p,stop:d}=t,{noop:c}=s,{splitPath:u}=o,{column:m,scatter:g}=l.seriesTypes,{extend:f,find:b,fireEvent:y,getNestedProperty:x,isArray:M,defined:C,isNumber:j,isObject:v,merge:w,objectEach:S,pick:P,splat:L}=h;class A extends g{constructor(){super(...arguments),this.processedData=[]}animate(t){let{chart:e,group:i}=this,s=p(this.options.animation);t?i.attr({translateX:e.plotLeft+e.plotWidth/2,translateY:e.plotTop+e.plotHeight/2,scaleX:.001,scaleY:.001}):i.animate({translateX:e.plotLeft,translateY:e.plotTop,scaleX:1,scaleY:1},s)}clearBounds(){this.points.forEach(t=>{delete t.bounds,delete t.insetIndex,delete t.projectedPath}),delete this.bounds}doFullTranslate(){return!!(this.isDirtyData||this.chart.isResizing||!this.hasRendered)}drawMapDataLabels(){super.drawDataLabels(),this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)}drawPoints(){let t=this,{chart:e,group:i,transformGroups:s=[]}=this,{mapView:o,renderer:r}=e;if(o){this.transformGroups=s,s[0]||(s[0]=r.g().add(i));for(let t=0,e=o.insets.length;t<e;++t)s[t+1]||s.push(r.g().add(i));this.doFullTranslate()&&(this.points.forEach(t=>{let{graphic:e}=t;t.group=s["number"==typeof t.insetIndex?t.insetIndex+1:0],e&&e.parentGroup!==t.group&&e.add(t.group)}),m.prototype.drawPoints.apply(this),this.points.forEach(i=>{let s=i.graphic;if(s){let o=s.animate,r="";i.name&&(r+="highcharts-name-"+i.name.replace(/ /g,"-").toLowerCase()),i.properties&&i.properties["hc-key"]&&(r+=" highcharts-key-"+i.properties["hc-key"].toString().toLowerCase()),r&&s.addClass(r),e.styledMode&&s.css(this.pointAttribs(i,i.selected&&"select"||void 0)),s.attr({visibility:!i.visible&&(i.visible||i.isNull)?"hidden":"inherit"}),s.animate=function(i,r,a){let n=j(i["stroke-width"])&&!j(s["stroke-width"]),l=j(s["stroke-width"])&&!j(i["stroke-width"]);if(n||l){let o=P(t.getStrokeWidth(t.options),1)/(e.mapView&&e.mapView.getScale()||1);n&&(s["stroke-width"]=o),l&&(i["stroke-width"]=o)}return o.call(s,i,r,l?function(){s.element.removeAttribute("stroke-width"),delete s["stroke-width"],a&&a.apply(this,arguments)}:a)}}})),s.forEach((i,s)=>{let a=(0===s?o:o.insets[s-1]).getSVGTransform(),n=P(this.getStrokeWidth(this.options),1),l=a.scaleX,h=a.scaleY>0?1:-1,c=e=>{(t.points||[]).forEach(t=>{let i;let s=t.graphic;s&&s["stroke-width"]&&(i=this.getStrokeWidth(t.options))&&s.attr({"stroke-width":i/e})})};if(r.globalAnimation&&e.hasRendered&&o.allowTransformAnimation){let t=Number(i.attr("translateX")),e=Number(i.attr("translateY")),s=Number(i.attr("scaleX")),o=(o,r)=>{let p=s+(l-s)*r.pos;i.attr({translateX:t+(a.translateX-t)*r.pos,translateY:e+(a.translateY-e)*r.pos,scaleX:p,scaleY:p*h,"stroke-width":n/p}),c(p)},d=w(p(r.globalAnimation)),u=d.step;d.step=function(){u&&u.apply(this,arguments),o.apply(this,arguments)},i.attr({animator:0}).animate({animator:1},d,(function(){"boolean"!=typeof r.globalAnimation&&r.globalAnimation.complete&&r.globalAnimation.complete({applyDrilldown:!0}),y(this,"mapZoomComplete")}).bind(this))}else d(i),i.attr(w(a,{"stroke-width":n/l})),c(l)}),this.isDrilling||this.drawMapDataLabels()}}getProjectedBounds(){if(!this.bounds&&this.chart.mapView){let{insets:t,projection:e}=this.chart.mapView,i=[];(this.points||[]).forEach(s=>{if(s.path||s.geometry){if("string"==typeof s.path?s.path=u(s.path):M(s.path)&&"M"===s.path[0]&&(s.path=this.chart.renderer.pathToSegments(s.path)),!s.bounds){let i=s.getProjectedBounds(e);if(i){s.labelrank=P(s.labelrank,(i.x2-i.x1)*(i.y2-i.y1));let{midX:e,midY:o}=i;if(t&&j(e)&&j(o)){let r=b(t,t=>t.isInside({x:e,y:o}));r&&(delete s.projectedPath,(i=s.getProjectedBounds(r.projection))&&r.allBounds.push(i),s.insetIndex=t.indexOf(r))}s.bounds=i}}s.bounds&&void 0===s.insetIndex&&i.push(s.bounds)}}),this.bounds=n.compositeBounds(i)}return this.bounds}getStrokeWidth(t){let e=this.pointAttrToOptions;return t[e&&e["stroke-width"]||"borderWidth"]}hasData(){return!!this.processedXData.length}pointAttribs(t,e){let{mapView:i,styledMode:s}=t.series.chart,o=s?this.colorAttribs(t):m.prototype.pointAttribs.call(this,t,e),r=this.getStrokeWidth(t.options);if(e){let i=w(this.options.states&&this.options.states[e],t.options.states&&t.options.states[e]||{}),s=this.getStrokeWidth(i);C(s)&&(r=s),o.stroke=i.borderColor??t.color}r&&i&&(r/=i.getScale());let a=this.getStrokeWidth(this.options);return o.dashstyle&&i&&j(a)&&(r=a/i.getScale()),t.visible||(o.fill=this.options.nullColor),C(r)?o["stroke-width"]=r:delete o["stroke-width"],o["stroke-linecap"]=o["stroke-linejoin"]=this.options.linecap,o}updateData(){return!this.processedData&&super.updateData.apply(this,arguments)}setData(t,e=!0,i,s){delete this.bounds,super.setData(t,!1,void 0,s),this.processData(),this.generatePoints(),e&&this.chart.redraw(i)}processData(){let t,e,i;let o=this.options,a=o.data,n=this.chart,l=n.options.chart,h=this.joinBy,p=o.keys||this.pointArrayMap,d=[],c={},u=this.chart.mapView,m=u&&(v(o.mapData,!0)?u.getGeoMap(o.mapData):u.geoMap),g=n.mapTransforms=l.mapTransforms||m&&m["hc-transform"]||n.mapTransforms;g&&S(g,t=>{t.rotation&&(t.cosAngle=Math.cos(t.rotation),t.sinAngle=Math.sin(t.rotation))}),M(o.mapData)?i=o.mapData:m&&"FeatureCollection"===m.type&&(this.mapTitle=m.title,i=s.geojson(m,this.type,this)),this.processedData=[];let f=this.processedData;if(a){let t;for(let e=0,i=a.length;e<i;++e){if(j(t=a[e]))f[e]={value:t};else if(M(t)){let i=0;f[e]={},!o.keys&&t.length>p.length&&"string"==typeof t[0]&&(f[e]["hc-key"]=t[0],++i);for(let s=0;s<p.length;++s,++i)p[s]&&void 0!==t[i]&&(p[s].indexOf(".")>0?r.prototype.setNestedProperty(f[e],t[i],p[s]):f[e][p[s]]=t[i])}else f[e]=a[e];h&&"_i"===h[0]&&(f[e]._i=e)}}if(i){this.mapData=i,this.mapMap={};for(let s=0;s<i.length;s++)e=(t=i[s]).properties,t._i=s,h[0]&&e&&e[h[0]]&&(t[h[0]]=e[h[0]]),c[t[h[0]]]=t;if(this.mapMap=c,h[1]){let t=h[1];f.forEach(e=>{let i=x(t,e);c[i]&&d.push(c[i])})}if(o.allAreas){if(h[1]){let t=h[1];f.forEach(e=>{d.push(x(t,e))})}let t="|"+d.map(function(t){return t&&t[h[0]]}).join("|")+"|";i.forEach(e=>{h[0]&&-1!==t.indexOf("|"+e[h[0]]+"|")||f.push(w(e,{value:null}))})}}this.processedXData=Array(f.length)}setOptions(t){let e=super.setOptions(t),i=e.joinBy;return null===e.joinBy&&(i="_i"),(i=this.joinBy=L(i))[1]||(i[1]=i[0]),e}translate(){let t=this.doFullTranslate(),e=this.chart.mapView,i=e&&e.projection;if(this.chart.hasRendered&&(this.isDirtyData||!this.hasRendered)&&(this.processData(),this.generatePoints(),delete this.bounds,!e||e.userOptions.center||j(e.userOptions.zoom)||e.zoom!==e.minZoom?this.getProjectedBounds():e.fitToBounds(void 0,void 0,!1)),e){let s=e.getSVGTransform();this.points.forEach(o=>{let a=j(o.insetIndex)&&e.insets[o.insetIndex].getSVGTransform()||s;a&&o.bounds&&j(o.bounds.midX)&&j(o.bounds.midY)&&(o.plotX=o.bounds.midX*a.scaleX+a.translateX,o.plotY=o.bounds.midY*a.scaleY+a.translateY),t&&(o.shapeType="path",o.shapeArgs={d:r.getProjectedPath(o,i)}),o.hiddenInDataClass||(o.projectedPath&&!o.projectedPath.length?o.setVisible(!1):o.visible||o.setVisible(!0))})}y(this,"afterTranslate")}update(t){t.mapData&&this.chart.mapView?.recommendMapView(this.chart,[this.chart.options.chart.map,...(this.chart.options.series||[]).map((e,i)=>i===this._i?t.mapData:e.mapData)],!0),super.update.apply(this,arguments)}}return A.defaultOptions=w(g.defaultOptions,a),f(A.prototype,{type:"map",axisTypes:e.seriesMembers.axisTypes,colorAttribs:e.seriesMembers.colorAttribs,colorKey:e.seriesMembers.colorKey,directTouch:!0,drawDataLabels:c,drawGraph:c,forceDL:!0,getCenter:i.getCenter,getExtremesFromAll:!0,getSymbol:c,isCartesian:!1,parallelArrays:e.seriesMembers.parallelArrays,pointArrayMap:e.seriesMembers.pointArrayMap,pointClass:r,preserveAspectRatio:!0,searchPoint:c,trackerGroups:e.seriesMembers.trackerGroups,useMapGeometry:!0}),e.compose(A),l.registerSeriesType("map",A),A}),i(e,"Series/MapLine/MapLineSeriesDefaults.js",[],function(){return{lineWidth:1,fillColor:"none",legendSymbol:"lineMarker"}}),i(e,"Series/MapLine/MapLineSeries.js",[e["Series/MapLine/MapLineSeriesDefaults.js"],e["Series/Map/MapSeries.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s){let{extend:o,merge:r}=s;class a extends e{pointAttribs(t,e){let i=super.pointAttribs(t,e);return i.fill=this.options.fillColor,i}}return a.defaultOptions=r(e.defaultOptions,t),o(a.prototype,{type:"mapline",colorProp:"stroke",pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"}}),i.registerSeriesType("mapline",a),a}),i(e,"Series/MapPoint/MapPointPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){let{scatter:i}=t.seriesTypes,{isNumber:s}=e;class o extends i.prototype.pointClass{isValid(){return!!(this.options.geometry||s(this.x)&&s(this.y)||s(this.options.lon)&&s(this.options.lat))}}return o}),i(e,"Series/MapPoint/MapPointSeriesDefaults.js",[],function(){return{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}},legendSymbol:"lineMarker"}}),i(e,"Series/MapPoint/MapPointSeries.js",[e["Core/Globals.js"],e["Series/MapPoint/MapPointPoint.js"],e["Series/MapPoint/MapPointSeriesDefaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r){let{noop:a}=t,{map:n,scatter:l}=s.seriesTypes,{extend:h,fireEvent:p,isNumber:d,merge:c}=r;class u extends l{constructor(){super(...arguments),this.clearBounds=n.prototype.clearBounds}drawDataLabels(){super.drawDataLabels(),this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)}projectPoint(t){let e=this.chart.mapView;if(e){let{geometry:i,lon:s,lat:o}=t,r=i&&"Point"===i.type&&i.coordinates;if(d(s)&&d(o)&&(r=[s,o]),r)return e.lonLatToProjectedUnits({lon:r[0],lat:r[1]})}}translate(){let t=this.chart.mapView;if(this.processedXData||this.processData(),this.generatePoints(),this.getProjectedBounds&&this.isDirtyData&&(delete this.bounds,this.getProjectedBounds()),t){let e=t.getSVGTransform(),{hasCoordinates:i}=t.projection;this.points.forEach(s=>{let o,{x:r,y:a}=s,n=d(s.insetIndex)&&t.insets[s.insetIndex].getSVGTransform()||e,l=this.projectPoint(s.options)||s.properties&&this.projectPoint(s.properties);if(l?(r=l.x,a=l.y):s.bounds&&(r=s.bounds.midX,a=s.bounds.midY,n&&d(r)&&d(a)&&(s.plotX=r*n.scaleX+n.translateX,s.plotY=a*n.scaleY+n.translateY,o=!0)),d(r)&&d(a)){if(!o){let e=t.projectedUnitsToPixels({x:r,y:a});s.plotX=e.x,s.plotY=i?e.y:this.chart.plotHeight-e.y}}else s.y=s.plotX=s.plotY=void 0;s.isInside=this.isPointInside(s),s.zone=this.zones.length?s.getZone():void 0})}p(this,"afterTranslate")}}return u.defaultOptions=c(l.defaultOptions,i),o.prototype.symbols.mapmarker=(t,e,i,s,o)=>{let r,a;let n=o&&"legend"===o.context;n?(r=t+i/2,a=e+s):o&&"number"==typeof o.anchorX&&"number"==typeof o.anchorY?(r=o.anchorX,a=o.anchorY):(r=t+i/2,a=e+s/2,e-=s);let l=n?s/3:s/2;return[["M",r,a],["C",r,a,r-l,e+1.5*l,r-l,e+l],["A",l,l,1,1,1,r+l,e+l],["C",r+l,e+1.5*l,r,a,r,a],["Z"]]},h(u.prototype,{type:"mappoint",axisTypes:["colorAxis"],forceDL:!0,isCartesian:!1,pointClass:e,searchPoint:a,useMapGeometry:!0}),s.registerSeriesType("mappoint",u),u}),i(e,"Series/Bubble/BubbleLegendDefaults.js",[],function(){return{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"0.9em",color:"#000000"},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}}),i(e,"Series/Bubble/BubbleLegendItem.js",[e["Core/Color/Color.js"],e["Core/Templating.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i,s){let{parse:o}=t,{noop:r}=i,{arrayMax:a,arrayMin:n,isNumber:l,merge:h,pick:p,stableSort:d}=s;return class{constructor(t,e){this.setState=r,this.init(t,e)}init(t,e){this.options=t,this.visible=!0,this.chart=e.chart,this.legend=e}addToLegend(t){t.splice(this.options.legendIndex,0,this)}drawLegendSymbol(t){let e;let i=p(t.options.itemDistance,20),s=this.legendItem||{},o=this.options,r=o.ranges,a=o.connectorDistance;if(!r||!r.length||!l(r[0].value)){t.options.bubbleLegend.autoRanges=!0;return}d(r,function(t,e){return e.value-t.value}),this.ranges=r,this.setOptions(),this.render();let n=this.getMaxLabelSize(),h=this.ranges[0].radius,c=2*h;e=(e=a-h+n.width)>0?e:0,this.maxLabel=n,this.movementX="left"===o.labels.align?e:0,s.labelWidth=c+e+i,s.labelHeight=c+n.height/2}setOptions(){let t=this.ranges,e=this.options,i=this.chart.series[e.seriesIndex],s=this.legend.baseline,r={zIndex:e.zIndex,"stroke-width":e.borderWidth},a={zIndex:e.zIndex,"stroke-width":e.connectorWidth},n={align:this.legend.options.rtl||"left"===e.labels.align?"right":"left",zIndex:e.zIndex},l=i.options.marker.fillOpacity,d=this.chart.styledMode;t.forEach(function(c,u){d||(r.stroke=p(c.borderColor,e.borderColor,i.color),r.fill=p(c.color,e.color,1!==l?o(i.color).setOpacity(l).get("rgba"):i.color),a.stroke=p(c.connectorColor,e.connectorColor,i.color)),t[u].radius=this.getRangeRadius(c.value),t[u]=h(t[u],{center:t[0].radius-t[u].radius+s}),d||h(!0,t[u],{bubbleAttribs:h(r),connectorAttribs:h(a),labelAttribs:n})},this)}getRangeRadius(t){let e=this.options,i=this.options.seriesIndex,s=this.chart.series[i],o=e.ranges[0].value,r=e.ranges[e.ranges.length-1].value,a=e.minSize,n=e.maxSize;return s.getRadius.call(this,r,o,a,n,t)}render(){let t=this.legendItem||{},e=this.chart.renderer,i=this.options.zThreshold;for(let s of(this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]}),t.symbol=e.g("bubble-legend"),t.label=e.g("bubble-legend-item").css(this.legend.itemStyle||{}),t.symbol.translateX=0,t.symbol.translateY=0,t.symbol.add(t.label),t.label.add(t.group),this.ranges))s.value>=i&&this.renderRange(s);this.hideOverlappingLabels()}renderRange(t){let e=this.ranges[0],i=this.legend,s=this.options,o=s.labels,r=this.chart,a=r.series[s.seriesIndex],n=r.renderer,l=this.symbols,h=l.labels,p=t.center,d=Math.abs(t.radius),c=s.connectorDistance||0,u=o.align,m=i.options.rtl,g=s.borderWidth,f=s.connectorWidth,b=e.radius||0,y=p-d-g/2+f/2,x=(y%1?1:.5)-(f%2?0:.5),M=n.styledMode,C=m||"left"===u?-c:c;"center"===u&&(C=0,s.connectorDistance=0,t.labelAttribs.align="center"),l.bubbleItems.push(n.circle(b,p+x,d).attr(M?{}:t.bubbleAttribs).addClass((M?"highcharts-color-"+a.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(s.className||"")).add(this.legendItem.symbol)),l.connectors.push(n.path(n.crispLine([["M",b,y],["L",b+C,y]],s.connectorWidth)).attr(M?{}:t.connectorAttribs).addClass((M?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(s.connectorClassName||"")).add(this.legendItem.symbol));let j=n.text(this.formatLabel(t)).attr(M?{}:t.labelAttribs).css(M?{}:o.style).addClass("highcharts-bubble-legend-labels "+(s.labels.className||"")).add(this.legendItem.symbol),v={x:b+C+s.labels.x,y:y+s.labels.y+.4*j.getBBox().height};j.attr(v),h.push(j),j.placed=!0,j.alignAttr=v}getMaxLabelSize(){let t,e;return this.symbols.labels.forEach(function(i){e=i.getBBox(!0),t=t?e.width>t.width?e:t:e}),t||{}}formatLabel(t){let i=this.options,s=i.labels.formatter,o=i.labels.format,{numberFormatter:r}=this.chart;return o?e.format(o,t):s?s.call(t):r(t.value,1)}hideOverlappingLabels(){let t=this.chart,e=this.options.labels.allowOverlap,i=this.symbols;!e&&i&&(t.hideOverlappingLabels(i.labels),i.labels.forEach(function(t,e){t.newOpacity?t.newOpacity!==t.oldOpacity&&i.connectors[e].show():i.connectors[e].hide()}))}getRanges(){let t=this.legend.bubbleLegend,e=t.chart.series,i=t.options.ranges,s,o,r=Number.MAX_VALUE,d=-Number.MAX_VALUE;return e.forEach(function(t){t.isBubble&&!t.ignoreSeries&&(o=t.zData.filter(l)).length&&(r=p(t.options.zMin,Math.min(r,Math.max(n(o),!1===t.options.displayNegative?t.options.zThreshold:-Number.MAX_VALUE))),d=p(t.options.zMax,Math.max(d,a(o))))}),s=r===d?[{value:d}]:[{value:r},{value:(r+d)/2},{value:d,autoRanges:!0}],i.length&&i[0].radius&&s.reverse(),s.forEach(function(t,e){i&&i[e]&&(s[e]=h(i[e],t))}),s}predictBubbleSizes(){let t=this.chart,e=t.legend.options,i=e.floating,s="horizontal"===e.layout,o=s?t.legend.lastLineHeight:0,r=t.plotSizeX,a=t.plotSizeY,n=t.series[this.options.seriesIndex],l=n.getPxExtremes(),h=Math.ceil(l.minPxSize),p=Math.ceil(l.maxPxSize),d,c=n.options.maxSize;return i||!/%$/.test(c)?d=p:(d=(Math.min(a,r)+o)*(c=parseFloat(c))/100/(c/100+1),(s&&a-d>=r||!s&&r-d>=a)&&(d=p)),[h,Math.ceil(d)]}updateRanges(t,e){let i=this.legend.options.bubbleLegend;i.minSize=t,i.maxSize=e,i.ranges=this.getRanges()}correctSizes(){let t=this.legend,e=this.chart.series[this.options.seriesIndex].getPxExtremes();Math.abs(Math.ceil(e.maxPxSize)-this.options.maxSize)>1&&(this.updateRanges(this.options.minSize,e.maxPxSize),t.render())}}}),i(e,"Series/Bubble/BubbleLegendComposition.js",[e["Series/Bubble/BubbleLegendDefaults.js"],e["Series/Bubble/BubbleLegendItem.js"],e["Core/Defaults.js"],e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e,i,s,o){let{setOptions:r}=i,{composed:a}=s,{addEvent:n,objectEach:l,pushUnique:h,wrap:p}=o;function d(t,e,i){let s,o,r;let a=this.legend,n=c(this)>=0;a&&a.options.enabled&&a.bubbleLegend&&a.options.bubbleLegend.autoRanges&&n?(s=a.bubbleLegend.options,o=a.bubbleLegend.predictBubbleSizes(),a.bubbleLegend.updateRanges(o[0],o[1]),s.placed||(a.group.placed=!1,a.allItems.forEach(t=>{(r=t.legendItem||{}).group&&(r.group.translateY=void 0)})),a.render(),this.getMargins(),this.axes.forEach(function(t){t.visible&&t.render(),s.placed||(t.setScale(),t.updateNames(),l(t.ticks,function(t){t.isNew=!0,t.isNewLabel=!0}))}),s.placed=!0,this.getMargins(),t.call(this,e,i),a.bubbleLegend.correctSizes(),f(a,u(a))):(t.call(this,e,i),a&&a.options.enabled&&a.bubbleLegend&&(a.render(),f(a,u(a))))}function c(t){let e=t.series,i=0;for(;i<e.length;){if(e[i]&&e[i].isBubble&&e[i].visible&&e[i].zData.length)return i;i++}return -1}function u(t){let e=t.allItems,i=[],s=e.length,o,r,a,n=0,l=0;for(n=0;n<s;n++)if(r=e[n].legendItem||{},a=(e[n+1]||{}).legendItem||{},r.labelHeight&&(e[n].itemHeight=r.labelHeight),e[n]===e[s-1]||r.y!==a.y){for(i.push({height:0}),o=i[i.length-1];l<=n;l++)e[l].itemHeight>o.height&&(o.height=e[l].itemHeight);o.step=n}return i}function m(t){let i=this.bubbleLegend,s=this.options,o=s.bubbleLegend,r=c(this.chart);i&&i.ranges&&i.ranges.length&&(o.ranges.length&&(o.autoRanges=!!o.ranges[0].autoRanges),this.destroyItem(i)),r>=0&&s.enabled&&o.enabled&&(o.seriesIndex=r,this.bubbleLegend=new e(o,this),this.bubbleLegend.addToLegend(t.allItems))}function g(t){let e;if(t.defaultPrevented)return!1;let i=this.chart,s=this.visible,o=this.chart.legend;o&&o.bubbleLegend&&(this.visible=!s,this.ignoreSeries=s,e=c(i)>=0,o.bubbleLegend.visible!==e&&(o.update({bubbleLegend:{enabled:e}}),o.bubbleLegend.visible=e),this.visible=s)}function f(t,e){let i=t.allItems,s=t.options.rtl,o,r,a,n,l=0;i.forEach((t,i)=>{(n=t.legendItem||{}).group&&(o=n.group.translateX||0,r=n.y||0,((a=t.movementX)||s&&t.ranges)&&(a=s?o-t.options.maxSize/2:o+a,n.group.attr({translateX:a})),i>e[l].step&&l++,n.group.attr({translateY:Math.round(r+e[l].height/2)}),n.y=r+e[l].height/2)})}return{compose:function(e,i,s){h(a,"Series.BubbleLegend")&&(r({legend:{bubbleLegend:t}}),p(e.prototype,"drawChartBox",d),n(i,"afterGetAllItems",m),n(s,"legendItemClick",g))}}}),i(e,"Series/Bubble/BubblePoint.js",[e["Core/Series/Point.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i){let{seriesTypes:{scatter:{prototype:{pointClass:s}}}}=e,{extend:o}=i;class r extends s{haloPath(e){return t.prototype.haloPath.call(this,0===e?0:(this.marker&&this.marker.radius||0)+e)}}return o(r.prototype,{ttBelow:!1}),r}),i(e,"Series/Bubble/BubbleSeries.js",[e["Series/Bubble/BubbleLegendComposition.js"],e["Series/Bubble/BubblePoint.js"],e["Core/Color/Color.js"],e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s,o,r){let{parse:a}=i,{composed:n,noop:l}=s,{series:h,seriesTypes:{column:{prototype:p},scatter:d}}=o,{addEvent:c,arrayMax:u,arrayMin:m,clamp:g,extend:f,isNumber:b,merge:y,pick:x,pushUnique:M}=r;function C(){let t=this.len,{coll:e,isXAxis:i,min:s}=this,o=i?"xData":"yData",r=(this.max||0)-(s||0),a=0,n=t,l=t/r,h;("xAxis"===e||"yAxis"===e)&&(this.series.forEach(t=>{if(t.bubblePadding&&t.reserveSpace()){this.allowZoomOutside=!0,h=!0;let e=t[o];if(i&&((t.onPoint||t).getRadii(0,0,t),t.onPoint&&(t.radii=t.onPoint.radii)),r>0){let i=e.length;for(;i--;)if(b(e[i])&&this.dataMin<=e[i]&&e[i]<=this.max){let o=t.radii&&t.radii[i]||0;a=Math.min((e[i]-s)*l-o,a),n=Math.max((e[i]-s)*l+o,n)}}}}),h&&r>0&&!this.logarithmic&&(n-=t,l*=(t+Math.max(0,a)-Math.min(n,t))/t,[["min","userMin",a],["max","userMax",n]].forEach(t=>{void 0===x(this.options[t[0]],this[t[1]])&&(this[t[0]]+=t[2]/l)})))}class j extends d{static compose(e,i,s,o){t.compose(i,s,o),M(n,"Series.Bubble")&&c(e,"foundExtremes",C)}animate(t){!t&&this.points.length<this.options.animationLimit&&this.points.forEach(function(t){let{graphic:e}=t;e&&e.width&&(this.hasRendered||e.attr({x:t.plotX,y:t.plotY,width:1,height:1}),e.animate(this.markerAttribs(t),this.options.animation))},this)}getRadii(){let t=this.zData,e=this.yData,i=[],s,o,r,a=this.chart.bubbleZExtremes,{minPxSize:n,maxPxSize:l}=this.getPxExtremes();if(!a){let t,e=Number.MAX_VALUE,i=-Number.MAX_VALUE;this.chart.series.forEach(s=>{if(s.bubblePadding&&s.reserveSpace()){let o=(s.onPoint||s).getZExtremes();o&&(e=Math.min(x(e,o.zMin),o.zMin),i=Math.max(x(i,o.zMax),o.zMax),t=!0)}}),t?(a={zMin:e,zMax:i},this.chart.bubbleZExtremes=a):a={zMin:0,zMax:0}}for(o=0,s=t.length;o<s;o++)r=t[o],i.push(this.getRadius(a.zMin,a.zMax,n,l,r,e&&e[o]));this.radii=i}getRadius(t,e,i,s,o,r){let a=this.options,n="width"!==a.sizeBy,l=a.zThreshold,h=e-t,p=.5;if(null===r||null===o)return null;if(b(o)){if(a.sizeByAbsoluteValue&&(o=Math.abs(o-l),e=h=Math.max(e-l,Math.abs(t-l)),t=0),o<t)return i/2-1;h>0&&(p=(o-t)/h)}return n&&p>=0&&(p=Math.sqrt(p)),Math.ceil(i+p*(s-i))/2}hasData(){return!!this.processedXData.length}pointAttribs(t,e){let i=this.options.marker.fillOpacity,s=h.prototype.pointAttribs.call(this,t,e);return 1!==i&&(s.fill=a(s.fill).setOpacity(i).get("rgba")),s}translate(){super.translate.call(this),this.getRadii(),this.translateBubble()}translateBubble(){let{data:t,options:e,radii:i}=this,{minPxSize:s}=this.getPxExtremes(),o=t.length;for(;o--;){let r=t[o],a=i?i[o]:0;"z"===this.zoneAxis&&(r.negative=(r.z||0)<(e.zThreshold||0)),b(a)&&a>=s/2?(r.marker=f(r.marker,{radius:a,width:2*a,height:2*a}),r.dlBox={x:r.plotX-a,y:r.plotY-a,width:2*a,height:2*a}):(r.shapeArgs=r.plotY=r.dlBox=void 0,r.isInside=!1)}}getPxExtremes(){let t=Math.min(this.chart.plotWidth,this.chart.plotHeight),e=e=>{let i;return"string"==typeof e&&(i=/%$/.test(e),e=parseInt(e,10)),i?t*e/100:e},i=e(x(this.options.minSize,8)),s=Math.max(e(x(this.options.maxSize,"20%")),i);return{minPxSize:i,maxPxSize:s}}getZExtremes(){let t=this.options,e=(this.zData||[]).filter(b);if(e.length){let i=x(t.zMin,g(m(e),!1===t.displayNegative?t.zThreshold||0:-Number.MAX_VALUE,Number.MAX_VALUE)),s=x(t.zMax,u(e));if(b(i)&&b(s))return{zMin:i,zMax:s}}}}return j.defaultOptions=y(d.defaultOptions,{dataLabels:{formatter:function(){let{numberFormatter:t}=this.series.chart,{z:e}=this.point;return b(e)?t(e,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"}),f(j.prototype,{alignDataLabel:p.alignDataLabel,applyZones:l,bubblePadding:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:e,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"}),c(j,"updatedData",t=>{delete t.target.chart.bubbleZExtremes}),c(j,"remove",t=>{delete t.target.chart.bubbleZExtremes}),o.registerSeriesType("bubble",j),j}),i(e,"Series/MapBubble/MapBubblePoint.js",[e["Series/Bubble/BubblePoint.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i){let{seriesTypes:{map:{prototype:{pointClass:{prototype:s}}}}}=e,{extend:o}=i;class r extends t{isValid(){return"number"==typeof this.z}}return o(r.prototype,{applyOptions:s.applyOptions,getProjectedBounds:s.getProjectedBounds}),r}),i(e,"Series/MapBubble/MapBubbleSeries.js",[e["Series/Bubble/BubbleSeries.js"],e["Series/MapBubble/MapBubblePoint.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e,i,s){let{seriesTypes:{map:{prototype:o},mappoint:{prototype:r}}}=i,{extend:a,merge:n}=s;class l extends t{constructor(){super(...arguments),this.clearBounds=o.clearBounds}searchPoint(t,e){return this.searchKDTree({plotX:t.chartX-this.chart.plotLeft,plotY:t.chartY-this.chart.plotTop},e,t)}translate(){r.translate.call(this),this.getRadii(),this.translateBubble()}updateParallelArrays(t,e,i){super.updateParallelArrays.call(this,t,e,i);let s=this.processedXData,o=this.xData;s&&o&&(s.length=o.length)}}return l.defaultOptions=n(t.defaultOptions,{lineWidth:0,animationLimit:500,joinBy:"hc-key",tooltip:{pointFormat:"{point.name}: {point.z}"}}),a(l.prototype,{type:"mapbubble",axisTypes:["colorAxis"],getProjectedBounds:o.getProjectedBounds,isCartesian:!1,pointArrayMap:["z"],pointClass:e,processData:o.processData,projectPoint:r.projectPoint,kdAxisArray:["plotX","plotY"],setData:o.setData,setOptions:o.setOptions,updateData:o.updateData,useMapGeometry:!0,xyFromShape:!0}),i.registerSeriesType("mapbubble",l),l}),i(e,"Series/Heatmap/HeatmapPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){let{scatter:{prototype:{pointClass:i}}}=t.seriesTypes,{clamp:s,defined:o,extend:r,pick:a}=e;class n extends i{applyOptions(t,e){return(this.isNull||null===this.value)&&delete this.color,super.applyOptions(t,e),this.formatPrefix=this.isNull||null===this.value?"null":"point",this}getCellAttributes(){let t=this.series,e=t.options,i=(e.colsize||1)/2,r=(e.rowsize||1)/2,n=t.xAxis,l=t.yAxis,h=this.options.marker||t.options.marker,p=t.pointPlacementToXValue(),d=a(this.pointPadding,e.pointPadding,0),c={x1:s(Math.round(n.len-n.translate(this.x-i,!1,!0,!1,!0,-p)),-n.len,2*n.len),x2:s(Math.round(n.len-n.translate(this.x+i,!1,!0,!1,!0,-p)),-n.len,2*n.len),y1:s(Math.round(l.translate(this.y-r,!1,!0,!1,!0)),-l.len,2*l.len),y2:s(Math.round(l.translate(this.y+r,!1,!0,!1,!0)),-l.len,2*l.len)};for(let t of[["width","x"],["height","y"]]){let e=t[0],i=t[1],s=i+"1",r=i+"2",a=Math.abs(c[s]-c[r]),p=h&&h.lineWidth||0,u=Math.abs(c[s]+c[r])/2,m=h&&h[e];if(o(m)&&m<a){let t=m/2+p/2;c[s]=u-t,c[r]=u+t}d&&(("x"===i&&n.reversed||"y"===i&&!l.reversed)&&(s=r,r=i+"1"),c[s]+=d,c[r]-=d)}return c}haloPath(t){if(!t)return[];let{x:e=0,y:i=0,width:s=0,height:o=0}=this.shapeArgs||{};return[["M",e-t,i-t],["L",e-t,i+o+t],["L",e+s+t,i+o+t],["L",e+s+t,i-t],["Z"]]}isValid(){return this.value!==1/0&&this.value!==-1/0}}return r(n.prototype,{dataLabelOnNull:!0,moveToTopOnHover:!0,ttBelow:!1}),n}),i(e,"Series/Heatmap/HeatmapSeriesDefaults.js",[e["Core/Utilities.js"]],function(t){let{isNumber:e}=t;return{animation:!1,borderRadius:0,borderWidth:0,interpolation:!1,nullColor:"#f7f7f7",dataLabels:{formatter:function(){let{numberFormatter:t}=this.series.chart,{value:i}=this.point;return e(i)?t(i,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:"allow",padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}},legendSymbol:"rectangle"}}),i(e,"Series/InterpolationUtilities.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){let{doc:i}=t,{defined:s,pick:o}=e;return{colorFromPoint:function(t,e){let i=e.series.colorAxis;if(i){let r=i.toColor(t||0,e).split(")")[0].split("(")[1].split(",").map(t=>o(parseFloat(t),parseInt(t,10)));return r[3]=255*o(r[3],1),s(t)&&e.visible||(r[3]=0),r}return[0,0,0,0]},getContext:function(t){let{canvas:e,context:s}=t;return e&&s?(s.clearRect(0,0,e.width,e.height),s):(t.canvas=i.createElement("canvas"),t.context=t.canvas.getContext("2d",{willReadFrequently:!0})||void 0,t.context)}}}),i(e,"Series/Heatmap/HeatmapSeries.js",[e["Core/Color/Color.js"],e["Series/ColorMapComposition.js"],e["Series/Heatmap/HeatmapPoint.js"],e["Series/Heatmap/HeatmapSeriesDefaults.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Renderer/SVG/SVGRenderer.js"],e["Core/Utilities.js"],e["Series/InterpolationUtilities.js"]],function(t,e,i,s,o,r,a,n){let{series:l,seriesTypes:{column:h,scatter:p}}=o,{prototype:{symbols:d}}=r,{addEvent:c,extend:u,fireEvent:m,isNumber:g,merge:f,pick:b}=a,{colorFromPoint:y,getContext:x}=n;class M extends p{constructor(){super(...arguments),this.valueMax=NaN,this.valueMin=NaN,this.isDirtyCanvas=!0}drawPoints(){let t=this,e=t.options,i=e.interpolation,s=e.marker||{};if(i){let{image:e,chart:i,xAxis:s,yAxis:o}=t,{reversed:r=!1,len:a}=s,{reversed:n=!1,len:l}=o,h={width:a,height:l};if(!e||t.isDirtyData||t.isDirtyCanvas){let a=x(t),{canvas:l,options:{colsize:p=1,rowsize:d=1},points:c,points:{length:u}}=t,m=i.colorAxis&&i.colorAxis[0];if(l&&a&&m){let{min:m,max:g}=s.getExtremes(),{min:f,max:b}=o.getExtremes(),x=g-m,M=b-f,C=Math.round(x/p/8*8),j=Math.round(M/d/8*8),[v,w]=[[C,C/x,r,"ceil"],[j,j/M,!n,"floor"]].map(([t,e,i,s])=>i?i=>Math[s](t-e*i):t=>Math[s](e*t)),S=l.width=C+1,P=S*(l.height=j+1),L=(u-1)/P,A=new Uint8ClampedArray(4*P),T=(t,e)=>4*Math.ceil(S*w(e-f)+v(t-m));t.buildKDTree();for(let t=0;t<P;t++){let e=c[Math.ceil(L*t)],{x:i,y:s}=e;A.set(y(e.value,e),T(i,s))}a.putImageData(new ImageData(A,S),0,0),e?e.attr({...h,href:l.toDataURL("image/png",1)}):(t.directTouch=!1,t.image=i.renderer.image(l.toDataURL("image/png",1)).attr(h).add(t.group))}t.isDirtyCanvas=!1}else(e.width!==a||e.height!==l)&&e.attr(h)}else(s.enabled||t._hasPointMarkers)&&(l.prototype.drawPoints.call(t),t.points.forEach(e=>{e.graphic&&(e.graphic[t.chart.styledMode?"css":"animate"](t.colorAttribs(e)),null===e.value&&e.graphic.addClass("highcharts-null-point"))}))}getExtremes(){let{dataMin:t,dataMax:e}=l.prototype.getExtremes.call(this,this.valueData);return g(t)&&(this.valueMin=t),g(e)&&(this.valueMax=e),l.prototype.getExtremes.call(this)}getValidPoints(t,e){return l.prototype.getValidPoints.call(this,t,e,!0)}hasData(){return!!this.processedXData.length}init(){super.init.apply(this,arguments);let t=this.options;t.pointRange=b(t.pointRange,t.colsize||1),this.yAxis.axisPointRange=t.rowsize||1,d.ellipse=d.circle,t.marker&&g(t.borderRadius)&&(t.marker.r=t.borderRadius)}markerAttribs(t,e){let i=t.shapeArgs||{};if(t.hasImage)return{x:t.plotX,y:t.plotY};if(e&&"normal"!==e){let s=t.options.marker||{},o=this.options.marker||{},r=o.states&&o.states[e]||{},a=s.states&&s.states[e]||{},n=(a.width||r.width||i.width||0)+(a.widthPlus||r.widthPlus||0),l=(a.height||r.height||i.height||0)+(a.heightPlus||r.heightPlus||0);return{x:(i.x||0)+((i.width||0)-n)/2,y:(i.y||0)+((i.height||0)-l)/2,width:n,height:l}}return i}pointAttribs(e,i){let s=l.prototype.pointAttribs.call(this,e,i),o=this.options||{},r=this.chart.options.plotOptions||{},a=r.series||{},n=r.heatmap||{},h=e&&e.options.borderColor||o.borderColor||n.borderColor||a.borderColor,p=e&&e.options.borderWidth||o.borderWidth||n.borderWidth||a.borderWidth||s["stroke-width"];if(s.stroke=e&&e.marker&&e.marker.lineColor||o.marker&&o.marker.lineColor||h||this.color,s["stroke-width"]=p,i&&"normal"!==i){let r=f(o.states&&o.states[i],o.marker&&o.marker.states&&o.marker.states[i],e&&e.options.states&&e.options.states[i]||{});s.fill=r.color||t.parse(s.fill).brighten(r.brightness||0).get(),s.stroke=r.lineColor||s.stroke}return s}translate(){let{borderRadius:t,marker:e}=this.options,i=e&&e.symbol||"rect",s=d[i]?i:"rect",o=-1!==["circle","square"].indexOf(s);for(let e of(this.generatePoints(),this.points)){let r=e.getCellAttributes(),a=Math.min(r.x1,r.x2),n=Math.min(r.y1,r.y2),l=Math.max(Math.abs(r.x2-r.x1),0),h=Math.max(Math.abs(r.y2-r.y1),0);if(e.hasImage=0===(e.marker&&e.marker.symbol||i||"").indexOf("url"),o){let t=Math.abs(l-h);a=Math.min(r.x1,r.x2)+(l<h?0:t/2),n=Math.min(r.y1,r.y2)+(l<h?t/2:0),l=h=Math.min(l,h)}e.hasImage&&(e.marker={width:l,height:h}),e.plotX=e.clientX=(r.x1+r.x2)/2,e.plotY=(r.y1+r.y2)/2,e.shapeType="path",e.shapeArgs=f(!0,{x:a,y:n,width:l,height:h},{d:d[s](a,n,l,h,{r:g(t)?t:0})})}m(this,"afterTranslate")}}return M.defaultOptions=f(p.defaultOptions,s),c(M,"afterDataClassLegendClick",function(){this.isDirtyCanvas=!0,this.drawPoints()}),u(M.prototype,{axisTypes:e.seriesMembers.axisTypes,colorKey:e.seriesMembers.colorKey,directTouch:!0,getExtremesFromAll:!0,parallelArrays:e.seriesMembers.parallelArrays,pointArrayMap:["y","value"],pointClass:i,specialGroup:"group",trackerGroups:e.seriesMembers.trackerGroups,alignDataLabel:h.prototype.alignDataLabel,colorAttribs:e.seriesMembers.colorAttribs,getSymbol:l.prototype.getSymbol}),e.compose(M),o.registerSeriesType("heatmap",M),M}),i(e,"masters/modules/map.src.js",[e["Core/Globals.js"],e["Maps/MapNavigation.js"],e["Series/ColorMapComposition.js"],e["Series/MapBubble/MapBubbleSeries.js"],e["Maps/GeoJSONComposition.js"],e["Core/Chart/MapChart.js"],e["Maps/MapView.js"],e["Maps/Projection.js"]],function(t,e,i,s,o,r,a,n){return t.ColorMapComposition=i,t.MapChart=t.MapChart||r,t.MapNavigation=t.MapNavigation||e,t.MapView=t.MapView||a,t.Projection=t.Projection||n,t.mapChart=t.Map=t.MapChart.mapChart,t.maps=t.MapChart.maps,t.geojson=o.geojson,t.topo2geo=o.topo2geo,o.compose(t.Chart),s.compose(t.Axis,t.Chart,t.Legend,t.Series),e.compose(r,t.Pointer,t.SVGRenderer),a.compose(r),t})});