<?php

namespace Modules\Activite\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Modules\Activite\Models\ActiviteModel;
use Modules\Params\Models\BrancheModel;
use Modules\Params\Models\CommuneModel;
use Modules\Params\Models\DomaineActiviteModel;
use Psr\Log\LoggerInterface;
use stdClass;
use UConverter;

use function PHPUnit\Framework\fileExists;

class ActiviteController extends BaseController
{
    protected ActiviteModel $activiteModel;
    function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->activiteModel = new ActiviteModel();
    }
    public function index()
    {
        $this->viewData['url_list'] = "/activite/data";
        $this->viewData['js'] = "Common.js";
        $this->viewData['title'] = "Liste des activites";
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());

        return view('activite/index', $this->viewData);
    }

    public function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(4);

        $this->viewData['url_list'] = "/activite/data";
        $this->viewData['js'] = "Volontaire.js";
        $this->viewData['title'] = "Activite";
        $this->viewData['route'] = "/activite/save";
        $this->viewData['activite'] =  $this->initActivite($id);
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
        $this->viewData['domaines'] = CommonTrait::formatData(new DomaineActiviteModel());
        $this->viewData['finances'] = CommonTrait::ouiNon();

        return view('activite/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/activite/data";
            $this->viewData['js'] = "Volontaire.js";
            $this->viewData['title'] = "Activite";
            $this->viewData['route'] = "/activite/save";
            $this->viewData['activite'] =  $this->initActivite($id);
            $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
            $this->viewData['domaines'] = CommonTrait::formatData(new DomaineActiviteModel());
            $this->viewData['finances'] = CommonTrait::ouiNon();

            return view('activite/add', $this->viewData);
        } else {

            $uneActivite = $this->uneActivite();
            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>L'activite <b>" . $uneActivite['nomActivite'] . "</b> a été modifiée</div>");
                $stmt = $this->activiteModel->update($id, $uneActivite);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>L'activite <b>" . $uneActivite['nomActivite'] . "</b> a été bien enregistrée</div>");
                $stmt = $this->activiteModel->save($uneActivite);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/activite'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $stmnt = $this->activiteModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>L'activite a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/activite'));
        }
    }

    private function uneActivite()
    {
        $activite = [];
        $activite['nomActivite'] = $this->request->getPost('nomActivite');
        $activite['brancheId'] = $this->request->getPost('brancheId');
        $activite['communeId'] = $this->request->getPost('communeId');
        $activite['zoneId'] = $this->request->getPost('zoneId');
        $activite['collineId'] = $this->request->getPost('collineId');
        $activite['domaineActiviteId'] = $this->request->getPost('domaineActiviteId');
        $activite['nbParticipantHomme'] = $this->request->getPost('nbParticipantHomme');
        $activite['nbParticipantFemme'] = $this->request->getPost('nbParticipantFemme');
        $activite['nbParticipantJeune'] = $this->request->getPost('nbParticipantJeune');
        $activite['lieuActivite'] = $this->request->getPost('lieuActivite');
        $activite['nbBeneficiaireHomme'] = $this->request->getPost('nbBeneficiaireHomme');
        $activite['nbBeneficiaireFemme'] = $this->request->getPost('nbBeneficiaireFemme');
        $activite['finance'] = $this->request->getPost('finance');
        $activite['recette'] = $this->request->getPost('recette');
        $activite['coutEstime'] = $this->request->getPost('coutEstime');
        $activite['dateActivite'] = $this->request->getPost('dateActivite');
        $activite['heureDebut'] = $this->request->getPost('heureDebut');
        $activite['dureeheure'] = $this->request->getPost('dureeheure');

        $file = $this->request->getFile('pathFile');
        if ($file->isValid() && !$file->hasMoved()) {
            $newName = $file->getRandomName();
            $file->move('files/activite', $newName);
            $activite['pathFile'] = $newName;
        }

        return $activite;
    }

    private function initActivite($id = NULL)
    {

        $activite = NULL;
        if ($id) {
            $activite = $this->activiteModel->find($id);
        } else {
            $activite = new stdClass();
            $activite->id = 0;
            $activite->nomActivite = "";
            $activite->brancheId = 0;
            $activite->communeId = 0;
            $activite->zoneId = 0;
            $activite->collineId = 0;
            $activite->domaineActiviteId = 0;
            $activite->nbParticipantHomme = 0;
            $activite->nbParticipantFemme = 0;
            $activite->nbParticipantJeune = 0;
            $activite->lieuActivite = "";
            $activite->nbBeneficiaireHomme = 0;
            $activite->nbBeneficiaireFemme = 0;
            $activite->finance = NULL;
            $activite->recette = NULL;
            $activite->coutEstime = NULL;
            $activite->dateActivite = NULL;
            $activite->heureDebut = NULL;
            $activite->dureeheure = NULL;
            $activite->pathFile = "";
        }

        return $activite;
    }

    private function _rules()
    {
        $rules = [];
        $rules['nomActivite'] = ['rules'  => 'required|min_length[2]|max_length[100]'];
        $rules['brancheId'] = ['rules'  => 'required|is_natural'];
        $rules['communeId'] = ['rules'  => 'required|is_natural'];
        $rules['zoneId'] = ['rules'  => 'required|is_natural'];
        $rules['collineId'] = ['rules'  => 'required|is_natural'];
        $rules['domaineActiviteId'] = ['rules'  => 'required|is_natural'];
        $rules['nbParticipantHomme'] = ['rules'  => 'required|is_natural'];
        $rules['nbParticipantFemme'] = ['rules'  => 'required|is_natural'];
        $rules['nbParticipantJeune'] = ['rules'  => 'required|is_natural'];
        $rules['lieuActivite'] = ['rules'  => 'required'];
        $rules['nbBeneficiaireHomme'] = ['rules'  => 'required|is_natural'];
        $rules['nbBeneficiaireFemme'] = ['rules'  => 'required|is_natural'];
        $rules['finance'] = ['rules'  => 'required'];
        $rules['recette'] = ['rules'  => 'required'];
        $rules['coutEstime'] = ['rules'  => 'required'];
        $rules['dateActivite'] = ['rules'  => 'required'];
        $rules['heureDebut'] = ['rules'  => 'required'];
        $rules['dureeheure'] = ['rules'  => 'required'];

        return $rules;
    }



    function fecth()
    {

        $search_column = ['id', 'nomActivite', 'brancheId', 'communeId', 'zoneId', 'collineId', 'domaineActiviteId', 'nbParticipantHomme', 'nbParticipantFemme', 'nbParticipantJeune', 'lieuActivite', 'nbBeneficiaireHomme', 'nbBeneficiaireFemme', 'finance', 'recette', 'coutEstime', 'dateActivite', 'heureDebut', 'dureeheure', 'pathFile'];
        $order_column = ['id', 'nomActivite', 'brancheId', 'communeId', 'zoneId', 'collineId', 'domaineActiviteId', 'nbParticipantHomme', 'nbParticipantFemme', 'nbParticipantJeune', 'lieuActivite', 'nbBeneficiaireHomme', 'nbBeneficiaireFemme', 'finance', 'recette', 'coutEstime', 'dateActivite', 'heureDebut', 'dureeheure', 'pathFile'];

        $activiteMdl = $this->activiteModel;
        if (\auth()->user()->inGroup('brancheManager')) {
            $activiteMdl->where('brancheId', \auth()->user()->brancheId);
        }

        if (\auth()->user()->inGroup('communeManager')) {
            $activiteMdl->where('communeId', \auth()->user()->communeId);
        }

        if ($this->request->getPost('brancheId') > 0) {
            $activiteMdl->where('brancheId', $this->request->getPost('brancheId'));
        }

        $fetch_data = DatatableQuery::build_query($activiteMdl, $search_column, $order_column);
        $output = $this->formatActivites($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatActivites($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  $data->nomActivite;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $data->brancheId);
                $sub_array[] =  CommonTrait::formatData(new CommuneModel(), $data->communeId);
                $sub_array[] =  CommonTrait::formatData(new DomaineActiviteModel(), $data->domaineActiviteId);
                $sub_array[] =  $data->lieuActivite;
                $sub_array[] =  $data->nbBeneficiaireHomme;
                $sub_array[] =  $data->nbBeneficiaireFemme;
                // $sub_array[] =  $data->dureeheure;
                $sub_array[] =  !empty($data->pathFile) ? anchor(base_url() . "files/activite/" . $data->pathFile, '...'.substr($data->pathFile, -8), "target='_blank'") : "";

                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                    $option = anchor($locale . "/activite/add/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " "
                        . anchor($locale . "/activite/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }

    function export()
    {
        $uri = current_url(true);
        $brancheId = $uri->getSegment(4);

        if ($brancheId > 0) {
            $branche = CommonTrait::formatData(new BrancheModel(), $brancheId);
        } else {
            $branche = "Toutes les branches";
        }

        $fileName = str_replace(' ', '', $branche);        
        $csv_file_name = "rapportExport/activite/activite_" . $fileName . ".csv";
        $file = fopen($csv_file_name, 'w');

        $arrays = [];
        $arrays[0] = ['', $this->formatText($branche)];
        $arrays[1] = [];
        $arrays[2] = [
            '#', 
            $this->formatText('Activite'), 
            $this->formatText('Province'), 
            $this->formatText('Branche'), 
            $this->formatText('Domaine'), 
            $this->formatText('Participant Homme'), 
            $this->formatText('Participant Femme'), 
            $this->formatText('Participant Jeune'), 
            $this->formatText("Lieu d'Activite"), 
            $this->formatText('Beneficiaire Homme'), 
            $this->formatText('Beneficiaire Femme'),
            $this->formatText('Est finance ?'), 
            $this->formatText('Recette'), 
            $this->formatText('Cout'), 
            $this->formatText('Date activite'), 
            $this->formatText('Heure debut'), 
            $this->formatText('Duree en Heure')
        ];


        if ($brancheId > 0) {
            $activites = $this->activiteModel->where('brancheId', $brancheId)->findAll();
        } else {
            $activites = $this->activiteModel->findAll();
        }

        $i = 1;
        foreach ($activites as $activite) {
            $sub_array = [];
            $sub_array[] = $i;
            $sub_array[] =  $this->formatText($activite->nomActivite);
            $sub_array[] =  $this->formatText($activite->brancheId > 0 ?CommonTrait::formatData(new BrancheModel(), $activite->brancheId):"");
            $sub_array[] =  $this->formatText($activite->communeId > 0 ?CommonTrait::formatData(new CommuneModel(), $activite->communeId):"");
            $sub_array[] =  $this->formatText($activite->domaineActiviteId > 0 ?CommonTrait::formatData(new DomaineActiviteModel(), $activite->domaineActiviteId):"");
            $sub_array[] =  $activite->nbParticipantHomme;
            $sub_array[] =  $activite->nbParticipantFemme;
            $sub_array[] =  $activite->nbParticipantJeune;
            $sub_array[] =  $activite->lieuActivite;
            $sub_array[] =  $activite->nbBeneficiaireHomme;
            $sub_array[] =  $activite->nbBeneficiaireFemme;
            $sub_array[] =  $activite->finance;
            $sub_array[] =  $activite->recette;
            $sub_array[] =  $activite->coutEstime;
            $sub_array[] =  $activite->dateActivite;
            $sub_array[] =  $activite->heureDebut;
            $sub_array[] =  $activite->dureeheure;

            $arrays[] = $sub_array;
            $i++;
        }


        foreach ($arrays as $array) {
            fputcsv($file, $array, ";");
        }
        fclose($file);
        $btn = anchor($csv_file_name, "Exporter un <i class='fa fa-file-csv'></i>", ['class' => 'text-success', 'target' => '_blank']);

        $status = 0;
        if (fileExists($csv_file_name)) {
            $status = 1;
        }

        return $this->response->setJSON(['status' => $status, 'btnExport' => $btn]);
    }

    function formatText($string = "")
    {
        return UConverter::transcode($string, 'ISO-8859-1', 'UTF8');
    }
}
