<?php

namespace Modules\Formation\Database\Migrations;

use CodeIgniter\Database\Migration;

class MenageModeleMigration extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 5,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'brancheId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'communeId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'zoneId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],
            'collineId' => [
                'type' => 'INT',
                'constraint' => '11',
            ],

            'nbMenageEnTransformation' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbMenageACertifier' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'nbMenageDejaCertifier' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'commentaire' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default'    => NULL,
            ],
            'userId' => [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'anneeCertification'=> [
                'type' => 'INT',
                'constraint' => '11',
                'default'    => 0,
            ],
            'created_at DATETIME default current_timestamp',
            'updated_at DATETIME default NULL',
            'deleted_at DATETIME default NULL',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('fr_menage_modeles');
    }

    public function down()
    {
        $this->forge->dropTable('fr_menage_modeles');
    }
}
