<?php

namespace Modules\PS\Config;

// Create a new instance of our RouteCollection class.
$routes->group("{locale}/ps", ["namespace" => "\Modules\PS\Controllers", 'filter' => ['appAuth']], function ($routes) {
    
    //Routes for Branches
    $routes->get("materiel", "MaterielController::index");
    $routes->get("materiel/add", "MaterielController::add");
    $routes->get("materiel/add/(:num)", "MaterielController::add");
    $routes->post("materiel/save", "MaterielController::save");
    $routes->post("materiel/data", "MaterielController::fecth");
    $routes->get("materiel/delete/(:num)", "MaterielController::delete");
    $routes->get("materiel/export/(:num)", "MaterielController::export");

    //Routes for formation
    $routes->get("formation", "FormationController::index");
    $routes->get("formation/add", "FormationController::add");
    $routes->get("formation/add/(:num)", "FormationController::add");
    $routes->post("formation/save", "FormationController::save");
    $routes->post("formation/data", "FormationController::fecth");
    $routes->get("formation/delete/(:num)", "FormationController::delete");
    $routes->get("formation/certificat/(:num)", "FormationController::certificat");

    //Routes for formations
    $routes->get("formations", "FormationsController::index");
    $routes->get("formations/add", "FormationsController::add");
    $routes->get("formations/add/(:num)", "FormationsController::add");
    $routes->get("formations/detail/(:num)", "FormationsController::detail");
    $routes->post("formations/save", "FormationsController::save");
    $routes->post("formations/data", "FormationsController::fecth");
    $routes->get("formations/delete/(:num)", "FormationsController::delete");
    $routes->post("formations/ajouterMembre", "FormationsMembresController::ajouterMembre");
    $routes->get("formations/supprimerMembre/(:num)/(:num)", "FormationsMembresController::supprimerMembre");
    $routes->get("formations/certificat/(:num)", "FormationsMembresController::certificat");
    $routes->get("formations/export/(:num)", "FormationsController::export");
    
    //Routes for couverture
    $routes->get("couvertureSanitaire", "CouvertureSanitaireController::index");
    $routes->get("couvertureSanitaire/add", "CouvertureSanitaireController::add");
    $routes->get("couvertureSanitaire/add/(:num)", "CouvertureSanitaireController::add");
    $routes->post("couvertureSanitaire/save", "CouvertureSanitaireController::save");
    $routes->post("couvertureSanitaire/data", "CouvertureSanitaireController::fecth");
    $routes->get("couvertureSanitaire/delete/(:num)", "CouvertureSanitaireController::delete");
    $routes->get("couvertureSanitaire/export/(:num)", "CouvertureSanitaireController::export");

});