<?php

namespace Modules\PS\Controllers;

use App\Controllers\BaseController;
use App\Libraries\DatatableQuery;
use App\ThirdParty\fpdf\PdfModel;
use App\Traits\CommonTrait;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use DateTime;
use Modules\Params\Models\BrancheModel;
use Modules\Params\Models\CommuneModel;
use Modules\Params\Models\TypeFormationModel;
use Modules\Params\Models\TypePremierSecourModel;
use Modules\PS\Models\FormationModel;
use Psr\Log\LoggerInterface;
use stdClass;
use UConverter;

class FormationController extends BaseController
{
    public FormationModel $formationModel;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        parent::initController($request, $response, $logger);
        $this->formationModel = new FormationModel();
    }

    public function index()
    {
        $this->viewData['url_list'] = "/ps/formation/data";
        $this->viewData['js'] = "";
        $this->viewData['title'] = "Liste des formations";

        return view('ps/formation/index', $this->viewData);
    }
    public function add()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $this->viewData['url_list'] = "";
        $this->viewData['js'] = "Volontaire.js";
        $this->viewData['route'] = "/ps/formation/save";
        $this->viewData['formation'] =  $this->initFormation($id);
        $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
        $this->viewData['certificats'] = CommonTrait::ouiNon();
        $this->viewData['niveaux'] = CommonTrait::niveauFormation();
        $this->viewData['categories'] = CommonTrait::categorieFormation();
        $this->viewData['sexes'] = CommonTrait::genres();
        $this->viewData['types'] = CommonTrait::formatData(new TypePremierSecourModel());
        if ($id > 0)
            $title = "Editer une formation";
        else
            $title = "Nouvelle formation";

        $this->viewData['title'] = $title;

        // echo "Format <pre>";
        // print_r($this->initFormation($id));
        // echo "</pre>";

        return view('ps/formation/add', $this->viewData);
    }

    public function save()
    {
        $id = $this->request->getPost('id');

        if (!$this->validate($this->_rules())) {

            $this->viewData['url_list'] = "/ps/formation/data";
            $this->viewData['js'] = "Volontaire.js";
            $this->viewData['route'] = "/ps/formation/save";
            $this->viewData['formation'] =  $this->initFormation($id);
            $this->viewData['branches'] = CommonTrait::formatData(new BrancheModel());
            $this->viewData['certificats'] = CommonTrait::ouiNon();
            $this->viewData['niveaux'] = CommonTrait::niveauFormation();
            $this->viewData['categories'] = CommonTrait::categorieFormation();
            $this->viewData['sexes'] = CommonTrait::genres();
            $this->viewData['types'] = CommonTrait::formatData(new TypePremierSecourModel());
            if ($id > 0)
                $title = "Editer une formation";
            else
                $title = "Nouvelle formation";

            $this->viewData['title'] = $title;


            return view('ps/formation/add', $this->viewData);
        } else {

            $uneFormation = $this->uneFormation();

            // echo "<pre>";
            // print_r($uneFormation);
            // echo "</pre>";

            // die();

            if ($id) {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation  a été modifiée</div>");
                $stmt = $this->formationModel->update($id, $uneFormation);
            } else {
                $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation  a été bien enregistrée</div>");
                $stmt = $this->formationModel->save($uneFormation);
            }

            if ($stmt) {
                return redirect()->to(site_url($this->viewData['locale'] . '/ps/formation'));
            }
        }
    }


    public function delete()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(6);

        $stmnt = $this->formationModel->delete($id);

        if ($stmnt) {
            $this->session->setFlashdata('message', "<div class='row alert alert-success'>La formation a été suprimée</div>");
            return redirect()->to(site_url($this->viewData['locale'] . '/ps/formation'));
        }
    }

    private function uneFormation()
    {
        $formation = [];
        $formation['brancheId'] = $this->request->getPost('brancheId');
        $formation['communeId'] = $this->request->getPost('communeId');
        $formation['formateurUnNomPrenom'] = $this->request->getPost('formateurUnNomPrenom');
        $formation['formateurDeuxNomPrenom'] = $this->request->getPost('formateurDeuxNomPrenom');
        $formation['dateFormation'] = $this->request->getPost('dateFormation');
        $formation['categorieId'] = $this->request->getPost('categorieId');
        $formation['niveauId'] = $this->request->getPost('niveauId');
        $formation['typeFormationId'] = $this->request->getPost('typeFormationId');
        $formation['nomParticipant'] = $this->request->getPost('nomParticipant');
        $formation['prenomParticipant'] = $this->request->getPost('prenomParticipant');
        $formation['cniParticipant'] = $this->request->getPost('cniParticipant');
        $formation['dateNaissance'] = $this->request->getPost('dateNaissance');
        $formation['sexe'] = $this->request->getPost('sexe');
        $formation['telephone'] = $this->request->getPost('telephone');
        $formation['brancheResidenceId'] = $this->request->getPost('brancheResidenceId');
        $formation['communeResidenceId'] = $this->request->getPost('communeResidenceId');
        $formation['certificat'] = $this->request->getPost('certificat');
        $formation['dateExpiration'] = $this->request->getPost('dateExpiration');
        $formation['userId'] = \auth()->user()->id;

        return $formation;
    }

    private function initFormation($id = NULL)
    {
        $formation = NULL;
        if ($id) {
            $formation = $this->formationModel->find($id);
        } else {

            $formation = new stdClass();
            $formation->id = 0;
            $formation->brancheId = 0;
            $formation->communeId = 0;
            $formation->formateurUnNomPrenom = '';
            $formation->formateurDeuxNomPrenom = '';
            $formation->dateFormation = '';
            $formation->categorieId = 0;
            $formation->niveauId = 0;
            $formation->typeFormationId = 0;
            $formation->nomParticipant = '';
            $formation->prenomParticipant = '';
            $formation->cniParticipant = '';
            $formation->dateNaissance = NULL;
            $formation->sexe = NULL;
            $formation->telephone = '';
            $formation->brancheResidenceId = 0;
            $formation->communeResidenceId = 0;
            $formation->certificat = NULL;
            $formation->dateExpiration = '';
        }

        return $formation;
    }

    private function _rules()
    {
        $rules = [];
        $rules['brancheId'] = ['rules'  => 'required'];
        $rules['communeId'] = ['rules'  => 'required'];
        $rules['formateurUnNomPrenom'] = ['rules'  => 'required'];
        // $rules['formateurDeuxNomPrenom'] = ['rules'  => 'required'];
        $rules['categorieId'] = ['rules'  => 'required'];
        $rules['niveauId'] = ['rules'  => 'required'];
        $rules['typeFormationId'] = ['rules'  => 'required'];
        $rules['nomParticipant'] = ['rules'  => 'required'];
        $rules['prenomParticipant'] = ['rules'  => 'required'];
        // $rules['cniParticipant'] = ['rules'  => 'required'];
        $rules['sexe'] = ['rules'  => 'required'];
        $rules['telephone'] = ['rules'  => 'required|decimal'];
        $rules['brancheResidenceId'] = ['rules'  => 'required'];
        $rules['communeResidenceId'] = ['rules'  => 'required'];
        $rules['certificat'] = ['rules'  => 'required'];
        // $rules['dateExpiration'] = ['rules'  => 'required'];

        return $rules;
    }

    function fecth()
    {
        $search_column = ['brancheId', 'communeId', 'formateurUnNomPrenom', 'formateurDeuxNomPrenom', 'dateFormation', 'categorieId', 'niveauId', 'typeFormationId', 'nomParticipant', 'prenomParticipant', 'cniParticipant', 'dateNaissance', 'sexe', 'telephone', 'brancheResidenceId', 'communeResidenceId', 'certificat', 'dateExpiration', 'userId'];
        $order_column = ['brancheId', 'communeId', 'formateurUnNomPrenom', 'formateurDeuxNomPrenom', 'dateFormation', 'categorieId', 'niveauId', 'typeFormationId', 'nomParticipant', 'prenomParticipant', 'cniParticipant', 'dateNaissance', 'sexe', 'telephone', 'brancheResidenceId', 'communeResidenceId', 'certificat', 'dateExpiration', 'userId'];

        $formationMdl = $this->formationModel;
        if (\auth()->user()->inGroup('brancheManager')) {
            $formationMdl->where('brancheId', \auth()->user()->brancheId);
        }

        if (\auth()->user()->inGroup('communeManager')) {
            $formationMdl->where('communeId', \auth()->user()->communeId);
        }

        $fetch_data = DatatableQuery::build_query($formationMdl, $search_column, $order_column);
        $output = $this->formatFormations($this->viewData['locale'], $fetch_data);

        return $this->response->setJSON($output);
    }

    private function formatFormations($locale, $datas)
    {
        $i = 1;
        $array_data = array();
        if (!empty($datas['data'])) {
            foreach ($datas['data'] as $data) {

                $sub_array = array();

                $sub_array[] =  $i;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $data->brancheId);
                $sub_array[] =  CommonTrait::formatData(new CommuneModel(), $data->communeId);
                $sub_array[] =  $data->formateurUnNomPrenom . ' & ' . $data->formateurDeuxNomPrenom;
                $sub_array[] =  $data->dateFormation;
                $sub_array[] =  CommonTrait::categorieFormation($data->categorieId);
                $sub_array[] =  CommonTrait::niveauFormation($data->niveauId);
                $sub_array[] =  CommonTrait::formatData(new TypePremierSecourModel(), $data->typeFormationId);
                $sub_array[] =  $data->nomParticipant . ' ' . $data->prenomParticipant.' '.$data->telephone;
                // $sub_array[] =  $data->telephone;
                $sub_array[] =  CommonTrait::formatData(new BrancheModel(), $data->brancheResidenceId) . " " . CommonTrait::formatData(new CommuneModel(), $data->communeResidenceId);
                $sub_array[] =  $data->certificat;

                $option = "-";
                if (\auth()->user()->inGroup('hr', 'admin') || (\auth()->user()->hasPermission('params.edit') && \auth()->user()->hasPermission('params.delete'))) {
                    $option = anchor($locale . "/ps/formation/add/" . $data->id, "<i class='fa fa-edit'></i>", ['class' => 'text-info']) . " "
                        . anchor($locale . "/ps/formation/certificat/" . $data->id, "<i class='fa fa-file-pdf'></i>", ['target'=>'_blank','class' => 'text-info']) . " "
                        . anchor($locale . "/ps/formation/delete/" . $data->id, "<i class='fa fa-trash'></i>", ['class' => 'text-danger']);
                }
                $sub_array[] = $option;

                $array_data[] = $sub_array;
                $i++;
            }
        }

        return [
            "draw" => intval($_POST["draw"]),
            "recordsTotal" => $datas['recordsTotal'],
            "recordsFiltered" => $datas['recordsFiltered'],
            "data" => $array_data
        ];
    }

    function certificat()
    {
        $uri = current_url(true);
        $id = $uri->getSegment(5);

        $pdf = new PdfModel();

        $formation = $this->formationModel->where('id', $id)->first();

        $nom = isset($formation->nomParticipant) ? $formation->nomParticipant : "-";
        $prenom = isset($formation->prenomParticipant) ? $formation->prenomParticipant : "-";
        $dateFormation = new DateTime($formation->dateFormation);

        $pdf->AliasNbPages();
        $pdf->SetAutoPageBreak(1, 13);
        $pdf->AddPage('L');
        $this->response->setHeader('Content-Type', 'application/pdf');        
        $pdf->Ln(10);

        $pdf->SetFont('Times', 'B', 20);
        $pdf->Cell(270, 20, $this->formatText("CERTIFICAT DE SECOURISTE "), 0, 1, 'C');
        $pdf->SetFont('Times', '', 14);
        $pdf->Cell(270, 6, $this->formatText("La Croix-Rouge du Burundi certifie que: "), '', 1, 'C');
        $pdf->SetFont('Times', 'B', 14);
        $pdf->Cell(270, 6, $this->formatText("Mr $nom $prenom"), '', 1, 'C');
        $pdf->Ln(4);

        $pdf->SetFont('Times', '', 14);
        $pdf->Cell(70, 6, "", '', 0, 'L');
        $pdf->Cell(200, 6, $this->formatText("a suivi et reussi avec succes la formation complete des Premiers secours"), '', 1, 'L');

        $pdf->Cell(70, 6,"", "", 0, 'L');
        $pdf->Cell(45, 6, $this->formatText("Apprentissage Mixte "), '', 0, 'L');
        $pdf->SetFont('Times', 'B', 14);
        $pdf->Cell(140, 6, $this->formatText("\"First Aid Blended Learning: FABL\"."), '', 1, 'L');
        $pdf->Ln(4);

        $pdf->SetFont('Times', '', 14);
        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(220, 6, $this->formatText("Les pratiques et l'evaluation des competences ont ete faites le ".$dateFormation->format('d M Y'))." .", '', 1, 'L');
        $pdf->Ln(10);        

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("Dr Desire HABONIMANA"), "", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("Bujumbura, le .../.../".date('Y')), "", 1, 'L');

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("Expert en Premiers secours"), "", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("La Croix-Rouge du Burundi"), "", 1, 'L');
        $pdf->Ln(3);

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("------------------------------------"), "", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("Anselme KATIYUNGURUZA"), "", 1, 'L');

        $pdf->Cell(70, 6, "", "", 0, 'L');
        $pdf->Cell(100, 6, $this->formatText("No ..../..../.../".date('Y')), " ", 0, 'L');
        $pdf->Cell(70, 6, $this->formatText("Secretaire General"), "", 1, 'C');

        $fileName = $this->formatText("identite/certificat_ps_" . $nom . "_" . $prenom . ".pdf");
        $pdf->Output($fileName, 'F');
        $pdf->Output();
    }

    function formatText($string = NULL)
    {
        if (gettype($string) == "string") {
            $string = UConverter::transcode($string, 'ISO-8859-1', 'UTF8');
        }

        if (gettype($string) == "array") {
            foreach ($string as $key => $value) {
                $string[$key] = UConverter::transcode($value, 'ISO-8859-1', 'UTF8');
            }
        }

        return $string;
    }
}
